/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.util.ArrayList;
import java.util.List;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ClientResultSet;
import org.apache.derby.client.am.ClientStatement;
import org.apache.derby.client.am.ClientTypes;
import org.apache.derby.client.am.ColumnMetaData;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.PreparedStatementCallbackInterface;
import org.apache.derby.client.am.ResultSetCallbackInterface;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Sqlca;
import org.apache.derby.client.am.StatementCallbackInterface;
import org.apache.derby.client.am.Utils;
import org.apache.derby.client.net.CodePoint;
import org.apache.derby.client.net.FdocaConstants;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetCursor;
import org.apache.derby.client.net.NetPackageReply;
import org.apache.derby.client.net.NetResultSet;
import org.apache.derby.client.net.NetSqlca;
import org.apache.derby.client.net.NetSqldta;
import org.apache.derby.client.net.NetStatement;
import org.apache.derby.client.net.StatementReplyInterface;
import org.apache.derby.jdbc.ClientDriver;
import org.apache.derby.shared.common.i18n.MessageUtil;

class NetStatementReply
extends NetPackageReply
implements StatementReplyInterface {
    NetStatementReply(NetAgent netAgent, int n2) {
        super(netAgent, n2);
    }

    @Override
    public void readPrepareDescribeOutput(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        this.startSameIdChainParse();
        this.parsePRPSQLSTTreply(statementCallbackInterface);
        this.endOfSameIdChainData();
    }

    @Override
    public void readExecuteImmediate(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseEXCSQLIMMreply(statementCallbackInterface);
        this.endOfSameIdChainData();
    }

    @Override
    public void readOpenQuery(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseOPNQRYreply(statementCallbackInterface);
        this.endOfSameIdChainData();
    }

    @Override
    public void readExecute(PreparedStatementCallbackInterface preparedStatementCallbackInterface) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseEXCSQLSTTreply(preparedStatementCallbackInterface);
        this.endOfSameIdChainData();
    }

    @Override
    public void readPrepare(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        this.startSameIdChainParse();
        this.parsePRPSQLSTTreply(statementCallbackInterface);
        this.endOfSameIdChainData();
    }

    @Override
    public void readDescribeInput(PreparedStatementCallbackInterface preparedStatementCallbackInterface) throws DisconnectException {
        if (this.longBufferForDecryption_ != null) {
            this.buffer_ = this.longBufferForDecryption_;
            this.pos_ = this.longPosForDecryption_;
            this.count_ = this.longCountForDecryption_;
            if (this.longBufferForDecryption_ != null && this.count_ > this.longBufferForDecryption_.length) {
                this.count_ = this.longBufferForDecryption_.length;
            }
            this.dssLength_ = 0;
            this.longBufferForDecryption_ = null;
        }
        this.startSameIdChainParse();
        this.parseDSCSQLSTTreply(preparedStatementCallbackInterface, 1);
        this.endOfSameIdChainData();
    }

    @Override
    public void readDescribeOutput(PreparedStatementCallbackInterface preparedStatementCallbackInterface) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseDSCSQLSTTreply(preparedStatementCallbackInterface, 0);
        this.endOfSameIdChainData();
    }

    @Override
    public void readExecuteCall(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseEXCSQLSTTreply(statementCallbackInterface);
        this.endOfSameIdChainData();
    }

    private void parsePRPSQLSTTreply(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        int n2 = this.parseTypdefsOrMgrlvlovrs();
        if (n2 == 9233) {
            ColumnMetaData columnMetaData = null;
            NetSqlca netSqlca = null;
            boolean bl = this.peekForNullSqlcagrp();
            if (bl && this.peekNumOfColumns() == 0) {
                netSqlca = this.parseSQLDARD(columnMetaData, true);
            } else {
                columnMetaData = ClientDriver.getFactory().newColumnMetaData(this.netAgent_.logWriter_);
                netSqlca = this.parseSQLDARD(columnMetaData, false);
            }
            statementCallbackInterface.completePrepareDescribeOutput(columnMetaData, netSqlca);
        } else if (n2 == 9224) {
            NetSqlca netSqlca = this.parseSQLCARD(null);
            statementCallbackInterface.completePrepare(netSqlca);
        } else {
            this.parsePrepareError(statementCallbackInterface);
        }
    }

    private void parseDSCSQLSTTreply(PreparedStatementCallbackInterface preparedStatementCallbackInterface, int n2) throws DisconnectException {
        int n3 = this.parseTypdefsOrMgrlvlovrs();
        if (n3 == 9233) {
            ColumnMetaData columnMetaData = null;
            if (columnMetaData == null) {
                columnMetaData = ClientDriver.getFactory().newColumnMetaData(this.netAgent_.logWriter_);
            }
            NetSqlca netSqlca = this.parseSQLDARD(columnMetaData, false);
            if (columnMetaData.columns_ == 0) {
                columnMetaData = null;
            }
            if (n2 == 0) {
                preparedStatementCallbackInterface.completeDescribeOutput(columnMetaData, netSqlca);
            } else {
                preparedStatementCallbackInterface.completeDescribeInput(columnMetaData, netSqlca);
            }
        } else if (n3 == 9224) {
            NetSqlca netSqlca = this.parseSQLCARD(null);
            if (n2 == 0) {
                preparedStatementCallbackInterface.completeDescribeOutput(null, netSqlca);
            } else {
                preparedStatementCallbackInterface.completeDescribeInput(null, netSqlca);
            }
        } else {
            this.parseDescribeError(preparedStatementCallbackInterface);
        }
    }

    private void parseEXCSQLIMMreply(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        int n2 = this.parseTypdefsOrMgrlvlovrs();
        if (n2 == 8728) {
            this.parseRDBUPDRM();
            n2 = this.parseTypdefsOrMgrlvlovrs();
        }
        switch (n2) {
            case 8716: {
                this.parseENDUOWRM(statementCallbackInterface.getConnectionCallbackInterface());
                this.parseTypdefsOrMgrlvlovrs();
            }
            case 9224: {
                NetSqlca netSqlca = this.parseSQLCARD(null);
                statementCallbackInterface.completeExecuteImmediate(netSqlca);
                break;
            }
            default: {
                this.parseExecuteImmediateError(statementCallbackInterface);
            }
        }
        n2 = this.peekCodePoint();
        if (n2 == 49152) {
            this.parsePBSD();
        }
    }

    private void parseOPNQRYreply(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        int n2 = this.peekCodePoint();
        if (n2 == 8709) {
            this.parseOpenQuery(statementCallbackInterface);
            n2 = this.peekCodePoint();
            if (n2 == 8728) {
                this.parseRDBUPDRM();
                n2 = this.peekCodePoint();
            }
        } else if (n2 == 8728) {
            this.parseRDBUPDRM();
            this.parseOpenQuery(statementCallbackInterface);
            n2 = this.peekCodePoint();
        } else if (n2 == 8722) {
            this.parseOpenQueryFailure(statementCallbackInterface);
            n2 = this.peekCodePoint();
        } else {
            this.parseOpenQueryError(statementCallbackInterface);
            n2 = this.peekCodePoint();
        }
        if (n2 == 49152) {
            this.parsePBSD();
        }
    }

    private void parseEXCSQLSETreply(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        int n2 = this.parseTypdefsOrMgrlvlovrs();
        if (n2 == 8728) {
            this.parseRDBUPDRM();
            this.parseTypdefsOrMgrlvlovrs();
        } else if (n2 == 8716) {
            this.parseENDUOWRM(statementCallbackInterface.getConnectionCallbackInterface());
            this.parseTypdefsOrMgrlvlovrs();
        }
        if (n2 == 9224) {
            NetSqlca netSqlca = this.parseSQLCARD(null);
            statementCallbackInterface.completeExecuteSetStatement(netSqlca);
        } else {
            this.parseExecuteSetStatementError(statementCallbackInterface);
        }
    }

    private void parseEXCSQLSTTreply(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        int n2 = this.peekCodePoint();
        if (n2 == 8728) {
            this.parseRDBUPDRM();
            n2 = this.peekCodePoint();
        }
        if (n2 == 8716) {
            this.parseENDUOWRM(statementCallbackInterface.getConnectionCallbackInterface());
            n2 = this.peekCodePoint();
        }
        if (n2 == 8729) {
            this.parseResultSetProcedure(statementCallbackInterface);
            n2 = this.peekCodePoint();
            if (n2 == 8728) {
                this.parseRDBUPDRM();
                n2 = this.peekCodePoint();
            }
            if (n2 == 49152) {
                this.parsePBSD();
            }
            return;
        }
        n2 = this.parseTypdefsOrMgrlvlovrs();
        if (n2 == 9224) {
            NetSqlca netSqlca = this.parseSQLCARD(null);
            statementCallbackInterface.completeExecute(netSqlca);
            n2 = this.peekCodePoint();
        } else if (n2 == 9235) {
            NetSqldta netSqldta = null;
            boolean bl = false;
            if (((ClientStatement)statementCallbackInterface).cachedSingletonRowData_ == null) {
                netSqldta = new NetSqldta(this.netAgent_);
            } else {
                netSqldta = (NetSqldta)((ClientStatement)statementCallbackInterface).cachedSingletonRowData_;
                netSqldta.resetDataBuffer();
                netSqldta.extdtaData_.clear();
                bl = true;
            }
            NetSqlca netSqlca = this.parseSQLDTARD(netSqldta);
            n2 = this.peekCodePoint();
            while (n2 == 5228) {
                this.copyEXTDTA(netSqldta);
                n2 = this.peekCodePoint();
            }
            statementCallbackInterface.completeExecuteCall(netSqlca, netSqldta);
        } else {
            this.parseExecuteError(statementCallbackInterface);
        }
        if (n2 == 49152) {
            this.parsePBSD();
            n2 = this.peekCodePoint();
        }
    }

    private void parseResultSetProcedure(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        List<Section> list = this.parseRSLSETRM();
        int n2 = this.parseTypdefsOrMgrlvlovrs();
        NetSqldta netSqldta = null;
        NetSqlca netSqlca = null;
        if (n2 == 9224) {
            netSqlca = this.parseSQLCARD(null);
        } else {
            netSqldta = new NetSqldta(this.netAgent_);
            netSqlca = this.parseSQLDTARD(netSqldta);
        }
        n2 = this.parseTypdefsOrMgrlvlovrs();
        int n3 = this.parseSQLRSLRD(list);
        ClientResultSet[] clientResultSetArray = new NetResultSet[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            NetResultSet netResultSet = this.parseResultSetCursor(statementCallbackInterface, list.get(i2));
            clientResultSetArray[i2] = netResultSet;
        }
        n2 = this.peekCodePoint();
        while (n2 == 5228) {
            this.copyEXTDTA(netSqldta);
            n2 = this.peekCodePoint();
        }
        statementCallbackInterface.completeExecuteCall(netSqlca, netSqldta, clientResultSetArray);
    }

    private NetResultSet parseResultSetCursor(StatementCallbackInterface statementCallbackInterface, Section section) throws DisconnectException {
        NetResultSet netResultSet = this.parseOPNQRYRM(statementCallbackInterface, false);
        int n2 = this.parseTypdefsOrMgrlvlovrs();
        NetSqlca netSqlca = null;
        if (n2 == 9224) {
            netSqlca = this.parseSQLCARD(null);
            n2 = this.parseTypdefsOrMgrlvlovrs();
        }
        ColumnMetaData columnMetaData = null;
        if (n2 == 9227) {
            columnMetaData = this.parseSQLCINRD();
            n2 = this.parseTypdefsOrMgrlvlovrs();
        }
        this.parseQRYDSC(netResultSet.netCursor_);
        n2 = this.peekCodePoint();
        statementCallbackInterface.completeExecuteCallOpenQuery(netSqlca, netResultSet, columnMetaData, section);
        while (n2 == 9243) {
            this.parseQRYDTA(netResultSet);
            n2 = this.peekCodePoint();
        }
        if (n2 == 8715) {
            this.parseEndQuery(netResultSet);
        }
        return netResultSet;
    }

    private void parseOpenQuery(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        Object object;
        NetResultSet netResultSet = this.parseOPNQRYRM(statementCallbackInterface, true);
        NetSqlca netSqlca = null;
        int n2 = this.peekCodePoint();
        if (n2 != 9242) {
            n2 = this.parseTypdefsOrMgrlvlovrs();
            if (n2 == 9233) {
                object = ClientDriver.getFactory().newColumnMetaData(this.netAgent_.logWriter_);
                NetSqlca netSqlca2 = this.parseSQLDARD((ColumnMetaData)object, false);
                statementCallbackInterface.completePrepareDescribeOutput((ColumnMetaData)object, netSqlca2);
                n2 = this.parseTypdefsOrMgrlvlovrs();
            }
            if (n2 == 9224) {
                netSqlca = this.parseSQLCARD(null);
                n2 = this.parseTypdefsOrMgrlvlovrs();
            }
        }
        this.parseQRYDSC(netResultSet.netCursor_);
        n2 = this.peekCodePoint();
        while (n2 == 9243) {
            this.parseQRYDTA(netResultSet);
            n2 = this.peekCodePoint();
        }
        if (n2 == 9224) {
            object = this.parseSQLCARD(null);
            statementCallbackInterface.completeSqlca((Sqlca)object);
            n2 = this.peekCodePoint();
        }
        if (n2 == 8715) {
            this.parseEndQuery(netResultSet);
        }
        statementCallbackInterface.completeOpenQuery(netSqlca, netResultSet);
    }

    void parseEndQuery(ResultSetCallbackInterface resultSetCallbackInterface) throws DisconnectException {
        this.parseENDQRYRM(resultSetCallbackInterface);
        this.parseTypdefsOrMgrlvlovrs();
        NetSqlca netSqlca = this.parseSQLCARD(null);
        resultSetCallbackInterface.earlyCloseComplete(netSqlca);
    }

    private void parseOpenQueryFailure(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        this.parseOPNQFLRM(statementCallbackInterface);
        this.parseTypdefsOrMgrlvlovrs();
        NetSqlca netSqlca = this.parseSQLCARD(null);
        statementCallbackInterface.completeOpenQuery(netSqlca, null);
    }

    private void parsePrepareError(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        int n2 = this.peekCodePoint();
        switch (n2) {
            case 8717: {
                NetSqlca netSqlca = this.parseAbnormalEndUow(statementCallbackInterface);
                statementCallbackInterface.completeSqlca(netSqlca);
                break;
            }
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 8718: {
                this.parseDTAMCHRM();
                break;
            }
            case 4691: {
                this.parseOBJNSPRM();
                break;
            }
            case 8708: {
                this.parseRDBNACRM();
                break;
            }
            case 8723: {
                NetSqlca netSqlca = this.parseSqlErrorCondition();
                statementCallbackInterface.completeSqlca(netSqlca);
                break;
            }
            default: {
                this.parseCommonError(n2);
            }
        }
    }

    private void parseExecuteImmediateError(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        int n2 = this.peekCodePoint();
        switch (n2) {
            case 8717: {
                NetSqlca netSqlca = this.parseAbnormalEndUow(statementCallbackInterface);
                statementCallbackInterface.completeSqlca(netSqlca);
                break;
            }
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 8718: {
                this.parseDTAMCHRM();
                break;
            }
            case 4691: {
                this.parseOBJNSPRM();
                break;
            }
            case 8708: {
                this.parseRDBNACRM();
                break;
            }
            case 8723: {
                NetSqlca netSqlca = this.parseSqlErrorCondition();
                statementCallbackInterface.completeSqlca(netSqlca);
                break;
            }
            default: {
                this.parseCommonError(n2);
            }
        }
    }

    private void parseDescribeError(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        int n2 = this.peekCodePoint();
        switch (n2) {
            case 8717: {
                NetSqlca netSqlca = this.parseAbnormalEndUow(statementCallbackInterface);
                statementCallbackInterface.completeSqlca(netSqlca);
                break;
            }
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 8708: {
                this.parseRDBNACRM();
                break;
            }
            case 8723: {
                NetSqlca netSqlca = this.parseSqlErrorCondition();
                statementCallbackInterface.completeSqlca(netSqlca);
                break;
            }
            default: {
                this.parseCommonError(n2);
            }
        }
    }

    private void parseOpenQueryError(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        int n2 = this.peekCodePoint();
        switch (n2) {
            case 8717: {
                NetSqlca netSqlca = this.parseAbnormalEndUow(statementCallbackInterface);
                statementCallbackInterface.completeSqlca(netSqlca);
                break;
            }
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 8718: {
                this.parseDTAMCHRM();
                break;
            }
            case 4691: {
                this.parseOBJNSPRM();
                break;
            }
            case 8719: {
                this.parseQRYPOPRM();
                break;
            }
            case 8708: {
                this.parseRDBNACRM();
                break;
            }
            default: {
                this.parseCommonError(n2);
            }
        }
    }

    private void parseExecuteError(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        int n2 = this.peekCodePoint();
        switch (n2) {
            case 8717: {
                NetSqlca netSqlca = this.parseAbnormalEndUow(statementCallbackInterface);
                statementCallbackInterface.completeSqlca(netSqlca);
                break;
            }
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 8718: {
                this.parseDTAMCHRM();
                break;
            }
            case 4691: {
                this.parseOBJNSPRM();
                break;
            }
            case 8708: {
                this.parseRDBNACRM();
                break;
            }
            case 8723: {
                NetSqlca netSqlca = this.parseSqlErrorCondition();
                statementCallbackInterface.completeSqlca(netSqlca);
                break;
            }
            default: {
                this.parseCommonError(n2);
            }
        }
    }

    private void parseExecuteSetStatementError(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        int n2 = this.peekCodePoint();
        switch (n2) {
            case 8717: {
                NetSqlca netSqlca = this.parseAbnormalEndUow(statementCallbackInterface);
                statementCallbackInterface.completeSqlca(netSqlca);
                break;
            }
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 8718: {
                this.parseDTAMCHRM();
                break;
            }
            case 4691: {
                this.parseOBJNSPRM();
                break;
            }
            case 8708: {
                this.parseRDBNACRM();
                break;
            }
            case 8723: {
                NetSqlca netSqlca = this.parseSqlErrorCondition();
                statementCallbackInterface.completeSqlca(netSqlca);
                break;
            }
            default: {
                this.parseCommonError(n2);
            }
        }
    }

    private NetResultSet parseOPNQRYRM(StatementCallbackInterface statementCallbackInterface, boolean bl) throws DisconnectException {
        int n2 = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        int n3 = 0;
        boolean bl3 = false;
        int n4 = 240;
        boolean bl4 = false;
        int n5 = 240;
        boolean bl5 = false;
        int n6 = 0;
        boolean bl6 = false;
        int n7 = 0;
        boolean bl7 = false;
        long l2 = 0L;
        boolean bl8 = false;
        int n8 = 240;
        boolean bl9 = false;
        this.parseLengthAndMatchCodePoint(8709);
        int n9 = this.getDdmLength();
        this.ensureBLayerDataInBuffer(n9);
        int n10 = this.peekCodePoint();
        int n11 = 0;
        while (n9 > 0) {
            boolean bl10 = false;
            if (n10 == 4425) {
                bl10 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                n11 = this.peekedLength_;
                n2 = this.parseFastSVRCOD(CodePoint.SVRCOD_INFO, CodePoint.SVRCOD_SESDMG);
                n9 = this.adjustDdmLength(n9, n11);
                n10 = this.peekCodePoint();
            }
            if (n10 == 8450) {
                bl10 = true;
                bl3 = this.checkAndGetReceivedFlag(bl3);
                n11 = this.peekedLength_;
                n3 = this.parseFastQRYPRCTYP();
                n9 = this.adjustDdmLength(n9, n11);
                n10 = this.peekCodePoint();
            }
            if (n10 == 8479) {
                bl10 = true;
                bl4 = this.checkAndGetReceivedFlag(bl4);
                n11 = this.peekedLength_;
                n4 = this.parseFastSQLCSRHLD();
                n9 = this.adjustDdmLength(n9, n11);
                n10 = this.peekCodePoint();
            }
            if (n10 == 8521) {
                bl10 = true;
                bl5 = this.checkAndGetReceivedFlag(bl5);
                n11 = this.peekedLength_;
                n5 = this.parseFastQRYATTSCR();
                n9 = this.adjustDdmLength(n9, n11);
                n10 = this.peekCodePoint();
            }
            if (n10 == 8535) {
                bl10 = true;
                bl6 = this.checkAndGetReceivedFlag(bl6);
                n11 = this.peekedLength_;
                n6 = this.parseFastQRYATTSNS();
                n9 = this.adjustDdmLength(n9, n11);
                n10 = this.peekCodePoint();
            }
            if (n10 == 8528) {
                bl10 = true;
                bl7 = this.checkAndGetReceivedFlag(bl7);
                n11 = this.peekedLength_;
                n7 = this.parseFastQRYATTUPD();
                n9 = this.adjustDdmLength(n9, n11);
                n10 = this.peekCodePoint();
            }
            if (n10 == 8539) {
                bl10 = true;
                bl8 = this.checkAndGetReceivedFlag(bl8);
                n11 = this.peekedLength_;
                l2 = this.parseFastQRYINSID();
                n9 = this.adjustDdmLength(n9, n11);
                n10 = this.peekCodePoint();
            }
            if (n10 == 8522) {
                bl10 = true;
                bl9 = this.checkAndGetReceivedFlag(bl9);
                n11 = this.peekedLength_;
                n8 = this.parseFastQRYATTSET();
                n9 = this.adjustDdmLength(n9, n11);
                n10 = this.peekCodePoint();
            }
            if (bl10) continue;
            this.doPrmnsprmSemantics(n10);
        }
        this.checkRequiredObjects(bl2, bl3, bl8);
        this.netAgent_.setSvrcod(n2);
        ClientStatement clientStatement = (ClientStatement)statementCallbackInterface;
        NetResultSet netResultSet = null;
        if (clientStatement.cachedCursor_ != null) {
            clientStatement.cachedCursor_.resetDataBuffer();
            ((NetCursor)clientStatement.cachedCursor_).extdtaData_.clear();
            try {
                netResultSet = (NetResultSet)ClientDriver.getFactory().newNetResultSet(this.netAgent_, (NetStatement)clientStatement.getMaterialStatement(), clientStatement.cachedCursor_, n3, n4, n5, n6, n8, l2, this.calculateResultSetType(n5, n6, clientStatement.resultSetType_), this.calculateResultSetConcurrency(n7, clientStatement.resultSetConcurrency_), this.calculateResultSetHoldability(n4));
            }
            catch (SqlException sqlException) {
                throw new DisconnectException(this.netAgent_, sqlException);
            }
        }
        try {
            netResultSet = (NetResultSet)ClientDriver.getFactory().newNetResultSet(this.netAgent_, (NetStatement)clientStatement.getMaterialStatement(), new NetCursor(this.netAgent_, n3), n3, n4, n5, n6, n8, l2, this.calculateResultSetType(n5, n6, clientStatement.resultSetType_), this.calculateResultSetConcurrency(n7, clientStatement.resultSetConcurrency_), this.calculateResultSetHoldability(n4));
        }
        catch (SqlException sqlException) {
            throw new DisconnectException(this.netAgent_, sqlException);
        }
        boolean bl11 = bl && netResultSet.resultSetType_ == 1003 && this.netAgent_.netConnection_.serverSupportsQryclsimp();
        netResultSet.netCursor_.setQryclsimpEnabled(bl11);
        return netResultSet;
    }

    private void parseENDQRYRM(ResultSetCallbackInterface resultSetCallbackInterface) throws DisconnectException {
        boolean bl = false;
        int n2 = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        String string = null;
        this.parseLengthAndMatchCodePoint(8715);
        this.pushLengthOnCollectionStack();
        int n3 = this.peekCodePoint();
        while (n3 != -1) {
            boolean bl3 = false;
            if (n3 == 4425) {
                bl3 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n2 = this.parseSVRCOD(CodePoint.SVRCOD_WARNING, CodePoint.SVRCOD_ERROR);
                n3 = this.peekCodePoint();
            }
            if (n3 == 8464) {
                bl3 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                string = this.parseRDBNAM(true);
                n3 = this.peekCodePoint();
            }
            if (bl3) continue;
            this.doPrmnsprmSemantics(n3);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl);
        this.netAgent_.setSvrcod(n2);
    }

    private void parseQRYPOPRM() throws DisconnectException {
        boolean bl = false;
        int n2 = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        String string = null;
        boolean bl3 = false;
        Section section = null;
        this.parseLengthAndMatchCodePoint(8719);
        this.pushLengthOnCollectionStack();
        int n3 = this.peekCodePoint();
        while (n3 != -1) {
            boolean bl4 = false;
            if (n3 == 4425) {
                bl4 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n2 = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                n3 = this.peekCodePoint();
            }
            if (n3 == 8464) {
                bl4 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                string = this.parseRDBNAM(true);
                n3 = this.peekCodePoint();
            }
            if (n3 == 8467) {
                bl4 = true;
                bl3 = this.checkAndGetReceivedFlag(bl3);
                section = this.parsePKGNAMCSN(true);
                n3 = this.peekCodePoint();
            }
            if (bl4) continue;
            this.doPrmnsprmSemantics(n3);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl, bl2, bl3);
        this.netAgent_.setSvrcod(n2);
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("08006.C"), MessageUtil.getCompleteMessage("J129", "org.apache.derby.loc.clientmessages", null)));
    }

    private void parseOPNQFLRM(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        boolean bl = false;
        int n2 = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        String string = null;
        this.parseLengthAndMatchCodePoint(8722);
        this.pushLengthOnCollectionStack();
        int n3 = this.peekCodePoint();
        while (n3 != -1) {
            boolean bl3 = false;
            if (n3 == 4425) {
                bl3 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n2 = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                n3 = this.peekCodePoint();
            }
            if (n3 == 8464) {
                bl3 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                string = this.parseRDBNAM(true);
                n3 = this.peekCodePoint();
            }
            if (bl3) continue;
            this.doPrmnsprmSemantics(n3);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl, bl2);
        this.netAgent_.setSvrcod(n2);
    }

    private List<Section> parseRSLSETRM() throws DisconnectException {
        boolean bl = false;
        int n2 = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        List<Section> list = null;
        this.parseLengthAndMatchCodePoint(8729);
        this.pushLengthOnCollectionStack();
        int n3 = this.peekCodePoint();
        while (n3 != -1) {
            boolean bl3 = false;
            if (n3 == 4425) {
                bl3 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n2 = this.parseSVRCOD(CodePoint.SVRCOD_INFO, CodePoint.SVRCOD_INFO);
                n3 = this.peekCodePoint();
            }
            if (n3 == 8505) {
                bl3 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                list = this.parsePKGSNLST();
                n3 = this.peekCodePoint();
            }
            if (bl3) continue;
            this.doPrmnsprmSemantics(n3);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl, bl2);
        this.netAgent_.setSvrcod(n2);
        return list;
    }

    private NetSqlca parseSQLDTARD(NetSqldta netSqldta) throws DisconnectException {
        boolean bl = false;
        boolean bl2 = false;
        this.parseLengthAndMatchCodePoint(9235);
        this.pushLengthOnCollectionStack();
        NetSqlca netSqlca = null;
        int n2 = this.peekCodePoint();
        while (n2 != -1) {
            boolean bl3 = false;
            if (n2 == 16) {
                bl3 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                this.parseFDODSC(netSqldta);
                n2 = this.peekCodePoint();
            }
            if (n2 == 5242) {
                bl3 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                netSqlca = this.parseFDODTA(netSqldta);
                n2 = this.peekCodePoint();
            }
            if (bl3) continue;
            this.doPrmnsprmSemantics(n2);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl, bl2);
        netSqldta.calculateColumnOffsetsForRow();
        return netSqlca;
    }

    private void parseQRYDSC(NetCursor netCursor) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(9242);
        this.parseSQLDTARDarray(netCursor, false);
    }

    private void parseFDODSC(NetCursor netCursor) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(16);
        this.parseSQLDTARDarray(netCursor, false);
    }

    private void parseSQLDTARDarray(NetCursor netCursor, boolean bl) throws DisconnectException {
        int n2;
        int n3;
        if (bl) {
            this.skipBytes();
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        this.netAgent_.targetTypdef_.clearMddOverrides();
        this.ensureBLayerDataInBuffer(n3);
        block11: for (n3 = this.getDdmLength(); n3 > 0; n3 -= n2) {
            n2 = this.readFastUnsignedByte();
            int n8 = this.readFastUnsignedByte();
            int n9 = this.readFastUnsignedByte();
            switch (n8) {
                case 120: {
                    if (n2 != 7 || n9 != 0) {
                        this.descriptorErrorDetected();
                    }
                    this.checkPreviousSQLDTARDtriplet(n4, 2, n5, 3);
                    n4 = 2;
                    n5 = 3;
                    int n10 = this.readFastUnsignedByte();
                    int n11 = this.readFastUnsignedByte();
                    int n12 = this.readFastUnsignedByte();
                    n6 = this.readFastUnsignedByte();
                    continue block11;
                }
                case 118: {
                    if (n9 != 208) {
                        this.descriptorErrorDetected();
                    }
                    this.checkPreviousSQLDTARDtriplet(n4, 5, n5, 4);
                    n4 = 5;
                    n5 = 3;
                    int n13 = this.peekTotalColumnCount(n2);
                    netCursor.initializeColumnInfoArrays(this.netAgent_.targetTypdef_, n13);
                    n7 += this.parseSQLDTAGRPdataLabelsAndUpdateColumn(netCursor, n7, n2);
                    continue block11;
                }
                case 113: {
                    switch (n9) {
                        case 224: {
                            if (n2 != 9) {
                                this.descriptorErrorDetected();
                            }
                            this.checkPreviousSQLDTARDtriplet(n4, 4, n5, 5);
                            n4 = 4;
                            n5 = 5;
                            this.checkFastRLO(FdocaConstants.RLO_SQLCADTA);
                            continue block11;
                        }
                        case 240: {
                            if (n2 != 6) {
                                this.descriptorErrorDetected();
                            }
                            this.checkPreviousSQLDTARDtriplet(n4, 4, n5, 6);
                            n4 = 4;
                            n5 = 6;
                            this.checkFastRLO(FdocaConstants.RLO_SQLDTARD);
                            continue block11;
                        }
                    }
                    this.descriptorErrorDetected();
                    continue block11;
                }
                case 127: {
                    if (n9 != 0) {
                        this.descriptorErrorDetected();
                    }
                    this.checkPreviousSQLDTARDtriplet(n4, 6, n5, 3);
                    n4 = 6;
                    n5 = 3;
                    n7 += this.parseSQLDTAGRPdataLabelsAndUpdateColumn(netCursor, n7, n2);
                    continue block11;
                }
                case 112: {
                    if (n2 != 12) {
                        this.descriptorErrorDetected();
                    }
                    this.checkPreviousSQLDTARDtriplet(n4, 3, n5, 2);
                    n4 = 3;
                    n5 = 2;
                    this.netAgent_.targetTypdef_.setMddOverride(n6, n9, this.readFastUnsignedByte(), this.readFastInt(), this.readFastUnsignedByte(), this.readFastUnsignedByte(), this.readFastShort());
                    continue block11;
                }
                default: {
                    this.descriptorErrorDetected();
                }
            }
        }
        this.adjustLengths(this.getDdmLength());
        netCursor.allocateCharBuffer();
        this.checkPreviousSQLDTARDtriplet(n4, 1, n5, 1);
    }

    private void checkPreviousSQLDTARDtriplet(int n2, int n3, int n4, int n5) throws DisconnectException {
        if (!FdocaConstants.SQLDTARD_TRIPLET_TYPES[n2][n3]) {
            this.descriptorErrorDetected();
        }
        if (!FdocaConstants.SQLDTARD_TRIPLET_IDS[n4][n5]) {
            this.descriptorErrorDetected();
        }
    }

    private void checkFastRLO(int[][] nArray) throws DisconnectException {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2;
            int n3;
            int n4 = this.readFastUnsignedByte();
            if (n4 != nArray[i2][0]) {
                this.descriptorErrorDetected();
            }
            if ((n3 = this.readFastUnsignedByte()) != nArray[i2][1]) {
                this.descriptorErrorDetected();
            }
            if ((n2 = this.readFastUnsignedByte()) == nArray[i2][2]) continue;
            this.descriptorErrorDetected();
        }
    }

    private void descriptorErrorDetected() throws DisconnectException {
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("08006.C"), MessageUtil.getCompleteMessage("J130", "org.apache.derby.loc.clientmessages", null)));
    }

    void parseQRYDTA(NetResultSet netResultSet) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(9243);
        if (this.longValueForDecryption_ == null) {
            int n2 = this.getDdmLength();
            this.ensureBLayerDataInBuffer(n2);
        }
        this.parseSQLDTARDdata(netResultSet.netCursor_);
        if (this.longValueForDecryption_ == null) {
            this.adjustLengths(this.getDdmLength());
        } else {
            this.longValueForDecryption_ = null;
        }
        if (this.longBufferForDecryption_ != null) {
            this.buffer_ = this.longBufferForDecryption_;
            this.pos_ = this.longPosForDecryption_;
            if (this.count_ > this.longBufferForDecryption_.length) {
                this.count_ = this.longBufferForDecryption_.length;
            } else if (this.longCountForDecryption_ != 0) {
                this.count_ = this.longCountForDecryption_;
                this.longCountForDecryption_ = 0;
            }
            this.dssLength_ = 0;
            this.longBufferForDecryption_ = null;
        }
    }

    private NetSqlca parseFDODTA(NetCursor netCursor) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(5242);
        int n2 = this.getDdmLength();
        this.ensureBLayerDataInBuffer(n2);
        this.mark();
        NetSqlca netSqlca = this.parseSQLCARDrow(null);
        int n3 = this.getFastSkipSQLCARDrowLength();
        this.adjustLengths(n3);
        this.parseFastSQLDTARDdata(netCursor);
        return netSqlca;
    }

    private void parseFastSQLDTARDdata(NetCursor netCursor) throws DisconnectException {
        netCursor.dataBufferStream_ = this.getFastData(netCursor.dataBufferStream_);
        netCursor.dataBuffer_ = netCursor.dataBufferStream_.toByteArray();
        netCursor.lastValidBytePosition_ = netCursor.dataBuffer_.length;
    }

    private void parseSQLDTARDdata(NetCursor netCursor) throws DisconnectException {
        if (this.longValueForDecryption_ == null) {
            netCursor.dataBufferStream_ = this.getData(netCursor.dataBufferStream_);
            netCursor.dataBuffer_ = netCursor.dataBufferStream_.toByteArray();
        } else {
            int n2 = netCursor.dataBufferStream_.size();
            if (n2 == 0) {
                netCursor.dataBuffer_ = this.longValueForDecryption_;
            } else {
                byte[] byArray = new byte[n2 + this.longValueForDecryption_.length];
                System.arraycopy(netCursor.dataBuffer_, 0, byArray, 0, n2);
                System.arraycopy(this.longValueForDecryption_, 0, byArray, n2, this.longValueForDecryption_.length);
                netCursor.dataBuffer_ = byArray;
            }
        }
        netCursor.lastValidBytePosition_ = netCursor.dataBuffer_.length;
    }

    void copyEXTDTA(NetCursor netCursor) throws DisconnectException {
        try {
            this.parseLengthAndMatchCodePoint(5228);
            byte[] byArray = null;
            if (this.longValueForDecryption_ == null) {
                byArray = this.getData(null).toByteArray();
            } else {
                byArray = this.longValueForDecryption_;
                this.dssLength_ = 0;
                this.longValueForDecryption_ = null;
            }
            netCursor.extdtaData_.add(byArray);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("08006.C.6"), (Throwable)outOfMemoryError, new Object[0]));
        }
    }

    Section parsePKGNAMCSN(boolean bl) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(8467);
        if (bl) {
            this.skipBytes();
            return null;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        byte[] byArray = null;
        int n2 = 0;
        byte[] byArray2 = null;
        int n3 = 0;
        int n4 = this.getDdmLength();
        int n5 = 0;
        this.ensureBLayerDataInBuffer(n4);
        int n6 = this.netAgent_.netConnection_.databaseMetaData_.serverSupportLongRDBNAM() ? 1550 : 781;
        if (n4 == 64) {
            n3 = n4 - 2;
            byArray2 = new byte[n3];
            n5 = this.peekFastBytes(byArray2, n5, n3);
            string = this.readFastString(18);
            string2 = this.readFastString(18);
            string3 = this.readFastString(18);
            byArray = this.readFastBytes(8);
        } else if (n4 >= 71 && n4 <= n6) {
            int n7;
            byArray2 = new byte[n4 - 2];
            int n8 = this.peekFastLength();
            int n9 = n7 = this.netAgent_.netConnection_.databaseMetaData_.serverSupportLongRDBNAM() ? 1024 : 255;
            if (n8 < 18 || n8 > n7) {
                this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.21"), n8));
                return null;
            }
            n5 = this.peekFastBytes(byArray2, n5, 2 + n8);
            this.skipFastBytes(2);
            string = this.readFastString(n8);
            n8 = this.peekFastLength();
            if (n8 < 18 || n8 > 255) {
                this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.7"), n8));
                return null;
            }
            n5 = this.peekFastBytes(byArray2, n5, 2 + n8);
            this.skipFastBytes(2);
            string2 = this.readFastString(n8);
            n8 = this.peekFastLength();
            if (n8 < 18 || n8 > 255) {
                this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.8"), n8));
                return null;
            }
            n5 = this.peekFastBytes(byArray2, n5, 2 + n8);
            this.skipFastBytes(2);
            string3 = this.readFastString(n8);
            n5 = this.peekFastBytes(byArray2, n5, 8);
            byArray = this.readFastBytes(8);
        } else {
            this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.9"), n4, this.netAgent_.targetSqlam_));
            return null;
        }
        n2 = this.readFastUnsignedShort();
        this.adjustLengths(n4);
        Section section = new Section(this.agent_, string3, n2, null, -1, true);
        section.setPKGNAMCBytes(byArray2);
        return section;
    }

    private int parseFastQRYPRCTYP() throws DisconnectException {
        this.matchCodePoint(8450);
        int n2 = this.readFastUnsignedShort();
        if (n2 != 9240 && n2 != 9239) {
            this.doValnsprmSemantics(8450, n2);
        }
        return n2;
    }

    private int parseFastSQLCSRHLD() throws DisconnectException {
        this.matchCodePoint(8479);
        int n2 = this.readFastUnsignedByte();
        if (n2 != 240 && n2 != 241) {
            this.doValnsprmSemantics(8479, n2);
        }
        return n2;
    }

    private int parseFastQRYATTSCR() throws DisconnectException {
        this.matchCodePoint(8521);
        int n2 = this.readFastUnsignedByte();
        if (n2 != 240 && n2 != 241) {
            this.doValnsprmSemantics(8521, n2);
        }
        return n2;
    }

    private int parseFastQRYATTSET() throws DisconnectException {
        this.matchCodePoint(8522);
        int n2 = this.readFastUnsignedByte();
        if (n2 != 240 && n2 != 241) {
            this.doValnsprmSemantics(8522, n2);
        }
        return n2;
    }

    private int parseFastQRYATTSNS() throws DisconnectException {
        this.matchCodePoint(8535);
        int n2 = this.readFastUnsignedByte();
        switch (n2) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                this.doValnsprmSemantics(8535, n2);
            }
        }
        return n2;
    }

    private int parseFastQRYATTUPD() throws DisconnectException {
        this.matchCodePoint(8528);
        int n2 = this.readFastUnsignedByte();
        switch (n2) {
            case 0: 
            case 1: 
            case 4: {
                break;
            }
            default: {
                this.doValnsprmSemantics(8528, n2);
            }
        }
        return n2;
    }

    private long parseFastQRYINSID() throws DisconnectException {
        this.matchCodePoint(8539);
        return this.readFastLong();
    }

    private List<Section> parsePKGSNLST() throws DisconnectException {
        ArrayList<Section> arrayList = new ArrayList<Section>();
        this.parseLengthAndMatchCodePoint(8505);
        this.pushLengthOnCollectionStack();
        while (this.peekCodePoint() != -1) {
            arrayList.add(this.parsePKGNAMCSN(false));
        }
        this.popCollectionStack();
        return arrayList;
    }

    private NetSqlca parseSQLDARD(ColumnMetaData columnMetaData, boolean bl) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(9233);
        return this.parseSQLDARDarray(columnMetaData, bl);
    }

    private int parseSQLRSLRD(List<Section> list) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(9230);
        return this.parseSQLRSLRDarray(list);
    }

    private ColumnMetaData parseSQLCINRD() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(9227);
        int n2 = this.getDdmLength();
        this.ensureBLayerDataInBuffer(n2);
        ColumnMetaData columnMetaData = this.parseSQLCINRDarray();
        this.adjustLengths(this.getDdmLength());
        return columnMetaData;
    }

    private NetSqlca parseSQLDARDarray(ColumnMetaData columnMetaData, boolean bl) throws DisconnectException {
        int n2 = 0;
        if (!this.ensuredLengthForDecryption_ && this.longValueForDecryption_ == null) {
            n2 = this.getDdmLength();
            this.ensureBLayerDataInBuffer(n2);
        }
        if (this.longValueForDecryption_ != null) {
            this.buffer_ = this.longValueForDecryption_;
            this.pos_ = 0;
            this.count_ = this.longValueForDecryption_.length;
        }
        NetSqlca netSqlca = null;
        if (bl) {
            this.mark();
            netSqlca = this.parseSQLCARDrow(null);
            this.skipFastBytes(n2 - this.getFastSkipSQLCARDrowLength());
            this.adjustLengths(this.getDdmLength());
            return netSqlca;
        }
        netSqlca = this.parseSQLCARDrow(null);
        this.parseSQLDHROW(columnMetaData);
        int n3 = this.parseSQLNUMROW();
        if (n3 > columnMetaData.columns_) {
            columnMetaData.initializeCache(n3);
        } else {
            columnMetaData.columns_ = n3;
        }
        for (int i2 = 0; i2 < columnMetaData.columns_; ++i2) {
            this.parseSQLDAROW(columnMetaData, i2);
        }
        if (this.longValueForDecryption_ == null) {
            this.adjustLengths(this.getDdmLength());
        } else {
            this.dssLength_ = 0;
            this.longValueForDecryption_ = null;
        }
        return netSqlca;
    }

    private int parseSQLRSLRDarray(List<Section> list) throws DisconnectException {
        int n2 = this.parseSQLNUMROW();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.parseSQLRSROW(list.get(i2));
        }
        return n2;
    }

    private ColumnMetaData parseSQLCINRDarray() throws DisconnectException {
        ColumnMetaData columnMetaData = ClientDriver.getFactory().newColumnMetaData(this.netAgent_.logWriter_);
        this.parseSQLDHROW(columnMetaData);
        columnMetaData.initializeCache(this.parseFastSQLNUMROW());
        for (int i2 = 0; i2 < columnMetaData.columns_; ++i2) {
            this.parseSQLDAROW(columnMetaData, i2);
        }
        return columnMetaData;
    }

    private void parseSQLDAROW(ColumnMetaData columnMetaData, int n2) throws DisconnectException {
        this.parseSQLDAGRP(columnMetaData, n2);
    }

    private void parseSQLDHROW(ColumnMetaData columnMetaData) throws DisconnectException {
        this.parseSQLDHGRP(columnMetaData);
    }

    private void parseSQLRSROW(Section section) throws DisconnectException {
        this.parseSQLRSGRP(section);
    }

    private void parseSQLDAGRP(ColumnMetaData columnMetaData, int n2) throws DisconnectException {
        long l2 = 0L;
        short s2 = this.readFastShort();
        short s3 = this.readFastShort();
        l2 = this.readFastLong();
        short s4 = this.readFastShort();
        int n3 = this.readFastUnsignedShort();
        columnMetaData.sqlPrecision_[n2] = s2;
        columnMetaData.sqlScale_[n2] = s3;
        columnMetaData.sqlLength_[n2] = l2;
        columnMetaData.sqlType_[n2] = s4;
        columnMetaData.nullable_[n2] = Utils.isSqlTypeNullable(s4);
        columnMetaData.sqlCcsid_[n2] = n3;
        columnMetaData.types_[n2] = ClientTypes.mapDERBYTypeToDriverType(true, s4, l2, n3);
        this.parseSQLDOPTGRP(columnMetaData, n2);
    }

    private void parseSQLUDTGRP(ColumnMetaData columnMetaData, int n2) throws DisconnectException {
        int n3 = columnMetaData.types_[n2];
        if (n3 != 2000 || !this.netAgent_.netConnection_.serverSupportsUDTs()) {
            if (this.readFastUnsignedByte() == 255) {
                return;
            }
        } else {
            String string = this.parseFastVCMorVCS();
            String string2 = this.parseFastVCMorVCS();
            columnMetaData.sqlUDTname_[n2] = string;
            columnMetaData.sqlUDTclassName_[n2] = string2;
        }
    }

    private void parseSQLDOPTGRP(ColumnMetaData columnMetaData, int n2) throws DisconnectException {
        if (this.readFastUnsignedByte() == 255) {
            return;
        }
        short s2 = this.readFastShort();
        String string = this.parseFastVCMorVCS();
        String string2 = this.parseFastVCMorVCS();
        String string3 = this.parseFastVCMorVCS();
        if (columnMetaData.sqlName_ == null) {
            columnMetaData.sqlName_ = new String[columnMetaData.columns_];
        }
        if (columnMetaData.sqlLabel_ == null) {
            columnMetaData.sqlLabel_ = new String[columnMetaData.columns_];
        }
        if (columnMetaData.sqlUnnamed_ == null) {
            columnMetaData.sqlUnnamed_ = new short[columnMetaData.columns_];
        }
        if (columnMetaData.sqlComment_ == null) {
            columnMetaData.sqlComment_ = new String[columnMetaData.columns_];
        }
        columnMetaData.sqlName_[n2] = string;
        columnMetaData.sqlLabel_[n2] = string2;
        columnMetaData.sqlUnnamed_[n2] = s2;
        columnMetaData.sqlComment_[n2] = string3;
        this.parseSQLUDTGRP(columnMetaData, n2);
        this.parseSQLDXGRP(columnMetaData, n2);
    }

    private void parseSQLDXGRP(ColumnMetaData columnMetaData, int n2) throws DisconnectException {
        if (this.readFastUnsignedByte() == 255) {
            return;
        }
        short s2 = this.readFastShort();
        short s3 = this.readFastShort();
        short s4 = this.readFastShort();
        short s5 = this.readFastShort();
        String string = this.parseFastVCS();
        String string2 = this.parseFastVCMorVCS();
        String string3 = this.parseFastVCMorVCS();
        String string4 = this.parseFastVCMorVCS();
        String string5 = this.parseFastVCMorVCS();
        if (columnMetaData.sqlxKeymem_ == null) {
            columnMetaData.sqlxKeymem_ = new short[columnMetaData.columns_];
        }
        if (columnMetaData.sqlxGenerated_ == null) {
            columnMetaData.sqlxGenerated_ = new short[columnMetaData.columns_];
        }
        if (columnMetaData.sqlxParmmode_ == null) {
            columnMetaData.sqlxParmmode_ = new short[columnMetaData.columns_];
        }
        if (columnMetaData.sqlxCorname_ == null) {
            columnMetaData.sqlxCorname_ = new String[columnMetaData.columns_];
        }
        if (columnMetaData.sqlxName_ == null) {
            columnMetaData.sqlxName_ = new String[columnMetaData.columns_];
        }
        if (columnMetaData.sqlxBasename_ == null) {
            columnMetaData.sqlxBasename_ = new String[columnMetaData.columns_];
        }
        if (columnMetaData.sqlxUpdatable_ == null) {
            columnMetaData.sqlxUpdatable_ = new int[columnMetaData.columns_];
        }
        if (columnMetaData.sqlxSchema_ == null) {
            columnMetaData.sqlxSchema_ = new String[columnMetaData.columns_];
        }
        if (columnMetaData.sqlxRdbnam_ == null) {
            columnMetaData.sqlxRdbnam_ = new String[columnMetaData.columns_];
        }
        columnMetaData.sqlxKeymem_[n2] = s2;
        columnMetaData.sqlxGenerated_[n2] = s4;
        columnMetaData.sqlxParmmode_[n2] = s5;
        columnMetaData.sqlxCorname_[n2] = string2;
        columnMetaData.sqlxName_[n2] = string5;
        columnMetaData.sqlxBasename_[n2] = string3;
        columnMetaData.sqlxUpdatable_[n2] = s3;
        columnMetaData.sqlxSchema_[n2] = string4 == null ? columnMetaData.sqldSchema_ : string4;
        columnMetaData.sqlxRdbnam_[n2] = string == null ? columnMetaData.sqldRdbnam_ : string;
    }

    private void parseSQLDHGRP(ColumnMetaData columnMetaData) throws DisconnectException {
        if (this.readFastUnsignedByte() == 255) {
            return;
        }
        short s2 = this.readFastShort();
        short s3 = this.readFastShort();
        short s4 = this.readFastShort();
        short s5 = this.readFastShort();
        short s6 = this.readFastShort();
        short s7 = this.readFastShort();
        String string = this.parseFastVCS();
        String string2 = this.parseFastVCMorVCS();
        columnMetaData.sqldHold_ = s2;
        columnMetaData.sqldReturn_ = s3;
        columnMetaData.sqldScroll_ = s4;
        columnMetaData.sqldSensitive_ = s5;
        columnMetaData.sqldFcode_ = s6;
        columnMetaData.sqldKeytype_ = s7;
        columnMetaData.sqldRdbnam_ = string;
        columnMetaData.sqldSchema_ = string2;
    }

    private void parseSQLRSGRP(Section section) throws DisconnectException {
        int n2 = this.readInt();
        String string = this.parseVCMorVCS();
        int n3 = this.readInt();
        section.setCursorName(string);
    }

    private String parseFastVCMorVCS() throws DisconnectException {
        String string = null;
        int n2 = this.readFastUnsignedShort();
        if (n2 > 0) {
            string = this.readFastString(n2, this.netAgent_.targetTypdef_.getCcsidMbcEncoding());
        }
        int n3 = this.readFastUnsignedShort();
        if (n2 > 0 && n3 > 0) {
            this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.10"), new Object[0]));
        } else if (n3 > 0) {
            string = this.readFastString(n3, this.netAgent_.targetTypdef_.getCcsidSbcEncoding());
        }
        return string;
    }

    private String parseVCMorVCS() throws DisconnectException {
        String string = null;
        int n2 = this.readUnsignedShort();
        if (n2 > 0) {
            string = this.readString(n2, this.netAgent_.targetTypdef_.getCcsidMbcEncoding());
        }
        int n3 = this.readUnsignedShort();
        if (n2 > 0 && n3 > 0) {
            this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.10"), new Object[0]));
        } else if (n3 > 0) {
            string = this.readString(n3, this.netAgent_.targetTypdef_.getCcsidSbcEncoding());
        }
        return string;
    }

    private int calculateResultSetType(int n2, int n3, int n4) {
        if (n2 == 240) {
            return 1003;
        }
        switch (n3) {
            case 1: {
                return 1004;
            }
        }
        return n4;
    }

    private int calculateResultSetConcurrency(int n2, int n3) {
        switch (n2) {
            case 1: {
                return 1007;
            }
            case 4: {
                return 1008;
            }
        }
        return n3;
    }

    private int calculateResultSetHoldability(int n2) {
        if (n2 == 240) {
            return 2;
        }
        return 1;
    }

    private int parseSQLDTAGRPdataLabelsAndUpdateColumn(NetCursor netCursor, int n2, int n3) throws DisconnectException {
        int n4 = (n3 - 3) / 3;
        for (int i2 = n2; i2 < n2 + n4; ++i2) {
            netCursor.qrydscTypdef_.updateColumn(netCursor, i2, this.readFastUnsignedByte(), this.readFastUnsignedShort());
        }
        return n4;
    }

    @Override
    public void readSetSpecialRegister(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseEXCSQLSETreply(statementCallbackInterface);
        this.endOfSameIdChainData();
    }
}

