/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

public class FloatingPoint {
    public static final int IEEE_754_FLOATING_POINT = 72;

    private FloatingPoint() {
    }

    private static final int convertFromByteToInt(byte[] byArray, int n2) {
        return byArray[n2] << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
    }

    private static final long convertFromByteToLong(byte[] byArray, int n2) {
        return ((long)byArray[n2] & 0xFFL) << 56 | ((long)byArray[n2 + 1] & 0xFFL) << 48 | ((long)byArray[n2 + 2] & 0xFFL) << 40 | ((long)byArray[n2 + 3] & 0xFFL) << 32 | ((long)byArray[n2 + 4] & 0xFFL) << 24 | ((long)byArray[n2 + 5] & 0xFFL) << 16 | ((long)byArray[n2 + 6] & 0xFFL) << 8 | (long)byArray[n2 + 7] & 0xFFL;
    }

    static float getFloat(byte[] byArray, int n2) {
        return Float.intBitsToFloat(FloatingPoint.convertFromByteToInt(byArray, n2));
    }

    static double getDouble(byte[] byArray, int n2) {
        return Double.longBitsToDouble(FloatingPoint.convertFromByteToLong(byArray, n2));
    }
}

