/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

public class DateTimeValue {
    private final int year;
    private final int month;
    private final int day;
    private final int hours;
    private final int minutes;
    private final int seconds;
    private final int nanos;

    private DateTimeValue(Calendar calendar, int n2) {
        this.year = calendar.get(1);
        this.month = calendar.get(2);
        this.day = calendar.get(5);
        this.hours = calendar.get(11);
        this.minutes = calendar.get(12);
        this.seconds = calendar.get(13);
        int n3 = calendar.get(14);
        this.nanos = n3 * 1000000 + n2 % 1000000;
    }

    DateTimeValue(java.sql.Date date, Calendar calendar) {
        this(DateTimeValue.initCalendar(calendar, date), 0);
    }

    DateTimeValue(Time time, Calendar calendar) {
        this(DateTimeValue.initCalendar(calendar, time), 0);
    }

    DateTimeValue(Timestamp timestamp, Calendar calendar) {
        this(DateTimeValue.initCalendar(calendar, timestamp), timestamp.getNanos());
    }

    public DateTimeValue(java.sql.Date date) {
        this(date, Calendar.getInstance());
    }

    public DateTimeValue(Time time) {
        this(time, Calendar.getInstance());
    }

    public DateTimeValue(Timestamp timestamp) {
        this(timestamp, Calendar.getInstance());
    }

    private static Calendar initCalendar(Calendar calendar, Date date) {
        calendar.clear();
        calendar.setTime(date);
        return calendar;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDayOfMonth() {
        return this.day;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public int getNanos() {
        return this.nanos;
    }
}

