/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Locale;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientBlob;
import org.apache.derby.client.am.ClientClob;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ClientTypes;
import org.apache.derby.client.am.ColumnTypeConversionException;
import org.apache.derby.client.am.OutsideRangeForDataTypeException;
import org.apache.derby.client.am.SqlException;

final class CrossConverters {
    public static final int UNKNOWN_LENGTH = Integer.MIN_VALUE;
    private static final BigDecimal bdMaxByteValue__ = BigDecimal.valueOf(127L);
    private static final BigDecimal bdMinByteValue__ = BigDecimal.valueOf(-128L);
    private static final BigDecimal bdMaxShortValue__ = BigDecimal.valueOf(32767L);
    private static final BigDecimal bdMinShortValue__ = BigDecimal.valueOf(-32768L);
    private static final BigDecimal bdMaxIntValue__ = BigDecimal.valueOf(Integer.MAX_VALUE);
    private static final BigDecimal bdMinIntValue__ = BigDecimal.valueOf(Integer.MIN_VALUE);
    private static final BigDecimal bdMaxLongValue__ = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final BigDecimal bdMinLongValue__ = BigDecimal.valueOf(Long.MIN_VALUE);
    private static final BigDecimal bdMaxFloatValue__ = new BigDecimal(3.4028234663852886E38);
    private static final BigDecimal bdMinFloatValue__ = new BigDecimal(-3.4028234663852886E38);
    private static final BigDecimal bdMaxDoubleValue__ = new BigDecimal(Double.MAX_VALUE);
    private static final BigDecimal bdMinDoubleValue__ = new BigDecimal(-1.7976931348623157E308);
    private static final BigDecimal bdZero__ = BigDecimal.valueOf(0L);
    private static final BigDecimal bdOne__ = BigDecimal.valueOf(1L);
    private final Agent agent_;

    CrossConverters(Agent agent) {
        this.agent_ = agent;
    }

    final Object setObject(int n2, boolean bl) throws SqlException {
        short s2 = bl ? (short)1 : 0;
        switch (n2) {
            case -7: 
            case 16: {
                return bl;
            }
            case 5: {
                return s2;
            }
            case 4: {
                return (int)s2;
            }
            case -5: {
                return (long)s2;
            }
            case 7: {
                return Float.valueOf(s2);
            }
            case 8: {
                return (double)s2;
            }
            case 3: {
                return BigDecimal.valueOf(s2);
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(bl);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "boolean", ClientTypes.getTypeString(n2));
    }

    final Object setObject(int n2, byte by) throws SqlException {
        return this.setObject(n2, (short)by);
    }

    final Object setObject(int n2, short s2) throws SqlException {
        switch (n2) {
            case -7: 
            case 16: {
                return s2 != 0;
            }
            case 5: {
                return s2;
            }
            case 4: {
                return (int)s2;
            }
            case -5: {
                return (long)s2;
            }
            case 7: {
                return Float.valueOf(s2);
            }
            case 8: {
                return (double)s2;
            }
            case 3: {
                return BigDecimal.valueOf(s2);
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(s2);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "byte", ClientTypes.getTypeString(n2));
    }

    final Object setObject(int n2, int n3) throws SqlException {
        switch (n2) {
            case -7: 
            case 16: {
                return n3 != 0;
            }
            case 5: {
                if (n3 > Short.MAX_VALUE || n3 < Short.MIN_VALUE) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "SMALLINT");
                }
                return (short)n3;
            }
            case 4: {
                return n3;
            }
            case -5: {
                return (long)n3;
            }
            case 7: {
                return Float.valueOf(n3);
            }
            case 8: {
                return (double)n3;
            }
            case 3: {
                return BigDecimal.valueOf(n3);
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(n3);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "int", ClientTypes.getTypeString(n2));
    }

    final boolean setBooleanFromObject(Object object, int n2) throws SqlException {
        switch (n2) {
            case 5: {
                return this.getBooleanFromShort((Short)object);
            }
            case 4: {
                return this.getBooleanFromInt((Integer)object);
            }
            case -5: {
                return this.getBooleanFromLong(((BigInteger)object).longValue());
            }
            case 7: {
                return this.getBooleanFromFloat(((Float)object).floatValue());
            }
            case 8: {
                return this.getBooleanFromDouble((Double)object);
            }
            case 3: {
                return this.getBooleanFromLong(((BigDecimal)object).longValue());
            }
            case -1: 
            case 1: 
            case 12: {
                return this.getBooleanFromString((String)object);
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_, ClientTypes.getTypeString(n2), "boolean");
    }

    final byte setByteFromObject(Object object, int n2) throws SqlException {
        switch (n2) {
            case 5: {
                return this.getByteFromShort((Short)object);
            }
            case 4: {
                return this.getByteFromInt((Integer)object);
            }
            case -5: {
                return this.getByteFromLong(((BigInteger)object).longValue());
            }
            case 7: {
                return this.getByteFromFloat(((Float)object).floatValue());
            }
            case 8: {
                return this.getByteFromDouble((Double)object);
            }
            case 3: {
                return this.getByteFromLong(((BigDecimal)object).longValue());
            }
            case -1: 
            case 1: 
            case 12: {
                return this.getByteFromString((String)object);
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_, ClientTypes.getTypeString(n2), "byte");
    }

    final Object setObject(int n2, long l2) throws SqlException {
        switch (n2) {
            case -7: 
            case 16: {
                return l2 != 0L;
            }
            case 5: {
                if (l2 > 32767L || l2 < -32768L) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "SMALLINT");
                }
                return (short)l2;
            }
            case 4: {
                if (l2 > Integer.MAX_VALUE || l2 < Integer.MIN_VALUE) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "INTEGER");
                }
                return (int)l2;
            }
            case -5: {
                return l2;
            }
            case 7: {
                return Float.valueOf(l2);
            }
            case 8: {
                return (double)l2;
            }
            case 3: {
                return BigDecimal.valueOf(l2);
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(l2);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "long", ClientTypes.getTypeString(n2));
    }

    final Object setObject(int n2, float f2) throws SqlException {
        switch (n2) {
            case -7: 
            case 16: {
                return f2 != 0.0f;
            }
            case 5: {
                if (f2 > 32767.0f || f2 < -32768.0f) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "SMALLINT");
                }
                return (short)f2;
            }
            case 4: {
                if (f2 > 2.1474836E9f || f2 < -2.1474836E9f) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "INTEGER");
                }
                return (int)f2;
            }
            case -5: {
                if (f2 > 9.223372E18f || f2 < -9.223372E18f) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "BIGINT");
                }
                return (long)f2;
            }
            case 7: {
                if (f2 == Float.POSITIVE_INFINITY || f2 == Float.NEGATIVE_INFINITY) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "REAL");
                }
                return Float.valueOf(f2);
            }
            case 8: {
                if ((double)f2 == Double.POSITIVE_INFINITY || (double)f2 == Double.NEGATIVE_INFINITY) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "DOUBLE");
                }
                return Double.valueOf(String.valueOf(f2));
            }
            case 3: {
                return new BigDecimal(String.valueOf(f2));
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(f2);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "float", ClientTypes.getTypeString(n2));
    }

    final Object setObject(int n2, double d2) throws SqlException {
        switch (n2) {
            case -7: 
            case 16: {
                return d2 != 0.0;
            }
            case 5: {
                if (d2 > 32767.0 || d2 < -32768.0) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "SMALLINT");
                }
                return (short)d2;
            }
            case 4: {
                if (d2 > 2.147483647E9 || d2 < -2.147483648E9) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "INTEGER");
                }
                return (int)d2;
            }
            case -5: {
                if (d2 > 9.223372036854776E18 || d2 < -9.223372036854776E18) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "BIGINT");
                }
                return (long)d2;
            }
            case 7: {
                if (d2 > 3.4028234663852886E38 || d2 < -3.4028234663852886E38) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "REAL");
                }
                return Float.valueOf((float)d2);
            }
            case 8: {
                if (d2 == Double.POSITIVE_INFINITY || d2 == Double.NEGATIVE_INFINITY) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "DOUBLE");
                }
                return d2;
            }
            case 3: {
                return BigDecimal.valueOf(d2);
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(d2);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "double", ClientTypes.getTypeString(n2));
    }

    final Object setObject(int n2, BigDecimal bigDecimal) throws SqlException {
        switch (n2) {
            case -7: 
            case 16: {
                return BigDecimal.valueOf(0L).compareTo(bigDecimal) != 0;
            }
            case 5: {
                if (bigDecimal.compareTo(bdMaxShortValue__) == 1 || bigDecimal.compareTo(bdMinShortValue__) == -1) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "SMALLINT");
                }
                return bigDecimal.shortValue();
            }
            case 4: {
                if (bigDecimal.compareTo(bdMaxIntValue__) == 1 || bigDecimal.compareTo(bdMinIntValue__) == -1) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "INTEGER");
                }
                return bigDecimal.intValue();
            }
            case -5: {
                if (bigDecimal.compareTo(bdMaxLongValue__) == 1 || bigDecimal.compareTo(bdMinLongValue__) == -1) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "BIGINT");
                }
                return bigDecimal.longValue();
            }
            case 7: {
                if (bigDecimal.compareTo(bdMaxFloatValue__) == 1 || bigDecimal.compareTo(bdMinFloatValue__) == -1) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "REAL");
                }
                return Float.valueOf(bigDecimal.floatValue());
            }
            case 8: {
                if (bigDecimal.compareTo(bdMaxDoubleValue__) == 1 || bigDecimal.compareTo(bdMinDoubleValue__) == -1) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "DOUBLE");
                }
                return bigDecimal.doubleValue();
            }
            case 3: {
                return bigDecimal;
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(bigDecimal);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "java.Math.BigDecimal", ClientTypes.getTypeString(n2));
    }

    final Object setObject(int n2, Date date) throws SqlException {
        switch (n2) {
            case 91: {
                return date;
            }
            case 93: {
                return new Timestamp(date.getTime());
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(date);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "java.sql.Date", ClientTypes.getTypeString(n2));
    }

    final Object setObject(int n2, Time time) throws SqlException {
        switch (n2) {
            case 92: {
                return time;
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(time);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "java.sql.Time", ClientTypes.getTypeString(n2));
    }

    final Object setObject(int n2, Timestamp timestamp) throws SqlException {
        switch (n2) {
            case 93: {
                return timestamp;
            }
            case 92: {
                return new Time(timestamp.getTime());
            }
            case 91: {
                return new Date(timestamp.getTime());
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(timestamp);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "java.sql.Timestamp", ClientTypes.getTypeString(n2));
    }

    final Object setObject(int n2, String string) throws SqlException {
        try {
            switch (n2) {
                case -7: 
                case 16: {
                    String string2 = string.trim().toUpperCase(Locale.ENGLISH);
                    if (string2.equals("UNKNOWN")) {
                        return null;
                    }
                    if (string2.equals("TRUE")) {
                        return Boolean.TRUE;
                    }
                    if (string2.equals("FALSE")) {
                        return Boolean.FALSE;
                    }
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22018"), ClientTypes.getTypeString(n2));
                }
                case 5: {
                    return Short.valueOf(string);
                }
                case 4: {
                    return Integer.valueOf(string);
                }
                case -5: {
                    return Long.valueOf(string);
                }
                case 7: {
                    return Float.valueOf(string);
                }
                case 8: {
                    return Double.valueOf(string);
                }
                case 3: {
                    return new BigDecimal(string);
                }
                case 91: {
                    return CrossConverters.date_valueOf(string, null);
                }
                case 92: {
                    return CrossConverters.time_valueOf(string, null);
                }
                case 93: {
                    return CrossConverters.timestamp_valueOf(string, null);
                }
                case -1: 
                case 1: 
                case 12: {
                    return string;
                }
                case 2005: {
                    return new ClientClob(this.agent_, string);
                }
            }
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "String", ClientTypes.getTypeString(n2));
        }
        catch (NumberFormatException numberFormatException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22018"), numberFormatException, ClientTypes.getTypeString(n2));
        }
    }

    public static int getInputJdbcType(int n2) {
        switch (n2) {
            case -6: 
            case 5: {
                return 4;
            }
            case 2: {
                return 3;
            }
            case 6: {
                return 8;
            }
        }
        return n2;
    }

    final Object setObject(int n2, byte[] byArray) throws SqlException {
        switch (n2) {
            case -4: 
            case -3: 
            case -2: {
                return byArray;
            }
            case 2004: {
                return new ClientBlob(byArray, this.agent_, 0);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "byte[]", ClientTypes.getTypeString(n2));
    }

    final Object setObject(int n2, Reader reader, int n3) throws SqlException {
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                return this.setStringFromReader(reader, n3);
            }
            case 2005: {
                if (n3 == Integer.MIN_VALUE) {
                    return new ClientClob(this.agent_, reader);
                }
                return new ClientClob(this.agent_, reader, n3);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "java.io.Reader", ClientTypes.getTypeString(n2));
    }

    private String setStringFromReader(Reader reader, int n2) throws SqlException {
        StringWriter stringWriter = new StringWriter();
        try {
            int n3 = reader.read();
            int n4 = 0;
            while (n3 != -1) {
                ++n4;
                stringWriter.write(n3);
                n3 = reader.read();
            }
            if (n2 != Integer.MIN_VALUE && n2 != n4) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ099.S"), new Object[0]);
            }
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            throw SqlException.javaException(this.agent_.logWriter_, iOException);
        }
    }

    final Object setObjectFromCharacterStream(int n2, InputStream inputStream, Charset charset, int n3) throws SqlException {
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                return this.setStringFromStream(inputStream, charset, n3);
            }
            case 2005: {
                if (n3 == Integer.MIN_VALUE) {
                    return new ClientClob(this.agent_, inputStream, charset);
                }
                return new ClientClob(this.agent_, inputStream, charset, n3);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "java.io.InputStream", ClientTypes.getTypeString(n2));
    }

    private String setStringFromStream(InputStream inputStream, Charset charset, int n2) throws SqlException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = 0;
        try {
            int n4 = inputStream.read();
            while (n4 != -1) {
                ++n3;
                byteArrayOutputStream.write(n4);
                n4 = inputStream.read();
            }
        }
        catch (IOException iOException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ001.U"), iOException, iOException.getClass().getName(), iOException.getMessage());
        }
        if (n2 != Integer.MIN_VALUE && n2 != n3) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ099.S"), new Object[0]);
        }
        return new String(byteArrayOutputStream.toByteArray(), charset);
    }

    final Object setObject(int n2, Blob blob) throws SqlException {
        switch (n2) {
            case 2004: {
                return blob;
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "java.sql.Blob", ClientTypes.getTypeString(n2));
    }

    final Object setObjectFromBinaryStream(int n2, InputStream inputStream, int n3) throws SqlException {
        switch (n2) {
            case -4: 
            case -3: 
            case -2: {
                return this.setBytesFromStream(inputStream, n3);
            }
            case 2004: {
                if (n3 == Integer.MIN_VALUE) {
                    return new ClientBlob(this.agent_, inputStream);
                }
                return new ClientBlob(this.agent_, inputStream, n3);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "java.io.InputStream", ClientTypes.getTypeString(n2));
    }

    private byte[] setBytesFromStream(InputStream inputStream, int n2) throws SqlException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = 0;
        try {
            int n4 = inputStream.read();
            while (n4 != -1) {
                ++n3;
                byteArrayOutputStream.write(n4);
                n4 = inputStream.read();
            }
            if (n2 != Integer.MIN_VALUE && n2 != n3) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ099.S"), new Object[0]);
            }
        }
        catch (IOException iOException) {
            throw SqlException.javaException(this.agent_.logWriter_, iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    final Object setObject(int n2, Clob clob) throws SqlException {
        switch (n2) {
            case 2005: {
                return clob;
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "java.sql.Clob", ClientTypes.getTypeString(n2));
    }

    final Object setObject(int n2, Object object) throws SqlException {
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            return this.setObject(n2, (Boolean)object);
        }
        if (object instanceof Integer) {
            return this.setObject(n2, (Integer)object);
        }
        if (object instanceof Long) {
            return this.setObject(n2, (Long)object);
        }
        if (object instanceof Float) {
            return this.setObject(n2, ((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return this.setObject(n2, (Double)object);
        }
        if (object instanceof BigDecimal) {
            return this.setObject(n2, (BigDecimal)object);
        }
        if (object instanceof Date) {
            return this.setObject(n2, (Date)object);
        }
        if (object instanceof Time) {
            return this.setObject(n2, (Time)object);
        }
        if (object instanceof Timestamp) {
            return this.setObject(n2, (Timestamp)object);
        }
        if (object instanceof String) {
            return this.setObject(n2, (String)object);
        }
        if (object instanceof byte[]) {
            return this.setObject(n2, (byte[])object);
        }
        if (object instanceof Blob) {
            return this.setObject(n2, (Blob)object);
        }
        if (object instanceof Clob) {
            return this.setObject(n2, (Clob)object);
        }
        if (object instanceof Array) {
            return this.setObject(n2, (Array)object);
        }
        if (object instanceof Ref) {
            return this.setObject(n2, (Ref)object);
        }
        if (object instanceof Short) {
            return this.setObject(n2, (Short)object);
        }
        if (object instanceof Byte) {
            return this.setObject(n2, (Byte)object);
        }
        if (object instanceof BigInteger) {
            return this.setObject(n2, new BigDecimal((BigInteger)object));
        }
        if (object instanceof java.util.Date) {
            return this.setObject(n2, new Timestamp(((java.util.Date)object).getTime()));
        }
        if (object instanceof Calendar) {
            return this.setObject(n2, new Timestamp(((Calendar)object).getTime().getTime()));
        }
        if (n2 == 2000) {
            return object;
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), object.getClass().getName(), ClientTypes.getTypeString(n2));
    }

    final boolean getBooleanFromShort(short s2) throws SqlException {
        return s2 != 0;
    }

    final boolean getBooleanFromInt(int n2) throws SqlException {
        return n2 != 0;
    }

    final boolean getBooleanFromLong(long l2) throws SqlException {
        return l2 != 0L;
    }

    final boolean getBooleanFromFloat(float f2) throws SqlException {
        return f2 != 0.0f;
    }

    final boolean getBooleanFromDouble(double d2) throws SqlException {
        return d2 != 0.0;
    }

    final boolean getBooleanFromString(String string) {
        String string2 = string.trim();
        return !string2.equals("0") && !string2.equals("false");
    }

    final byte getByteFromShort(short s2) throws SqlException {
        if (s2 > 127 || s2 < -128) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "TINYINT");
        }
        return (byte)s2;
    }

    final byte getByteFromInt(int n2) throws SqlException {
        if (n2 > 127 || n2 < -128) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "TINYINT");
        }
        return (byte)n2;
    }

    final byte getByteFromLong(long l2) throws SqlException {
        if (l2 > 127L || l2 < -128L) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "TINYINT");
        }
        return (byte)l2;
    }

    final byte getByteFromFloat(float f2) throws SqlException {
        if (f2 > 127.0f || f2 < -128.0f) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "TINYINT");
        }
        return (byte)f2;
    }

    final byte getByteFromDouble(double d2) throws SqlException {
        if (d2 > 127.0 || d2 < -128.0) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "TINYINT");
        }
        return (byte)d2;
    }

    final byte getByteFromBoolean(boolean bl) throws SqlException {
        return bl ? (byte)1 : 0;
    }

    final byte getByteFromString(String string) throws SqlException {
        try {
            return CrossConverters.parseByte(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22018"), numberFormatException, "byte");
        }
    }

    final short getShortFromInt(int n2) throws SqlException {
        if (n2 > Short.MAX_VALUE || n2 < Short.MIN_VALUE) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "SMALLINT");
        }
        return (short)n2;
    }

    final short getShortFromLong(long l2) throws SqlException {
        if (l2 > 32767L || l2 < -32768L) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "SMALLINT");
        }
        return (short)l2;
    }

    final short getShortFromFloat(float f2) throws SqlException {
        if (f2 > 32767.0f || f2 < -32768.0f) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "SMALLINT");
        }
        return (short)f2;
    }

    final short getShortFromDouble(double d2) throws SqlException {
        if (d2 > 32767.0 || d2 < -32768.0) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "SMALLINT");
        }
        return (short)d2;
    }

    final short getShortFromBoolean(boolean bl) throws SqlException {
        return bl ? (short)1 : 0;
    }

    final short getShortFromString(String string) throws SqlException {
        try {
            return CrossConverters.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22018"), numberFormatException, "short");
        }
    }

    final int getIntFromLong(long l2) throws SqlException {
        if (l2 > Integer.MAX_VALUE || l2 < Integer.MIN_VALUE) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "INTEGER");
        }
        return (int)l2;
    }

    final int getIntFromFloat(float f2) throws SqlException {
        if (f2 > 2.1474836E9f || f2 < -2.1474836E9f) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "INTEGER");
        }
        return (int)f2;
    }

    final int getIntFromDouble(double d2) throws SqlException {
        if (d2 > 2.147483647E9 || d2 < -2.147483648E9) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "INTEGER");
        }
        return (int)d2;
    }

    final int getIntFromBoolean(boolean bl) throws SqlException {
        return bl ? 1 : 0;
    }

    final int getIntFromString(String string) throws SqlException {
        try {
            return CrossConverters.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22018"), numberFormatException, "int");
        }
    }

    final long getLongFromFloat(float f2) throws SqlException {
        if (f2 > 9.223372E18f || f2 < -9.223372E18f) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "BIGINT");
        }
        return (long)f2;
    }

    final long getLongFromDouble(double d2) throws SqlException {
        if (d2 > 9.223372036854776E18 || d2 < -9.223372036854776E18) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "BIGINT");
        }
        return (long)d2;
    }

    final long getLongFromBoolean(boolean bl) throws SqlException {
        return bl ? 1L : 0L;
    }

    final long getLongFromString(String string) throws SqlException {
        try {
            return CrossConverters.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22018"), numberFormatException, "long");
        }
    }

    final float getFloatFromDouble(double d2) throws SqlException {
        if (Float.isInfinite((float)d2)) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "DOUBLE");
        }
        return (float)d2;
    }

    final float getFloatFromBoolean(boolean bl) throws SqlException {
        return bl ? 1.0f : 0.0f;
    }

    final float getFloatFromString(String string) throws SqlException {
        try {
            return Float.parseFloat(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22018"), numberFormatException, "float");
        }
    }

    final double getDoubleFromBoolean(boolean bl) throws SqlException {
        return bl ? 1.0 : 0.0;
    }

    final double getDoubleFromString(String string) throws SqlException {
        try {
            return Double.parseDouble(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22018"), numberFormatException, "double");
        }
    }

    final BigDecimal getBigDecimalFromString(String string) throws SqlException {
        try {
            return new BigDecimal(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22018"), numberFormatException, "java.math.BigDecimal");
        }
    }

    final String getStringFromBytes(byte[] byArray) throws SqlException {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            String string = Integer.toHexString(byArray[i2] & 0xFF);
            if (string.length() == 1) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    final Date getDateFromString(String string, Calendar calendar) throws SqlException {
        try {
            return CrossConverters.date_valueOf(string, calendar);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22007.S.181"), illegalArgumentException, new Object[0]);
        }
    }

    final Time getTimeFromString(String string, Calendar calendar) throws SqlException {
        try {
            return CrossConverters.time_valueOf(string, calendar);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22007.S.181"), illegalArgumentException, new Object[0]);
        }
    }

    final Timestamp getTimestampFromString(String string, Calendar calendar) throws SqlException {
        try {
            return CrossConverters.timestamp_valueOf(string, calendar);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22007.S.181"), illegalArgumentException, new Object[0]);
        }
    }

    private static Date date_valueOf(String string, Calendar calendar) {
        String string2 = "JDBC Date format must be yyyy-mm-dd";
        if (string == null) {
            throw new IllegalArgumentException(string2);
        }
        string = string.trim();
        if (calendar == null) {
            return Date.valueOf(string);
        }
        calendar.clear();
        CrossConverters.initDatePortion(calendar, string);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return new Date(calendar.getTimeInMillis());
    }

    private static void initDatePortion(Calendar calendar, String string) {
        if (string.length() != 10 || string.charAt(4) != '-' || string.charAt(7) != '-') {
            throw new IllegalArgumentException();
        }
        int n2 = CrossConverters.digit(string.charAt(0)) * 1000 + CrossConverters.digit(string.charAt(1)) * 100 + CrossConverters.digit(string.charAt(2)) * 10 + CrossConverters.digit(string.charAt(3));
        int n3 = CrossConverters.digit(string.charAt(5)) * 10 + CrossConverters.digit(string.charAt(6)) - 1;
        int n4 = CrossConverters.digit(string.charAt(8)) * 10 + CrossConverters.digit(string.charAt(9));
        calendar.set(n2, n3, n4);
    }

    private static int digit(char c2) {
        int n2 = Character.digit(c2, 10);
        if (n2 == -1) {
            throw new IllegalArgumentException();
        }
        return n2;
    }

    private static Time time_valueOf(String string, Calendar calendar) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        string = string.trim();
        if (calendar == null) {
            return Time.valueOf(string);
        }
        calendar.clear();
        CrossConverters.initTimePortion(calendar, string);
        calendar.set(1970, 0, 1);
        return new Time(calendar.getTimeInMillis());
    }

    private static void initTimePortion(Calendar calendar, String string) {
        if (string.length() != 8 || string.charAt(2) != ':' || string.charAt(5) != ':') {
            throw new IllegalArgumentException();
        }
        int n2 = CrossConverters.digit(string.charAt(0)) * 10 + CrossConverters.digit(string.charAt(1));
        int n3 = CrossConverters.digit(string.charAt(3)) * 10 + CrossConverters.digit(string.charAt(4));
        int n4 = CrossConverters.digit(string.charAt(6)) * 10 + CrossConverters.digit(string.charAt(7));
        calendar.set(11, n2);
        calendar.set(12, n3);
        calendar.set(13, n4);
    }

    private static Timestamp timestamp_valueOf(String string, Calendar calendar) {
        Object object;
        if (string == null) {
            throw new IllegalArgumentException();
        }
        string = string.trim();
        if (calendar == null) {
            return Timestamp.valueOf(string);
        }
        calendar.clear();
        String[] stringArray = string.split(" ");
        if (stringArray.length != 2) {
            throw new IllegalArgumentException();
        }
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        CrossConverters.initDatePortion(calendar, string2);
        String[] stringArray2 = string3.split("\\.");
        if (stringArray2.length < 1 || stringArray2.length > 2) {
            throw new IllegalArgumentException();
        }
        String string4 = stringArray2[0];
        CrossConverters.initTimePortion(calendar, string4);
        int n2 = 0;
        if (stringArray2.length > 1) {
            object = stringArray2[1];
            int n3 = 9 - ((String)object).length();
            if (n3 < 0) {
                throw new IllegalArgumentException();
            }
            n2 = Integer.parseInt((String)object);
            for (int i2 = 0; i2 < n3; ++i2) {
                n2 *= 10;
            }
        }
        object = new Timestamp(calendar.getTimeInMillis());
        ((Timestamp)object).setNanos(n2);
        return object;
    }

    private static byte parseByte(String string) throws NumberFormatException {
        int n2 = CrossConverters.parseInt(string);
        if (n2 < -128 || n2 > 127) {
            throw new NumberFormatException();
        }
        return (byte)n2;
    }

    private static short parseShort(String string) throws NumberFormatException {
        int n2 = CrossConverters.parseInt(string);
        if (n2 < Short.MIN_VALUE || n2 > Short.MAX_VALUE) {
            throw new NumberFormatException();
        }
        return (short)n2;
    }

    private static int parseInt(String string) throws NumberFormatException {
        int n2;
        int n3;
        if (string == null) {
            throw new NumberFormatException("null");
        }
        int n4 = 0;
        boolean bl = false;
        int n5 = 0;
        int n6 = string.length();
        if (n6 == 0) {
            throw new NumberFormatException(string);
        }
        if (string.charAt(0) == '-') {
            bl = true;
            n3 = Integer.MIN_VALUE;
            ++n5;
        } else {
            n3 = -2147483647;
        }
        int n7 = n3 / 10;
        if (n5 < n6) {
            if ((n2 = Character.digit(string.charAt(n5++), 10)) < 0) {
                throw new NumberFormatException(string);
            }
            n4 = -n2;
        }
        while (n5 < n6) {
            char c2;
            if ((c2 = string.charAt(n5++)) == ' ') {
                CrossConverters.skipPadding(string, n5, n6);
                break;
            }
            n2 = Character.digit(c2, 10);
            if (n2 < 0) {
                throw new NumberFormatException(string);
            }
            if (n4 < n7) {
                throw new NumberFormatException(string);
            }
            if ((n4 *= 10) < n3 + n2) {
                throw new NumberFormatException(string);
            }
            n4 -= n2;
        }
        if (bl) {
            if (n5 > 1) {
                return n4;
            }
            throw new NumberFormatException(string);
        }
        return -n4;
    }

    private static long parseLong(String string) throws NumberFormatException {
        int n2;
        long l2;
        if (string == null) {
            throw new NumberFormatException("null");
        }
        long l3 = 0L;
        boolean bl = false;
        int n3 = 0;
        int n4 = string.length();
        if (n4 == 0) {
            throw new NumberFormatException(string);
        }
        if (string.charAt(0) == '-') {
            bl = true;
            l2 = Long.MIN_VALUE;
            ++n3;
        } else {
            l2 = -9223372036854775807L;
        }
        long l4 = l2 / 10L;
        if (n3 < n4) {
            if ((n2 = Character.digit(string.charAt(n3++), 10)) < 0) {
                throw new NumberFormatException(string);
            }
            l3 = -n2;
        }
        while (n3 < n4) {
            char c2;
            if ((c2 = string.charAt(n3++)) == ' ') {
                CrossConverters.skipPadding(string, n3, n4);
                break;
            }
            n2 = Character.digit(c2, 10);
            if (n2 < 0) {
                throw new NumberFormatException(string);
            }
            if (l3 < l4) {
                throw new NumberFormatException(string);
            }
            if ((l3 *= 10L) < l2 + (long)n2) {
                throw new NumberFormatException(string);
            }
            l3 -= (long)n2;
        }
        if (bl) {
            if (n3 > 1) {
                return l3;
            }
            throw new NumberFormatException(string);
        }
        return -l3;
    }

    private static void skipPadding(String string, int n2, int n3) throws NumberFormatException {
        while (n2 < n3) {
            if (string.charAt(n2++) == ' ') continue;
            throw new NumberFormatException(string);
        }
    }
}

