/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.IOException;
import java.io.Writer;
import org.apache.derby.client.am.ClientClob;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.SqlException;

class ClobLocatorWriter
extends Writer {
    private final ClientConnection connection;
    private final ClientClob clob;
    private long currentPos;
    private boolean isClosed = false;

    ClobLocatorWriter(ClientConnection clientConnection, ClientClob clientClob, long l2) throws SqlException {
        if (l2 - 1L > clientClob.sqlLength()) {
            throw new IndexOutOfBoundsException();
        }
        this.connection = clientConnection;
        this.clob = clientClob;
        this.currentPos = l2;
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
    }

    private void checkClosed() throws IOException {
        if (this.isClosed) {
            throw new IOException("This operation is not permitted because theWriter has been closed");
        }
    }

    @Override
    public void write(int n2) throws IOException {
        char[] cArray = new char[]{(char)n2};
        this.writeCharacters(cArray, 0, cArray.length);
    }

    @Override
    public void write(char[] cArray) throws IOException {
        this.checkClosed();
        this.writeCharacters(cArray, 0, cArray.length);
    }

    @Override
    public void flush() {
    }

    @Override
    public void write(char[] cArray, int n2, int n3) throws IOException {
        this.checkClosed();
        if (n3 == 0) {
            return;
        }
        if (n2 < 0 || n2 > cArray.length || n3 < 0 || n3 > cArray.length - n2) {
            throw new IndexOutOfBoundsException();
        }
        this.writeCharacters(cArray, n2, n3);
    }

    private void writeCharacters(char[] cArray, int n2, int n3) throws IOException {
        try {
            this.clob.setStringX(this.currentPos, new String(cArray, n2, n3), 0, n3);
            this.currentPos += (long)n3;
        }
        catch (SqlException sqlException) {
            IOException iOException = new IOException();
            iOException.initCause(sqlException);
            throw iOException;
        }
    }
}

