/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.client.am.ClientClob;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.SqlException;

class ClobLocatorInputStream
extends InputStream {
    private final ClientConnection connection;
    private final ClientClob clob;
    private long currentPos;

    ClobLocatorInputStream(ClientConnection clientConnection, ClientClob clientClob) throws SqlException {
        this.connection = clientConnection;
        this.clob = clientClob;
        this.currentPos = 1L;
    }

    ClobLocatorInputStream(ClientConnection clientConnection, ClientClob clientClob, long l2) throws SqlException {
        this(clientConnection, clientClob);
        this.currentPos = l2;
    }

    @Override
    public int read() throws IOException {
        byte[] byArray = this.readBytes(1);
        if (byArray.length == 0) {
            return -1;
        }
        return byArray[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 == 0) {
            return 0;
        }
        if (n2 < 0 || n3 < 0 || n3 > byArray.length - n2) {
            throw new IndexOutOfBoundsException();
        }
        byte[] byArray2 = this.readBytes(n3);
        if (byArray2.length == 0) {
            return -1;
        }
        System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
        return byArray2.length;
    }

    private byte[] readBytes(int n2) throws IOException {
        try {
            int n3 = (int)Math.min((long)n2, this.clob.sqlLength() - this.currentPos + 1L);
            String string = this.connection.locatorProcedureCall().clobGetSubString(this.clob.getLocator(), this.currentPos, n3);
            byte[] byArray = this.getBytesFromString(string);
            this.currentPos += (long)byArray.length;
            return byArray;
        }
        catch (SqlException sqlException) {
            throw new IOException(sqlException);
        }
    }

    private byte[] getBytesFromString(String string) {
        byte[] byArray = new byte[string.length()];
        for (int i2 = 1; i2 <= string.length(); ++i2) {
            char c2 = string.charAt(i2 - 1);
            byArray[i2 - 1] = c2 <= '\u00ff' ? (int)c2 : 63;
        }
        return byArray;
    }
}

