/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import org.apache.derby.client.am.ClientCallableStatement;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.shared.common.error.ExceptionUtil;

class CallableLocatorProcedures {
    private boolean isLocatorSupportAvailable = true;
    private ClientCallableStatement blobCreateLocatorCall;
    private ClientCallableStatement blobReleaseLocatorCall;
    private ClientCallableStatement blobGetPositionFromLocatorCall;
    private ClientCallableStatement blobGetPositionFromBytesCall;
    private ClientCallableStatement blobGetLengthCall;
    private ClientCallableStatement blobGetBytesCall;
    private ClientCallableStatement blobSetBytesCall;
    private ClientCallableStatement blobTruncateCall;
    private ClientCallableStatement clobCreateLocatorCall;
    private ClientCallableStatement clobReleaseLocatorCall;
    private ClientCallableStatement clobGetPositionFromStringCall;
    private ClientCallableStatement clobGetPositionFromLocatorCall;
    private ClientCallableStatement clobGetLengthCall;
    private ClientCallableStatement clobGetSubStringCall;
    private ClientCallableStatement clobSetStringCall;
    private ClientCallableStatement clobTruncateCall;
    private final ClientConnection connection;
    private static final int VARCHAR_MAXWIDTH = 32672;
    private static final int INVALID_LOCATOR = -1;

    CallableLocatorProcedures(ClientConnection clientConnection) {
        this.connection = clientConnection;
    }

    int blobCreateLocator() throws SqlException {
        if (!this.isLocatorSupportAvailable) {
            return -1;
        }
        try {
            if (this.blobCreateLocatorCall == null || !this.blobCreateLocatorCall.openOnClient_) {
                this.blobCreateLocatorCall = this.connection.prepareCallX("? = CALL SYSIBM.BLOBCREATELOCATOR()", 1003, 1007, this.connection.holdability());
                this.blobCreateLocatorCall.registerOutParameterX(1, 4);
                this.blobCreateLocatorCall.isAutoCommittableStatement_ = false;
            }
            this.blobCreateLocatorCall.executeX();
        }
        catch (SqlException sqlException) {
            if (sqlException.getSQLState().compareTo(ExceptionUtil.getSQLStateFromIdentifier("42Y03.S.0")) == 0) {
                this.isLocatorSupportAvailable = false;
                return -1;
            }
            throw sqlException;
        }
        return this.blobCreateLocatorCall.getIntX(1);
    }

    void blobReleaseLocator(int n2) throws SqlException {
        if (this.blobReleaseLocatorCall == null || !this.blobReleaseLocatorCall.openOnClient_) {
            this.blobReleaseLocatorCall = this.connection.prepareCallX("CALL SYSIBM.BLOBRELEASELOCATOR(?)", 1003, 1007, 2);
            this.blobReleaseLocatorCall.isAutoCommittableStatement_ = false;
        }
        this.blobReleaseLocatorCall.setIntX(1, n2);
        try {
            this.blobReleaseLocatorCall.executeX();
        }
        catch (SqlException sqlException) {
            SqlException sqlException2 = this.handleInvalidLocator(sqlException);
            throw sqlException2;
        }
    }

    long blobGetPositionFromLocator(int n2, int n3, long l2) throws SqlException {
        if (this.blobGetPositionFromLocatorCall == null || !this.blobGetPositionFromLocatorCall.openOnClient_) {
            this.blobGetPositionFromLocatorCall = this.connection.prepareCallX("? = CALL SYSIBM.BLOBGETPOSITIONFROMLOCATOR(?, ?, ?)", 1003, 1007, 2);
            this.blobGetPositionFromLocatorCall.registerOutParameterX(1, -5);
            this.blobGetPositionFromLocatorCall.isAutoCommittableStatement_ = false;
        }
        this.blobGetPositionFromLocatorCall.setIntX(2, n2);
        this.blobGetPositionFromLocatorCall.setIntX(3, n3);
        this.blobGetPositionFromLocatorCall.setLongX(4, l2);
        try {
            this.blobGetPositionFromLocatorCall.executeX();
        }
        catch (SqlException sqlException) {
            SqlException sqlException2 = this.handleInvalidLocator(sqlException);
            throw sqlException2;
        }
        return this.blobGetPositionFromLocatorCall.getLongX(1);
    }

    long blobGetPositionFromBytes(int n2, byte[] byArray, long l2) throws SqlException {
        long l3 = -1L;
        int n3 = byArray.length;
        do {
            long l4 = this.blobGetPositionFromBytes(n2, l2, byArray, 0, 32672);
            boolean bl = false;
            if (n3 > 32672 && l4 > 0L) {
                int n4;
                for (int i2 = 32672; i2 < n3; i2 += n4) {
                    n4 = Math.min(n3 - i2, 32672);
                    long l5 = this.blobGetPositionFromBytes(n2, l4 + (long)i2, byArray, i2, n4);
                    if (l5 == l4 + (long)i2) continue;
                    bl = true;
                    l2 = l4 + 1L;
                    break;
                }
            }
            if (!bl) {
                return l4;
            }
            if (l3 >= 0L) continue;
            l3 = this.blobGetLength(n2);
        } while (l2 + (long)n3 <= l3);
        return -1L;
    }

    private long blobGetPositionFromBytes(int n2, long l2, byte[] byArray, int n3, int n4) throws SqlException {
        if (this.blobGetPositionFromBytesCall == null || !this.blobGetPositionFromBytesCall.openOnClient_) {
            this.blobGetPositionFromBytesCall = this.connection.prepareCallX("? = CALL SYSIBM.BLOBGETPOSITIONFROMBYTES(?, ?, ?)", 1003, 1007, 2);
            this.blobGetPositionFromBytesCall.registerOutParameterX(1, -5);
            this.blobGetPositionFromBytesCall.isAutoCommittableStatement_ = false;
        }
        byte[] byArray2 = byArray;
        int n5 = Math.min(byArray.length - n3, n4);
        if (n5 != byArray2.length) {
            byArray2 = new byte[n5];
            System.arraycopy(byArray, n3, byArray2, 0, n5);
        }
        this.blobGetPositionFromBytesCall.setIntX(2, n2);
        this.blobGetPositionFromBytesCall.setBytesX(3, byArray2);
        this.blobGetPositionFromBytesCall.setLongX(4, l2);
        try {
            this.blobGetPositionFromBytesCall.executeX();
        }
        catch (SqlException sqlException) {
            SqlException sqlException2 = this.handleInvalidLocator(sqlException);
            throw sqlException2;
        }
        return this.blobGetPositionFromBytesCall.getLongX(1);
    }

    long blobGetLength(int n2) throws SqlException {
        if (this.blobGetLengthCall == null || !this.blobGetLengthCall.openOnClient_) {
            this.blobGetLengthCall = this.connection.prepareCallX("? = CALL SYSIBM.BLOBGETLENGTH(?)", 1003, 1007, 2);
            this.blobGetLengthCall.registerOutParameterX(1, -5);
            this.blobGetLengthCall.isAutoCommittableStatement_ = false;
        }
        this.blobGetLengthCall.setIntX(2, n2);
        try {
            this.blobGetLengthCall.executeX();
        }
        catch (SqlException sqlException) {
            SqlException sqlException2 = this.handleInvalidLocator(sqlException);
            throw sqlException2;
        }
        return this.blobGetLengthCall.getLongX(1);
    }

    byte[] blobGetBytes(int n2, long l2, int n3) throws SqlException {
        byte[] byArray;
        if (n3 == 0) {
            return new byte[0];
        }
        if (this.blobGetBytesCall == null || !this.blobGetBytesCall.openOnClient_) {
            this.blobGetBytesCall = this.connection.prepareCallX("? = CALL SYSIBM.BLOBGETBYTES(?, ?, ?)", 1003, 1007, 2);
            this.blobGetBytesCall.registerOutParameterX(1, -3);
            this.blobGetBytesCall.isAutoCommittableStatement_ = false;
        }
        byte[] byArray2 = null;
        for (int i2 = 0; i2 < n3; i2 += byArray.length) {
            this.blobGetBytesCall.setIntX(2, n2);
            this.blobGetBytesCall.setLongX(3, l2 + (long)i2);
            this.blobGetBytesCall.setIntX(4, n3 - i2);
            try {
                this.blobGetBytesCall.executeX();
            }
            catch (SqlException sqlException) {
                SqlException sqlException2 = this.handleInvalidLocator(sqlException);
                throw sqlException2;
            }
            byArray = this.blobGetBytesCall.getBytesX(1);
            if (i2 == 0) {
                if (byArray.length == n3) {
                    return byArray;
                }
                byArray2 = new byte[n3];
            }
            if (byArray.length == 0) break;
            System.arraycopy(byArray, 0, byArray2, i2, byArray.length);
        }
        return byArray2;
    }

    void blobSetBytes(int n2, long l2, int n3, byte[] byArray) throws SqlException {
        int n4;
        if (this.blobSetBytesCall == null || !this.blobSetBytesCall.openOnClient_) {
            this.blobSetBytesCall = this.connection.prepareCallX("CALL SYSIBM.BLOBSETBYTES(?, ?, ?, ?)", 1003, 1007, 2);
            this.blobSetBytesCall.isAutoCommittableStatement_ = false;
        }
        byte[] byArray2 = byArray;
        for (int i2 = 0; i2 < n3; i2 += n4) {
            n4 = Math.min(n3 - i2, 32672);
            if (n4 != byArray2.length) {
                byArray2 = new byte[n4];
            }
            if (byArray2 != byArray) {
                System.arraycopy(byArray, i2, byArray2, 0, n4);
            }
            this.blobSetBytesCall.setIntX(1, n2);
            this.blobSetBytesCall.setLongX(2, l2 + (long)i2);
            this.blobSetBytesCall.setIntX(3, n4);
            this.blobSetBytesCall.setBytesX(4, byArray2);
            try {
                this.blobSetBytesCall.executeX();
                continue;
            }
            catch (SqlException sqlException) {
                SqlException sqlException2 = this.handleInvalidLocator(sqlException);
                throw sqlException2;
            }
        }
    }

    void blobTruncate(int n2, long l2) throws SqlException {
        if (this.blobTruncateCall == null || !this.blobTruncateCall.openOnClient_) {
            this.blobTruncateCall = this.connection.prepareCallX("CALL SYSIBM.BLOBTRUNCATE(?, ?)", 1003, 1007, 2);
            this.blobTruncateCall.isAutoCommittableStatement_ = false;
        }
        this.blobTruncateCall.setIntX(1, n2);
        this.blobTruncateCall.setLongX(2, l2);
        try {
            this.blobTruncateCall.executeX();
        }
        catch (SqlException sqlException) {
            SqlException sqlException2 = this.handleInvalidLocator(sqlException);
            throw sqlException2;
        }
    }

    int clobCreateLocator() throws SqlException {
        if (!this.isLocatorSupportAvailable) {
            return -1;
        }
        try {
            if (this.clobCreateLocatorCall == null || !this.clobCreateLocatorCall.openOnClient_) {
                this.clobCreateLocatorCall = this.connection.prepareCallX("? = CALL SYSIBM.CLOBCREATELOCATOR()", 1003, 1007, 2);
                this.clobCreateLocatorCall.registerOutParameterX(1, 4);
                this.clobCreateLocatorCall.isAutoCommittableStatement_ = false;
            }
            this.clobCreateLocatorCall.executeX();
        }
        catch (SqlException sqlException) {
            if (sqlException.getSQLState().compareTo(ExceptionUtil.getSQLStateFromIdentifier("42Y03.S.0")) == 0) {
                this.isLocatorSupportAvailable = false;
                return -1;
            }
            throw sqlException;
        }
        return this.clobCreateLocatorCall.getIntX(1);
    }

    void clobReleaseLocator(int n2) throws SqlException {
        if (this.clobReleaseLocatorCall == null || !this.clobReleaseLocatorCall.openOnClient_) {
            this.clobReleaseLocatorCall = this.connection.prepareCallX("CALL SYSIBM.CLOBRELEASELOCATOR(?)", 1003, 1007, 2);
            this.clobReleaseLocatorCall.isAutoCommittableStatement_ = false;
        }
        this.clobReleaseLocatorCall.setIntX(1, n2);
        try {
            this.clobReleaseLocatorCall.executeX();
        }
        catch (SqlException sqlException) {
            SqlException sqlException2 = this.handleInvalidLocator(sqlException);
            throw sqlException2;
        }
    }

    long clobGetPositionFromString(int n2, String string, long l2) throws SqlException {
        long l3 = -1L;
        int n3 = string.length();
        do {
            long l4 = this.clobGetPositionFromString(n2, l2, string, 0, 32672);
            boolean bl = false;
            if (n3 > 32672 && l4 > 0L) {
                int n4;
                for (int i2 = 32672; i2 < n3; i2 += n4) {
                    n4 = Math.min(n3 - i2, 32672);
                    long l5 = this.clobGetPositionFromString(n2, l4 + (long)i2, string, i2, n4);
                    if (l5 == l4 + (long)i2) continue;
                    bl = true;
                    l2 = l4 + 1L;
                    break;
                }
            }
            if (!bl) {
                return l4;
            }
            if (l3 >= 0L) continue;
            l3 = this.clobGetLength(n2);
        } while (l2 + (long)n3 <= l3);
        return -1L;
    }

    private long clobGetPositionFromString(int n2, long l2, String string, int n3, int n4) throws SqlException {
        if (this.clobGetPositionFromStringCall == null || !this.clobGetPositionFromStringCall.openOnClient_) {
            this.clobGetPositionFromStringCall = this.connection.prepareCallX("? = CALL SYSIBM.CLOBGETPOSITIONFROMSTRING(?, ?, ?)", 1003, 1007, 2);
            this.clobGetPositionFromStringCall.registerOutParameterX(1, -5);
            this.clobGetPositionFromStringCall.isAutoCommittableStatement_ = false;
        }
        String string2 = string;
        int n5 = Math.min(string.length() - n3, n4);
        if (n5 != string2.length()) {
            string2 = string.substring(n3, n3 + n5);
        }
        this.clobGetPositionFromStringCall.setIntX(2, n2);
        this.clobGetPositionFromStringCall.setStringX(3, string2);
        this.clobGetPositionFromStringCall.setLongX(4, l2);
        try {
            this.clobGetPositionFromStringCall.executeX();
        }
        catch (SqlException sqlException) {
            SqlException sqlException2 = this.handleInvalidLocator(sqlException);
            throw sqlException2;
        }
        return this.clobGetPositionFromStringCall.getLongX(1);
    }

    long clobGetPositionFromLocator(int n2, int n3, long l2) throws SqlException {
        if (this.clobGetPositionFromLocatorCall == null || !this.clobGetPositionFromLocatorCall.openOnClient_) {
            this.clobGetPositionFromLocatorCall = this.connection.prepareCallX("? = CALL SYSIBM.CLOBGETPOSITIONFROMLOCATOR(?, ?, ?)", 1003, 1007, 2);
            this.clobGetPositionFromLocatorCall.registerOutParameterX(1, -5);
            this.clobGetPositionFromLocatorCall.isAutoCommittableStatement_ = false;
        }
        this.clobGetPositionFromLocatorCall.setIntX(2, n2);
        this.clobGetPositionFromLocatorCall.setIntX(3, n3);
        this.clobGetPositionFromLocatorCall.setLongX(4, l2);
        try {
            this.clobGetPositionFromLocatorCall.executeX();
        }
        catch (SqlException sqlException) {
            SqlException sqlException2 = this.handleInvalidLocator(sqlException);
            throw sqlException2;
        }
        return this.clobGetPositionFromLocatorCall.getLongX(1);
    }

    long clobGetLength(int n2) throws SqlException {
        if (this.clobGetLengthCall == null || !this.clobGetLengthCall.openOnClient_) {
            this.clobGetLengthCall = this.connection.prepareCallX("? = CALL SYSIBM.CLOBGETLENGTH(?)", 1003, 1007, 2);
            this.clobGetLengthCall.registerOutParameterX(1, -5);
            this.clobGetLengthCall.isAutoCommittableStatement_ = false;
        }
        this.clobGetLengthCall.setIntX(2, n2);
        try {
            this.clobGetLengthCall.executeX();
        }
        catch (SqlException sqlException) {
            SqlException sqlException2 = this.handleInvalidLocator(sqlException);
            throw sqlException2;
        }
        return this.clobGetLengthCall.getLongX(1);
    }

    String clobGetSubString(int n2, long l2, int n3) throws SqlException {
        String string;
        if (n3 == 0) {
            return "";
        }
        if (this.clobGetSubStringCall == null || !this.clobGetSubStringCall.openOnClient_) {
            this.clobGetSubStringCall = this.connection.prepareCallX("? = CALL SYSIBM.CLOBGETSUBSTRING(?, ?, ?)", 1003, 1007, 2);
            this.clobGetSubStringCall.registerOutParameterX(1, 12);
            this.clobGetSubStringCall.isAutoCommittableStatement_ = false;
        }
        StringBuffer stringBuffer = null;
        for (int i2 = 0; i2 < n3; i2 += string.length()) {
            this.clobGetSubStringCall.setIntX(2, n2);
            this.clobGetSubStringCall.setLongX(3, l2 + (long)i2);
            this.clobGetSubStringCall.setIntX(4, n3 - i2);
            try {
                this.clobGetSubStringCall.executeX();
            }
            catch (SqlException sqlException) {
                SqlException sqlException2 = this.handleInvalidLocator(sqlException);
                throw sqlException2;
            }
            string = this.clobGetSubStringCall.getStringX(1);
            if (i2 == 0) {
                if (string.length() == n3) {
                    return string;
                }
                stringBuffer = new StringBuffer(n3);
            }
            if (string.length() == 0) break;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    void clobSetString(int n2, long l2, int n3, String string) throws SqlException {
        int n4;
        if (this.clobSetStringCall == null || !this.clobSetStringCall.openOnClient_) {
            this.clobSetStringCall = this.connection.prepareCallX("CALL SYSIBM.CLOBSETSTRING(?, ?, ?, ?)", 1003, 1007, 2);
            this.clobSetStringCall.isAutoCommittableStatement_ = false;
        }
        String string2 = string;
        for (int i2 = 0; i2 < n3; i2 += n4) {
            n4 = Math.min(n3 - i2, 32672);
            if (n4 < string.length()) {
                string2 = string.substring(i2, i2 + n4);
            }
            this.clobSetStringCall.setIntX(1, n2);
            this.clobSetStringCall.setLongX(2, l2 + (long)i2);
            this.clobSetStringCall.setIntX(3, n4);
            this.clobSetStringCall.setStringX(4, string2);
            try {
                this.clobSetStringCall.executeX();
                continue;
            }
            catch (SqlException sqlException) {
                SqlException sqlException2 = this.handleInvalidLocator(sqlException);
                throw sqlException2;
            }
        }
    }

    void clobTruncate(int n2, long l2) throws SqlException {
        if (this.clobTruncateCall == null || !this.clobTruncateCall.openOnClient_) {
            this.clobTruncateCall = this.connection.prepareCallX("CALL SYSIBM.CLOBTRUNCATE(?, ?)", 1003, 1007, 2);
            this.clobTruncateCall.isAutoCommittableStatement_ = false;
        }
        this.clobTruncateCall.setIntX(1, n2);
        this.clobTruncateCall.setLongX(2, l2);
        try {
            this.clobTruncateCall.executeX();
        }
        catch (SqlException sqlException) {
            SqlException sqlException2 = this.handleInvalidLocator(sqlException);
            throw sqlException2;
        }
    }

    private SqlException handleInvalidLocator(SqlException sqlException) {
        for (SqlException sqlException2 = sqlException; sqlException2 != null; sqlException2 = sqlException2.getNextException()) {
            if (sqlException2.getSQLState().compareTo(ExceptionUtil.getSQLStateFromIdentifier("XJ217.S")) != 0) continue;
            return new SqlException(this.connection.agent_.logWriter_, new ClientMessageId("XJ215.S"), null, sqlException);
        }
        return sqlException;
    }
}

