/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.client.am.ClientBlob;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.SqlException;

class BlobLocatorInputStream
extends InputStream {
    private final ClientConnection connection;
    private final ClientBlob blob;
    private long currentPos;
    private final long maxPos;

    BlobLocatorInputStream(ClientConnection clientConnection, ClientBlob clientBlob) throws SqlException {
        this.connection = clientConnection;
        this.blob = clientBlob;
        this.currentPos = 1L;
        this.maxPos = -1L;
    }

    BlobLocatorInputStream(ClientConnection clientConnection, ClientBlob clientBlob, long l2, long l3) throws SqlException {
        this.connection = clientConnection;
        this.blob = clientBlob;
        this.currentPos = l2;
        this.maxPos = l3 != -1L ? Math.min(clientBlob.sqlLength(), l2 + l3 - 1L) : -1L;
    }

    @Override
    public int read() throws IOException {
        byte[] byArray = this.readBytes(1);
        if (byArray.length == 0) {
            return -1;
        }
        return byArray[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 == 0) {
            return 0;
        }
        if (n2 < 0 || n3 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        byte[] byArray2 = this.readBytes(n3);
        if (byArray2.length == 0) {
            return -1;
        }
        System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
        return byArray2.length;
    }

    private byte[] readBytes(int n2) throws IOException {
        try {
            int n3 = -1;
            n3 = this.maxPos != -1L ? (int)Math.min((long)n2, this.maxPos - this.currentPos + 1L) : (int)Math.min((long)n2, this.blob.sqlLength() - this.currentPos + 1L);
            byte[] byArray = this.connection.locatorProcedureCall().blobGetBytes(this.blob.getLocator(), this.currentPos, n3);
            this.currentPos += (long)byArray.length;
            return byArray;
        }
        catch (SqlException sqlException) {
            throw new IOException(sqlException);
        }
    }
}

