/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.LogicalConnection;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.stmtcache.JDBCStatementCache;
import org.apache.derby.client.net.NetXAConnection;
import org.apache.derby.jdbc.BasicClientDataSource40;
import org.apache.derby.jdbc.ClientDriver;

public class ClientPooledConnection
implements PooledConnection {
    private boolean newPC_ = true;
    private ArrayList<ConnectionEventListener> listeners_ = new ArrayList();
    private int eventIterators;
    ClientConnection physicalConnection_ = null;
    NetXAConnection netXAPhysicalConnection_ = null;
    private final JDBCStatementCache statementCache;
    private LogicalConnection logicalConnection_ = null;
    protected LogWriter logWriter_ = null;
    protected int rmId_ = 0;
    private final CopyOnWriteArrayList<StatementEventListener> statementEventListeners = new CopyOnWriteArrayList();

    public ClientPooledConnection(BasicClientDataSource40 basicClientDataSource40, LogWriter logWriter, String string, String string2) throws SQLException {
        this.logWriter_ = logWriter;
        this.statementCache = basicClientDataSource40.maxStatementsToPool() <= 0 ? null : new JDBCStatementCache(basicClientDataSource40.maxStatementsToPool());
        try {
            this.physicalConnection_ = ClientDriver.getFactory().newNetConnection(this.logWriter_, string, string2, basicClientDataSource40, -1, false, this);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public ClientPooledConnection(BasicClientDataSource40 basicClientDataSource40, LogWriter logWriter, String string, String string2, int n2) throws SQLException {
        this.logWriter_ = logWriter;
        this.rmId_ = n2;
        this.statementCache = basicClientDataSource40.maxStatementsToPool() <= 0 ? null : null;
        try {
            this.netXAPhysicalConnection_ = new NetXAConnection(logWriter, string, string2, basicClientDataSource40, n2, true, this);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        this.physicalConnection_ = this.netXAPhysicalConnection_.getNetConnection();
    }

    public boolean isStatementPoolingEnabled() {
        return this.statementCache != null;
    }

    protected void finalize() throws Throwable {
        if (this.logWriter_ != null) {
            this.logWriter_.traceEntry(this, "finalize", new Object[0]);
        }
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        try {
            if (this.logWriter_ != null) {
                this.logWriter_.traceEntry(this, "close", new Object[0]);
            }
            if (this.logicalConnection_ != null) {
                this.logicalConnection_.nullPhysicalConnection();
                this.logicalConnection_ = null;
            }
            if (this.physicalConnection_ == null) {
                return;
            }
            this.physicalConnection_.closeResources();
        }
        finally {
            this.physicalConnection_ = null;
        }
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        try {
            if (this.logWriter_ != null) {
                this.logWriter_.traceEntry(this, "getConnection", new Object[0]);
            }
            this.createLogicalConnection();
            if (!this.newPC_) {
                this.physicalConnection_.reset(this.logWriter_);
            } else {
                this.physicalConnection_.lightReset();
            }
            this.newPC_ = false;
            if (this.logWriter_ != null) {
                this.logWriter_.traceExit((Object)this, "getConnection", this.logicalConnection_);
            }
            return this.logicalConnection_;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private void createLogicalConnection() throws SqlException {
        if (this.physicalConnection_ == null) {
            throw new SqlException(this.logWriter_, new ClientMessageId("08003.C.1"), new Object[0]);
        }
        try {
            if (this.physicalConnection_.transactionInProgress()) {
                this.physicalConnection_.rollback();
            }
        }
        catch (SQLException sQLException) {
            throw new SqlException(sQLException);
        }
        if (this.logicalConnection_ != null) {
            this.logicalConnection_.closeWithoutRecyclingToPool();
        }
        this.logicalConnection_ = this.statementCache == null ? ClientDriver.getFactory().newLogicalConnection(this.physicalConnection_, this) : ClientDriver.getFactory().newCachingLogicalConnection(this.physicalConnection_, this, this.statementCache);
    }

    @Override
    public synchronized void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (this.logWriter_ != null) {
            this.logWriter_.traceEntry(this, "addConnectionEventListener", connectionEventListener);
        }
        if (connectionEventListener == null) {
            return;
        }
        if (this.eventIterators > 0) {
            this.listeners_ = new ArrayList<ConnectionEventListener>(this.listeners_);
        }
        this.listeners_.add(connectionEventListener);
    }

    @Override
    public synchronized void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (this.logWriter_ != null) {
            this.logWriter_.traceEntry(this, "removeConnectionEventListener", connectionEventListener);
        }
        if (this.eventIterators > 0) {
            this.listeners_ = new ArrayList<ConnectionEventListener>(this.listeners_);
        }
        this.listeners_.remove(connectionEventListener);
    }

    public synchronized void recycleConnection() {
        if (this.physicalConnection_.agent_.loggingEnabled()) {
            this.physicalConnection_.agent_.logWriter_.traceEntry(this, "recycleConnection", new Object[0]);
        }
        this.logicalConnection_ = null;
        this.fireConnectionEventListeners(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void informListeners(SqlException sqlException) {
        if (sqlException.getErrorCode() < 40000) {
            return;
        }
        ClientPooledConnection clientPooledConnection = this;
        synchronized (clientPooledConnection) {
            this.fireConnectionEventListeners(sqlException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireConnectionEventListeners(SqlException sqlException) {
        if (!this.listeners_.isEmpty()) {
            ConnectionEvent connectionEvent = sqlException == null ? new ConnectionEvent(this) : new ConnectionEvent(this, sqlException.getSQLException());
            ++this.eventIterators;
            try {
                for (ConnectionEventListener connectionEventListener : this.listeners_) {
                    if (sqlException == null) {
                        connectionEventListener.connectionClosed(connectionEvent);
                        continue;
                    }
                    connectionEventListener.connectionErrorOccurred(connectionEvent);
                }
            }
            finally {
                --this.eventIterators;
            }
        }
    }

    public synchronized void nullLogicalConnection() {
        this.logicalConnection_ = null;
    }

    @Override
    public void addStatementEventListener(StatementEventListener statementEventListener) {
        if (this.logWriter_ != null) {
            this.logWriter_.traceEntry(this, "addStatementEventListener", statementEventListener);
        }
        if (statementEventListener != null) {
            this.statementEventListeners.add(statementEventListener);
        }
    }

    @Override
    public void removeStatementEventListener(StatementEventListener statementEventListener) {
        if (this.logWriter_ != null) {
            this.logWriter_.traceEntry(this, "removeConnectionEventListener", statementEventListener);
        }
        this.statementEventListeners.remove(statementEventListener);
    }

    public void onStatementClose(PreparedStatement preparedStatement) {
        if (!this.statementEventListeners.isEmpty()) {
            StatementEvent statementEvent = new StatementEvent(this, preparedStatement);
            for (StatementEventListener statementEventListener : this.statementEventListeners) {
                statementEventListener.statementClosed(statementEvent);
            }
        }
    }

    public void onStatementErrorOccurred(PreparedStatement preparedStatement, SQLException sQLException) {
        if (!this.statementEventListeners.isEmpty()) {
            StatementEvent statementEvent = new StatementEvent(this, preparedStatement, sQLException);
            for (StatementEventListener statementEventListener : this.statementEventListeners) {
                statementEventListener.statementErrorOccurred(statementEvent);
            }
        }
    }
}

