/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.jar;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.jar.JarFileObject;
import org.apache.commons.vfs2.provider.jar.JarFileProvider;
import org.apache.commons.vfs2.provider.zip.ZipFileObject;
import org.apache.commons.vfs2.provider.zip.ZipFileSystem;

public class JarFileSystem
extends ZipFileSystem {
    private Attributes attributes;

    protected JarFileSystem(AbstractFileName rootName, FileObject file, FileSystemOptions fileSystemOptions) throws FileSystemException {
        super(rootName, file, fileSystemOptions);
    }

    @Override
    protected ZipFile createZipFile(File file) throws FileSystemException {
        try {
            return new JarFile(file);
        }
        catch (IOException ioe) {
            throw new FileSystemException("vfs.provider.jar/open-jar-file.error", (Object)file, (Throwable)ioe);
        }
    }

    @Override
    protected ZipFileObject createZipFileObject(AbstractFileName name, ZipEntry entry) throws FileSystemException {
        return new JarFileObject(name, entry, this, true);
    }

    @Override
    protected void addCapabilities(Collection<Capability> caps) {
        caps.addAll(JarFileProvider.CAPABILITIES);
    }

    Attributes getAttributes() throws IOException {
        if (this.attributes == null) {
            Manifest man = ((JarFile)this.getZipFile()).getManifest();
            if (man == null) {
                this.attributes = new Attributes(1);
            } else {
                this.attributes = man.getMainAttributes();
                if (this.attributes == null) {
                    this.attributes = new Attributes(1);
                }
            }
        }
        return this.attributes;
    }

    Object getAttribute(Attributes.Name attrName) throws FileSystemException {
        try {
            Attributes attr = this.getAttributes();
            String value = attr.getValue(attrName);
            return value;
        }
        catch (IOException ioe) {
            throw new FileSystemException(attrName.toString(), ioe);
        }
    }

    Attributes.Name lookupName(String attrName) {
        if (Attributes.Name.CLASS_PATH.toString().equals(attrName)) {
            return Attributes.Name.CLASS_PATH;
        }
        if (Attributes.Name.CONTENT_TYPE.toString().equals(attrName)) {
            return Attributes.Name.CONTENT_TYPE;
        }
        if (Attributes.Name.EXTENSION_INSTALLATION.toString().equals(attrName)) {
            return Attributes.Name.EXTENSION_INSTALLATION;
        }
        if (Attributes.Name.EXTENSION_LIST.toString().equals(attrName)) {
            return Attributes.Name.EXTENSION_LIST;
        }
        if (Attributes.Name.EXTENSION_NAME.toString().equals(attrName)) {
            return Attributes.Name.EXTENSION_NAME;
        }
        if (Attributes.Name.IMPLEMENTATION_TITLE.toString().equals(attrName)) {
            return Attributes.Name.IMPLEMENTATION_TITLE;
        }
        if (Attributes.Name.IMPLEMENTATION_URL.toString().equals(attrName)) {
            return Attributes.Name.IMPLEMENTATION_URL;
        }
        if (Attributes.Name.IMPLEMENTATION_VENDOR.toString().equals(attrName)) {
            return Attributes.Name.IMPLEMENTATION_VENDOR;
        }
        if (Attributes.Name.IMPLEMENTATION_VENDOR_ID.toString().equals(attrName)) {
            return Attributes.Name.IMPLEMENTATION_VENDOR_ID;
        }
        if (Attributes.Name.IMPLEMENTATION_VERSION.toString().equals(attrName)) {
            return Attributes.Name.IMPLEMENTATION_VENDOR;
        }
        if (Attributes.Name.MAIN_CLASS.toString().equals(attrName)) {
            return Attributes.Name.MAIN_CLASS;
        }
        if (Attributes.Name.MANIFEST_VERSION.toString().equals(attrName)) {
            return Attributes.Name.MANIFEST_VERSION;
        }
        if (Attributes.Name.SEALED.toString().equals(attrName)) {
            return Attributes.Name.SEALED;
        }
        if (Attributes.Name.SIGNATURE_VERSION.toString().equals(attrName)) {
            return Attributes.Name.SIGNATURE_VERSION;
        }
        if (Attributes.Name.SPECIFICATION_TITLE.toString().equals(attrName)) {
            return Attributes.Name.SPECIFICATION_TITLE;
        }
        if (Attributes.Name.SPECIFICATION_VENDOR.toString().equals(attrName)) {
            return Attributes.Name.SPECIFICATION_VENDOR;
        }
        if (Attributes.Name.SPECIFICATION_VERSION.toString().equals(attrName)) {
            return Attributes.Name.SPECIFICATION_VERSION;
        }
        return new Attributes.Name(attrName);
    }

    @Override
    public Object getAttribute(String attrName) throws FileSystemException {
        Attributes.Name name = this.lookupName(attrName);
        return this.getAttribute(name);
    }

    @Override
    protected ZipFile getZipFile() throws FileSystemException {
        return super.getZipFile();
    }
}

