/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.http5;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.AbstractRandomAccessStreamContent;
import org.apache.commons.vfs2.provider.http5.Http5FileObject;
import org.apache.commons.vfs2.provider.http5.Http5FileSystem;
import org.apache.commons.vfs2.provider.http5.MonitoredHttpResponseContentInputStream;
import org.apache.commons.vfs2.util.MonitorInputStream;
import org.apache.commons.vfs2.util.RandomAccessMode;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;

final class Http5RandomAccessContent<FS extends Http5FileSystem>
extends AbstractRandomAccessStreamContent {
    protected long filePointer;
    private final Http5FileObject<FS> fileObject;
    private DataInputStream dis;
    private MonitorInputStream mis;

    Http5RandomAccessContent(Http5FileObject<FS> fileObject, RandomAccessMode mode) {
        super(mode);
        this.fileObject = fileObject;
    }

    @Override
    public void close() throws IOException {
        if (this.dis != null) {
            this.dis.close();
            this.dis = null;
            this.mis = null;
        }
    }

    @Override
    protected DataInputStream getDataInputStream() throws IOException {
        long skipped;
        if (this.dis != null) {
            return this.dis;
        }
        HttpGet httpGet = new HttpGet(this.fileObject.getInternalURI());
        httpGet.setHeader("Range", (Object)("bytes=" + this.filePointer + "-"));
        ClassicHttpResponse httpResponse = this.fileObject.executeHttpUriRequest((HttpUriRequest)httpGet);
        int status = httpResponse.getCode();
        if (status != 206 && status != 200) {
            throw new FileSystemException("vfs.provider.http/get-range.error", this.fileObject.getName(), this.filePointer, status);
        }
        this.mis = new MonitoredHttpResponseContentInputStream(httpResponse);
        if (status == 200 && (skipped = this.mis.skip(this.filePointer)) != this.filePointer) {
            throw new FileSystemException("vfs.provider.http/get-range.error", this.fileObject.getName(), this.filePointer, status);
        }
        this.dis = new DataInputStream(new FilterInputStream(this.mis){

            @Override
            public int read() throws IOException {
                int ret = super.read();
                if (ret > -1) {
                    ++Http5RandomAccessContent.this.filePointer;
                }
                return ret;
            }

            @Override
            public int read(byte[] b2) throws IOException {
                int ret = super.read(b2);
                if (ret > -1) {
                    Http5RandomAccessContent.this.filePointer += (long)ret;
                }
                return ret;
            }

            @Override
            public int read(byte[] b2, int off, int len) throws IOException {
                int ret = super.read(b2, off, len);
                if (ret > -1) {
                    Http5RandomAccessContent.this.filePointer += (long)ret;
                }
                return ret;
            }
        });
        return this.dis;
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.filePointer;
    }

    @Override
    public long length() throws IOException {
        return this.fileObject.getContent().getSize();
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos == this.filePointer) {
            return;
        }
        if (pos < 0L) {
            throw new FileSystemException("vfs.provider/random-access-invalid-position.error", (Object)pos);
        }
        if (this.dis != null) {
            this.close();
        }
        this.filePointer = pos;
    }
}

