/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.cache;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.cache.AbstractFilesCache;
import org.apache.commons.vfs2.cache.FileSystemAndNameKey;

public class SoftRefFilesCache
extends AbstractFilesCache {
    private static final Log log = LogFactory.getLog(SoftRefFilesCache.class);
    private final Map<FileSystem, Map<FileName, Reference<FileObject>>> fileSystemCache = new HashMap<FileSystem, Map<FileName, Reference<FileObject>>>();
    private final Map<Reference<FileObject>, FileSystemAndNameKey> refReverseMap = new HashMap<Reference<FileObject>, FileSystemAndNameKey>(100);
    private final ReferenceQueue<FileObject> refQueue = new ReferenceQueue();
    private ReleaseThread releaseThread;

    @Override
    public synchronized void clear(FileSystem fileSystem) {
        Map<FileName, Reference<FileObject>> files = this.getOrCreateFilesystemCache(fileSystem);
        Iterator<FileSystemAndNameKey> iterKeys = this.refReverseMap.values().iterator();
        while (iterKeys.hasNext()) {
            FileSystemAndNameKey key = iterKeys.next();
            if (key.getFileSystem() != fileSystem) continue;
            iterKeys.remove();
            files.remove(key.getFileName());
        }
        if (files.isEmpty()) {
            this.close(fileSystem);
        }
    }

    @Override
    public synchronized void close() {
        super.close();
        this.endThread();
        this.fileSystemCache.clear();
        this.refReverseMap.clear();
    }

    private synchronized void close(FileSystem fileSystem) {
        if (log.isDebugEnabled()) {
            log.debug("Close FileSystem: " + fileSystem.getRootName());
        }
        this.fileSystemCache.remove(fileSystem);
        if (this.fileSystemCache.isEmpty()) {
            this.endThread();
        }
    }

    protected Reference<FileObject> createReference(FileObject file, ReferenceQueue<FileObject> refqueue) {
        return new SoftReference<FileObject>(file, refqueue);
    }

    private synchronized void endThread() {
        ReleaseThread thread = this.releaseThread;
        this.releaseThread = null;
        if (thread != null) {
            thread.interrupt();
        }
    }

    @Override
    public synchronized FileObject getFile(FileSystem fileSystem, FileName fileName) {
        Map<FileName, Reference<FileObject>> files = this.getOrCreateFilesystemCache(fileSystem);
        Reference<FileObject> ref = files.get(fileName);
        if (ref == null) {
            return null;
        }
        FileObject fo = ref.get();
        if (fo == null) {
            this.removeFile(fileSystem, fileName);
        }
        return fo;
    }

    protected synchronized Map<FileName, Reference<FileObject>> getOrCreateFilesystemCache(FileSystem fileSystem) {
        if (this.fileSystemCache.isEmpty()) {
            this.startThread();
        }
        return this.fileSystemCache.computeIfAbsent(fileSystem, k2 -> new HashMap());
    }

    private String getSafeName(FileName fileName) {
        return fileName.getFriendlyURI();
    }

    private String getSafeName(FileObject fileObject) {
        return this.getSafeName(fileObject.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putFile(FileObject fileObject) {
        if (log.isDebugEnabled()) {
            log.debug("putFile: " + this.getSafeName(fileObject));
        }
        SoftRefFilesCache softRefFilesCache = this;
        synchronized (softRefFilesCache) {
            Map<FileName, Reference<FileObject>> files = this.getOrCreateFilesystemCache(fileObject.getFileSystem());
            Reference<FileObject> ref = this.createReference(fileObject, this.refQueue);
            FileSystemAndNameKey key = new FileSystemAndNameKey(fileObject.getFileSystem(), fileObject.getName());
            Reference<FileObject> old = files.put(fileObject.getName(), ref);
            if (old != null) {
                this.refReverseMap.remove(old);
            }
            this.refReverseMap.put(ref, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putFileIfAbsent(FileObject fileObject) {
        if (log.isDebugEnabled()) {
            log.debug("putFile: " + this.getSafeName(fileObject));
        }
        SoftRefFilesCache softRefFilesCache = this;
        synchronized (softRefFilesCache) {
            Map<FileName, Reference<FileObject>> files = this.getOrCreateFilesystemCache(fileObject.getFileSystem());
            Reference<FileObject> ref = this.createReference(fileObject, this.refQueue);
            FileSystemAndNameKey key = new FileSystemAndNameKey(fileObject.getFileSystem(), fileObject.getName());
            if (files.containsKey(fileObject.getName()) && files.get(fileObject.getName()).get() != null) {
                return false;
            }
            Reference<FileObject> old = files.put(fileObject.getName(), ref);
            if (old != null) {
                this.refReverseMap.remove(old);
            }
            this.refReverseMap.put(ref, key);
            return true;
        }
    }

    @Override
    public synchronized void removeFile(FileSystem fileSystem, FileName fileName) {
        if (this.removeFile(new FileSystemAndNameKey(fileSystem, fileName))) {
            this.close(fileSystem);
        }
    }

    private synchronized boolean removeFile(FileSystemAndNameKey key) {
        Map<FileName, Reference<FileObject>> files;
        Reference<FileObject> ref;
        if (log.isDebugEnabled()) {
            log.debug("removeFile: " + this.getSafeName(key.getFileName()));
        }
        if ((ref = (files = this.getOrCreateFilesystemCache(key.getFileSystem())).remove(key.getFileName())) != null) {
            this.refReverseMap.remove(ref);
        }
        return files.isEmpty();
    }

    private synchronized void removeFile(Reference<?> ref) {
        FileSystemAndNameKey key = this.refReverseMap.get(ref);
        if (key != null && this.removeFile(key)) {
            this.close(key.getFileSystem());
        }
    }

    private synchronized void startThread() {
        if (this.releaseThread == null) {
            this.releaseThread = new ReleaseThread();
            this.releaseThread.start();
        }
    }

    public String toString() {
        return super.toString() + " [releaseThread=" + this.releaseThread + (this.releaseThread == null ? "" : "(ID " + this.releaseThread.getId() + " is " + (Object)((Object)this.releaseThread.getState()) + ")") + "]";
    }

    private final class ReleaseThread
    extends Thread {
        private ReleaseThread() {
            this.setName(ReleaseThread.class.getName());
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                while (true) {
                    SoftRefFilesCache.this.removeFile(SoftRefFilesCache.this.refQueue.remove(0L));
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }
}

