/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.util.logging;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DisableTrace;

@DisableTrace
public class UCPLoggerFactory {
    private static final Logger logger = Logger.getLogger(UCPLoggerFactory.class.getCanonicalName());

    public static Logger createLogger(String name) {
        return Logger.getLogger(name);
    }

    public static synchronized void setLogLevel(Level newLogLevel) {
        try {
            Logger.getLogger("oracle.ucp").setLevel(newLogLevel);
            if (newLogLevel != null) {
                Handler[] logHandler = Logger.getLogger("").getHandlers();
                for (int i2 = 0; i2 < logHandler.length; ++i2) {
                    logHandler[i2].setLevel(newLogLevel);
                }
            }
        }
        catch (Exception e2) {
            logger.log(Level.FINEST, "setLogLevel", e2);
        }
    }

    public static Level getLogLevel() {
        return Logger.getLogger("oracle.ucp").getLevel();
    }
}

