/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.util;

import java.util.ArrayList;
import java.util.List;
import oracle.jdbc.logging.annotations.DisableTrace;

@DisableTrace
public class RingBuffer<T> {
    public static final int DEFAULT_CAPACITY = 64;
    public final Object[] ring;
    public int pointer = 0;
    protected long nUpdates = 0L;

    public RingBuffer() {
        this(64);
    }

    public RingBuffer(int capacity) {
        this.ring = new Object[capacity];
    }

    public int next(int i2) {
        return (i2 + 1) % this.getCapacity();
    }

    public int previous(int i2) {
        int j2 = i2 - 1;
        return j2 < 0 ? this.getCapacity() - 1 : j2;
    }

    public void addItem(T item) {
        this.pointer = this.next(this.pointer);
        this.ring[this.pointer] = item;
        if (++this.nUpdates < 0L) {
            this.nUpdates = Long.MAX_VALUE;
        }
    }

    public int getCapacity() {
        return this.ring.length;
    }

    public long getNumberOfUpdates() {
        return this.nUpdates;
    }

    public List<T> getAsList() {
        ArrayList<Object> listHistory = new ArrayList<Object>();
        int index = this.pointer;
        int i2 = 0;
        while ((long)i2 < Math.min((long)this.getCapacity(), this.getNumberOfUpdates())) {
            listHistory.add(this.ring[index]);
            index = this.previous(index);
            ++i2;
        }
        return listHistory;
    }

    @DisableTrace
    public String toString() {
        return this.toString(this.getCapacity());
    }

    @DisableTrace
    public String toString(int nItems) {
        StringBuilder sb = new StringBuilder();
        int i2 = this.pointer;
        int n2 = nItems;
        if (n2 < 1) {
            return "";
        }
        do {
            Object item;
            if (null == (item = this.ring[i2])) continue;
            sb.append(item.toString());
        } while ((i2 = this.previous(i2)) != this.pointer && --n2 > 0);
        return sb.toString();
    }

    public void clear() {
        this.pointer = 0;
        this.nUpdates = 0L;
    }
}

