/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.logging;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Visibility;

@DisableTrace
public class ClioSupport {
    private static Logger defaultLogger = Logger.getLogger("oracle.ucp");

    private static String toString(Executable method) {
        return method instanceof Constructor ? "<init>" : method.getName();
    }

    private static void _log(Logger logger, Level level, Class cls, Executable method, Object receiver, String message) {
        String outMessage = (null != cls ? cls.getName() : "") + ":" + (null != method ? ClioSupport.toString(method) : "") + ":" + (null != receiver ? receiver.toString() : "") + ":" + message;
        if (null != logger) {
            logger.log(level, outMessage);
        } else {
            defaultLogger.log(level, outMessage);
        }
    }

    @Log(value=Visibility.INTERNAL)
    public static void ilog(Logger logger, Level level, Class cls, Executable method, Object receiver, String message) {
        ClioSupport._log(logger, level, cls, method, receiver, message);
    }

    @Log(value=Visibility.INTERNAL)
    public static void ilogFinest(Logger logger, Class cls, Executable method, Object receiver, String message) {
        ClioSupport.ilog(logger, Level.FINEST, cls, method, receiver, message);
    }

    @Log(value=Visibility.INTERNAL)
    public static void ilogFiner(Logger logger, Class cls, Executable method, Object receiver, String message) {
        ClioSupport.ilog(logger, Level.FINER, cls, method, receiver, message);
    }

    @Log(value=Visibility.INTERNAL)
    public static void ilogFine(Logger logger, Class cls, Executable method, Object receiver, String message) {
        ClioSupport.ilog(logger, Level.FINE, cls, method, receiver, message);
    }

    @Log(value=Visibility.INTERNAL)
    public static void ilogConfig(Logger logger, Class cls, Executable method, Object receiver, String message) {
        ClioSupport.ilog(logger, Level.CONFIG, cls, method, receiver, message);
    }

    @Log(value=Visibility.INTERNAL)
    public static void ilogInfo(Logger logger, Class cls, Executable method, Object receiver, String message) {
        ClioSupport.ilog(logger, Level.INFO, cls, method, receiver, message);
    }

    @Log(value=Visibility.INTERNAL)
    public static void ilogWarning(Logger logger, Class cls, Executable method, Object receiver, String message) {
        ClioSupport.ilog(logger, Level.WARNING, cls, method, receiver, message);
    }

    @Log(value=Visibility.INTERNAL)
    public static void ilogSevere(Logger logger, Class cls, Executable method, Object receiver, String message) {
        ClioSupport.ilog(logger, Level.SEVERE, cls, method, receiver, message);
    }

    @Log(value=Visibility.INTERNAL)
    public static void ilogOff(Logger logger, Class cls, Executable method, Object receiver, String message) {
        ClioSupport.ilog(logger, Level.OFF, cls, method, receiver, message);
    }

    @Log(value=Visibility.INTERNAL)
    public static void ilogThrowing(Logger logger, Class cls, Executable method, Object receiver, Throwable throwable) {
        ClioSupport.ilog(logger, Level.FINEST, cls, method, receiver, "throwing: " + throwable.getMessage() + " : " + Arrays.toString(throwable.getStackTrace()));
    }

    @Log(value=Visibility.PUBLIC)
    public static void plog(Logger logger, Level level, Class cls, Executable method, Object receiver, String message) {
        ClioSupport._log(logger, level, cls, method, receiver, message);
    }

    public static void entering(Logger logger, Level level, Class cls, Executable method, Object receiver, Object ... args) {
        StringBuilder sb = new StringBuilder();
        sb.append(" <- entering - ");
        for (Object arg : args) {
            sb.append(null != arg ? arg.toString() : "null").append(", ");
        }
        ClioSupport._log(logger, level, cls, method, receiver, sb.toString());
    }

    public static void returning(Logger logger, Level level, Class cls, Executable method, Object receiver) {
        ClioSupport._log(logger, level, cls, method, receiver, " - returning -> void");
    }

    public static void returning(Logger logger, Level level, Class cls, Executable method, Object receiver, Object value) {
    }

    public static void throwing(Logger logger, Level level, Class cls, Executable method, Object receiver, Throwable thrown) {
    }

    public static void exiting(Logger logger, Level level, Class cls, Executable method, Object receiver, Throwable thrown) {
    }

    public static boolean publicEnter() {
        return true;
    }

    public static void publicExit() {
    }
}

