/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.sql.XAConnection;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.ConnectionWithAbandonedTimeout;
import oracle.ucp.jdbc.ConnectionWithTimeToLiveTimeout;
import oracle.ucp.jdbc.HarvestableConnection;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.JDBCUniversalPooledConnection;
import oracle.ucp.jdbc.LabelableConnection;
import oracle.ucp.jdbc.ValidConnection;
import oracle.ucp.jdbc.proxy.JDBCConnectionProxyFactory;
import oracle.ucp.jdbc.proxy.LogicalObject;
import oracle.ucp.util.UCPErrorHandler;

@DisableTrace
public class XAConnectionProxyFactory
extends JDBCConnectionProxyFactory
implements InvocationHandler,
LabelableConnection,
HarvestableConnection,
ConnectionWithAbandonedTimeout,
ConnectionWithTimeToLiveTimeout,
ValidConnection,
LogicalObject {
    public static Object createConnectionProxy(JDBCConnectionPool jdbcConnectionPool, JDBCUniversalPooledConnection jdbcPooledConnection) throws UniversalConnectionPoolException {
        Object proxiedConnection = jdbcPooledConnection.getPhysicalConnection();
        Object connectionProxy = null;
        try {
            connectionProxy = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), XAConnectionProxyFactory.createInterfaces(proxiedConnection), (InvocationHandler)new XAConnectionProxyFactory(proxiedConnection, jdbcConnectionPool, jdbcPooledConnection));
        }
        catch (Throwable e2) {
            connectionProxy = Proxy.newProxyInstance(XAConnectionProxyFactory.class.getClassLoader(), XAConnectionProxyFactory.createInterfaces(proxiedConnection), (InvocationHandler)new XAConnectionProxyFactory(proxiedConnection, jdbcConnectionPool, jdbcPooledConnection));
        }
        return connectionProxy;
    }

    protected XAConnectionProxyFactory(Object proxiedConnection, JDBCConnectionPool jdbcConnectionPool, JDBCUniversalPooledConnection jdbcPooledConnection) throws UniversalConnectionPoolException {
        super(proxiedConnection, jdbcConnectionPool, jdbcPooledConnection);
    }

    @Override
    protected void setProxiedConnection(Object proxiedConnection) throws UniversalConnectionPoolException {
        if (!(proxiedConnection instanceof XAConnection)) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(267);
        }
        this.m_proxiedConnection = (XAConnection)proxiedConnection;
    }

    @Override
    protected Object proxyInvokeAfterTargetInvoke(Object proxy, String methodName, Object result) throws Throwable {
        return result;
    }
}

