/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.proxy;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLRecoverableException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.JDBCUniversalPooledConnection;
import oracle.ucp.jdbc.proxy.LogicalObject;
import oracle.ucp.jdbc.proxy.ResultSetProxyFactory;
import oracle.ucp.jdbc.proxy.StatementProxyFactory;

@DisableTrace
public class PreparedStatementProxyFactory
extends StatementProxyFactory
implements InvocationHandler,
LogicalObject {
    protected static ConcurrentMap<Class, Constructor> constructorMap = new ConcurrentHashMap<Class, Constructor>();

    public static Object createPreparedStatementProxy(Object proxiedStatement, Object proxyConnection, JDBCConnectionPool jdbcConnectionPool, JDBCUniversalPooledConnection jdbcPooledConnection) throws UniversalConnectionPoolException {
        if (proxiedStatement == null) {
            return null;
        }
        Object stmtProxy = null;
        try {
            stmtProxy = PreparedStatementProxyFactory.createProxyHelper(proxyConnection.getClass().getClassLoader(), proxiedStatement, proxyConnection, jdbcConnectionPool, jdbcPooledConnection);
        }
        catch (Throwable e2) {
            try {
                stmtProxy = PreparedStatementProxyFactory.createProxyHelper(PreparedStatementProxyFactory.class.getClassLoader(), proxiedStatement, proxyConnection, jdbcConnectionPool, jdbcPooledConnection);
            }
            catch (Throwable ee) {
                throw new UniversalConnectionPoolException(ee);
            }
        }
        return stmtProxy;
    }

    private static Object createProxyHelper(ClassLoader clsLoader, Object proxiedStatement, Object proxyConnection, JDBCConnectionPool jdbcConnectionPool, JDBCUniversalPooledConnection jdbcPooledConnection) throws Exception {
        Class<?> stmtClass = proxiedStatement.getClass();
        Constructor<?> constructor = (Constructor<?>)constructorMap.get(stmtClass);
        if (constructor == null) {
            Class<?> pxyClass = Proxy.getProxyClass(clsLoader, PreparedStatementProxyFactory.createInterfaces(proxiedStatement));
            constructor = pxyClass.getConstructor(InvocationHandler.class);
        }
        Object stmtProxy = constructor.newInstance(new PreparedStatementProxyFactory(proxiedStatement, proxyConnection, jdbcConnectionPool, jdbcPooledConnection));
        if (null == constructorMap.putIfAbsent(stmtClass, constructor)) {
        }
        return stmtProxy;
    }

    protected PreparedStatementProxyFactory(Object proxiedStatement, Object proxyConnection, JDBCConnectionPool jdbcConnectionPool, JDBCUniversalPooledConnection jdbcPooledConnection) throws UniversalConnectionPoolException {
        super(proxiedStatement, proxyConnection, jdbcConnectionPool, jdbcPooledConnection);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            String methodName = method.getName();
            if (methodName.equals("executeQuery") || methodName.equals("getReturnResultSet")) {
                this.m_jdbcPooledConnection.heartbeat();
                if (this.creationTS < this.m_jdbcPooledConnection.getAvailableStartTime() || this.creationTS < this.m_jdbcPooledConnection.getBorrowedStartTime()) {
                    this.m_closed = true;
                    this.m_proxyConnection.close();
                }
                Object result = method.invoke((Object)this.m_proxiedStatement, args);
                this.m_jdbcPooledConnection.heartbeat();
                if (this.m_jdbcConnectionPool.getAbandonedConnectionTimeout() > 0) {
                    Object proxyResultSet = ResultSetProxyFactory.createResultSetProxy(result, proxy, this.m_jdbcConnectionPool, this.m_jdbcPooledConnection);
                    return proxyResultSet;
                }
                return result;
            }
            return super.invoke(proxy, method, args);
        }
        catch (InvocationTargetException e2) {
            Throwable t2 = e2.getCause();
            if (t2 instanceof SQLRecoverableException) {
                this.m_jdbcPooledConnection.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                this.m_jdbcConnectionPool.returnConnection(this.m_jdbcPooledConnection);
            }
            throw t2;
        }
    }

    private final String getStackTraceString(Throwable exc) {
        StringWriter stackTraceWriter = new StringWriter(1024);
        PrintWriter pw = new PrintWriter(stackTraceWriter);
        exc.printStackTrace(pw);
        return ((Object)stackTraceWriter).toString();
    }
}

