/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.proxy;

import java.lang.reflect.Executable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.replay.ReplayableConnection;
import oracle.ucp.AbandonedConnectionTimeoutCallback;
import oracle.ucp.ConnectionHarvestingCallback;
import oracle.ucp.TimeToLiveConnectionTimeoutCallback;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.common.Clock;
import oracle.ucp.jdbc.ConnectionWithAbandonedTimeout;
import oracle.ucp.jdbc.ConnectionWithTimeToLiveTimeout;
import oracle.ucp.jdbc.HarvestableConnection;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.JDBCUniversalPooledConnection;
import oracle.ucp.jdbc.LabelableConnection;
import oracle.ucp.jdbc.ValidConnection;
import oracle.ucp.jdbc.oracle.Poolable;
import oracle.ucp.jdbc.proxy.LogicalObject;
import oracle.ucp.util.UCPErrorHandler;

@DisableTrace
abstract class JDBCConnectionProxyFactory
implements InvocationHandler,
LabelableConnection,
HarvestableConnection,
ConnectionWithAbandonedTimeout,
ConnectionWithTimeToLiveTimeout,
ValidConnection,
Poolable,
LogicalObject {
    protected Object m_proxiedConnection;
    protected JDBCUniversalPooledConnection m_jdbcPooledConnection;
    protected JDBCConnectionPool m_jdbcConnectionPool;
    protected Boolean m_closed = new Boolean(false);
    protected final long creationTS;
    protected final boolean isReplayable;
    private static final Map<String, SwitchTable> m_invokeSwitchTable = new HashMap<String, SwitchTable>();
    private static Map<Class, Class[]> m_mapKnownInterfaces;

    protected JDBCConnectionProxyFactory(Object proxiedConnection, JDBCConnectionPool jdbcConnectionPool, JDBCUniversalPooledConnection jdbcPooledConnection) throws UniversalConnectionPoolException {
        if (null == jdbcPooledConnection) {
            UCPErrorHandler.throwUniversalConnectionPoolException(150);
        }
        if (null == jdbcConnectionPool) {
            UCPErrorHandler.throwUniversalConnectionPoolException(54);
        }
        this.m_jdbcConnectionPool = jdbcConnectionPool;
        this.m_jdbcPooledConnection = jdbcPooledConnection;
        this.setProxiedConnection(proxiedConnection);
        this.isReplayable = proxiedConnection instanceof ReplayableConnection;
        this.creationTS = Clock.clock();
    }

    protected abstract void setProxiedConnection(Object var1) throws UniversalConnectionPoolException;

    protected abstract Object proxyInvokeAfterTargetInvoke(Object var1, String var2, Object var3) throws Throwable;

    protected Object proxyInvokeBeforeTargetInvoke(Object proxy, String methodName, Object[] args) throws Throwable {
        SwitchTable invokeSwitch = m_invokeSwitchTable.get(methodName);
        if (null == invokeSwitch) {
            invokeSwitch = SwitchTable._ABSENT;
        }
        switch (invokeSwitch) {
            case OBJECT_EQUALS: {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            case OBJECT_HASHCODE: {
                return new Integer(System.identityHashCode(proxy));
            }
            case OBJECT_TOSTRING: {
                return proxy.getClass().getName() + "@" + Integer.toHexString(proxy.hashCode());
            }
            case ISLOGICALLYCLOSED: {
                return this.isLogicallyClosed();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        Object is = m_invokeSwitchTable.get(methodName);
        if (null == is) {
            is = SwitchTable._ABSENT;
        }
        SwitchTable invokeSwitch = is;
        this.m_jdbcPooledConnection.heartbeat();
        if (Clock.isBefore(this.creationTS, this.m_jdbcPooledConnection.getAvailableStartTime()) || Clock.isBefore(this.creationTS, this.m_jdbcPooledConnection.getBorrowedStartTime())) {
            this.m_closed = true;
        }
        try {
            is = this.m_closed;
            synchronized (is) {
                Object preResult = this.proxyInvokeBeforeTargetInvoke(proxy, methodName, args);
                if (preResult != null) {
                    return preResult;
                }
                if (SwitchTable.CLOSE == invokeSwitch) {
                    if (null != args && 1 == args.length && (args[0] instanceof Integer || args[0] instanceof Properties)) {
                        method.invoke(this.m_proxiedConnection, args[0]);
                        if (args[0] instanceof Integer && (Integer)args[0] == 1) {
                            JDBCConnectionRetrievalInfo cri = (JDBCConnectionRetrievalInfo)this.m_jdbcPooledConnection.getConnectionRetrievalInfo();
                            this.m_jdbcPooledConnection.setConnectionRetrievalInfo(cri.getCopyWithNewProxyProperties(-1, null));
                        }
                        this.m_jdbcPooledConnection.heartbeat();
                    } else {
                        if (this.m_closed.booleanValue()) {
                            return null;
                        }
                        this.m_closed = true;
                        try {
                            this.m_jdbcConnectionPool.returnConnection(this.m_jdbcPooledConnection);
                        }
                        catch (UniversalConnectionPoolException ucpe) {
                            Throwable sqlexc = ucpe.getCause();
                            if (sqlexc != null) {
                                throw sqlexc;
                            }
                            throw ucpe;
                        }
                    }
                    return null;
                }
                if (this.m_closed.booleanValue()) {
                    switch (invokeSwitch) {
                        case ISUSABLE: 
                        case ISVALID: {
                            return false;
                        }
                        case ISCLOSED: {
                            return true;
                        }
                    }
                    throw UCPErrorHandler.newSQLException(31);
                }
                switch (invokeSwitch) {
                    case ISVALID: {
                        if (args == null) {
                            return this.m_jdbcPooledConnection.isValid();
                        }
                        if (args.length == 1 && args[0] instanceof Integer) {
                            return this.m_jdbcPooledConnection.isValid(((Integer)args[0]).intValue());
                        }
                        return method.invoke((Object)this, args);
                    }
                    case _REST: {
                        return method.invoke((Object)this, args);
                    }
                }
                Object result = method.invoke(this.m_proxiedConnection, args);
                this.m_jdbcPooledConnection.heartbeat();
                Object postResult = this.proxyInvokeAfterTargetInvoke(proxy, methodName, result);
                return postResult != result ? postResult : result;
            }
        }
        catch (InvocationTargetException e2) {
            Throwable t2 = e2.getCause();
            if (t2 instanceof SQLRecoverableException) {
                this.m_jdbcPooledConnection.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                this.m_jdbcConnectionPool.returnConnection(this.m_jdbcPooledConnection);
            }
            throw t2;
        }
        catch (Throwable e3) {
            throw e3;
        }
    }

    @Override
    public void applyConnectionLabel(String key, String value) throws SQLException {
        try {
            this.m_jdbcPooledConnection.applyConnectionLabel(key, value);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(32, ucpExc);
        }
    }

    @Override
    public void removeConnectionLabel(String key) throws SQLException {
        try {
            this.m_jdbcPooledConnection.removeConnectionLabel(key);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(33, ucpExc);
        }
    }

    @Override
    public Properties getConnectionLabels() throws SQLException {
        Properties props = null;
        try {
            props = this.m_jdbcPooledConnection.getConnectionLabels();
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(34, ucpExc);
        }
        return props;
    }

    @Override
    public Properties getUnmatchedConnectionLabels(Properties requestedLabels) throws SQLException {
        Properties props = null;
        try {
            props = this.m_jdbcPooledConnection.getUnmatchedConnectionLabels(requestedLabels);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(35, ucpExc);
        }
        return props;
    }

    @Override
    public void setConnectionHarvestable(boolean isConnectionHarvestable) throws SQLException {
        try {
            this.m_jdbcPooledConnection.setConnectionHarvestable(isConnectionHarvestable);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(36, ucpExc);
        }
    }

    @Override
    public boolean isConnectionHarvestable() throws SQLException {
        return this.m_jdbcPooledConnection.isConnectionHarvestable();
    }

    @Override
    public void registerConnectionHarvestingCallback(ConnectionHarvestingCallback cbk) throws SQLException {
        try {
            this.m_jdbcPooledConnection.registerConnectionHarvestingCallback(cbk);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(37, ucpExc);
        }
    }

    @Override
    public void removeConnectionHarvestingCallback() throws SQLException {
        try {
            this.m_jdbcPooledConnection.removeConnectionHarvestingCallback();
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(38, ucpExc);
        }
    }

    @Override
    public void registerAbandonedConnectionTimeoutCallback(AbandonedConnectionTimeoutCallback cbk) throws SQLException {
        try {
            this.m_jdbcPooledConnection.registerAbandonedConnectionTimeoutCallback(cbk);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(39, ucpExc);
        }
    }

    @Override
    public void removeAbandonedConnectionTimeoutCallback() throws SQLException {
        try {
            this.m_jdbcPooledConnection.removeAbandonedConnectionTimeoutCallback();
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(40, ucpExc);
        }
    }

    @Override
    public void registerTimeToLiveConnectionTimeoutCallback(TimeToLiveConnectionTimeoutCallback cbk) throws SQLException {
        try {
            this.m_jdbcPooledConnection.registerTimeToLiveConnectionTimeoutCallback(cbk);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(41, ucpExc);
        }
    }

    @Override
    public void removeTimeToLiveConnectionTimeoutCallback() throws SQLException {
        try {
            this.m_jdbcPooledConnection.removeTimeToLiveConnectionTimeoutCallback();
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(42, ucpExc);
        }
    }

    @Override
    public boolean isValid() throws SQLException {
        return this.m_jdbcPooledConnection.isValid();
    }

    @Override
    public void setInvalid() throws SQLException {
        try {
            this.m_jdbcPooledConnection.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(47, ucpExc);
        }
    }

    @Override
    public UniversalPooledConnection getPooledObject() {
        return this.m_jdbcPooledConnection;
    }

    @Override
    public boolean isLogicallyClosed() {
        return this.m_closed;
    }

    protected static Class[] createInterfaces(Object object) {
        Class<?> objectClass = object.getClass();
        Class[] knownInterfaces = m_mapKnownInterfaces.get(objectClass);
        if (null != knownInterfaces) {
            return knownInterfaces;
        }
        HashSet<Class<LogicalObject>> interfacesSet = new HashSet<Class<LogicalObject>>();
        JDBCConnectionProxyFactory.addInterfaces(interfacesSet, objectClass);
        interfacesSet.add(LabelableConnection.class);
        interfacesSet.add(HarvestableConnection.class);
        interfacesSet.add(ConnectionWithAbandonedTimeout.class);
        interfacesSet.add(ConnectionWithTimeToLiveTimeout.class);
        interfacesSet.add(ValidConnection.class);
        interfacesSet.add(Poolable.class);
        interfacesSet.add(LogicalObject.class);
        Class[] interfaces = interfacesSet.toArray(new Class[0]);
        m_mapKnownInterfaces.put(objectClass, interfaces);
        return interfaces;
    }

    private static void addInterfaces(HashSet interfaces, Class type) {
        if (type == null) {
            return;
        }
        Class<?>[] proxyInterfaces = type.getInterfaces();
        for (int i2 = 0; i2 < proxyInterfaces.length; ++i2) {
            Class<?> proxyInterface = proxyInterfaces[i2];
            if (!Modifier.isPublic(proxyInterface.getModifiers())) continue;
            interfaces.add(proxyInterface);
        }
        JDBCConnectionProxyFactory.addInterfaces(interfaces, type.getSuperclass());
    }

    static {
        m_invokeSwitchTable.put("close", SwitchTable.CLOSE);
        m_invokeSwitchTable.put("isValid", SwitchTable.ISVALID);
        m_invokeSwitchTable.put("isUsable", SwitchTable.ISUSABLE);
        m_invokeSwitchTable.put("isClosed", SwitchTable.ISCLOSED);
        m_invokeSwitchTable.put("applyConnectionLabel", SwitchTable._REST);
        m_invokeSwitchTable.put("removeConnectionLabel", SwitchTable._REST);
        m_invokeSwitchTable.put("getConnectionLabels", SwitchTable._REST);
        m_invokeSwitchTable.put("getUnmatchedConnectionLabels", SwitchTable._REST);
        m_invokeSwitchTable.put("setConnectionHarvestable", SwitchTable._REST);
        m_invokeSwitchTable.put("isConnectionHarvestable", SwitchTable._REST);
        m_invokeSwitchTable.put("registerConnectionHarvestingCallback", SwitchTable._REST);
        m_invokeSwitchTable.put("removeConnectionHarvestingCallback", SwitchTable._REST);
        m_invokeSwitchTable.put("registerAbandonedConnectionTimeoutCallback", SwitchTable._REST);
        m_invokeSwitchTable.put("removeAbandonedConnectionTimeoutCallback", SwitchTable._REST);
        m_invokeSwitchTable.put("registerTimeToLiveConnectionTimeoutCallback", SwitchTable._REST);
        m_invokeSwitchTable.put("removeTimeToLiveConnectionTimeoutCallback", SwitchTable._REST);
        m_invokeSwitchTable.put("setInvalid", SwitchTable._REST);
        m_invokeSwitchTable.put("getPooledObject", SwitchTable._REST);
        m_invokeSwitchTable.put("isLogicallyClosed", SwitchTable.ISLOGICALLYCLOSED);
        m_invokeSwitchTable.put("equals", SwitchTable.OBJECT_EQUALS);
        m_invokeSwitchTable.put("hashCode", SwitchTable.OBJECT_HASHCODE);
        m_invokeSwitchTable.put("toString", SwitchTable.OBJECT_TOSTRING);
        m_mapKnownInterfaces = new HashMap<Class, Class[]>();
    }

    private static final class SwitchTable
    extends Enum<SwitchTable> {
        public static final /* enum */ SwitchTable CLOSE;
        public static final /* enum */ SwitchTable ISVALID;
        public static final /* enum */ SwitchTable ISUSABLE;
        public static final /* enum */ SwitchTable ISCLOSED;
        public static final /* enum */ SwitchTable _REST;
        public static final /* enum */ SwitchTable _ABSENT;
        public static final /* enum */ SwitchTable OBJECT_EQUALS;
        public static final /* enum */ SwitchTable OBJECT_HASHCODE;
        public static final /* enum */ SwitchTable OBJECT_TOSTRING;
        public static final /* enum */ SwitchTable ISLOGICALLYCLOSED;
        private static final /* synthetic */ SwitchTable[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public static SwitchTable[] values() {
            return (SwitchTable[])$VALUES.clone();
        }

        public static SwitchTable valueOf(String name) {
            return Enum.valueOf(SwitchTable.class, name);
        }

        static {
            try {
                $$$methodRef$$$2 = SwitchTable.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = SwitchTable.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = SwitchTable.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            CLOSE = new SwitchTable();
            ISVALID = new SwitchTable();
            ISUSABLE = new SwitchTable();
            ISCLOSED = new SwitchTable();
            _REST = new SwitchTable();
            _ABSENT = new SwitchTable();
            OBJECT_EQUALS = new SwitchTable();
            OBJECT_HASHCODE = new SwitchTable();
            OBJECT_TOSTRING = new SwitchTable();
            ISLOGICALLYCLOSED = new SwitchTable();
            $VALUES = new SwitchTable[]{CLOSE, ISVALID, ISUSABLE, ISCLOSED, _REST, _ABSENT, OBJECT_EQUALS, OBJECT_HASHCODE, OBJECT_TOSTRING, ISLOGICALLYCLOSED};
        }
    }
}

