/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.proxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.ConnectionWithAbandonedTimeout;
import oracle.ucp.jdbc.ConnectionWithTimeToLiveTimeout;
import oracle.ucp.jdbc.HarvestableConnection;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.JDBCUniversalPooledConnection;
import oracle.ucp.jdbc.LabelableConnection;
import oracle.ucp.jdbc.ValidConnection;
import oracle.ucp.jdbc.proxy.CallableStatementProxyFactory;
import oracle.ucp.jdbc.proxy.JDBCConnectionProxyFactory;
import oracle.ucp.jdbc.proxy.PreparedStatementProxyFactory;
import oracle.ucp.jdbc.proxy.StatementProxyFactory;
import oracle.ucp.util.UCPErrorHandler;

@DisableTrace
public class ConnectionProxyFactory
extends JDBCConnectionProxyFactory
implements InvocationHandler,
LabelableConnection,
HarvestableConnection,
ConnectionWithAbandonedTimeout,
ConnectionWithTimeToLiveTimeout,
ValidConnection {
    protected static ConcurrentMap<Class, Constructor> constructorMap = new ConcurrentHashMap<Class, Constructor>();

    public static Object createConnectionProxy(JDBCConnectionPool jdbcConnectionPool, JDBCUniversalPooledConnection jdbcPooledConnection) throws UniversalConnectionPoolException {
        Object cp = null;
        try {
            cp = ConnectionProxyFactory.createProxyHelper(Thread.currentThread().getContextClassLoader(), jdbcConnectionPool, jdbcPooledConnection);
        }
        catch (Throwable e2) {
            try {
                cp = ConnectionProxyFactory.createProxyHelper(ConnectionProxyFactory.class.getClassLoader(), jdbcConnectionPool, jdbcPooledConnection);
            }
            catch (Throwable ee) {
                throw new UniversalConnectionPoolException(ee);
            }
        }
        return cp;
    }

    private static Object createProxyHelper(ClassLoader clsLoader, JDBCConnectionPool jdbcConnectionPool, JDBCUniversalPooledConnection jdbcPooledConnection) throws Exception {
        Object proxiedConnection = jdbcPooledConnection.getPhysicalConnection();
        Class<?> pconnClass = proxiedConnection.getClass();
        Constructor<?> constructor = (Constructor<?>)constructorMap.get(pconnClass);
        if (constructor == null) {
            Class<?> pxyClass = Proxy.getProxyClass(clsLoader, ConnectionProxyFactory.createInterfaces(proxiedConnection));
            constructor = pxyClass.getConstructor(InvocationHandler.class);
        }
        Object connectionProxy = constructor.newInstance(new ConnectionProxyFactory(proxiedConnection, jdbcConnectionPool, jdbcPooledConnection));
        if (null == constructorMap.putIfAbsent(pconnClass, constructor)) {
        }
        return connectionProxy;
    }

    protected ConnectionProxyFactory(Object proxiedConnection, JDBCConnectionPool jdbcConnectionPool, JDBCUniversalPooledConnection jdbcPooledConnection) throws UniversalConnectionPoolException {
        super(proxiedConnection, jdbcConnectionPool, jdbcPooledConnection);
    }

    @Override
    protected void setProxiedConnection(Object proxiedConnection) throws UniversalConnectionPoolException {
        if (!(proxiedConnection instanceof Connection)) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(259);
        }
        this.m_proxiedConnection = (Connection)proxiedConnection;
    }

    @Override
    protected Object proxyInvokeAfterTargetInvoke(Object proxy, String methodName, Object result) throws Throwable {
        if (methodName.equals("createStatement")) {
            Object proxyStatement = StatementProxyFactory.createStatementProxy(result, proxy, this.m_jdbcConnectionPool, this.m_jdbcPooledConnection);
            return proxyStatement;
        }
        if (methodName.equals("prepareStatement")) {
            Object proxyPreparedStatement = PreparedStatementProxyFactory.createPreparedStatementProxy(result, proxy, this.m_jdbcConnectionPool, this.m_jdbcPooledConnection);
            return proxyPreparedStatement;
        }
        if (methodName.equals("prepareCall")) {
            Object proxyCallableStatement = CallableStatementProxyFactory.createCallableStatementProxy(result, proxy, this.m_jdbcConnectionPool, this.m_jdbcPooledConnection);
            return proxyCallableStatement;
        }
        return result;
    }
}

