/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle.rlb;

import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.oracle.FailoverablePooledConnection;
import oracle.ucp.jdbc.oracle.rlb.OracleDatabaseInstanceInfo;
import oracle.ucp.jdbc.oracle.rlb.PolicyBase;
import oracle.ucp.jdbc.oracle.rlb.RLBInfo;
import oracle.ucp.logging.ClioSupport;

@DefaultLogger(value="oracle.ucp.jdbc.oracle.rlb")
@Supports(value={Feature.LOAD_BALANCING})
class PolicyImpl
extends PolicyBase {
    public static final int NUMBER_OF_HITS_PER_INSTANCE = 1000;
    private final Map<String, SpecificStats> mapSpecificStats = new HashMap<String, SpecificStats>();
    private float advisoryPercentTotal = 100.0f;
    private final Random m_rand = new Random(0L);
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;

    PolicyImpl() {
    }

    private long getAttemptedConnRequestCount(String instanceName) {
        SpecificStats stats = this.mapSpecificStats.get(instanceName);
        return null == stats ? 0L : stats.attemptedConnRequestsCount;
    }

    private void incrementAttemptedConnRequestCount(String instanceName) {
        SpecificStats stats = this.mapSpecificStats.get(instanceName);
        if (null == stats) {
            stats = new SpecificStats();
            this.mapSpecificStats.put(instanceName, stats);
        }
        ++stats.attemptedConnRequestsCount;
    }

    @Override
    public Map<OracleDatabaseInstanceInfo, Integer> getCurrentRebalancePolicy() {
        String instanceName;
        boolean bl = (0x80000000000000L & TraceControllerImpl.feature) != 0L;
        StringBuilder sb = new StringBuilder();
        sb.append("Connection rebalancing policy requested: ");
        HashMap<OracleDatabaseInstanceInfo, Integer> currentRebalancePolicy = new HashMap<OracleDatabaseInstanceInfo, Integer>();
        RLBInfo.Frame frame = this.getRLBInfo().getPreviousFrame();
        if (null == frame) {
            sb.append("empty");
            if (bl) {
                ClioSupport.ilogFinest($$$loggerRef$$$2, PolicyImpl.class, $$$methodRef$$$2, this, sb.toString());
            }
            return currentRebalancePolicy;
        }
        float goodGroupSum = 0.0f;
        int totalAttemptedConnRequestsCount = 0;
        int totalConnectionsCount = 0;
        ArrayList<OracleDatabaseInstanceInfo> instancesAlive = new ArrayList<OracleDatabaseInstanceInfo>();
        for (OracleDatabaseInstanceInfo dbInstance : this.getRLBInfo().getInstances()) {
            String instanceName2 = dbInstance.getInstanceName();
            if (1 != dbInstance.status || 4 == dbInstance.flag || 5 == dbInstance.flag) continue;
            instancesAlive.add(dbInstance);
            goodGroupSum += dbInstance.getAdvisoryPercent();
            totalAttemptedConnRequestsCount = (int)((long)totalAttemptedConnRequestsCount + this.getAttemptedConnRequestCount(instanceName2));
            totalConnectionsCount += dbInstance.getNumberOfConnectionsCount();
        }
        this.advisoryPercentTotal = goodGroupSum;
        boolean resetAttempts = false;
        boolean wideBandwidth = true;
        for (OracleDatabaseInstanceInfo oracleDatabaseInstanceInfo : instancesAlive) {
            int connsPlanned;
            instanceName = oracleDatabaseInstanceInfo.getInstanceName();
            RLBInfo.InstanceStats instanceStats = frame.getStats(instanceName);
            float actualPercent = 100.0f * (float)instanceStats.getConnsBorrowed() / (float)frame.getTotalBorrowed();
            float targetPercent = oracleDatabaseInstanceInfo.getAdvisoryPercent();
            float deltaPercent = targetPercent - actualPercent;
            int connectionsToRebalance = Math.round((float)totalConnectionsCount * deltaPercent / 100.0f);
            long connsNecessary = instanceStats.getConnsBorrowedPeak();
            if (connsNecessary > (long)(connsPlanned = Math.round((float)totalConnectionsCount * targetPercent / 100.0f))) {
                wideBandwidth = false;
                if (bl) {
                    ClioSupport.ilogFinest($$$loggerRef$$$2, PolicyImpl.class, $$$methodRef$$$2, this, instanceName + ": bandwidth is too narrow, rebalance");
                }
            }
            if (connectionsToRebalance > 0) {
                currentRebalancePolicy.put(oracleDatabaseInstanceInfo, connectionsToRebalance);
                continue;
            }
            if (totalAttemptedConnRequestsCount > instancesAlive.size() * 1000) {
                float ACRRatio = (float)this.getAttemptedConnRequestCount(instanceName) / (float)totalAttemptedConnRequestsCount;
                int instConnCount = oracleDatabaseInstanceInfo.getNumberOfConnectionsCount();
                float connRatio = (float)instConnCount / (float)totalConnectionsCount;
                if (connRatio > ACRRatio * 0.75f) {
                    if (connectionsToRebalance < 0) {
                        currentRebalancePolicy.put(oracleDatabaseInstanceInfo, connectionsToRebalance);
                    }
                    resetAttempts = true;
                    continue;
                }
                if (!bl) continue;
                ClioSupport.ilogFinest($$$loggerRef$$$2, PolicyImpl.class, $$$methodRef$$$2, this, "connRatio=" + connRatio + " is less than ACRRatio=" + ACRRatio + ", condition is under gravitation threshold");
                continue;
            }
            if (!bl) continue;
            ClioSupport.ilogFinest($$$loggerRef$$$2, PolicyImpl.class, $$$methodRef$$$2, this, "totalAttemptedConnRequestsCount=" + totalAttemptedConnRequestsCount + " is lower than a designated gravitation threshold");
        }
        if (resetAttempts) {
            this.mapSpecificStats.clear();
            resetAttempts = false;
        }
        if (0 == currentRebalancePolicy.keySet().size()) {
            sb.append("empty");
        } else {
            for (Map.Entry entry : currentRebalancePolicy.entrySet()) {
                instanceName = ((OracleDatabaseInstanceInfo)entry.getKey()).getInstanceName();
                int nconns = (Integer)entry.getValue();
                sb.append("(").append(instanceName).append(", ").append(nconns).append(")");
            }
        }
        if (bl) {
            ClioSupport.ilogFinest($$$loggerRef$$$2, PolicyImpl.class, $$$methodRef$$$2, this, sb.toString());
        }
        if (wideBandwidth) {
            if (bl) {
                ClioSupport.ilogFinest($$$loggerRef$$$2, PolicyImpl.class, $$$methodRef$$$2, this, "wide bandwidth - no rebalance necessary");
            }
            return Collections.emptyMap();
        }
        return currentRebalancePolicy;
    }

    @Override
    public FailoverablePooledConnection borrowConnection(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        int violatingFactor;
        RLBInfo.Frame frame = this.getRLBInfo().getCurrentFrame();
        if (null == frame) {
            return null;
        }
        Collection<OracleDatabaseInstanceInfo> instances = this.getRLBInfo().getInstances();
        int numInstances = instances.size();
        boolean[] tried = new boolean[numInstances];
        int violatingInstCount = this.getViolatingInstancesCount();
        int n2 = violatingFactor = violatingInstCount != 0 ? this.getUpInstancesCount() / violatingInstCount : Integer.MAX_VALUE;
        if (this.advisoryPercentTotal > 0.0f && numInstances > 0) {
            float total = this.advisoryPercentTotal;
            block0: for (int j2 = 0; j2 < numInstances; ++j2) {
                float percentSum = 0.0f;
                int i2 = 0;
                float randomPercent = this.m_rand.nextFloat() * total;
                for (OracleDatabaseInstanceInfo dbInstance : this.getRLBInfo().getInstances()) {
                    String instanceName = dbInstance.getInstanceName();
                    int flag = dbInstance.flag;
                    if (!(tried[i2] || 1 != flag && 2 != flag && 3 != flag)) {
                        if (3 == flag && violatingFactor > 2) {
                            tried[i2] = true;
                            ++i2;
                            continue;
                        }
                        if (randomPercent < (percentSum += dbInstance.getAdvisoryPercent())) {
                            FailoverablePooledConnection fpc;
                            if (j2 == 0) {
                                this.incrementAttemptedConnRequestCount(instanceName);
                            }
                            if (null != (fpc = this.getConnectionsDispatcher().borrowConnection(dbInstance, cri))) {
                                return fpc;
                            }
                            total -= dbInstance.getAdvisoryPercent();
                            tried[i2] = true;
                            continue block0;
                        }
                    }
                    ++i2;
                }
            }
        }
        return null;
    }

    private int getViolatingInstancesCount() {
        int violatingCount = 0;
        for (OracleDatabaseInstanceInfo dbInstance : this.getRLBInfo().getInstances()) {
            if (dbInstance.status != 1 || 3 != dbInstance.flag) continue;
            ++violatingCount;
        }
        return violatingCount;
    }

    private int getUpInstancesCount() {
        int upCount = 0;
        for (OracleDatabaseInstanceInfo dbInstance : this.getRLBInfo().getInstances()) {
            if (dbInstance.status != 1) continue;
            ++upCount;
        }
        return upCount;
    }

    static {
        try {
            $$$methodRef$$$6 = PolicyImpl.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$5 = PolicyImpl.class.getDeclaredMethod("getUpInstancesCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$4 = PolicyImpl.class.getDeclaredMethod("getViolatingInstancesCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$3 = PolicyImpl.class.getDeclaredMethod("borrowConnection", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$2 = PolicyImpl.class.getDeclaredMethod("getCurrentRebalancePolicy", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$1 = PolicyImpl.class.getDeclaredMethod("incrementAttemptedConnRequestCount", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$0 = PolicyImpl.class.getDeclaredMethod("getAttemptedConnRequestCount", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
    }

    private static final class SpecificStats {
        long attemptedConnRequestsCount = 0L;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;

        private SpecificStats() {
        }

        static {
            try {
                $$$methodRef$$$1 = SpecificStats.class.getDeclaredConstructor(1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = SpecificStats.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    }
}

