/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.lang.reflect.Executable;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.common.Failoverable;
import oracle.ucp.jdbc.oracle.FailoverActionResult;
import oracle.ucp.jdbc.oracle.FailoverablePooledConnection;
import oracle.ucp.jdbc.oracle.RACManager;
import oracle.ucp.jdbc.oracle.RACManagerImpl;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.TaskManager;
import oracle.ucp.util.TimerManager;

@DefaultLogger(value="oracle.ucp.jdbc.oracle")
@Supports(value={Feature.LOAD_BALANCING, Feature.HIGH_AVAILABILITY})
class ReplayableRACManagerImpl
extends RACManagerImpl
implements RACManager,
Failoverable {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;

    ReplayableRACManagerImpl(TaskManager taskManager, TimerManager timerManager, boolean isStrictWebSessionAffinity, boolean isStrictXAAffinity) throws UniversalConnectionPoolException {
        super(taskManager, timerManager, isStrictWebSessionAffinity, isStrictXAAffinity);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    FailoverActionResult processFailoverAction(FailoverablePooledConnection failoverablePooledConnection, boolean bl, boolean bl2, int n2) {
        void actionFlag;
        boolean bl3 = (0xC0000000000000L & TraceControllerImpl.feature) != 0L;
        FailoverActionResult result = FailoverActionResult.NOOP;
        switch (actionFlag) {
            case 0: {
                void pc;
                void isAvailableConnection;
                try {
                    void isPlannedDownEvent;
                    if (isAvailableConnection == false && isPlannedDownEvent != false) {
                        pc.setStatus(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN);
                        result = FailoverActionResult.MARKED_CLOSE_ON_RETURN;
                        break;
                    }
                    if (isAvailableConnection == false) {
                        pc.setStatus(UniversalPooledConnectionStatus.STATUS_RECONNECTING);
                        result = FailoverActionResult.MARKED_BAD;
                        break;
                    }
                    pc.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                    result = FailoverActionResult.MARKED_BAD;
                }
                catch (UniversalConnectionPoolException ucpe) {
                    if (bl3) {
                        ClioSupport.ilogFinest($$$loggerRef$$$0, ReplayableRACManagerImpl.class, $$$methodRef$$$0, this, this.getStackTraceString(ucpe));
                    }
                    this.m_errorInfo.append(", ").append(ucpe.getStackTrace()[0].toString());
                    result = FailoverActionResult.FAILED;
                }
                break;
            }
            case 1: {
                void pc;
                void isAvailableConnection;
                if (pc.getStatus() != UniversalPooledConnectionStatus.STATUS_BAD && pc.getStatus() != UniversalPooledConnectionStatus.STATUS_RECONNECTING) {
                    if (!bl3) break;
                    ClioSupport.ilogFinest($$$loggerRef$$$0, ReplayableRACManagerImpl.class, $$$methodRef$$$0, this, "AC replugging already happened - no FCF cleanup");
                    break;
                }
                try {
                    pc.abort();
                }
                catch (Exception exc) {
                    if (bl3) {
                        ClioSupport.ilogFinest($$$loggerRef$$$0, ReplayableRACManagerImpl.class, $$$methodRef$$$0, this, this.getStackTraceString(exc));
                    }
                    this.m_errorInfo.append(", ").append(exc.getStackTrace()[0].toString());
                    result = FailoverActionResult.FAILED;
                }
                try {
                    pc.close(isAvailableConnection == false);
                    result = FailoverActionResult.ABORTED_AND_CLOSED;
                }
                catch (UniversalConnectionPoolException ucpe) {
                    if (bl3) {
                        ClioSupport.ilogFinest($$$loggerRef$$$0, ReplayableRACManagerImpl.class, $$$methodRef$$$0, this, this.getStackTraceString(ucpe));
                    }
                    this.m_errorInfo.append(", ").append(ucpe.getStackTrace()[0].toString());
                    result = FailoverActionResult.FAILED;
                }
                break;
            }
        }
        return result;
    }

    static {
        try {
            $$$methodRef$$$1 = ReplayableRACManagerImpl.class.getDeclaredConstructor(TaskManager.class, TimerManager.class, Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$0 = ReplayableRACManagerImpl.class.getDeclaredMethod("processFailoverAction", FailoverablePooledConnection.class, Boolean.TYPE, Boolean.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
    }
}

