/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.pool.OracleConnectionBuilderImpl;
import oracle.jdbc.replay.OracleDataSourceImpl;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.oracle.OracleDataSourceConnectionFactoryAdapter;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionRetrievalInfo;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.Util;

@DefaultLogger(value="oracle.ucp.jdbc.oracle")
@Supports(value={Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public class ReplayDataSourceConnectionFactoryAdapter
extends OracleDataSourceConnectionFactoryAdapter {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    public ReplayDataSourceConnectionFactoryAdapter(DataSource dataSource) throws UniversalConnectionPoolException {
        super(dataSource);
    }

    @Override
    public void initializeUrlFromConnectionFactory() {
        block3: {
            boolean bl = (0x30000000000000L & TraceControllerImpl.feature) != 0L;
            Class<?> dsClass = this.m_dataSource.getClass();
            Class<?> cls = null;
            try {
                cls = Class.forName("oracle.jdbc.replay.OracleDataSourceImpl", true, dsClass.getClassLoader());
                Method m3 = cls.getMethod("getURL", new Class[0]);
                this.m_url = (String)m3.invoke((Object)this.m_dataSource, new Object[0]);
                if (bl) {
                    ClioSupport.ilogFinest($$$loggerRef$$$0, ReplayDataSourceConnectionFactoryAdapter.class, $$$methodRef$$$0, this, "initializeUrlFromConnectionFactory() succeeded");
                }
            }
            catch (Exception exc) {
                if (!bl) break block3;
                ClioSupport.ilogThrowing($$$loggerRef$$$0, ReplayDataSourceConnectionFactoryAdapter.class, $$$methodRef$$$0, this, exc);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setUrl(String string) {
        block2: {
            boolean bl = (0x30000000000000L & TraceControllerImpl.feature) != 0L;
            Class<?> dsClass = this.m_dataSource.getClass();
            Class<?> cls = null;
            try {
                void url;
                cls = Class.forName("oracle.jdbc.replay.OracleDataSourceImpl", true, dsClass.getClassLoader());
                Method m3 = cls.getMethod("setURL", String.class);
                m3.invoke((Object)this.m_dataSource, url);
            }
            catch (Exception exc) {
                if (!bl) break block2;
                ClioSupport.ilogThrowing($$$loggerRef$$$1, ReplayDataSourceConnectionFactoryAdapter.class, $$$methodRef$$$1, this, exc);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object createConnection(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        boolean bl = (0x30000000000000L & TraceControllerImpl.feature) != 0L;
        OracleDataSourceImpl ods = null;
        Connection connection = null;
        try {
            void connectionRequestInfo;
            if (!(this.m_dataSource instanceof OracleDataSourceImpl)) {
                if (bl) {
                    ClioSupport.ilogFinest($$$loggerRef$$$2, ReplayDataSourceConnectionFactoryAdapter.class, $$$methodRef$$$2, this, "about to create connection without specifying instance");
                }
                connection = (Connection)super.createConnection((ConnectionRetrievalInfo)connectionRequestInfo);
            } else {
                String instanceName;
                ods = (OracleDataSourceImpl)this.m_dataSource;
                JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)connectionRequestInfo;
                if (connectionRequestInfo instanceof OracleJDBCConnectionRetrievalInfo) {
                    instanceName = ((OracleJDBCConnectionRetrievalInfo)connectionRequestInfo).getInstanceName();
                    if (bl) {
                        ClioSupport.ilogFinest($$$loggerRef$$$2, ReplayDataSourceConnectionFactoryAdapter.class, $$$methodRef$$$2, this, "about to create connection to the instance " + instanceName);
                    }
                } else {
                    instanceName = null;
                }
                OracleConnectionBuilderImpl builder = ods.createConnectionBuilder();
                connection = builder.user(jdbcCri.getUser()).password(jdbcCri.getPassword()).instanceName(instanceName).serviceName(jdbcCri.getServiceName()).shardingKey(jdbcCri.getShardingKey()).superShardingKey(jdbcCri.getSuperShardingKey()).build();
                if (connection instanceof OracleConnection) {
                    Properties proxyProps;
                    String in = ((OracleConnection)connection).getServerSessionInfo().getProperty("INSTANCE_NAME");
                    assert (null != in);
                    assert (instanceName == null || Util.equalsNormalized(in, instanceName)) : "internal error: got connection from the wrong instance";
                    if (instanceName != null && !"".equals(instanceName) && !Util.equalsNormalized(in, instanceName) && bl) {
                        ClioSupport.ilogFinest($$$loggerRef$$$2, ReplayDataSourceConnectionFactoryAdapter.class, $$$methodRef$$$2, this, "wrong conn opened, desired:" + instanceName + ", actual:" + in);
                    }
                    if ((proxyProps = jdbcCri.getProxyProperties()) != null) {
                        int proxyType = jdbcCri.getProxyType();
                        if (bl) {
                            ClioSupport.ilogFinest($$$loggerRef$$$2, ReplayDataSourceConnectionFactoryAdapter.class, $$$methodRef$$$2, this, " Opening proxy session with Properties = " + proxyProps);
                        }
                        ((OracleConnection)connection).openProxySession(proxyType, proxyProps);
                    }
                } else if (bl) {
                    ClioSupport.ilogFinest($$$loggerRef$$$2, ReplayDataSourceConnectionFactoryAdapter.class, $$$methodRef$$$2, this, "not an oracle connection");
                }
            }
        }
        catch (SQLException e2) {
            UCPErrorHandler.throwUniversalConnectionPoolException(257, e2);
        }
        return connection;
    }

    static {
        try {
            $$$methodRef$$$3 = ReplayDataSourceConnectionFactoryAdapter.class.getDeclaredConstructor(DataSource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$2 = ReplayDataSourceConnectionFactoryAdapter.class.getDeclaredMethod("createConnection", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$1 = ReplayDataSourceConnectionFactoryAdapter.class.getDeclaredMethod("setUrl", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$0 = ReplayDataSourceConnectionFactoryAdapter.class.getDeclaredMethod("initializeUrlFromConnectionFactory", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
    }
}

