/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.admin.UniversalConnectionPoolManagerBase;
import oracle.ucp.common.Clock;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.JDBCUniversalPooledConnection;
import oracle.ucp.jdbc.oracle.FailoverablePooledConnection;
import oracle.ucp.jdbc.oracle.FailoverablePooledConnectionHelper;
import oracle.ucp.jdbc.oracle.OracleFailoverablePooledConnection;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionPool;
import oracle.ucp.jdbc.oracle.rlb.RLBInfo;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.TaskHandle;
import oracle.ucp.util.TaskManagerException;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.UCPTaskBase;
import oracle.ucp.util.Util;

@DefaultLogger(value="oracle.ucp.jdbc.proxy")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT, Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public class OracleUniversalPooledConnection
extends JDBCUniversalPooledConnection
implements OracleFailoverablePooledConnection,
FailoverablePooledConnection {
    public static final int CANCELLATION_TIMEOUT = 15;
    private static final String DEFAULT_DRCP_VALUE = "NULL";
    private static final char DRCP_KEY_VALUE_SEPARATOR = '=';
    private static final char DRCP_MULTITAG_SEPARATOR = ';';
    private String m_dataSourceInstanceName;
    private String m_dbUniqueName;
    private String m_hostName;
    private String m_serviceName;
    private int m_instanceId;
    private JDBCConnectionPool m_cp;
    private boolean m_isNamedInstanceConn;
    private boolean isDRCPTagMatched;
    private Date m_instanceStartTime;
    private AtomicReference<RLBInfo.Frame> rlbBorrowStats;
    private AtomicReference<RLBInfo.Frame> rlbOpenStats;
    private boolean isPdbSessionInitialized;
    static final boolean shardRoutingEnabled;
    private OracleConnection.DRCPState initialDrcpState;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;

    public OracleUniversalPooledConnection(JDBCConnectionPool connectionPool, Object connection, ConnectionRetrievalInfo connectionRetrievalInfo, boolean connectionFailoverEnabled) throws UniversalConnectionPoolException {
        block3: {
            super(connectionPool, connection, connectionRetrievalInfo, connectionFailoverEnabled);
            boolean bl = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
            this.m_instanceId = -1;
            this.m_cp = null;
            this.m_isNamedInstanceConn = false;
            this.isDRCPTagMatched = true;
            this.rlbBorrowStats = new AtomicReference<Object>(null);
            this.rlbOpenStats = new AtomicReference<Object>(null);
            this.isPdbSessionInitialized = false;
            if (bl) {
                ClioSupport.ilogFinest($$$loggerRef$$$47, OracleUniversalPooledConnection.class, $$$methodRef$$$47, null, "connectionFailoverEnabled: " + connectionFailoverEnabled);
            }
            this.m_cp = connectionPool;
            this.m_isNamedInstanceConn = false;
            try {
                Connection conn = this.getSQLConnection(connection);
                OracleConnection oConn = (OracleConnection)conn;
                this.initialDrcpState = oConn.getDRCPState();
            }
            catch (SQLException e2) {
                if (!bl) break block3;
                ClioSupport.ilogThrowing($$$loggerRef$$$47, OracleUniversalPooledConnection.class, $$$methodRef$$$47, null, e2);
            }
        }
    }

    @Override
    public void validate() {
        boolean bl = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
        boolean valid = false;
        try {
            Connection conn = this.getSQLConnection(this.getPhysicalConnection());
            if (null != conn && (valid = FailoverablePooledConnectionHelper.isUsableOnOracleConnection(conn))) {
                if (null == this.m_cp.getSQLForValidateConnection()) {
                    valid = FailoverablePooledConnectionHelper.pingDatabaseOnOracleConnection(conn);
                } else {
                    if (bl) {
                        ClioSupport.ilogFinest($$$loggerRef$$$0, OracleUniversalPooledConnection.class, $$$methodRef$$$0, this, "Using SQL command to validate");
                    }
                    super.validate();
                }
            }
        }
        catch (Exception e2) {
            valid = false;
        }
        finally {
            if (valid) {
                this.setLastConnectionValidationTime(Clock.clock());
                if (bl) {
                    ClioSupport.ilogFinest($$$loggerRef$$$0, OracleUniversalPooledConnection.class, $$$methodRef$$$0, this, "connection is good");
                }
            } else {
                this.setStatus(UniversalPooledConnectionStatus.STATUS_BAD, "connection is bad");
                this.setLastConnectionValidationTime(0L);
            }
        }
    }

    @Override
    public boolean isValid() {
        boolean bl = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
        JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)this.getConnectionRetrievalInfo();
        OracleShardingKey key = jdbcCri.getShardingKey();
        OracleShardingKey superKey = jdbcCri.getSuperShardingKey();
        try {
            if (key == null) {
                return this.isValid(15L);
            }
            return this.setShardingKeyIfValid(key, superKey, 15);
        }
        catch (SQLException e2) {
            if (bl) {
                ClioSupport.ilogThrowing($$$loggerRef$$$1, OracleUniversalPooledConnection.class, $$$methodRef$$$1, this, e2);
            }
            return false;
        }
    }

    @Override
    public long getLastNetworkAccessTime() {
        block3: {
            boolean bl = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
            try {
                Connection conn = this.getSQLConnection(this.getPhysicalConnection());
                if (null != conn) {
                    return FailoverablePooledConnectionHelper.getLastNetworkAccessTime(conn);
                }
            }
            catch (Exception e2) {
                if (!bl) break block3;
                ClioSupport.ilogThrowing($$$loggerRef$$$2, OracleUniversalPooledConnection.class, $$$methodRef$$$2, this, e2);
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public boolean setShardingKeyIfValid(OracleShardingKey oracleShardingKey, OracleShardingKey oracleShardingKey2, int n2) {
        boolean bl = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
        Connection conn = (Connection)this.getPhysicalConnection();
        if (!(conn instanceof OracleConnection)) {
            return true;
        }
        boolean isValid = false;
        OracleConnection oconn = (OracleConnection)conn;
        try {
            void timeout;
            void superKey;
            void key;
            isValid = oconn.setShardingKeyIfValid((OracleShardingKey)key, (OracleShardingKey)superKey, (int)timeout);
        }
        catch (SQLException e2) {
            isValid = false;
            if (e2.getCause() instanceof IOException || e2.getCause() instanceof TimeoutException || e2.getCause() instanceof InterruptedException) {
                this.setStatus(UniversalPooledConnectionStatus.STATUS_BAD, "connection is bad");
            }
        }
        finally {
            if (isValid) {
                this.setLastConnectionValidationTime(Clock.clock());
                if (bl) {
                    ClioSupport.ilogFinest($$$loggerRef$$$3, OracleUniversalPooledConnection.class, $$$methodRef$$$3, this, "connection is good");
                }
            } else {
                this.setStatus(UniversalPooledConnectionStatus.STATUS_BAD, "connection is bad");
                this.setLastConnectionValidationTime(0L);
            }
        }
        return isValid;
    }

    @Override
    protected void initFailoverParameters() throws UniversalConnectionPoolException {
        Connection oracleConn = null;
        try {
            oracleConn = this.getSQLConnection(this.getPhysicalConnection());
        }
        catch (Exception e2) {
            UCPErrorHandler.throwUniversalConnectionPoolException(301, e2);
        }
        Properties prop = FailoverablePooledConnectionHelper.getSessionInfoOnOracleConnection(oracleConn);
        String val = prop.getProperty("INSTANCE_NAME");
        if (val != null) {
            this.setDataSourceInstanceName(val.trim().toLowerCase());
        }
        if ((val = prop.getProperty("SERVER_HOST")) != null) {
            this.setHostName(val.trim().toLowerCase());
        }
        if ((val = prop.getProperty("SERVICE_NAME")) != null) {
            this.setServiceName(val.trim().toLowerCase());
        }
        if ((val = prop.getProperty("DATABASE_NAME")) != null) {
            this.setDbUniqueName(val.trim().toLowerCase());
        }
        if ((val = prop.getProperty("AUTH_SC_INSTANCE_START_TIME")) != null) {
            this.setInstanceStartTime(FailoverablePooledConnectionHelper.getInstanceStartTime(val));
        }
    }

    @Override
    public int getInstanceNumber() {
        boolean bl;
        boolean bl2 = bl = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
        if (this.m_instanceId >= 0) {
            return this.m_instanceId;
        }
        try {
            Connection oconn = this.getSQLConnection(this.getPhysicalConnection());
            if (oconn != null) {
                this.m_instanceId = FailoverablePooledConnectionHelper.getInstanceNumber(oconn);
                return this.m_instanceId;
            }
        }
        catch (Exception exc) {
            if (bl) {
                ClioSupport.ilogThrowing($$$loggerRef$$$5, OracleUniversalPooledConnection.class, $$$methodRef$$$5, this, exc);
            }
            Object oconn = null;
        }
        return -1;
    }

    void updateInstanceNumber() {
        boolean bl = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            Connection oconn = this.getSQLConnection(this.getPhysicalConnection());
            if (oconn != null) {
                this.m_instanceId = FailoverablePooledConnectionHelper.getInstanceNumber(oconn);
            }
        }
        catch (Exception exc) {
            if (bl) {
                ClioSupport.ilogThrowing($$$loggerRef$$$6, OracleUniversalPooledConnection.class, $$$methodRef$$$6, this, exc);
            }
            this.m_instanceId = -1;
            Object oconn = null;
        }
    }

    @Override
    public String getDataSourceInstanceName() {
        return this.m_dataSourceInstanceName;
    }

    @Override
    public synchronized void setDataSourceInstanceName(String dataSourceInstanceName) {
        this.m_dataSourceInstanceName = dataSourceInstanceName;
    }

    @Override
    public String getDbUniqueName() {
        return this.m_dbUniqueName;
    }

    @Override
    public void setDbUniqueName(String dbUniqueName) {
        this.m_dbUniqueName = dbUniqueName;
    }

    @Override
    public String getHostName() {
        return this.m_hostName;
    }

    @Override
    public void setHostName(String hostName) {
        this.m_hostName = hostName;
    }

    @Override
    public String getServiceName() {
        return this.m_serviceName;
    }

    @Override
    public void setServiceName(String serviceName) {
        this.m_serviceName = serviceName;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void setMaxStatements(int n2) throws SQLException {
        void maxStatements;
        boolean bl = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
        Connection oconn = null;
        try {
            oconn = this.getSQLConnection(this.getPhysicalConnection());
        }
        catch (Exception exc) {
            if (bl) {
                ClioSupport.ilogThrowing($$$loggerRef$$$15, OracleUniversalPooledConnection.class, $$$methodRef$$$15, this, exc);
            }
            oconn = null;
        }
        if (this.getMaxStatements() != maxStatements) {
            if (maxStatements > 0) {
                FailoverablePooledConnectionHelper.enableStatementPooling(oconn, (int)maxStatements);
            } else {
                FailoverablePooledConnectionHelper.disableStatementPooling(oconn);
            }
        }
        super.setMaxStatements((int)maxStatements);
    }

    @Override
    public void abort() {
        block5: {
            boolean bl = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
            try {
                Connection oconn = this.getSQLConnection(this.getPhysicalConnection());
                if (oconn == null) {
                    return;
                }
                if (bl) {
                    ClioSupport.ilogFinest($$$loggerRef$$$16, OracleUniversalPooledConnection.class, $$$methodRef$$$16, this, "aborting connection: " + oconn);
                }
                if (!UniversalPooledConnectionStatus.STATUS_RECONNECTING.equals(this.getStatus())) {
                    this.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                }
                FailoverablePooledConnectionHelper.abortOracleConnection(oconn);
            }
            catch (Exception e2) {
                if (!bl) break block5;
                ClioSupport.ilogThrowing($$$loggerRef$$$16, OracleUniversalPooledConnection.class, $$$methodRef$$$16, this, e2);
            }
        }
    }

    @Override
    public void handleTimeout() {
        block9: {
            boolean bl = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
            TaskHandle<Connection> tconn = null;
            TaskHandle<Boolean> tcancel = null;
            TaskHandle<Boolean> trollback = null;
            try {
                tconn = UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Connection>(){
                    private static Executable $$$methodRef$$$0;
                    private static Logger $$$loggerRef$$$0;
                    private static Executable $$$methodRef$$$1;
                    private static Logger $$$loggerRef$$$1;
                    private static Executable $$$methodRef$$$2;
                    private static Logger $$$loggerRef$$$2;

                    @Override
                    public Connection call() throws Exception {
                        return OracleUniversalPooledConnection.this.getSQLConnection(OracleUniversalPooledConnection.this.getPhysicalConnection());
                    }

                    static {
                        try {
                            $$$methodRef$$$2 = 1.class.getDeclaredConstructor(OracleUniversalPooledConnection.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        try {
                            $$$methodRef$$$1 = 1.class.getDeclaredMethod("call", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        try {
                            $$$methodRef$$$0 = 1.class.getDeclaredMethod("call", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    }
                });
                final Connection oconn = tconn.get(15000L);
                tconn = null;
                tcancel = UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Boolean>(){
                    private static Executable $$$methodRef$$$0;
                    private static Logger $$$loggerRef$$$0;
                    private static Executable $$$methodRef$$$1;
                    private static Logger $$$loggerRef$$$1;
                    private static Executable $$$methodRef$$$2;
                    private static Logger $$$loggerRef$$$2;

                    @Override
                    public Boolean call() throws Exception {
                        FailoverablePooledConnectionHelper.cancelOnOracleConnection(oconn);
                        return true;
                    }

                    static {
                        try {
                            $$$methodRef$$$2 = 2.class.getDeclaredConstructor(OracleUniversalPooledConnection.class, Connection.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        try {
                            $$$methodRef$$$1 = 2.class.getDeclaredMethod("call", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        try {
                            $$$methodRef$$$0 = 2.class.getDeclaredMethod("call", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    }
                });
                tcancel.get(15000L);
                tcancel = null;
                if (bl) {
                    ClioSupport.ilogFinest($$$loggerRef$$$17, OracleUniversalPooledConnection.class, $$$methodRef$$$17, this, "conn cancelled successfully");
                }
                if (!oconn.getAutoCommit() && this.getStatus() == UniversalPooledConnectionStatus.STATUS_NORMAL) {
                    trollback = UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Boolean>(){
                        private static Executable $$$methodRef$$$0;
                        private static Logger $$$loggerRef$$$0;
                        private static Executable $$$methodRef$$$1;
                        private static Logger $$$loggerRef$$$1;
                        private static Executable $$$methodRef$$$2;
                        private static Logger $$$loggerRef$$$2;

                        @Override
                        public Boolean call() throws Exception {
                            oconn.rollback();
                            return true;
                        }

                        static {
                            try {
                                $$$methodRef$$$2 = 3.class.getDeclaredConstructor(OracleUniversalPooledConnection.class, Connection.class);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                            try {
                                $$$methodRef$$$1 = 3.class.getDeclaredMethod("call", new Class[0]);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                            try {
                                $$$methodRef$$$0 = 3.class.getDeclaredMethod("call", new Class[0]);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        }
                    });
                    trollback.get(15000L);
                    trollback = null;
                }
            }
            catch (TaskManagerException e2) {
                if (bl) {
                    ClioSupport.ilogWarning($$$loggerRef$$$17, OracleUniversalPooledConnection.class, $$$methodRef$$$17, this, "connection cancellation is timed out");
                }
                if (null != tconn) {
                    tconn.getTask().release();
                }
                if (null != tcancel) {
                    tcancel.getTask().release();
                }
                if (null != trollback) {
                    trollback.getTask().release();
                }
            }
            catch (Exception exc) {
                if (!bl) break block9;
                ClioSupport.ilogThrowing($$$loggerRef$$$17, OracleUniversalPooledConnection.class, $$$methodRef$$$17, this, exc);
            }
        }
    }

    @Override
    public void setAvailable() {
        block5: {
            boolean bl = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
            super.setAvailable();
            try {
                if (((OracleJDBCConnectionPool)this.m_cp).isDRCPEnabled(this) && this.initialDrcpState == OracleConnection.DRCPState.DETACHED) {
                    this.detachServerConnection(null);
                }
            }
            catch (SQLException e2) {
                if (bl) {
                    ClioSupport.ilogThrowing($$$loggerRef$$$18, OracleUniversalPooledConnection.class, $$$methodRef$$$18, this, e2);
                }
            }
            catch (UniversalConnectionPoolException e3) {
                if (!bl) break block5;
                ClioSupport.ilogThrowing($$$loggerRef$$$18, OracleUniversalPooledConnection.class, $$$methodRef$$$18, this, e3);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean attachServerConnection(ConnectionRetrievalInfo connectionRetrievalInfo) throws SQLException {
        void cri;
        Connection oconn;
        block3: {
            boolean bl = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
            oconn = null;
            try {
                oconn = this.getSQLConnection(this.getPhysicalConnection());
            }
            catch (Exception exc) {
                if (!bl) break block3;
                ClioSupport.ilogThrowing($$$loggerRef$$$19, OracleUniversalPooledConnection.class, $$$methodRef$$$19, this, exc);
            }
        }
        boolean value = FailoverablePooledConnectionHelper.attachServerConnection(oconn);
        if (cri != null) {
            int cost = super.labelingCost(cri.getLabels());
            this.isDRCPTagMatched = value && cost == 0;
        }
        return this.isDRCPTagMatched;
    }

    public void detachServerConnection(String string) throws SQLException {
        String tag;
        Connection oconn;
        block7: {
            boolean bl;
            block6: {
                bl = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
                oconn = null;
                try {
                    oconn = this.getSQLConnection(this.getPhysicalConnection());
                }
                catch (Exception exc) {
                    if (!bl) break block6;
                    ClioSupport.ilogThrowing($$$loggerRef$$$20, OracleUniversalPooledConnection.class, $$$methodRef$$$20, this, exc);
                }
            }
            ConnectionRetrievalInfo cri = this.getConnectionRetrievalInfo();
            if (cri != null && cri.getLabels() != null) {
                try {
                    tag = ((OracleJDBCConnectionPool)this.m_cp).isDRCPMultiTagEnabled(this) ? this.getDRCPTag(cri.getLabels()) : cri.getLabels().toString();
                }
                catch (UniversalConnectionPoolException e2) {
                    if (!bl) break block7;
                    ClioSupport.ilogThrowing($$$loggerRef$$$20, OracleUniversalPooledConnection.class, $$$methodRef$$$20, this, e2);
                }
            }
        }
        if (this.isDRCPEnabled() && this.isMultitenantDatabase()) {
            tag = tag == null ? "serviceName=" + this.getDelegator().serviceName() : tag + ";serviceName=" + this.getDelegator().serviceName();
        }
        FailoverablePooledConnectionHelper.detachServerConnection(oconn, tag);
    }

    protected String getDRCPTag(Properties labelProperties) throws SQLException {
        Iterator<Map.Entry<Object, Object>> labelEntries = labelProperties.entrySet().iterator();
        StringBuilder drcpTagBuilder = new StringBuilder();
        while (labelEntries.hasNext()) {
            Map.Entry<Object, Object> labelEntry = labelEntries.next();
            String key = (String)labelEntry.getKey();
            String value = (String)labelEntry.getValue();
            if (value == null || value.trim().length() == 0) {
                value = DEFAULT_DRCP_VALUE;
            }
            this.validateDRCPKeyAndValue(key, value);
            drcpTagBuilder.append(key);
            drcpTagBuilder.append('=');
            drcpTagBuilder.append(value);
            if (!labelEntries.hasNext()) continue;
            drcpTagBuilder.append(';');
        }
        return drcpTagBuilder.toString();
    }

    protected void validateDRCPKeyAndValue(String key, String value) throws SQLException {
        if (key.indexOf(61) != -1 || key.indexOf(59) != -1) {
            throw UCPErrorHandler.newSQLException(70, key);
        }
        if (value.indexOf(61) != -1 || value.indexOf(59) != -1) {
            throw UCPErrorHandler.newSQLException(71, value);
        }
    }

    public boolean isDRCPEnabled() throws SQLException {
        Connection oconn;
        block2: {
            boolean bl = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
            oconn = null;
            try {
                oconn = this.getSQLConnection(this.getPhysicalConnection());
            }
            catch (Exception exc) {
                if (!bl) break block2;
                ClioSupport.ilogThrowing($$$loggerRef$$$23, OracleUniversalPooledConnection.class, $$$methodRef$$$23, this, exc);
            }
        }
        return FailoverablePooledConnectionHelper.isDRCPEnabled(oconn);
    }

    public boolean isDRCPMultitagEnabled() throws SQLException {
        Connection oconn = null;
        oconn = this.getSQLConnection(this.getPhysicalConnection());
        return FailoverablePooledConnectionHelper.isDRCPMultitagEnabled(oconn);
    }

    public String getDRCPReturnTag() throws UniversalConnectionPoolException {
        boolean bl = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
        Connection oconn = null;
        try {
            oconn = this.getSQLConnection(this.getPhysicalConnection());
            return FailoverablePooledConnectionHelper.getDRCPReturnTag(oconn);
        }
        catch (Exception exc) {
            if (bl) {
                ClioSupport.ilogThrowing($$$loggerRef$$$25, OracleUniversalPooledConnection.class, $$$methodRef$$$25, this, exc);
            }
            throw new UniversalConnectionPoolException(exc);
        }
    }

    public String getDRCPPLSQLCallbackName() throws UniversalConnectionPoolException {
        boolean bl = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
        Connection oconn = null;
        try {
            oconn = this.getSQLConnection(this.getPhysicalConnection());
            return FailoverablePooledConnectionHelper.getDRCPPLSQLCallbackName(oconn);
        }
        catch (Exception exc) {
            if (bl) {
                ClioSupport.ilogThrowing($$$loggerRef$$$26, OracleUniversalPooledConnection.class, $$$methodRef$$$26, this, exc);
            }
            throw new UniversalConnectionPoolException(exc);
        }
    }

    @Override
    public Properties getUnmatchedConnectionLabels(Properties requestedLabels) throws UniversalConnectionPoolException {
        if (this.getConnectionLabels() != null && ((OracleJDBCConnectionPool)this.m_cp).isDRCPEnabled(this)) {
            if (((OracleJDBCConnectionPool)this.m_cp).isDRCPMultiTagEnabled(this)) {
                return this.findUnmatchedTags(requestedLabels);
            }
            return this.isDRCPTagMatched ? null : requestedLabels;
        }
        return super.getUnmatchedConnectionLabels(requestedLabels);
    }

    protected Properties findUnmatchedTags(Properties requestedLabels) throws UniversalConnectionPoolException {
        String drcpReturnTag;
        Properties unmatchedTags = new Properties();
        if (requestedLabels != null) {
            unmatchedTags.putAll((Map<?, ?>)requestedLabels);
        }
        if ((drcpReturnTag = this.getDRCPReturnTag()) != null && drcpReturnTag.trim().length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(drcpReturnTag, ";");
            while (tokenizer.hasMoreTokens()) {
                String currentToken = tokenizer.nextToken();
                int eqIndex = currentToken.indexOf(61);
                if (eqIndex == -1) continue;
                unmatchedTags.remove(currentToken.substring(0, eqIndex));
            }
        }
        if (unmatchedTags.isEmpty()) {
            return null;
        }
        return unmatchedTags;
    }

    @Override
    public int getDatabaseVersion() throws UniversalConnectionPoolException {
        boolean bl = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
        int dbVersion = 0;
        try {
            Connection oconn = this.getSQLConnection(this.getPhysicalConnection());
            return FailoverablePooledConnectionHelper.getDatabaseVersion(oconn);
        }
        catch (Exception exc) {
            dbVersion = 0;
            if (bl) {
                ClioSupport.ilogThrowing($$$loggerRef$$$29, OracleUniversalPooledConnection.class, $$$methodRef$$$29, this, exc);
            }
            return dbVersion;
        }
    }

    @Override
    public boolean isNamedInstanceConnection() {
        return this.m_isNamedInstanceConn;
    }

    @Override
    public void setAsNamedInstanceConnection() {
        this.m_isNamedInstanceConn = true;
    }

    @Override
    public String getInstance() {
        return this.getDataSourceInstanceName();
    }

    @Override
    public String getService() {
        return this.getServiceName();
    }

    @Override
    public String getHost() {
        return this.getHostName();
    }

    @Override
    public String getDatabase() {
        return this.getDbUniqueName();
    }

    @Override
    public void close(boolean isConnectionBorrowed) throws UniversalConnectionPoolException {
        throw new IllegalStateException("obsolete");
    }

    @Override
    public Date getInstanceStartTime() {
        return this.m_instanceStartTime;
    }

    @Override
    public Properties getConnectionInfo() throws UniversalConnectionPoolException {
        Properties connInfo;
        block2: {
            boolean bl = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
            connInfo = null;
            try {
                Connection oconn = this.getSQLConnection(this.getPhysicalConnection());
                connInfo = FailoverablePooledConnectionHelper.getSessionInfoOnOracleConnection(oconn);
            }
            catch (Exception exc) {
                connInfo = null;
                if (!bl) break block2;
                ClioSupport.ilogThrowing($$$loggerRef$$$38, OracleUniversalPooledConnection.class, $$$methodRef$$$38, this, exc);
            }
        }
        return connInfo;
    }

    void setInstanceStartTime(Date time) {
        this.m_instanceStartTime = time;
    }

    public RLBInfo.Frame getRlbBorrowStats() {
        return this.rlbBorrowStats.get();
    }

    public void setRlbBorrowStats(RLBInfo.Frame rlbStats) {
        this.rlbBorrowStats.set(rlbStats);
    }

    public boolean isMultitenantDatabase() {
        block3: {
            boolean bl = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
            try {
                Properties connProps = this.getConnectionInfo();
                if (connProps != null && connProps.containsKey("AUTH_PDB_UID")) {
                    return true;
                }
            }
            catch (UniversalConnectionPoolException e2) {
                if (!bl) break block3;
                ClioSupport.ilogThrowing($$$loggerRef$$$42, OracleUniversalPooledConnection.class, $$$methodRef$$$42, this, e2);
            }
        }
        return false;
    }

    public boolean isShardedDatabase() {
        boolean isShardedDb;
        block58: {
            Throwable throwable;
            ResultSet rs2;
            Throwable throwable2;
            Statement stmt;
            boolean bl;
            boolean bl2 = bl = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
            if (!shardRoutingEnabled) {
                return false;
            }
            isShardedDb = false;
            try {
                stmt = this.getSQLConnection(this.getPhysicalConnection()).createStatement();
                throwable2 = null;
                try {
                    rs2 = stmt.executeQuery("select * from LOCAL_CHUNK_TYPES");
                    throwable = null;
                    try {
                        if (rs2.next()) {
                            isShardedDb = true;
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (rs2 != null) {
                            if (throwable != null) {
                                try {
                                    rs2.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                rs2.close();
                            }
                        }
                    }
                }
                catch (Throwable rs2) {
                    throwable2 = rs2;
                    throw rs2;
                }
                finally {
                    if (stmt != null) {
                        if (throwable2 != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable rs2) {
                                throwable2.addSuppressed(rs2);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
            catch (SQLException e2) {
                if (bl) {
                    ClioSupport.ilogThrowing($$$loggerRef$$$43, OracleUniversalPooledConnection.class, $$$methodRef$$$43, this, e2);
                }
                isShardedDb = false;
            }
            if (isShardedDb) {
                try {
                    stmt = this.getSQLConnection(this.getPhysicalConnection()).createStatement();
                    throwable2 = null;
                    try {
                        rs2 = stmt.executeQuery("select * from gsmadmin_internal.cloud");
                        throwable = null;
                        try {
                            if (rs2.next()) {
                                isShardedDb = false;
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (rs2 != null) {
                                if (throwable != null) {
                                    try {
                                        rs2.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    rs2.close();
                                }
                            }
                        }
                    }
                    catch (Throwable throwable7) {
                        throwable2 = throwable7;
                        throw throwable7;
                    }
                    finally {
                        if (stmt != null) {
                            if (throwable2 != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable8) {
                                    throwable2.addSuppressed(throwable8);
                                }
                            } else {
                                stmt.close();
                            }
                        }
                    }
                }
                catch (SQLException e3) {
                    if (!bl) break block58;
                    ClioSupport.ilogThrowing($$$loggerRef$$$43, OracleUniversalPooledConnection.class, $$$methodRef$$$43, this, e3);
                }
            }
        }
        return isShardedDb;
    }

    public void setPdbSessionInitialized(boolean initialized) {
        this.isPdbSessionInitialized = initialized;
    }

    public void initPdbSession(ConnectionRetrievalInfo cri) throws SQLException {
        if (this.isPdbSessionInitialized) {
            return;
        }
        JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
        Properties roles = jdbcCri.getPdbRoles();
        if (roles == null || roles.isEmpty()) {
            return;
        }
        try (Statement stmt = this.getSQLConnection(this.getPhysicalConnection()).createStatement();){
            for (Map.Entry<Object, Object> roleProperty : jdbcCri.getPdbRoles().entrySet()) {
                String roleName = (String)roleProperty.getKey();
                String rolePassword = (String)roleProperty.getValue();
                if (rolePassword == null) {
                    rolePassword = "";
                }
                stmt.execute("set role " + roleName + (rolePassword.equals("") ? "" : " identified by " + rolePassword));
                this.isPdbSessionInitialized = true;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int labelingCost(Properties properties) {
        block4: {
            boolean bl = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
            try {
                void labels;
                if (((OracleJDBCConnectionPool)this.m_cp).isDRCPMultiTagEnabled(this)) {
                    Properties connLabels = this.getConnectionLabels();
                    if (connLabels != null && labels != null && connLabels.equals(labels) || connLabels == null && labels == null) {
                        return 0;
                    }
                    break block4;
                }
                return super.labelingCost((Properties)labels);
            }
            catch (UniversalConnectionPoolException e2) {
                if (!bl) break block4;
                ClioSupport.ilogThrowing($$$loggerRef$$$46, OracleUniversalPooledConnection.class, $$$methodRef$$$46, this, e2);
            }
        }
        return Integer.MAX_VALUE;
    }

    static {
        try {
            $$$methodRef$$$47 = OracleUniversalPooledConnection.class.getDeclaredConstructor(JDBCConnectionPool.class, Object.class, ConnectionRetrievalInfo.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$46 = OracleUniversalPooledConnection.class.getDeclaredMethod("labelingCost", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$45 = OracleUniversalPooledConnection.class.getDeclaredMethod("initPdbSession", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$44 = OracleUniversalPooledConnection.class.getDeclaredMethod("setPdbSessionInitialized", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$43 = OracleUniversalPooledConnection.class.getDeclaredMethod("isShardedDatabase", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$42 = OracleUniversalPooledConnection.class.getDeclaredMethod("isMultitenantDatabase", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$41 = OracleUniversalPooledConnection.class.getDeclaredMethod("setRlbBorrowStats", RLBInfo.Frame.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$40 = OracleUniversalPooledConnection.class.getDeclaredMethod("getRlbBorrowStats", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$39 = OracleUniversalPooledConnection.class.getDeclaredMethod("setInstanceStartTime", Date.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$38 = OracleUniversalPooledConnection.class.getDeclaredMethod("getConnectionInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$37 = OracleUniversalPooledConnection.class.getDeclaredMethod("getInstanceStartTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$36 = OracleUniversalPooledConnection.class.getDeclaredMethod("close", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$35 = OracleUniversalPooledConnection.class.getDeclaredMethod("getDatabase", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$34 = OracleUniversalPooledConnection.class.getDeclaredMethod("getHost", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$33 = OracleUniversalPooledConnection.class.getDeclaredMethod("getService", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$32 = OracleUniversalPooledConnection.class.getDeclaredMethod("getInstance", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$31 = OracleUniversalPooledConnection.class.getDeclaredMethod("setAsNamedInstanceConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$30 = OracleUniversalPooledConnection.class.getDeclaredMethod("isNamedInstanceConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$29 = OracleUniversalPooledConnection.class.getDeclaredMethod("getDatabaseVersion", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$28 = OracleUniversalPooledConnection.class.getDeclaredMethod("findUnmatchedTags", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$27 = OracleUniversalPooledConnection.class.getDeclaredMethod("getUnmatchedConnectionLabels", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$26 = OracleUniversalPooledConnection.class.getDeclaredMethod("getDRCPPLSQLCallbackName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$25 = OracleUniversalPooledConnection.class.getDeclaredMethod("getDRCPReturnTag", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$24 = OracleUniversalPooledConnection.class.getDeclaredMethod("isDRCPMultitagEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$23 = OracleUniversalPooledConnection.class.getDeclaredMethod("isDRCPEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$22 = OracleUniversalPooledConnection.class.getDeclaredMethod("validateDRCPKeyAndValue", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$21 = OracleUniversalPooledConnection.class.getDeclaredMethod("getDRCPTag", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$20 = OracleUniversalPooledConnection.class.getDeclaredMethod("detachServerConnection", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$19 = OracleUniversalPooledConnection.class.getDeclaredMethod("attachServerConnection", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$18 = OracleUniversalPooledConnection.class.getDeclaredMethod("setAvailable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$17 = OracleUniversalPooledConnection.class.getDeclaredMethod("handleTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$16 = OracleUniversalPooledConnection.class.getDeclaredMethod("abort", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$15 = OracleUniversalPooledConnection.class.getDeclaredMethod("setMaxStatements", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$14 = OracleUniversalPooledConnection.class.getDeclaredMethod("setServiceName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$13 = OracleUniversalPooledConnection.class.getDeclaredMethod("getServiceName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$12 = OracleUniversalPooledConnection.class.getDeclaredMethod("setHostName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$11 = OracleUniversalPooledConnection.class.getDeclaredMethod("getHostName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$10 = OracleUniversalPooledConnection.class.getDeclaredMethod("setDbUniqueName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$9 = OracleUniversalPooledConnection.class.getDeclaredMethod("getDbUniqueName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$8 = OracleUniversalPooledConnection.class.getDeclaredMethod("setDataSourceInstanceName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$7 = OracleUniversalPooledConnection.class.getDeclaredMethod("getDataSourceInstanceName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$6 = OracleUniversalPooledConnection.class.getDeclaredMethod("updateInstanceNumber", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$5 = OracleUniversalPooledConnection.class.getDeclaredMethod("getInstanceNumber", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$4 = OracleUniversalPooledConnection.class.getDeclaredMethod("initFailoverParameters", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$3 = OracleUniversalPooledConnection.class.getDeclaredMethod("setShardingKeyIfValid", OracleShardingKey.class, OracleShardingKey.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$2 = OracleUniversalPooledConnection.class.getDeclaredMethod("getLastNetworkAccessTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$1 = OracleUniversalPooledConnection.class.getDeclaredMethod("isValid", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        try {
            $$$methodRef$$$0 = OracleUniversalPooledConnection.class.getDeclaredMethod("validate", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.proxy");
        shardRoutingEnabled = Boolean.valueOf(Util.getShardRoutingEnabled());
    }
}

