/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.io.Serializable;
import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.Referenceable;
import javax.naming.spi.ObjectFactory;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.ucp.NoAvailableConnectionsException;
import oracle.ucp.UniversalConnectionPoolAdapter;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.JDBCUniversalPooledConnection;
import oracle.ucp.jdbc.PoolDataSourceImpl;
import oracle.ucp.jdbc.PoolXADataSource;
import oracle.ucp.jdbc.UCPXAConnectionBuilder;
import oracle.ucp.jdbc.UCPXAConnectionBuilderImpl;
import oracle.ucp.jdbc.XAConnectionConnectionPool;
import oracle.ucp.jdbc.XADataSourceConnectionFactoryAdapter;
import oracle.ucp.jdbc.oracle.OracleXAConnectionConnectionPool;
import oracle.ucp.jdbc.oracle.OracleXADataSourceConnectionFactoryAdapter;
import oracle.ucp.jdbc.proxy.XAConnectionProxyFactory;
import oracle.ucp.util.UCPErrorHandler;

@DefaultLogger(value="oracle.ucp.jdbc")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT, Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public class PoolXADataSourceImpl
extends PoolDataSourceImpl
implements PoolXADataSource,
Serializable,
Referenceable,
ObjectFactory,
UniversalConnectionPoolAdapter {
    private XADataSource m_xaDataSource = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;

    public PoolXADataSourceImpl() {
    }

    PoolXADataSourceImpl(String poolName, String dsName, Map<String, Object> config) throws UniversalConnectionPoolException, Exception {
        super(poolName, dsName, config);
    }

    @Override
    protected void createPoolWithDefaultProperties() throws SQLException {
        boolean bl = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
        String className = this.getClass().getName();
        int errCode = 27;
        try {
            this.m_xaDataSource = (XADataSource)this.m_connectionFactory;
            if (bl) {
                this.ilogFinest($$$loggerRef$$$0, PoolXADataSourceImpl.class, $$$methodRef$$$0, this, "XADataSource is set");
            }
            errCode = 1;
            if (this.m_connectionFactoryClassName != null && this.m_connectionFactoryClassName.startsWith("oracle.jdbc")) {
                OracleXADataSourceConnectionFactoryAdapter ocfa = new OracleXADataSourceConnectionFactoryAdapter(this.m_xaDataSource);
                this.m_cp = new OracleXAConnectionConnectionPool(ocfa);
                ocfa.setUniversalConnectionPool(this.m_cp);
            } else {
                XADataSourceConnectionFactoryAdapter cfa = new XADataSourceConnectionFactoryAdapter(this.m_xaDataSource);
                this.m_cp = new XAConnectionConnectionPool(cfa);
                cfa.setUniversalConnectionPool(this.m_cp);
            }
            assert (this.m_cp != null);
            this.m_cp.setConnectionFactory(this.m_connectionFactory);
            if (bl) {
                this.ilogFine($$$loggerRef$$$0, PoolXADataSourceImpl.class, $$$methodRef$$$0, this, "connection pool is created");
            }
        }
        catch (Exception e2) {
            UCPErrorHandler.throwSQLException(errCode, e2);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        boolean bl;
        boolean bl2 = bl = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
        if (bl) {
            this.ilogFinest($$$loggerRef$$$1, PoolXADataSourceImpl.class, $$$methodRef$$$1, this, "PoolXADataSourceImpl.getConnection() is disabled");
        }
        UCPErrorHandler.throwSQLException(58, null);
        return null;
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        boolean bl;
        boolean bl2 = bl = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
        if (bl) {
            this.ilogFinest($$$loggerRef$$$2, PoolXADataSourceImpl.class, $$$methodRef$$$2, this, "PoolXADataSourceImpl.getConnection() is disabled");
        }
        UCPErrorHandler.throwSQLException(58, null);
        return null;
    }

    @Override
    public Connection getConnection(Properties properties) throws SQLException {
        boolean bl;
        boolean bl2 = bl = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
        if (bl) {
            this.ilogFinest($$$loggerRef$$$3, PoolXADataSourceImpl.class, $$$methodRef$$$3, this, "PoolXADataSourceImpl.getConnection() is disabled");
        }
        UCPErrorHandler.throwSQLException(58, null);
        return null;
    }

    @Override
    public Connection getConnection(String string, String string2, Properties properties) throws SQLException {
        boolean bl;
        boolean bl2 = bl = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
        if (bl) {
            this.ilogFinest($$$loggerRef$$$4, PoolXADataSourceImpl.class, $$$methodRef$$$4, this, "PoolXADataSourceImpl.getConnection() is disabled");
        }
        UCPErrorHandler.throwSQLException(58, null);
        return null;
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        return this.getXAConnection(this.getUser(), this.getPassword(), null);
    }

    @Override
    public XAConnection getXAConnection(String user, String password) throws SQLException {
        return this.getXAConnection(user, password, null);
    }

    @Override
    public XAConnection getXAConnection(Properties labels) throws SQLException {
        return this.getXAConnection(this.getUser(), this.getPassword(), labels);
    }

    @Override
    public XAConnection getXAConnection(String username, String password, Properties labels) throws SQLException {
        return this.createXAConnectionBuilder().user(username).password(password).labels(labels).build();
    }

    XAConnection getXAConnection(UCPXAConnectionBuilderImpl builder) throws SQLException {
        this.startPool();
        XAConnection xaconn = null;
        try {
            if (builder.serviceName == null) {
                builder.serviceName(this.getServiceName());
            }
            if (builder.user == null) {
                builder.user(this.getUser());
            }
            if (builder.password == null) {
                builder.password(this.getPassword());
            }
            if (builder.pdbRoles == null) {
                builder.pdbRoles(this.getPdbRoles());
            }
            JDBCConnectionRetrievalInfo cri = new JDBCConnectionRetrievalInfo(builder);
            JDBCUniversalPooledConnection jdbcPooledConnection = (JDBCUniversalPooledConnection)this.m_cp.borrowConnection(cri);
            jdbcPooledConnection.setMaxStatements(this.m_cp.getMaxStatements());
            xaconn = (XAConnection)XAConnectionProxyFactory.createConnectionProxy(this.m_cp, jdbcPooledConnection);
        }
        catch (NoAvailableConnectionsException e2) {
            UCPErrorHandler.throwSQLException(28, e2);
        }
        catch (UniversalConnectionPoolException e3) {
            UCPErrorHandler.throwSQLException(29, e3);
        }
        return xaconn;
    }

    @Override
    public UCPXAConnectionBuilder createXAConnectionBuilder() {
        return new UCPXAConnectionBuilderImpl(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public XAConnection build() throws SQLException {
                return PoolXADataSourceImpl.this.getXAConnection(this);
            }

            static {
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredConstructor(PoolXADataSourceImpl.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("build", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    static {
        try {
            $$$methodRef$$$12 = PoolXADataSourceImpl.class.getDeclaredConstructor(String.class, String.class, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$11 = PoolXADataSourceImpl.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$10 = PoolXADataSourceImpl.class.getDeclaredMethod("createXAConnectionBuilder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$9 = PoolXADataSourceImpl.class.getDeclaredMethod("getXAConnection", UCPXAConnectionBuilderImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$8 = PoolXADataSourceImpl.class.getDeclaredMethod("getXAConnection", String.class, String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$7 = PoolXADataSourceImpl.class.getDeclaredMethod("getXAConnection", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$6 = PoolXADataSourceImpl.class.getDeclaredMethod("getXAConnection", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$5 = PoolXADataSourceImpl.class.getDeclaredMethod("getXAConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$4 = PoolXADataSourceImpl.class.getDeclaredMethod("getConnection", String.class, String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$3 = PoolXADataSourceImpl.class.getDeclaredMethod("getConnection", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$2 = PoolXADataSourceImpl.class.getDeclaredMethod("getConnection", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$1 = PoolXADataSourceImpl.class.getDeclaredMethod("getConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$0 = PoolXADataSourceImpl.class.getDeclaredMethod("createPoolWithDefaultProperties", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
    }
}

