/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.OracleType;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.pool.OracleShardingKeyBuilderImpl;
import oracle.jdbc.pool.OracleShardingKeyImpl;
import oracle.jdbc.pool.ShardingMetadata;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.common.Chunk;
import oracle.ucp.common.ChunkEventHandler;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.FailoverDriver;
import oracle.ucp.common.HashRangeShardingKeys;
import oracle.ucp.common.ListShardingKeys;
import oracle.ucp.common.ListSuperShardingKeys;
import oracle.ucp.common.ONSDriver;
import oracle.ucp.common.RangeShardingKeys;
import oracle.ucp.common.RangeSuperShardKeys;
import oracle.ucp.common.Selector;
import oracle.ucp.common.Service;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.common.ShardingKeys;
import oracle.ucp.common.SuperShardingKeys;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.Util;

@DefaultLogger(value="oracle.ucp.common")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT, Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public abstract class ShardRoutingCache {
    protected final Map<RoutingKey, Chunk> routingCache = new ConcurrentSkipListMap<RoutingKey, Chunk>();
    private final Map<L2RoutingKey, List<Chunk>> l2RoutingCache = new ConcurrentHashMap<L2RoutingKey, List<Chunk>>();
    protected final ChunkEventHandler chunkEventHandler = this.prepareChunkEventHandler();
    protected final AtomicReference<ShardingMetadata> shardingMetadata = new AtomicReference<Object>(null);
    private static final String SHARD_UNIQUE_ID_CONN_PROPERTY_KEY = "AUTH_GLOBALLY_UNIQUE_DBID";
    private final Map<String, LongAdder> shardConnectionCounter = new ConcurrentHashMap<String, LongAdder>();
    private final Map<String, LongAdder> shardPendingConnectionCounter = new ConcurrentHashMap<String, LongAdder>();
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;

    private boolean hasVersionedChunk(String chunkName) {
        return this.routingCache.entrySet().stream().anyMatch(cacheEntry -> ((Chunk)cacheEntry.getValue()).name().equals(chunkName));
    }

    protected RoutingKey routingKeysForVersionedChunk(String chunkName) {
        Optional<Map.Entry> entry = this.routingCache.entrySet().stream().filter(cacheEntry -> ((Chunk)cacheEntry.getValue()).name().equals(chunkName)).findFirst();
        if (entry.isPresent()) {
            return (RoutingKey)entry.get().getKey();
        }
        return null;
    }

    private boolean hasShardingKey(OracleShardingKey shardingKey, OracleShardingKey superKey) {
        if (this.shardingMetadata.get() == null) {
            return false;
        }
        L2RoutingKey l2Key = new L2RoutingKey(shardingKey, superKey);
        if (this.l2RoutingCache.containsKey(l2Key)) {
            return true;
        }
        OracleShardingKey shardKeyToLookup = this.lookupKey(shardingKey);
        return this.routingCache.entrySet().stream().anyMatch(cacheEntry -> ((RoutingKey)cacheEntry.getKey()).containsShardingKey(shardKeyToLookup, superKey));
    }

    /*
     * WARNING - void declaration
     */
    protected Chunk update(RoutingKey routingKey, String string) {
        void chunkName;
        void routingKey2;
        boolean bl;
        boolean bl2 = bl = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
        if (routingKey2 == null || chunkName == null || chunkName.equals("")) {
            return null;
        }
        Chunk newChunk = new Chunk((String)chunkName);
        Chunk cachedChunk = this.routingCache.get(routingKey2);
        if (cachedChunk != null && !cachedChunk.name().equals(chunkName)) {
            if (bl) {
                ClioSupport.ilogFinest($$$loggerRef$$$3, ShardRoutingCache.class, $$$methodRef$$$3, this, "Replace chunk for key:" + routingKey2 + " with new Chunk:" + (String)chunkName + " , (old chunk:" + cachedChunk.name() + ")");
            }
            this.routingCache.replace((RoutingKey)routingKey2, cachedChunk, newChunk);
            this.l2RoutingCache.clear();
            return cachedChunk;
        }
        if (cachedChunk == null) {
            RoutingKey chunkRoutingKey = this.routingKeysForVersionedChunk((String)chunkName);
            if (this.routingCache.putIfAbsent((RoutingKey)routingKey2, newChunk) == null) {
                this.l2RoutingCache.clear();
                if (chunkRoutingKey != null && !routingKey2.equals(chunkRoutingKey)) {
                    int maxVersion = this.routingCache.values().stream().filter(arg_0 -> ShardRoutingCache.lambda$update$3((String)chunkName, arg_0)).max((o1, o2) -> o1.version() - o2.version()).get().version();
                    this.routingCache.get(chunkRoutingKey).setVersion(maxVersion + 1);
                    if (bl) {
                        ClioSupport.ilogFinest($$$loggerRef$$$3, ShardRoutingCache.class, $$$methodRef$$$3, this, "Chunk keys:" + chunkRoutingKey + " has split,hence updated chunk name to:" + this.routingCache.get(chunkRoutingKey).name());
                    }
                }
            }
        }
        return this.routingCache.get(routingKey2);
    }

    private void cleanup() {
        boolean bl = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
        boolean cleanedUp = this.routingCache.values().removeIf(k2 -> k2.instances().size() <= 0);
        if (cleanedUp) {
            this.l2RoutingCache.clear();
            if (bl) {
                ClioSupport.ilogFinest($$$loggerRef$$$4, ShardRoutingCache.class, $$$methodRef$$$4, this, "Cleaned up shard routing cache!");
            }
        }
    }

    protected boolean isMaxPerShardReached(ServiceMember member) {
        String shardUniqueId = member.dbUniqueId();
        if (shardUniqueId == null || shardUniqueId.equals("")) {
            return false;
        }
        if (!this.shardConnectionCounter.containsKey(shardUniqueId)) {
            return false;
        }
        int maxPerShard = this.service().connectionSource().limits().getMaxPerShard();
        return this.shardConnectionCounter.getOrDefault(shardUniqueId, new LongAdder()).sum() + this.shardPendingConnectionCounter.getOrDefault(shardUniqueId, new LongAdder()).sum() >= (long)maxPerShard;
    }

    boolean isMaxPerShardConfigured() {
        int maxPerShard = this.service().connectionSource().limits().getMaxPerShard();
        return maxPerShard < Integer.MAX_VALUE;
    }

    LongAdder pendingCreateConnectionCounter(ServiceMember instance) {
        String shardUniqueId = instance.dbUniqueId();
        if (shardUniqueId == null || shardUniqueId.equals("")) {
            return new LongAdder();
        }
        return this.shardPendingConnectionCounter.computeIfAbsent(shardUniqueId, v2 -> new LongAdder());
    }

    /*
     * WARNING - void declaration
     */
    protected void onConnectionCreation(CoreConnection coreConnection) throws UniversalConnectionPoolException {
        block12: {
            void connection;
            boolean bl = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
            String shardUniqueId = connection.serviceMember().dbUniqueId();
            if (this.isMaxPerShardReached(connection.serviceMember())) {
                UCPErrorHandler.throwUniversalConnectionPoolException(389);
            }
            this.shardConnectionCounter.computeIfAbsent(shardUniqueId, v2 -> new LongAdder()).increment();
            JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)connection.cri();
            if (bl) {
                ClioSupport.ilogFinest($$$loggerRef$$$8, ShardRoutingCache.class, $$$methodRef$$$8, this, String.format("\n\tCreating connection with OracleShardingKey(%s,%s)\n", jdbcCri.getShardingKey(), jdbcCri.getSuperShardingKey()));
            }
            try {
                Chunk connChunk;
                if (!this.allInstances(jdbcCri).contains(connection.serviceMember())) {
                    this.buildTopologyForInstance((CoreConnection)connection);
                    return;
                }
                if (jdbcCri.getShardingKey() == null) {
                    return;
                }
                String connChunkName = connection.chunkName();
                String topoChunkName = this.matchingChunkName(jdbcCri);
                if (topoChunkName == null) {
                    this.buildTopologyForInstance((CoreConnection)connection);
                    return;
                }
                if (connChunkName == null) {
                    return;
                }
                connChunkName = connChunkName.toLowerCase();
                RoutingKey routingKey = this.routingKeysForVersionedChunk(connChunkName);
                ServiceMember connInstance = connection.serviceMember();
                Chunk.Metadata metadata = null;
                if (routingKey == null) {
                    metadata = connection.chunkMetadata(connChunkName);
                    if (metadata == null) {
                        return;
                    }
                    routingKey = this.makeKey(metadata);
                }
                if ((connChunk = this.update(routingKey, connChunkName)) != null && !connChunk.hasInstance(connInstance)) {
                    if (metadata == null) {
                        metadata = connection.chunkMetadata(connChunkName);
                    }
                    connChunk.addInstanceWithPriority(connInstance, metadata.priority);
                }
            }
            catch (SQLException e2) {
                if (!bl) break block12;
                ClioSupport.ilogThrowing($$$loggerRef$$$8, ShardRoutingCache.class, $$$methodRef$$$8, this, e2);
            }
        }
    }

    void onConnectionClosure(CoreConnection connection) {
        String shardUniqueId = connection.serviceMember().dbUniqueId();
        if (this.shardConnectionCounter.containsKey(shardUniqueId)) {
            this.shardConnectionCounter.get(shardUniqueId).decrement();
        }
    }

    /*
     * WARNING - void declaration
     */
    void buildTopologyForInstance(CoreConnection coreConnection) {
        block4: {
            boolean bl = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
            try {
                void connection;
                if (bl) {
                    ClioSupport.ilogFinest($$$loggerRef$$$10, ShardRoutingCache.class, $$$methodRef$$$10, this, "Building topo for Instance " + connection.serviceMember().name());
                }
                List<Chunk.Metadata> chunkInfoList = connection.instanceChunksMetadata();
                for (Chunk.Metadata chunkInfo : chunkInfoList) {
                    String chunkName = chunkInfo.chunkName;
                    RoutingKey key = this.makeKey(chunkInfo);
                    if (this.update(key, chunkName) == null) continue;
                    this.routingCache.get(key).addInstanceWithPriority(connection.serviceMember(), chunkInfo.priority);
                }
            }
            catch (SQLException e2) {
                if (!bl) break block4;
                ClioSupport.ilogThrowing($$$loggerRef$$$10, ShardRoutingCache.class, $$$methodRef$$$10, this, e2);
            }
        }
    }

    protected abstract Service service();

    protected ShardingMetadata shardingMetadata() {
        return this.shardingMetadata.get();
    }

    protected RoutingKey makeKey(Chunk.Metadata chunkInfo) throws SQLException {
        ShardingKeys shardingKeys;
        SuperShardingKeys superShardingKeys = null;
        if (this.shardingMetadata().getSuperShardingType() != ShardingMetadata.ShardingType.NONE) {
            List<OracleShardingKeyImpl> superKeysHigh = OracleShardingKeyImpl.decodeKeys(chunkInfo.superKeyHigh, this.shardingMetadata(), true, true);
            List<OracleShardingKeyImpl> superKeysLow = OracleShardingKeyImpl.decodeKeys(chunkInfo.superKeyLow, this.shardingMetadata(), true, false);
            if (this.shardingMetadata().getSuperShardingType() == ShardingMetadata.ShardingType.LIST) {
                superShardingKeys = new ListSuperShardingKeys(superKeysHigh);
            } else if (this.shardingMetadata().getSuperShardingType() == ShardingMetadata.ShardingType.RANGE) {
                superShardingKeys = new RangeSuperShardKeys(superKeysHigh.get(0), superKeysLow.get(0));
            }
        } else {
            superShardingKeys = SuperShardingKeys.DEFAULT_SUPER_SHARDING_KEYS;
        }
        List<OracleShardingKeyImpl> shardkeysHigh = OracleShardingKeyImpl.decodeKeys(chunkInfo.shardKeyHigh, this.shardingMetadata(), false, true);
        List<OracleShardingKeyImpl> shardkeysLow = OracleShardingKeyImpl.decodeKeys(chunkInfo.shardKeyLow, this.shardingMetadata(), false, false);
        if (this.shardingMetadata().getShardingType() == ShardingMetadata.ShardingType.LIST) {
            shardingKeys = new ListShardingKeys(shardkeysHigh);
        } else if (this.shardingMetadata().getShardingType() == ShardingMetadata.ShardingType.RANGE) {
            shardingKeys = new RangeShardingKeys(shardkeysHigh.get(0), shardkeysLow.get(0));
        } else if (this.shardingMetadata().getShardingType() == ShardingMetadata.ShardingType.HASH) {
            shardingKeys = new HashRangeShardingKeys(shardkeysHigh.get(0), shardkeysLow.get(0));
        } else {
            throw new IllegalStateException("Shard Type in database not recognized");
        }
        return new RoutingKey(shardingKeys, superShardingKeys);
    }

    /*
     * WARNING - void declaration
     */
    protected void initialize(CoreConnection coreConnection, ONSDriver oNSDriver) throws UniversalConnectionPoolException {
        block3: {
            boolean bl = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
            try {
                void connection;
                void onsDriver;
                if (onsDriver != null) {
                    this.chunkEventHandler.start((ONSDriver)onsDriver);
                }
                this.shardingMetadata.compareAndSet(null, connection.shardingMetadata());
            }
            catch (SQLException e2) {
                if (!bl) break block3;
                ClioSupport.ilogThrowing($$$loggerRef$$$13, ShardRoutingCache.class, $$$methodRef$$$13, this, e2);
            }
        }
    }

    private Chunk matchingChunk(String chunkName, ServiceMember instance) {
        return this.routingCache.values().stream().filter(k2 -> k2.absoluteName().equals(chunkName)).filter(k2 -> instance == null ? true : k2.hasInstance(instance)).findFirst().get();
    }

    boolean hasMatchingChunk(String chunkName, ServiceMember instance) {
        return this.routingCache.values().stream().anyMatch(k2 -> k2.absoluteName().equals(chunkName) && (instance == null || k2.hasInstance(instance)));
    }

    ChunkEventHandler prepareChunkEventHandler() {
        return new ChunkEventHandler(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            /*
             * WARNING - void declaration
             */
            @Override
            void onEvent(ChunkEventHandler.Event event) {
                ServiceMember instanceToLookup;
                void event2;
                boolean bl;
                boolean bl2 = bl = (0L & TraceControllerImpl.feature) != 0L;
                if (!event2.eventType().equalsIgnoreCase("chunk")) {
                    if (bl) {
                        ClioSupport.ilogFinest($$$loggerRef$$$0, 1.class, $$$methodRef$$$0, this, "Not chunk event , ignoring it");
                    }
                    return;
                }
                if (event2.chunkName() == null || event2.chunkName().length() <= 0) {
                    if (bl) {
                        ClioSupport.ilogFinest($$$loggerRef$$$0, 1.class, $$$methodRef$$$0, this, "Not applicable chunk event: Chunk name is empty, ignoring it");
                    }
                    return;
                }
                ServiceMember eventInst = ShardRoutingCache.this.service().getMember(event2.instanceName(), event2.database(), ShardRoutingCache.this.service().name());
                if (eventInst == null) {
                    if (bl) {
                        ClioSupport.ilogFinest($$$loggerRef$$$0, 1.class, $$$methodRef$$$0, this, "Not applicable chunk event: Instance name not known or null, ignoring it");
                    }
                    return;
                }
                ServiceMember serviceMember = instanceToLookup = event2.status() == ChunkEventHandler.Event.Status.UP ? null : eventInst;
                if (!ShardRoutingCache.this.hasMatchingChunk(event2.chunkName(), instanceToLookup)) {
                    if (bl) {
                        ClioSupport.ilogFinest($$$loggerRef$$$0, 1.class, $$$methodRef$$$0, this, "Not applicable chunk event:Chunk not known, ignoring it");
                    }
                    return;
                }
                Chunk chunk = ShardRoutingCache.this.matchingChunk(event2.chunkName(), instanceToLookup);
                if (chunk == null) {
                    return;
                }
                boolean isReadOnlyAllowed = Boolean.valueOf(Util.getReadOnlyInstanceAllowed());
                if ((event2.status() == ChunkEventHandler.Event.Status.DOWN || !isReadOnlyAllowed && event2.status() == ChunkEventHandler.Event.Status.READONLY) && chunk.hasInstance(eventInst)) {
                    if (bl) {
                        ClioSupport.ilogFinest($$$loggerRef$$$0, 1.class, $$$methodRef$$$0, this, "Chunk Event Handler : Removed Instance " + eventInst + " for Chunk :" + chunk.name());
                    }
                    chunk.removeInstance(eventInst);
                }
                if (event2.status() == ChunkEventHandler.Event.Status.UP) {
                    chunk.addInstanceWithPriority(eventInst, event2.priority());
                }
                if (event2.status() == ChunkEventHandler.Event.Status.SPLIT && chunk.hasInstance(eventInst)) {
                    if (bl) {
                        ClioSupport.ilogFinest($$$loggerRef$$$0, 1.class, $$$methodRef$$$0, this, "Chunk Event Handler : Removed Instance " + eventInst + " for Chunk :" + chunk.name());
                    }
                    int priority = chunk.instancePriority(eventInst);
                    chunk.removeInstance(eventInst);
                    if (ShardRoutingCache.this.shardingMetadata().getShardingType() == ShardingMetadata.ShardingType.HASH) {
                        RoutingKey splitKey2;
                        RoutingKey key = ShardRoutingCache.this.routingKeysForVersionedChunk(chunk.name());
                        OracleShardingKeyImpl boundary = new OracleShardingKeyBuilderImpl().subkey(event2.hashSplitBoundary(), OracleType.NUMBER).build();
                        List<ShardingKeys> splitKeys = ((HashRangeShardingKeys)key.shardingKeys).split(boundary);
                        if (splitKeys.size() <= 0 && splitKeys.size() != 2) {
                            if (bl) {
                                ClioSupport.ilogWarning($$$loggerRef$$$0, 1.class, $$$methodRef$$$0, this, "Hash boundary could not be used to split the chunk");
                            }
                            ShardRoutingCache.this.cleanup();
                            return;
                        }
                        RoutingKey splitKey1 = new RoutingKey(splitKeys.get(0), key.superShardingKeys);
                        if (ShardRoutingCache.this.update(splitKey1, event2.chunkName()) != null) {
                            ShardRoutingCache.this.routingCache.get(splitKey1).addInstanceWithPriority(eventInst, priority);
                            if (bl) {
                                ClioSupport.ilogFinest($$$loggerRef$$$0, 1.class, $$$methodRef$$$0, this, " Added Routing key: " + splitKey1 + " for Chunk:" + ShardRoutingCache.this.routingCache.get(splitKey1));
                            }
                        }
                        if (ShardRoutingCache.this.update(splitKey2 = new RoutingKey(splitKeys.get(1), key.superShardingKeys), event2.newChunkName()) != null) {
                            ShardRoutingCache.this.routingCache.get(splitKey2).addInstanceWithPriority(eventInst, priority);
                            if (bl) {
                                ClioSupport.ilogFinest($$$loggerRef$$$0, 1.class, $$$methodRef$$$0, this, " Added Routing key: " + splitKey2 + " for Chunk:" + ShardRoutingCache.this.routingCache.get(splitKey2));
                            }
                        }
                    }
                }
                ShardRoutingCache.this.cleanup();
            }

            static {
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredConstructor(ShardRoutingCache.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("onEvent", ChunkEventHandler.Event.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    void onHAEvent(FailoverDriver.Event haEvent) {
        ServiceMember eventInst = this.service().getMember(haEvent.instance(), haEvent.database(), haEvent.host(), haEvent.serviceName());
        if (eventInst != null) {
            this.routingCache.values().forEach(chunk -> chunk.removeInstance(eventInst));
        }
        this.cleanup();
    }

    Selector shardKeyBorrowSelector(final ConnectionRetrievalInfo cri, final boolean usePriority) {
        JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
        final OracleShardingKey shardKey = jdbcCri.getShardingKey();
        final List<Chunk> reqChunks = this.chunks(cri);
        return new Selector(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            @Override
            public boolean selected(CoreConnection connection) {
                if (!(cri instanceof JDBCConnectionRetrievalInfo)) {
                    return false;
                }
                if (shardKey == null) {
                    return true;
                }
                if (reqChunks == null || reqChunks.size() <= 0) {
                    return false;
                }
                boolean isSelected = usePriority ? reqChunks.stream().anyMatch(chunk -> chunk.hasPriorityInstance(connection.serviceMember())) : reqChunks.stream().anyMatch(chunk -> chunk.hasInstance(connection.serviceMember()));
                return isSelected;
            }

            static {
                try {
                    $$$methodRef$$$3 = 2.class.getDeclaredConstructor(ShardRoutingCache.class, ConnectionRetrievalInfo.class, OracleShardingKey.class, List.class, Boolean.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = 2.class.getDeclaredMethod("lambda$selected$0", CoreConnection.class, Chunk.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 2.class.getDeclaredMethod("lambda$selected$1", CoreConnection.class, Chunk.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 2.class.getDeclaredMethod("selected", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    protected List<Chunk> chunks(ConnectionRetrievalInfo cri) {
        JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
        OracleShardingKey key = jdbcCri.getShardingKey();
        OracleShardingKey superKey = jdbcCri.getSuperShardingKey();
        if (key == null) {
            return null;
        }
        if (this.shardingMetadata() == null) {
            return null;
        }
        L2RoutingKey l2Key = new L2RoutingKey(key, superKey);
        if (this.l2RoutingCache.containsKey(l2Key)) {
            return this.l2RoutingCache.get(l2Key);
        }
        OracleShardingKey shardKey = this.lookupKey(key);
        List<Chunk> chunksForKey = this.routingCache.entrySet().stream().filter(cacheEntry -> ((RoutingKey)cacheEntry.getKey()).containsShardingKey(shardKey, superKey)).map(cacheEntry -> (Chunk)cacheEntry.getValue()).collect(Collectors.toList());
        this.l2RoutingCache.putIfAbsent(l2Key, chunksForKey);
        return chunksForKey;
    }

    String matchingChunkName(ConnectionRetrievalInfo cri) {
        List<Chunk> chunks = this.chunks(cri);
        if (chunks == null || chunks.size() == 0) {
            return null;
        }
        return chunks.get(0).absoluteName();
    }

    private OracleShardingKey lookupKey(OracleShardingKey key) {
        if (key == null) {
            return null;
        }
        OracleShardingKey lookupKey = key;
        if (this.shardingMetadata().getShardingType() == ShardingMetadata.ShardingType.HASH) {
            long keyHash = ((OracleShardingKeyImpl)key).shardKeyOraHash(this.shardingMetadata());
            lookupKey = new OracleShardingKeyBuilderImpl().subkey(keyHash, OracleType.NUMBER).oraHash(keyHash).build();
        }
        return lookupKey;
    }

    boolean validateCri(ConnectionRetrievalInfo cri) {
        JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
        if (jdbcCri.getShardingKey() == null) {
            return true;
        }
        if (this.shardingMetadata.get() == null) {
            return false;
        }
        OracleShardingKey shardKey = jdbcCri.getShardingKey();
        OracleShardingKey superKey = jdbcCri.getSuperShardingKey();
        ShardingMetadata metadata = this.shardingMetadata.get();
        if (!((OracleShardingKeyImpl)shardKey).isValid(metadata)) {
            throw new IllegalArgumentException("Sharding Keys provided do not match the sharded database metadata");
        }
        if (superKey != null && !((OracleShardingKeyImpl)superKey).isValid(metadata)) {
            throw new IllegalArgumentException("Super Sharding Keys provided do not match the sharded database metadata");
        }
        return this.hasShardingKey(shardKey, jdbcCri.getSuperShardingKey());
    }

    Set<ServiceMember> priorityInstancesThatCanGrow(ConnectionRetrievalInfo cri) {
        return this.allPriorityInstances(cri).stream().filter(e2 -> !this.isMaxPerShardReached((ServiceMember)e2)).collect(Collectors.toSet());
    }

    boolean canGrow(ConnectionRetrievalInfo cri) {
        Set<ServiceMember> instances = this.allPriorityInstances(cri);
        if (instances.size() == 0) {
            return true;
        }
        return instances.stream().anyMatch(sm -> !this.isMaxPerShardReached((ServiceMember)sm));
    }

    private Set<ServiceMember> allPriorityInstances(ConnectionRetrievalInfo cri) {
        List<Chunk> reqChunks = this.chunks(cri);
        HashSet<ServiceMember> allInstances = new HashSet<ServiceMember>();
        if (reqChunks != null) {
            reqChunks.stream().forEach(c2 -> allInstances.addAll(c2.priorityInstances()));
        }
        return allInstances;
    }

    Set<ServiceMember> allInstances(ConnectionRetrievalInfo cri) {
        List<Chunk> reqChunks = this.chunks(cri);
        HashSet<ServiceMember> allInstances = new HashSet<ServiceMember>();
        if (reqChunks != null) {
            reqChunks.stream().forEach(c2 -> allInstances.addAll(c2.instances()));
        }
        return allInstances;
    }

    private String htmlCacheInfo() {
        StringBuffer infoStr = new StringBuffer();
        infoStr.append("<h3><centre>LOAD DISTRIBUTION</centre></h3><table  border=\"1\" style=\"width:60%\"><tr><th>Shard Instance</th> <th> Load(%) </th> </tr>");
        for (ServiceMember serviceMember : this.service().getAllMembers()) {
            long instBorrowedTime = serviceMember.lbStats.borrowTimes.totalDelta();
            long totalBorrowedTime = this.service().totalBorrowTimes(null);
            float actualLoad = 0L != totalBorrowedTime ? (float)instBorrowedTime / (float)totalBorrowedTime * 100.0f : 0.0f;
            infoStr.append("<tr><td> " + serviceMember.name() + "</td>" + "<td> " + actualLoad + "</td></tr>");
        }
        infoStr.append("</table></br><br>");
        infoStr.append("</table><br><br><h3><centre>SHARD ROUTING CACHE</centre></h3><table  border=\"1\" style=\"width:100%\"><tr><th>Super Sharding Keys </th> <th> Sharding Keys</th> <th> Chunk name</th><th> Instances</th></tr>" + this.routingCache.entrySet().stream().map(entry -> "<tr>" + ((RoutingKey)entry.getKey()).toHTMLString() + ((Chunk)entry.getValue()).toHTMLString()).collect(Collectors.joining("</tr>")));
        infoStr.append("</table></br><br>");
        return infoStr.toString();
    }

    @DisableTrace
    public String cacheInfo() {
        StringBuffer infoStr = new StringBuffer();
        infoStr.append("\n\t\t SHARD ROUTING CACHE \n\n \nSUPER SHARDING KEY\t\t SHARDING KEY\t\t\t\t\t\t\tCHUNK NAME \t\tINSTANCES\n\n" + this.routingCache.entrySet().stream().map(entry -> String.format("%-70s", entry.getKey()) + "\t\t" + ((Chunk)entry.getValue()).toString()).collect(Collectors.joining("\n")));
        return infoStr.toString();
    }

    @DisableTrace
    String metadataInfo() {
        StringBuffer infoStr = new StringBuffer();
        infoStr.append("\t\t SHARDING INFO:\n\tSuper Sharding Type :" + this.shardingMetadata().getSuperShardingType().toString());
        infoStr.append("\n\tSharding Type :" + this.shardingMetadata().getShardingType().toString());
        return infoStr.toString();
    }

    public void destroy() {
        this.l2RoutingCache.clear();
        this.routingCache.clear();
        this.chunkEventHandler.stop();
    }

    void removeChunk(String chunkName, ServiceMember instance) {
        if (this.hasMatchingChunk(chunkName, instance)) {
            this.matchingChunk(chunkName, instance).removeInstance(instance);
        }
        this.cleanup();
    }

    public String shardConnectionStats() {
        StringBuffer statStr = new StringBuffer();
        statStr.append("Shard Connection Stats(<Shard Instance:connection count>) for Service " + this.service().name() + ":{");
        this.service().getAllMembers().stream().filter(sm -> this.shardConnectionCounter.containsKey(sm.dbUniqueId())).forEach(sm -> statStr.append("<" + sm.name() + ":" + this.shardConnectionCounter.get(sm.dbUniqueId()) + "> "));
        statStr.append("}");
        return statStr.toString();
    }

    public boolean available(ConnectionRetrievalInfo cri) {
        JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
        if (this.hasShardingKey(jdbcCri.getShardingKey(), jdbcCri.getSuperShardingKey())) {
            return this.allInstances(jdbcCri).stream().anyMatch(inst -> inst.activeCount.get() - inst.borrowedCount.get() > 0);
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$update$3(String chunkName, Chunk c2) {
        return c2.absoluteName().equals(chunkName);
    }

    static {
        try {
            $$$methodRef$$$57 = ShardRoutingCache.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$56 = ShardRoutingCache.class.getDeclaredMethod("access$200", ShardRoutingCache.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$55 = ShardRoutingCache.class.getDeclaredMethod("access$000", ShardRoutingCache.class, String.class, ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$54 = ShardRoutingCache.class.getDeclaredMethod("lambda$hasVersionedChunk$0", String.class, Map.Entry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$53 = ShardRoutingCache.class.getDeclaredMethod("lambda$routingKeysForVersionedChunk$1", String.class, Map.Entry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$52 = ShardRoutingCache.class.getDeclaredMethod("lambda$hasShardingKey$2", OracleShardingKey.class, OracleShardingKey.class, Map.Entry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$51 = ShardRoutingCache.class.getDeclaredMethod("lambda$update$3", String.class, Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$50 = ShardRoutingCache.class.getDeclaredMethod("lambda$update$4", Chunk.class, Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$49 = ShardRoutingCache.class.getDeclaredMethod("lambda$cleanup$5", Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$48 = ShardRoutingCache.class.getDeclaredMethod("lambda$pendingCreateConnectionCounter$6", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$47 = ShardRoutingCache.class.getDeclaredMethod("lambda$onConnectionCreation$7", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$46 = ShardRoutingCache.class.getDeclaredMethod("lambda$matchingChunk$8", String.class, Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$45 = ShardRoutingCache.class.getDeclaredMethod("lambda$matchingChunk$9", ServiceMember.class, Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$44 = ShardRoutingCache.class.getDeclaredMethod("lambda$hasMatchingChunk$10", String.class, ServiceMember.class, Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$43 = ShardRoutingCache.class.getDeclaredMethod("lambda$onHAEvent$11", ServiceMember.class, Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$42 = ShardRoutingCache.class.getDeclaredMethod("lambda$chunks$12", OracleShardingKey.class, OracleShardingKey.class, Map.Entry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$41 = ShardRoutingCache.class.getDeclaredMethod("lambda$chunks$13", Map.Entry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$40 = ShardRoutingCache.class.getDeclaredMethod("lambda$priorityInstancesThatCanGrow$14", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$39 = ShardRoutingCache.class.getDeclaredMethod("lambda$canGrow$15", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$38 = ShardRoutingCache.class.getDeclaredMethod("lambda$allPriorityInstances$16", Set.class, Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$37 = ShardRoutingCache.class.getDeclaredMethod("lambda$allInstances$17", Set.class, Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$36 = ShardRoutingCache.class.getDeclaredMethod("lambda$htmlCacheInfo$18", Map.Entry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$35 = ShardRoutingCache.class.getDeclaredMethod("lambda$cacheInfo$19", Map.Entry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$34 = ShardRoutingCache.class.getDeclaredMethod("lambda$shardConnectionStats$20", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$33 = ShardRoutingCache.class.getDeclaredMethod("lambda$shardConnectionStats$21", StringBuffer.class, ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$32 = ShardRoutingCache.class.getDeclaredMethod("lambda$available$22", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$31 = ShardRoutingCache.class.getDeclaredMethod("available", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$30 = ShardRoutingCache.class.getDeclaredMethod("shardConnectionStats", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$29 = ShardRoutingCache.class.getDeclaredMethod("removeChunk", String.class, ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$28 = ShardRoutingCache.class.getDeclaredMethod("destroy", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$27 = ShardRoutingCache.class.getDeclaredMethod("htmlCacheInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$26 = ShardRoutingCache.class.getDeclaredMethod("allInstances", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$25 = ShardRoutingCache.class.getDeclaredMethod("allPriorityInstances", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$24 = ShardRoutingCache.class.getDeclaredMethod("canGrow", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$23 = ShardRoutingCache.class.getDeclaredMethod("priorityInstancesThatCanGrow", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$22 = ShardRoutingCache.class.getDeclaredMethod("validateCri", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$21 = ShardRoutingCache.class.getDeclaredMethod("lookupKey", OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$20 = ShardRoutingCache.class.getDeclaredMethod("matchingChunkName", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$19 = ShardRoutingCache.class.getDeclaredMethod("chunks", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$18 = ShardRoutingCache.class.getDeclaredMethod("shardKeyBorrowSelector", ConnectionRetrievalInfo.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$17 = ShardRoutingCache.class.getDeclaredMethod("onHAEvent", FailoverDriver.Event.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$16 = ShardRoutingCache.class.getDeclaredMethod("prepareChunkEventHandler", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$15 = ShardRoutingCache.class.getDeclaredMethod("hasMatchingChunk", String.class, ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$14 = ShardRoutingCache.class.getDeclaredMethod("matchingChunk", String.class, ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$13 = ShardRoutingCache.class.getDeclaredMethod("initialize", CoreConnection.class, ONSDriver.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$12 = ShardRoutingCache.class.getDeclaredMethod("makeKey", Chunk.Metadata.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$11 = ShardRoutingCache.class.getDeclaredMethod("shardingMetadata", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$10 = ShardRoutingCache.class.getDeclaredMethod("buildTopologyForInstance", CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$9 = ShardRoutingCache.class.getDeclaredMethod("onConnectionClosure", CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$8 = ShardRoutingCache.class.getDeclaredMethod("onConnectionCreation", CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$7 = ShardRoutingCache.class.getDeclaredMethod("pendingCreateConnectionCounter", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$6 = ShardRoutingCache.class.getDeclaredMethod("isMaxPerShardConfigured", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$5 = ShardRoutingCache.class.getDeclaredMethod("isMaxPerShardReached", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$4 = ShardRoutingCache.class.getDeclaredMethod("cleanup", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$3 = ShardRoutingCache.class.getDeclaredMethod("update", RoutingKey.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$2 = ShardRoutingCache.class.getDeclaredMethod("hasShardingKey", OracleShardingKey.class, OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$1 = ShardRoutingCache.class.getDeclaredMethod("routingKeysForVersionedChunk", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$0 = ShardRoutingCache.class.getDeclaredMethod("hasVersionedChunk", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
    }

    private static class L2RoutingKey {
        OracleShardingKey key = null;
        OracleShardingKey superKey = null;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;

        L2RoutingKey(OracleShardingKey k2, OracleShardingKey sk) {
            this.key = k2;
            this.superKey = sk;
        }

        @DisableTrace
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            L2RoutingKey other = (L2RoutingKey)obj;
            if (this.key == null) {
                return false;
            }
            if (this.key.equals(other.key)) {
                if (this.superKey == null && other.superKey == null) {
                    return true;
                }
                if (this.superKey != null && this.superKey.equals(other.superKey)) {
                    return true;
                }
            }
            return false;
        }

        @DisableTrace
        public int hashCode() {
            return (this.key != null ? this.key.hashCode() : 0) + (this.superKey != null ? this.superKey.hashCode() : 0);
        }

        static {
            try {
                $$$methodRef$$$0 = L2RoutingKey.class.getDeclaredConstructor(OracleShardingKey.class, OracleShardingKey.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    }

    static class RoutingKey
    implements Comparable<RoutingKey> {
        private final SuperShardingKeys superShardingKeys;
        private final ShardingKeys shardingKeys;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;

        RoutingKey(ShardingKeys keys, SuperShardingKeys superShardingKeys) {
            this.superShardingKeys = superShardingKeys;
            this.shardingKeys = keys;
        }

        public int hashCode() {
            return 31 * (this.superShardingKeys == null ? 0 : this.superShardingKeys.hashCode()) + this.shardingKeys.hashCode();
        }

        public boolean equals(Object otherObj) {
            if (otherObj == null) {
                return false;
            }
            if (otherObj == this) {
                return true;
            }
            if (!(otherObj instanceof RoutingKey)) {
                return false;
            }
            RoutingKey otherKey = (RoutingKey)otherObj;
            return this.superShardingKeys.equals(otherKey.superShardingKeys) && this.shardingKeys.equals(otherKey.shardingKeys);
        }

        boolean containsShardingKey(OracleShardingKey shardingKey, OracleShardingKey superKey) {
            if (superKey != null && this.superShardingKeys == null) {
                return false;
            }
            if (this.superShardingKeys != null && !this.superShardingKeys.equals(SuperShardingKeys.DEFAULT_SUPER_SHARDING_KEYS)) {
                if (superKey == null) {
                    return false;
                }
                if (!this.superShardingKeys.contains(superKey)) {
                    return false;
                }
            }
            if (shardingKey == null) {
                return false;
            }
            return this.shardingKeys.contains(shardingKey);
        }

        @DisableTrace
        public String toString() {
            return (this.superShardingKeys != null ? this.superShardingKeys.toString() : "") + (this.shardingKeys != null ? "\t\t" + this.shardingKeys.toString() : "");
        }

        @DisableTrace
        private String toHTMLString() {
            return "<td>" + (this.superShardingKeys != null ? this.superShardingKeys.toString() : "") + "</td>" + "<td>" + (this.shardingKeys != null ? this.shardingKeys.toString() : "") + "</td>";
        }

        @Override
        public int compareTo(RoutingKey o2) {
            int equal = this.superShardingKeys.compareTo(o2.superShardingKeys);
            if (equal != 0) {
                return equal;
            }
            int result = this.shardingKeys.compareTo(o2.shardingKeys);
            return result;
        }

        static {
            try {
                $$$methodRef$$$8 = RoutingKey.class.getDeclaredConstructor(ShardingKeys.class, SuperShardingKeys.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$7 = RoutingKey.class.getDeclaredMethod("access$400", RoutingKey.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$6 = RoutingKey.class.getDeclaredMethod("access$300", RoutingKey.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$5 = RoutingKey.class.getDeclaredMethod("access$100", RoutingKey.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$4 = RoutingKey.class.getDeclaredMethod("compareTo", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$3 = RoutingKey.class.getDeclaredMethod("compareTo", RoutingKey.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$2 = RoutingKey.class.getDeclaredMethod("containsShardingKey", OracleShardingKey.class, OracleShardingKey.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = RoutingKey.class.getDeclaredMethod("equals", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = RoutingKey.class.getDeclaredMethod("hashCode", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    }
}

