/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.ucp.common.ShardingKeys;

class HashRangeShardingKeys
implements ShardingKeys {
    private final OracleShardingKey keyLowHash;
    private final OracleShardingKey keyHighHash;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;

    HashRangeShardingKeys(OracleShardingKey keyHighHash, OracleShardingKey keyLowHash) {
        this.keyLowHash = keyLowHash;
        this.keyHighHash = keyHighHash;
    }

    @Override
    public boolean contains(OracleShardingKey hashedKey) {
        return hashedKey.compareTo(this.keyLowHash) >= 0 && hashedKey.compareTo(this.keyHighHash) < 0;
    }

    @DisableTrace
    public String toString() {
        return "{Low:" + this.keyLowHash + ", High:" + this.keyHighHash + "}";
    }

    public int hashCode() {
        return 31 * this.keyLowHash.hashCode() + this.keyHighHash.hashCode();
    }

    public boolean equals(Object otherObj) {
        if (otherObj == null) {
            return false;
        }
        if (otherObj == this) {
            return true;
        }
        if (!(otherObj instanceof HashRangeShardingKeys)) {
            return false;
        }
        HashRangeShardingKeys otherKeys = (HashRangeShardingKeys)otherObj;
        return this.keyLowHash.equals(otherKeys.keyLowHash) && this.keyHighHash.equals(otherKeys.keyHighHash);
    }

    @Override
    public int compareTo(ShardingKeys other) {
        HashRangeShardingKeys otherKeys = (HashRangeShardingKeys)other;
        int lowCompare = this.keyLowHash.compareTo(otherKeys.keyLowHash);
        if (lowCompare != 0) {
            return lowCompare;
        }
        return this.keyHighHash.compareTo(otherKeys.keyHighHash);
    }

    List<ShardingKeys> split(OracleShardingKey boundaryHash) {
        ArrayList<ShardingKeys> splitKeys = new ArrayList<ShardingKeys>(2);
        splitKeys.add(new HashRangeShardingKeys(boundaryHash, this.keyLowHash));
        splitKeys.add(new HashRangeShardingKeys(this.keyHighHash, boundaryHash));
        return splitKeys;
    }

    static {
        try {
            $$$methodRef$$$5 = HashRangeShardingKeys.class.getDeclaredConstructor(OracleShardingKey.class, OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = HashRangeShardingKeys.class.getDeclaredMethod("split", OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = HashRangeShardingKeys.class.getDeclaredMethod("compareTo", ShardingKeys.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = HashRangeShardingKeys.class.getDeclaredMethod("equals", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = HashRangeShardingKeys.class.getDeclaredMethod("hashCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = HashRangeShardingKeys.class.getDeclaredMethod("contains", OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }
}

