/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.lang.reflect.Executable;
import java.sql.SQLRecoverableException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.pooling.Factory;
import oracle.jdbc.pooling.Pool;
import oracle.jdbc.pooling.PoolIterator;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolManagerBase;
import oracle.ucp.common.AffinityContext;
import oracle.ucp.common.Applicator;
import oracle.ucp.common.Clock;
import oracle.ucp.common.ConnectionSource;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.Counter;
import oracle.ucp.common.Limits;
import oracle.ucp.common.Policies;
import oracle.ucp.common.Selector;
import oracle.ucp.common.Selectors;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.TaskHandle;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.UCPTaskBase;
import oracle.ucp.util.Util;

@DefaultLogger(value="oracle.ucp.common")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT})
public final class Core {
    private final Map<String, Pool<CoreConnection>> waitFreePools = new ConcurrentHashMap<String, Pool<CoreConnection>>();
    private static final boolean isAffinityStrict;
    private AtomicReference<ConnectionSource> connectionSource = new AtomicReference<ConnectionSource>(ConnectionSource.IDLE);
    private AtomicReference<Limits> limits = new AtomicReference<Limits>(Limits.DEFAULT);
    private AtomicReference<Policies> policies = new AtomicReference<1>(new Policies(){
        private final IllegalStateException err = new IllegalStateException("policies are not set up yet");
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        @Override
        public ConnectionRetrievalInfo getMostPopularCri() {
            throw this.err;
        }

        @Override
        public boolean isCriUnpopular(ConnectionRetrievalInfo cri) {
            throw this.err;
        }

        static {
            try {
                $$$methodRef$$$2 = 1.class.getDeclaredConstructor(Core.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = 1.class.getDeclaredMethod("isCriUnpopular", ConnectionRetrievalInfo.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = 1.class.getDeclaredMethod("getMostPopularCri", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    });
    private AtomicInteger pendingAvailableGrows = new AtomicInteger();
    private AtomicInteger pendingBorrowedGrows = new AtomicInteger();
    private AtomicLong repurposeCount = new AtomicLong(0L);
    private ReentrantLock handlersLock = new ReentrantLock();
    private static final long INITIALIZE_TIMEOUT = 1000L;
    private final AtomicBoolean adjusterEnabled = new AtomicBoolean(false);
    private final AtomicBoolean adjusterBusy = new AtomicBoolean(false);
    private static final int HARVESTING_ATTEMPTS = 5;
    AtomicBoolean keepOverMinimum = new AtomicBoolean(false);
    public static final int ADJUST_MIN_LIMIT_ATTEMPTS = 10;
    public static final int BEST_INSTANCE_CREATION_ATTEMPTS = 3;
    public static final long ADJUST_MIN_LIMIT_DELAY = 2000L;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;
    private static Executable $$$methodRef$$$58;
    private static Logger $$$loggerRef$$$58;
    private static Executable $$$methodRef$$$59;
    private static Logger $$$loggerRef$$$59;
    private static Executable $$$methodRef$$$60;
    private static Logger $$$loggerRef$$$60;
    private static Executable $$$methodRef$$$61;
    private static Logger $$$loggerRef$$$61;
    private static Executable $$$methodRef$$$62;
    private static Logger $$$loggerRef$$$62;
    private static Executable $$$methodRef$$$63;
    private static Logger $$$loggerRef$$$63;
    private static Executable $$$methodRef$$$64;
    private static Logger $$$loggerRef$$$64;
    private static Executable $$$methodRef$$$65;
    private static Logger $$$loggerRef$$$65;
    private static Executable $$$methodRef$$$66;
    private static Logger $$$loggerRef$$$66;

    Core() {
    }

    private Pool<CoreConnection> waitFreePool(String serviceName) {
        if (serviceName != null) {
            return this.waitFreePools.get(serviceName);
        }
        throw new IllegalStateException("Service is not registered in the pool");
    }

    private void put(CoreConnection conn) {
        String serviceName = conn.serviceName();
        this.waitFreePool(serviceName).put(conn);
        conn.serviceMember().serviceRef.buildDistributionTable();
        if (this.totalCount().get() + this.pendingBorrowedGrows.get() + this.pendingAvailableGrows.get() >= this.limits().getMin()) {
            this.keepOverMinimum.set(true);
        }
    }

    private void forEach(String service, Applicator applicator) {
        this.forSome(service, Selectors.EVERY, applicator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CoreConnection> split(String serviceName, Selector selector) {
        ArrayList<CoreConnection> connections = new ArrayList<CoreConnection>();
        PoolIterator<CoreConnection> it = this.waitFreePool(serviceName).iterator(true);
        try {
            while (it.hasNext()) {
                CoreConnection connection = (CoreConnection)it.next();
                if (!selector.selected(connection)) continue;
                it.remove();
                connection.serviceMember().serviceRef.buildDistributionTable();
                connections.add(connection);
            }
        }
        finally {
            it.release();
        }
        return connections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forSome(String serviceName, Selector selector, Applicator applicator) {
        PoolIterator<CoreConnection> it = this.waitFreePool(serviceName).iterator(true);
        try {
            while (it.hasNext()) {
                CoreConnection conn = (CoreConnection)it.next();
                if (!selector.selected(conn)) continue;
                applicator.apply(conn);
            }
        }
        finally {
            it.release();
        }
    }

    private void forFirst(String serviceName, Selector selector, Applicator applicator) {
        this.forFirst(serviceName, selector, applicator, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forFirst(String serviceName, Selector selector, Applicator applicator, boolean revisit) {
        PoolIterator<CoreConnection> it = this.waitFreePool(serviceName).iterator(revisit);
        try {
            while (it.hasNext()) {
                CoreConnection conn = (CoreConnection)it.next();
                if (!selector.selected(conn)) continue;
                applicator.apply(conn);
                return;
            }
        }
        finally {
            it.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoreConnection retrieveFirst(String serviceName, Selector selector) {
        CoreConnection found = null;
        PoolIterator<CoreConnection> it = this.waitFreePool(serviceName).iterator(true);
        try {
            while (it.hasNext()) {
                CoreConnection conn = (CoreConnection)it.next();
                if (!selector.selected(conn)) continue;
                it.remove();
                conn.serviceMember().serviceRef.buildDistributionTable();
                found = conn;
                break;
            }
        }
        finally {
            it.release();
        }
        return found;
    }

    private void registerService(String serviceName) {
        this.waitFreePools.putIfAbsent(serviceName, Factory.create());
        ConnectionSource.FailoverCallback failoverCallback = this.prepareFailoverHandler(serviceName);
        ConnectionSource.RebalanceCallback rebalanceCallback = this.prepareRebalanceHandler(serviceName);
        this.connectionSource().registerService(serviceName, failoverCallback, rebalanceCallback);
    }

    final void plugConnectionSource(ConnectionSource connectionSource) {
        if (connectionSource == null) {
            throw new IllegalArgumentException("null connectionSource");
        }
        this.connectionSource.set(connectionSource);
    }

    public ConnectionSource connectionSource() {
        return this.connectionSource.get();
    }

    final void plugLimits(Limits limits) {
        if (limits == null) {
            throw new IllegalArgumentException("null limits");
        }
        this.limits.set(limits);
    }

    private Limits limits() {
        return this.limits.get();
    }

    final void plugPolicies(Policies policies) {
        if (policies == null) {
            throw new IllegalArgumentException("null policies");
        }
        this.policies.set(policies);
    }

    private Policies policies() {
        return this.policies.get();
    }

    /*
     * WARNING - void declaration
     */
    @Supports(value={Feature.CHECK_OUT})
    final CoreConnection borrow(ConnectionRetrievalInfo connectionRetrievalInfo, ConnectionAffinityCallback connectionAffinityCallback) {
        void callback;
        void cri;
        boolean bl = (0x4000000000000L & TraceControllerImpl.feature) != 0L;
        boolean[] perfectMatch = new boolean[]{false};
        CoreConnection[] selectedConn = new CoreConnection[]{null};
        CoreConnection[] currentConn = new CoreConnection[]{null};
        final ConnectionSource cs = this.connectionSource();
        String serviceName = cs.serviceName((ConnectionRetrievalInfo)cri);
        Properties reqLabels = cri.getLabels();
        Comparator<CoreConnection> costComparator = cs.costComparator(reqLabels);
        Selector perfectCostSelector = cs.perfectCostSelector(reqLabels);
        Selector wrongCostSelector = cs.wrongCostSelector(reqLabels);
        Selector shardBasedSelector = Selectors.or(cs.shardKeyBasedBorrowSelector((ConnectionRetrievalInfo)cri, true), cs.shardKeyBasedBorrowSelector((ConnectionRetrievalInfo)cri, false));
        Selector appropAvailBalancedSelector = new Selector((ConnectionRetrievalInfo)cri, (ConnectionAffinityCallback)callback, wrongCostSelector, perfectCostSelector, perfectMatch, selectedConn, costComparator){
            private final Selector lbSelector;
            final /* synthetic */ ConnectionRetrievalInfo val$cri;
            final /* synthetic */ ConnectionAffinityCallback val$callback;
            final /* synthetic */ Selector val$wrongCostSelector;
            final /* synthetic */ Selector val$perfectCostSelector;
            final /* synthetic */ boolean[] val$perfectMatch;
            final /* synthetic */ CoreConnection[] val$selectedConn;
            final /* synthetic */ Comparator val$costComparator;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            {
                this.val$cri = connectionRetrievalInfo;
                this.val$callback = connectionAffinityCallback;
                this.val$wrongCostSelector = selector;
                this.val$perfectCostSelector = selector2;
                this.val$perfectMatch = blArray;
                this.val$selectedConn = coreConnectionArray;
                this.val$costComparator = comparator;
                this.lbSelector = cs.loadBalancedBorrowSelector(this.val$cri, this.val$callback);
            }

            @Override
            public boolean selected(CoreConnection conn) {
                if (conn.closed() || conn.bad()) {
                    return false;
                }
                if (!conn.available()) {
                    return false;
                }
                if (!conn.cri().equals(this.val$cri)) {
                    return false;
                }
                boolean loadBalanced = this.lbSelector.selected(conn);
                if (this.val$wrongCostSelector.selected(conn)) {
                    return false;
                }
                if (this.val$perfectCostSelector.selected(conn)) {
                    this.val$perfectMatch[0] = loadBalanced;
                    return this.val$perfectMatch[0];
                }
                CoreConnection sc = this.val$selectedConn[0];
                return loadBalanced && (null == sc || this.val$costComparator.compare(conn, sc) < 0);
            }

            static {
                try {
                    $$$methodRef$$$1 = 2.class.getDeclaredConstructor(Core.class, ConnectionSource.class, ConnectionRetrievalInfo.class, ConnectionAffinityCallback.class, Selector.class, Selector.class, boolean[].class, CoreConnection[].class, Comparator.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 2.class.getDeclaredMethod("selected", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
        Selector appropAvailSelector = new Selector((ConnectionRetrievalInfo)cri, wrongCostSelector, perfectCostSelector, perfectMatch, selectedConn, costComparator){
            final /* synthetic */ ConnectionRetrievalInfo val$cri;
            final /* synthetic */ Selector val$wrongCostSelector;
            final /* synthetic */ Selector val$perfectCostSelector;
            final /* synthetic */ boolean[] val$perfectMatch;
            final /* synthetic */ CoreConnection[] val$selectedConn;
            final /* synthetic */ Comparator val$costComparator;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            {
                this.val$cri = connectionRetrievalInfo;
                this.val$wrongCostSelector = selector;
                this.val$perfectCostSelector = selector2;
                this.val$perfectMatch = blArray;
                this.val$selectedConn = coreConnectionArray;
                this.val$costComparator = comparator;
            }

            @Override
            public boolean selected(CoreConnection conn) {
                if (conn.closed() || conn.bad()) {
                    return false;
                }
                if (!conn.available()) {
                    return false;
                }
                if (!conn.cri().equals(this.val$cri)) {
                    return false;
                }
                if (this.val$wrongCostSelector.selected(conn)) {
                    return false;
                }
                if (this.val$perfectCostSelector.selected(conn)) {
                    this.val$perfectMatch[0] = true;
                    return true;
                }
                CoreConnection sc = this.val$selectedConn[0];
                return null == sc || this.val$costComparator.compare(conn, sc) < 0;
            }

            static {
                try {
                    $$$methodRef$$$1 = 3.class.getDeclaredConstructor(Core.class, ConnectionRetrievalInfo.class, Selector.class, Selector.class, boolean[].class, CoreConnection[].class, Comparator.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 3.class.getDeclaredMethod("selected", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
        Applicator applicator = new Applicator((ConnectionRetrievalInfo)cri, currentConn){
            final /* synthetic */ ConnectionRetrievalInfo val$cri;
            final /* synthetic */ CoreConnection[] val$currentConn;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            {
                this.val$cri = connectionRetrievalInfo;
                this.val$currentConn = coreConnectionArray;
            }

            @Override
            public void apply(CoreConnection conn) {
                conn.makeUnavailable(this.val$cri);
                this.val$currentConn[0] = conn;
            }

            static {
                try {
                    $$$methodRef$$$1 = 4.class.getDeclaredConstructor(Core.class, ConnectionRetrievalInfo.class, CoreConnection[].class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 4.class.getDeclaredMethod("apply", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
        do {
            boolean dbAffinity;
            currentConn[0] = null;
            Selector balancedSelector = cs.isShardedDatabase() ? Selectors.and(shardBasedSelector, appropAvailBalancedSelector) : appropAvailBalancedSelector;
            Selector unBalancedSelector = cs.isShardedDatabase() ? Selectors.and(shardBasedSelector, appropAvailSelector) : appropAvailSelector;
            boolean bl2 = dbAffinity = null != callback && ConnectionAffinityCallback.AffinityPolicy.DATA_BASED_AFFINITY == callback.getAffinityPolicy();
            if (cs.failoverEnabled() || dbAffinity) {
                this.forFirst(serviceName, balancedSelector, applicator, false);
                if (null == currentConn[0]) {
                    if (!dbAffinity || !isAffinityStrict) {
                        this.forFirst(serviceName, unBalancedSelector, applicator, false);
                    }
                } else if (null != callback) {
                    ConnectionAffinityCallback.AffinityPolicy policy = callback.getAffinityPolicy();
                    if (callback.getConnectionAffinityContext() == null) {
                        ServiceMember chosenConnInstance = currentConn[0].serviceMember();
                        if (ConnectionAffinityCallback.AffinityPolicy.WEBSESSION_BASED_AFFINITY == policy && chosenConnInstance.affined() || ConnectionAffinityCallback.AffinityPolicy.TRANSACTION_BASED_AFFINITY == policy) {
                            if (bl) {
                                ClioSupport.ilogFinest($$$loggerRef$$$15, Core.class, $$$methodRef$$$15, this, String.format("Updating affinity context with instance %s", chosenConnInstance.name()));
                            }
                            callback.setConnectionAffinityContext(new AffinityContext(chosenConnInstance.service(), chosenConnInstance.database(), chosenConnInstance.name(), policy));
                        }
                    }
                }
            } else {
                this.forFirst(serviceName, unBalancedSelector, applicator, false);
            }
            if (null == currentConn[0]) {
                if (cs.failoverEnabled() && selectedConn[0] != null) {
                    this.updateRLBStats(selectedConn[0].serviceMember());
                }
                return selectedConn[0];
            }
            CoreConnection connToReturn = selectedConn[0];
            selectedConn[0] = currentConn[0];
            if (null == connToReturn) continue;
            connToReturn.makeAvailable();
        } while (!perfectMatch[0]);
        if (cs.failoverEnabled() && currentConn[0] != null) {
            this.updateRLBStats(currentConn[0].serviceMember());
        }
        return currentConn[0];
    }

    @Supports(value={Feature.POOL_STATISTICS})
    private void updateRLBStats(ServiceMember serviceMember) {
        if (serviceMember.violatingRLBAdvisory()) {
            serviceMember.lbStats.onFailedLbBorrowed();
            serviceMember.serviceRef.lbStats.onFailedLbBorrowed();
        } else {
            serviceMember.lbStats.onSuccessfulLbBorrowed();
            serviceMember.serviceRef.lbStats.onSuccessfulLbBorrowed();
        }
    }

    @Supports(value={Feature.CHECK_IN})
    final void reclaim(CoreConnection conn) throws UniversalConnectionPoolException {
        if (conn.available()) {
            return;
        }
        boolean replaceOnReturn = false;
        if (conn.normal()) {
            if (conn.reusable()) {
                conn.onReturn();
                conn.makeAvailable();
                return;
            }
            if (!conn.markedCloseOnReturn()) {
                replaceOnReturn = true;
            }
        } else if (conn.markedToReplace()) {
            replaceOnReturn = true;
        }
        if (conn.bad() || conn.markedCloseOnReturn()) {
            conn.abort();
        }
        this.retrieve(conn);
        conn.close();
        if (replaceOnReturn) {
            this.growAvailableAsynch(conn.cri());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final CoreConnection growBorrowed(ConnectionRetrievalInfo cri, ConnectionAffinityCallback callback, long timeToRetry) throws UniversalConnectionPoolException {
        CoreConnection connection = null;
        int total = this.totalCount().get() + this.pendingAvailableGrows.get() + this.pendingBorrowedGrows.incrementAndGet();
        try {
            int retries = 5;
            String serviceName = this.connectionSource().serviceName(cri);
            for (int i2 = 0; i2 < 5; ++i2) {
                if (this.connectionSource().isMultitenantDatabase() && total > this.limits().getMin() && total > this.limits().getRepurposeThreshold() && (connection = this.tryRepurpose(cri)) != null) {
                    this.repurposeCount.getAndIncrement();
                } else {
                    if (!this.connectionSource().isServiceRegistered(serviceName)) {
                        this.registerService(serviceName);
                    }
                    if (total > this.limits().getMax()) {
                        if (this.makeRoom(cri)) {
                            connection = this.connectionSource().create(cri, callback, EnumSet.of(ConnectionSource.CreateMode.USE_BEST_INSTANCE), timeToRetry);
                            if (connection == null) continue;
                        }
                    } else {
                        connection = this.connectionSource().create(cri, callback, EnumSet.of(ConnectionSource.CreateMode.USE_BEST_INSTANCE), timeToRetry);
                    }
                }
                break;
            }
        }
        finally {
            if (null != connection) {
                connection.onBorrow(cri);
                connection.makeUnavailable(cri);
                this.put(connection);
            }
            this.pendingBorrowedGrows.getAndDecrement();
        }
        return connection;
    }

    @Supports(value={Feature.HIGH_AVAILABILITY})
    private ConnectionSource.FailoverCallback prepareFailoverHandler(final String serviceName) {
        return new ConnectionSource.FailoverCallback(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ConnectionSource.FailoverCallback.Result handle(Selector cleanupSelector, Selector markupSelector, boolean isGracefulDraining, boolean restoreAfterCleanup) {
                Core.this.handlersLock.lock();
                try {
                    ConnectionSource.FailoverCallback.Result result = this.handleHelper(cleanupSelector, markupSelector, isGracefulDraining, restoreAfterCleanup);
                    return result;
                }
                finally {
                    Core.this.handlersLock.unlock();
                }
            }

            /*
             * WARNING - void declaration
             */
            private ConnectionSource.FailoverCallback.Result handleHelper(Selector selector, Selector selector2, boolean bl, boolean bl2) {
                void cleanupSelector;
                CoreConnection conn;
                boolean bl3 = (0L & TraceControllerImpl.feature) != 0L;
                int count = 0;
                ConnectionSource.FailoverCallback.Result.ResultType resultType = ConnectionSource.FailoverCallback.Result.ResultType.FAILURE;
                int avail = Core.this.availableCount();
                int borrowed = Core.this.borrowedCount();
                int availMarkedDown = 0;
                int borrowedMarkedDown = 0;
                int[] availClosed = new int[]{0};
                int[] borrowedClosed = new int[]{0};
                int[] opened = new int[]{0};
                while (null != (conn = Core.this.retrieveFirst(serviceName, (Selector)cleanupSelector))) {
                    block12: {
                        if (Core.this.connectionSource().isReplayable() && !conn.available()) {
                            conn.markReconnecting();
                            Core.this.put(conn);
                        } else {
                            void restoreAfterCleanup;
                            conn.abort();
                            conn.close();
                            if (restoreAfterCleanup != false) {
                                try {
                                    Core.this.growAvailable(conn.cri());
                                    opened[0] = opened[0] + 1;
                                }
                                catch (UniversalConnectionPoolException e2) {
                                    if (!bl3) break block12;
                                    ClioSupport.ilogThrowing($$$loggerRef$$$1, 5.class, $$$methodRef$$$1, this, e2);
                                }
                            }
                        }
                    }
                    if (conn.available()) {
                        availClosed[0] = availClosed[0] + 1;
                    } else {
                        borrowedClosed[0] = borrowedClosed[0] + 1;
                    }
                    ++count;
                }
                if (count > 0 && bl3) {
                    ClioSupport.ilogFinest($$$loggerRef$$$1, 5.class, $$$methodRef$$$1, this, String.format("FF: cleaned up %d connections", count));
                }
                count = 0;
                while (true) {
                    void isGracefulDraining;
                    void markupSelector;
                    boolean[] marked = new boolean[]{false};
                    boolean[] av = new boolean[]{false};
                    Core.this.forFirst(serviceName, (Selector)markupSelector, new Applicator((boolean)isGracefulDraining, marked, av){
                        final /* synthetic */ boolean val$isGracefulDraining;
                        final /* synthetic */ boolean[] val$marked;
                        final /* synthetic */ boolean[] val$av;
                        private static Executable $$$methodRef$$$0;
                        private static Logger $$$loggerRef$$$0;
                        private static Executable $$$methodRef$$$1;
                        private static Logger $$$loggerRef$$$1;
                        {
                            this.val$isGracefulDraining = bl;
                            this.val$marked = blArray;
                            this.val$av = blArray2;
                        }

                        @Override
                        public void apply(CoreConnection conn) {
                            if (this.val$isGracefulDraining) {
                                conn.markCloseOnReturn();
                            } else {
                                conn.markToReplace();
                            }
                            this.val$marked[0] = true;
                            this.val$av[0] = conn.available();
                        }

                        static {
                            try {
                                $$$methodRef$$$1 = 1.class.getDeclaredConstructor(5.class, Boolean.TYPE, boolean[].class, boolean[].class);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                            try {
                                $$$methodRef$$$0 = 1.class.getDeclaredMethod("apply", CoreConnection.class);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        }
                    });
                    if (!marked[0]) break;
                    ++count;
                    if (av[0]) {
                        ++availMarkedDown;
                        continue;
                    }
                    ++borrowedMarkedDown;
                    borrowedClosed[0] = borrowedClosed[0] + 1;
                }
                if (count > 0 && bl3) {
                    ClioSupport.ilogFinest($$$loggerRef$$$1, 5.class, $$$methodRef$$$1, this, String.format("FF: marked to-replace %d connections", count));
                }
                int beforeAvail = Core.this.availableCount();
                int beforeBorrowed = Core.this.borrowedCount();
                ConnectionSource.FailoverCallback.Result result = new ConnectionSource.FailoverCallback.Result();
                result.type = ConnectionSource.FailoverCallback.Result.ResultType.SUCCESS;
                result.availConns = Core.this.availableCount();
                result.borrowedConns = Core.this.borrowedCount();
                result.availOpened = opened[0] + Core.this.availableCount() > beforeAvail ? Core.this.availableCount() - beforeAvail : 0;
                result.availClosed = availClosed[0] + (beforeAvail > Core.this.availableCount() ? beforeAvail - Core.this.availableCount() : 0);
                result.borrowedClosed = borrowedClosed[0] + (beforeBorrowed > Core.this.borrowedCount() ? beforeBorrowed - Core.this.borrowedCount() : 0);
                Core.this.kickAdjuster();
                return result;
            }

            static {
                try {
                    $$$methodRef$$$2 = 5.class.getDeclaredConstructor(Core.class, String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 5.class.getDeclaredMethod("handleHelper", Selector.class, Selector.class, Boolean.TYPE, Boolean.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 5.class.getDeclaredMethod("handle", Selector.class, Selector.class, Boolean.TYPE, Boolean.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    @Supports(value={Feature.LOAD_BALANCING})
    private ConnectionSource.RebalanceCallback prepareRebalanceHandler(final String serviceName) {
        return new ConnectionSource.RebalanceCallback(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public ConnectionSource.RebalanceCallback.Result handle(final Selector cleanupSelector, final Selector markupSelector) {
                final ConnectionSource.RebalanceCallback.Result res = new ConnectionSource.RebalanceCallback.Result();
                UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){
                    private static Executable $$$methodRef$$$0;
                    private static Logger $$$loggerRef$$$0;
                    private static Executable $$$methodRef$$$1;
                    private static Logger $$$loggerRef$$$1;
                    private static Executable $$$methodRef$$$2;
                    private static Logger $$$loggerRef$$$2;

                    @Override
                    public void run() {
                        if (!Core.this.handlersLock.tryLock()) {
                            return;
                        }
                        try {
                            this.runHelper();
                        }
                        finally {
                            Core.this.handlersLock.unlock();
                        }
                    }

                    private void runHelper() {
                        boolean bl = (0L & TraceControllerImpl.feature) != 0L;
                        final int maxLimit = Math.max(1, (Core.this.totalCount().get() + Core.this.pendingBorrowedGrows.get() + Core.this.pendingAvailableGrows.get()) * 15 / 100);
                        final int[] count = new int[]{0};
                        while (count[0] < maxLimit) {
                            block11: {
                                if (res.terminate.get()) {
                                    return;
                                }
                                CoreConnection conn = Core.this.retrieveFirst(serviceName, new Selector(){
                                    private static Executable $$$methodRef$$$0;
                                    private static Logger $$$loggerRef$$$0;
                                    private static Executable $$$methodRef$$$1;
                                    private static Logger $$$loggerRef$$$1;

                                    @Override
                                    public boolean selected(CoreConnection conn) {
                                        boolean gravitate;
                                        block1: {
                                            gravitate = false;
                                            if (!cleanupSelector.selected(conn)) break block1;
                                            ServiceMember inst = conn.serviceMember();
                                            int delta = inst.connsToRebalance.get();
                                            if (delta < 0 && inst.connsToRebalance.compareAndSet(delta, delta + 1)) {
                                                gravitate = true;
                                            }
                                        }
                                        return gravitate;
                                    }

                                    static {
                                        try {
                                            $$$methodRef$$$1 = 1.class.getDeclaredConstructor(1.class);
                                        }
                                        catch (Throwable throwable) {}
                                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                        try {
                                            $$$methodRef$$$0 = 1.class.getDeclaredMethod("selected", CoreConnection.class);
                                        }
                                        catch (Throwable throwable) {}
                                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                    }
                                });
                                if (null == conn) break;
                                conn.close();
                                try {
                                    Core.this.growAvailable(conn.cri());
                                }
                                catch (UniversalConnectionPoolException e2) {
                                    if (!bl) break block11;
                                    ClioSupport.ilogThrowing($$$loggerRef$$$1, 1.class, $$$methodRef$$$1, this, e2);
                                }
                            }
                            count[0] = count[0] + 1;
                        }
                        Core.this.forSome(serviceName, new Selector(){
                            private static Executable $$$methodRef$$$0;
                            private static Logger $$$loggerRef$$$0;
                            private static Executable $$$methodRef$$$1;
                            private static Logger $$$loggerRef$$$1;

                            @Override
                            public boolean selected(CoreConnection conn) {
                                boolean gravitate;
                                block3: {
                                    if (count[0] >= maxLimit) {
                                        return false;
                                    }
                                    if (res.terminate.get()) {
                                        return false;
                                    }
                                    gravitate = false;
                                    if (!markupSelector.selected(conn)) break block3;
                                    ServiceMember inst = conn.serviceMember();
                                    int delta = inst.connsToRebalance.get();
                                    if (delta < 0 && inst.connsToRebalance.compareAndSet(delta, delta + 1)) {
                                        gravitate = true;
                                    }
                                }
                                return gravitate;
                            }

                            static {
                                try {
                                    $$$methodRef$$$1 = 2.class.getDeclaredConstructor(1.class, int[].class, Integer.TYPE);
                                }
                                catch (Throwable throwable) {}
                                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                try {
                                    $$$methodRef$$$0 = 2.class.getDeclaredMethod("selected", CoreConnection.class);
                                }
                                catch (Throwable throwable) {}
                                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                            }
                        }, new Applicator(){
                            private static Executable $$$methodRef$$$0;
                            private static Logger $$$loggerRef$$$0;
                            private static Executable $$$methodRef$$$1;
                            private static Logger $$$loggerRef$$$1;

                            @Override
                            public void apply(CoreConnection conn) {
                                conn.markToReplace();
                                count[0] = count[0] + 1;
                            }

                            static {
                                try {
                                    $$$methodRef$$$1 = 3.class.getDeclaredConstructor(1.class, int[].class);
                                }
                                catch (Throwable throwable) {}
                                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                try {
                                    $$$methodRef$$$0 = 3.class.getDeclaredMethod("apply", CoreConnection.class);
                                }
                                catch (Throwable throwable) {}
                                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                            }
                        });
                        if (count[0] > 0 && bl) {
                            ClioSupport.ilogFine($$$loggerRef$$$1, 1.class, $$$methodRef$$$1, this, String.format("rebalanced %d connection(s)", count[0]));
                        }
                        if (Core.this.keepOverMinimum.get()) {
                            for (int j2 = Core.this.totalCount().get() + Core.this.pendingBorrowedGrows.get() + Core.this.pendingAvailableGrows.get(); j2 < Core.this.limits().getMin(); ++j2) {
                                if (res.terminate.get()) {
                                    return;
                                }
                                try {
                                    Core.this.growAvailable(Core.this.policies().getMostPopularCri(), true);
                                    if (!bl) continue;
                                    ClioSupport.ilogFinest($$$loggerRef$$$1, 1.class, $$$methodRef$$$1, this, "grew up one connection to reach the minimum");
                                    continue;
                                }
                                catch (UniversalConnectionPoolException e3) {
                                    if (!bl) break;
                                    ClioSupport.ilogThrowing($$$loggerRef$$$1, 1.class, $$$methodRef$$$1, this, e3);
                                    break;
                                }
                            }
                        }
                        if (res.terminate.get()) {
                            return;
                        }
                        Core.this.adjustMaxLimit();
                    }

                    static {
                        try {
                            $$$methodRef$$$2 = 1.class.getDeclaredConstructor(6.class, ConnectionSource.RebalanceCallback.Result.class, Selector.class, Selector.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        try {
                            $$$methodRef$$$1 = 1.class.getDeclaredMethod("runHelper", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        try {
                            $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    }
                });
                return res;
            }

            static {
                try {
                    $$$methodRef$$$1 = 6.class.getDeclaredConstructor(Core.class, String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 6.class.getDeclaredMethod("handle", Selector.class, Selector.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    private CoreConnection tryRepurpose(ConnectionRetrievalInfo cri) {
        CoreConnection toRepurpose = null;
        String serviceName = this.connectionSource().serviceName(cri);
        if (!this.connectionSource().isServiceRegistered(serviceName)) {
            return null;
        }
        if (this.waitFreePools.size() > 0) {
            for (String targetServiceName : this.waitFreePools.keySet()) {
                if (serviceName != null && serviceName.equals(targetServiceName) || (toRepurpose = this.retrieveFirst(targetServiceName, this.connectionSource().serviceBasedRepurposeSelector(cri, true))) == null) continue;
                if (toRepurpose.repurpose(cri)) {
                    return toRepurpose;
                }
                toRepurpose.close();
                return null;
            }
            for (String targetServiceName : this.waitFreePools.keySet()) {
                if (serviceName != null && serviceName.equals(targetServiceName) || (toRepurpose = this.retrieveFirst(targetServiceName, this.connectionSource().serviceBasedRepurposeSelector(cri, false))) == null) continue;
                if (toRepurpose.repurpose(cri)) {
                    return toRepurpose;
                }
                toRepurpose.close();
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private boolean makeRoom(ConnectionRetrievalInfo connectionRetrievalInfo) {
        boolean bl = (0x6000000000000L & TraceControllerImpl.feature) != 0L;
        this.adjusterEnabled.set(false);
        try {
            void cri;
            String poolServiceName;
            CoreConnection toClose = null;
            Iterator<String> iterator = this.waitFreePools.keySet().iterator();
            while (iterator.hasNext() && (toClose = this.retrieveFirst(poolServiceName = iterator.next(), new Selector(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                public boolean selected(CoreConnection connection) {
                    if (!connection.available()) {
                        return false;
                    }
                    if (connection.closed()) {
                        return true;
                    }
                    return Core.this.policies().isCriUnpopular(connection.cri());
                }

                static {
                    try {
                        $$$methodRef$$$1 = 7.class.getDeclaredConstructor(Core.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 7.class.getDeclaredMethod("selected", CoreConnection.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            })) == null) {
            }
            if (toClose != null) {
                toClose.close();
                if (bl) {
                    ClioSupport.ilogFinest($$$loggerRef$$$22, Core.class, $$$methodRef$$$22, this, "closed 1 connection");
                }
                boolean bl2 = true;
                return bl2;
            }
            iterator = this.waitFreePools.keySet().iterator();
            while (iterator.hasNext() && (toClose = this.retrieveFirst(poolServiceName = iterator.next(), Selectors.and(this.connectionSource().availableConnectionsSelector(), Selectors.or(Selectors.not(this.connectionSource().matchingCriSelector((ConnectionRetrievalInfo)cri)), Selectors.not(this.connectionSource().shardKeyBasedBorrowSelector((ConnectionRetrievalInfo)cri, false)))))) == null) {
            }
            if (null != toClose) {
                toClose.close();
                if (bl) {
                    ClioSupport.ilogFinest($$$loggerRef$$$22, Core.class, $$$methodRef$$$22, this, "close 1 connection");
                }
                boolean bl3 = true;
                return bl3;
            }
            boolean bl4 = false;
            return bl4;
        }
        finally {
            this.adjusterEnabled.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void growAvailable(ConnectionRetrievalInfo cri, boolean useBestInstance) throws UniversalConnectionPoolException {
        CoreConnection conn = null;
        int total = this.totalCount().get() + this.pendingBorrowedGrows.get() + this.pendingAvailableGrows.incrementAndGet();
        try {
            if (total > this.limits().getMax()) {
                return;
            }
            conn = this.connectionSource().create(cri, null, useBestInstance ? EnumSet.of(ConnectionSource.CreateMode.USE_BEST_INSTANCE) : EnumSet.noneOf(ConnectionSource.CreateMode.class), 0L);
            if (conn == null) {
                return;
            }
            conn.makeAvailable();
            this.put(conn);
        }
        finally {
            this.pendingAvailableGrows.getAndDecrement();
        }
    }

    private void growAvailable(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        this.growAvailable(cri, true);
    }

    private void growAvailableAsynch(final ConnectionRetrievalInfo cri) {
        UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public void run() {
                block2: {
                    boolean bl = (0L & TraceControllerImpl.feature) != 0L;
                    try {
                        Core.this.growAvailable(cri);
                    }
                    catch (UniversalConnectionPoolException e2) {
                        if (!bl) break block2;
                        ClioSupport.ilogThrowing($$$loggerRef$$$0, 8.class, $$$methodRef$$$0, this, e2);
                    }
                }
            }

            static {
                try {
                    $$$methodRef$$$1 = 8.class.getDeclaredConstructor(Core.class, ConnectionRetrievalInfo.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 8.class.getDeclaredMethod("run", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void initialize() throws UniversalConnectionPoolException {
        boolean bl = (0x6000000000000L & TraceControllerImpl.feature) != 0L;
        this.adjusterEnabled.set(false);
        final boolean[] succeeded = new boolean[]{true};
        final Throwable[] cause = new Throwable[]{null};
        try {
            int initPoolSize = Math.min(Math.min(this.limits().getInitial(), this.limits().getMax()), this.limits().getMaxPerService());
            final AtomicInteger connsToCreate = new AtomicInteger();
            UCPTaskBase<Boolean> task = new UCPTaskBase<Boolean>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;

                @Override
                public Boolean call() {
                    boolean bl;
                    boolean bl2 = bl = (0L & TraceControllerImpl.feature) != 0L;
                    if (bl) {
                        ClioSupport.ilogFinest($$$loggerRef$$$0, 9.class, $$$methodRef$$$0, this, "launching init thread");
                    }
                    while (connsToCreate.getAndDecrement() > 0) {
                        try {
                            CoreConnection conn;
                            ConnectionRetrievalInfo defaultCri = Core.this.connectionSource().defaultCri();
                            String defaultSvcName = Core.this.connectionSource().serviceName(defaultCri);
                            if (!Core.this.connectionSource().isServiceRegistered(defaultSvcName)) {
                                Core.this.registerService(defaultSvcName);
                            }
                            if (null != (conn = Core.this.connectionSource().create(Core.this.policies().getMostPopularCri(), null, EnumSet.of(ConnectionSource.CreateMode.USE_BEST_INSTANCE), 1000L))) {
                                conn.makeAvailable();
                                Core.this.put(conn);
                                if (!bl) continue;
                                ClioSupport.ilogFinest($$$loggerRef$$$0, 9.class, $$$methodRef$$$0, this, String.format("connection %s successfully created", conn.toString()));
                                continue;
                            }
                            if (!bl) continue;
                            ClioSupport.ilogWarning($$$loggerRef$$$0, 9.class, $$$methodRef$$$0, this, "connection not created");
                        }
                        catch (UniversalConnectionPoolException e2) {
                            if (bl) {
                                ClioSupport.ilogThrowing($$$loggerRef$$$0, 9.class, $$$methodRef$$$0, this, e2);
                            }
                            if (e2.getCause() instanceof SQLRecoverableException) continue;
                            if (bl) {
                                ClioSupport.ilogFinest($$$loggerRef$$$0, 9.class, $$$methodRef$$$0, this, "failure");
                            }
                            succeeded[0] = false;
                            cause[0] = e2;
                            break;
                        }
                    }
                    return succeeded[0];
                }

                static {
                    try {
                        $$$methodRef$$$2 = 9.class.getDeclaredConstructor(Core.class, AtomicInteger.class, boolean[].class, Throwable[].class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$1 = 9.class.getDeclaredMethod("call", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 9.class.getDeclaredMethod("call", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            };
            try {
                connsToCreate.set(initPoolSize > 0 ? 1 : 0);
                if (!((Boolean)task.call()).booleanValue()) {
                    UCPErrorHandler.throwUniversalConnectionPoolException(66, new IllegalStateException("unable to start connection creation task", cause[0]));
                }
                int maxInitThreads = Util.getMaxInitThreads();
                int initThreads = Math.min(Math.max(0, maxInitThreads), Math.max(0, initPoolSize));
                if (bl) {
                    ClioSupport.ilogFinest($$$loggerRef$$$26, Core.class, $$$methodRef$$$26, this, String.format("initPoolSize=%d, maxInitThreads=%d, initThreads=%d", initPoolSize, maxInitThreads, initThreads));
                }
                connsToCreate.set(initPoolSize - 1);
                TaskHandle[] handles = new TaskHandle[initThreads];
                for (int i2 = 0; i2 < handles.length; ++i2) {
                    handles[i2] = UniversalConnectionPoolManagerBase.getTaskManager().submitTask(task);
                }
                for (TaskHandle handle : handles) {
                    succeeded[0] = succeeded[0] && (Boolean)handle.get(0L) != false;
                }
            }
            catch (Exception e2) {
                if (bl) {
                    ClioSupport.ilogThrowing($$$loggerRef$$$26, Core.class, $$$methodRef$$$26, this, e2);
                }
                UCPErrorHandler.throwUniversalConnectionPoolException(66, e2);
            }
        }
        finally {
            this.adjusterEnabled.set(true);
        }
        if (succeeded[0]) {
            return;
        }
        UCPErrorHandler.throwUniversalConnectionPoolException(66, cause[0].getCause());
    }

    final void closeAvailableInactive(long inactivityTimeout) {
        if (inactivityTimeout == 0L) {
            return;
        }
        int closed = 0;
        for (String poolServiceName : this.waitFreePools.keySet()) {
            for (CoreConnection conn : this.split(poolServiceName, this.connectionSource().inactiveConnectionsSelector(inactivityTimeout))) {
                conn.close();
                ++closed;
            }
        }
        if (closed > 0) {
            this.adjustLimits();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void replaceNonReusable() {
        this.adjusterEnabled.set(false);
        try {
            for (String poolServiceName : this.waitFreePools.keySet()) {
                for (CoreConnection conn : this.split(poolServiceName, new Selector(){
                    private static Executable $$$methodRef$$$0;
                    private static Logger $$$loggerRef$$$0;
                    private static Executable $$$methodRef$$$1;
                    private static Logger $$$loggerRef$$$1;

                    @Override
                    public boolean selected(CoreConnection conn) {
                        if (!conn.reusable()) {
                            if (conn.available()) {
                                conn.close();
                                return true;
                            }
                            conn.markToReplace();
                            return false;
                        }
                        return false;
                    }

                    static {
                        try {
                            $$$methodRef$$$1 = 10.class.getDeclaredConstructor(Core.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        try {
                            $$$methodRef$$$0 = 10.class.getDeclaredMethod("selected", CoreConnection.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    }
                })) {
                    this.growAvailableAsynch(conn.cri());
                }
            }
        }
        finally {
            this.adjusterEnabled.set(true);
        }
    }

    final void replaceAvailable() throws UniversalConnectionPoolException {
        this.replaceAvailable(false);
    }

    final void replaceInvalidAvailable() throws UniversalConnectionPoolException {
        this.replaceAvailable(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceAvailable(final boolean invalidOnly) throws UniversalConnectionPoolException {
        this.adjusterEnabled.set(false);
        try {
            for (String poolServiceName : this.waitFreePools.keySet()) {
                List<CoreConnection> closedConnections = this.split(poolServiceName, new Selector(){
                    private static Executable $$$methodRef$$$0;
                    private static Logger $$$loggerRef$$$0;
                    private static Executable $$$methodRef$$$1;
                    private static Logger $$$loggerRef$$$1;

                    @Override
                    public boolean selected(CoreConnection connection) {
                        if (!connection.available()) {
                            connection.markToReplace();
                            return false;
                        }
                        if (invalidOnly && connection.valid()) {
                            return false;
                        }
                        connection.close();
                        return true;
                    }

                    static {
                        try {
                            $$$methodRef$$$1 = 11.class.getDeclaredConstructor(Core.class, Boolean.TYPE);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        try {
                            $$$methodRef$$$0 = 11.class.getDeclaredMethod("selected", CoreConnection.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    }
                });
                for (CoreConnection connection : closedConnections) {
                    this.growAvailable(connection.cri());
                }
            }
        }
        finally {
            this.adjusterEnabled.set(true);
        }
    }

    void kickAdjuster() {
        if (!this.adjusterEnabled.get()) {
            return;
        }
        if (this.adjusterBusy.compareAndSet(false, true)) {
            UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                public void run() {
                    try {
                        Core.this.adjustLimits();
                    }
                    finally {
                        Core.this.adjusterBusy.set(false);
                    }
                }

                static {
                    try {
                        $$$methodRef$$$1 = 12.class.getDeclaredConstructor(Core.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 12.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            });
        }
    }

    int pendingAvailableGrows() {
        return this.pendingAvailableGrows.get();
    }

    @Supports(value={Feature.ABANDONED_CONN_TIMEOUT})
    final void returnAbandoned(int abandonedTimeout) {
        for (String poolServiceName : this.waitFreePools.keySet()) {
            this.forSome(poolServiceName, this.connectionSource().abandonedConnectionsSelector(abandonedTimeout), new Applicator(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                public void apply(CoreConnection conn) {
                    conn.handleTimeout();
                    conn.makeAvailable();
                }

                static {
                    try {
                        $$$methodRef$$$1 = 13.class.getDeclaredConstructor(Core.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 13.class.getDeclaredMethod("apply", CoreConnection.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            });
        }
    }

    @Supports(value={Feature.TTL_CONN_TIMEOUT})
    final void returnTTLed(int timeoutTTLed) {
        for (String poolServiceName : this.waitFreePools.keySet()) {
            this.forSome(poolServiceName, this.connectionSource().ttlConnectionsSelector(timeoutTTLed), new Applicator(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                public void apply(CoreConnection conn) {
                    conn.handleTimeout();
                    conn.makeAvailable();
                }

                static {
                    try {
                        $$$methodRef$$$1 = 14.class.getDeclaredConstructor(Core.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 14.class.getDeclaredMethod("apply", CoreConnection.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            });
        }
    }

    @Supports(value={Feature.CONN_HARVESTING})
    final void harvest(int triggerCount, int maxCount) {
        if (triggerCount >= 0 && triggerCount < Integer.MAX_VALUE && this.availableCount() <= triggerCount) {
            final int[] requestedConns = new int[]{maxCount};
            UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                public void run() {
                    block0: for (int i2 = 0; i2 < 5 * requestedConns[0] && requestedConns[0] > 0; ++i2) {
                        final long[] oldestLastAccessedTime = new long[]{Clock.clock()};
                        final boolean[] exhausted = new boolean[]{true};
                        for (String poolServiceName : Core.this.waitFreePools.keySet()) {
                            Core.this.forSome(poolServiceName, Selectors.and(Selectors.not(Core.this.connectionSource().availableConnectionsSelector()), Core.this.connectionSource().harvestableConnectionSelector()), new Applicator(){
                                private static Executable $$$methodRef$$$0;
                                private static Logger $$$loggerRef$$$0;
                                private static Executable $$$methodRef$$$1;
                                private static Logger $$$loggerRef$$$1;

                                @Override
                                public void apply(CoreConnection conn) {
                                    long lastAccessedTime = conn.lastAccessedTime();
                                    if (lastAccessedTime < oldestLastAccessedTime[0]) {
                                        oldestLastAccessedTime[0] = lastAccessedTime;
                                        exhausted[0] = false;
                                    }
                                }

                                static {
                                    try {
                                        $$$methodRef$$$1 = 1.class.getDeclaredConstructor(15.class, long[].class, boolean[].class);
                                    }
                                    catch (Throwable throwable) {}
                                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                    try {
                                        $$$methodRef$$$0 = 1.class.getDeclaredMethod("apply", CoreConnection.class);
                                    }
                                    catch (Throwable throwable) {}
                                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                }
                            });
                        }
                        if (exhausted[0]) break;
                        for (String poolServiceName : Core.this.waitFreePools.keySet()) {
                            if (requestedConns[0] <= 0) continue block0;
                            Core.this.forSome(poolServiceName, Selectors.and(Selectors.not(Core.this.connectionSource().availableConnectionsSelector()), Core.this.connectionSource().harvestableConnectionSelector(), new Selector(){
                                private static Executable $$$methodRef$$$0;
                                private static Logger $$$loggerRef$$$0;
                                private static Executable $$$methodRef$$$1;
                                private static Logger $$$loggerRef$$$1;

                                @Override
                                public boolean selected(CoreConnection connection) {
                                    return requestedConns[0] > 0;
                                }

                                static {
                                    try {
                                        $$$methodRef$$$1 = 2.class.getDeclaredConstructor(15.class);
                                    }
                                    catch (Throwable throwable) {}
                                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                    try {
                                        $$$methodRef$$$0 = 2.class.getDeclaredMethod("selected", CoreConnection.class);
                                    }
                                    catch (Throwable throwable) {}
                                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                }
                            }), new Applicator(){
                                private static Executable $$$methodRef$$$0;
                                private static Logger $$$loggerRef$$$0;
                                private static Executable $$$methodRef$$$1;
                                private static Logger $$$loggerRef$$$1;

                                @Override
                                public void apply(CoreConnection conn) {
                                    if (conn.lastAccessedTime() <= oldestLastAccessedTime[0]) {
                                        conn.cleanupToHarvest();
                                        conn.makeAvailable();
                                        requestedConns[0] = requestedConns[0] - 1;
                                    }
                                }

                                static {
                                    try {
                                        $$$methodRef$$$1 = 3.class.getDeclaredConstructor(15.class, long[].class);
                                    }
                                    catch (Throwable throwable) {}
                                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                    try {
                                        $$$methodRef$$$0 = 3.class.getDeclaredMethod("apply", CoreConnection.class);
                                    }
                                    catch (Throwable throwable) {}
                                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                }
                            });
                        }
                    }
                }

                static {
                    try {
                        $$$methodRef$$$1 = 15.class.getDeclaredConstructor(Core.class, int[].class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 15.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            });
        }
    }

    final boolean retrieve(final CoreConnection connection) {
        return null != this.retrieveFirst(connection.serviceName(), new Selector(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public boolean selected(CoreConnection selectedConnection) {
                if (connection.available()) {
                    return false;
                }
                return connection == selectedConnection;
            }

            static {
                try {
                    $$$methodRef$$$1 = 16.class.getDeclaredConstructor(Core.class, CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 16.class.getDeclaredMethod("selected", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        });
    }

    final CoreConnection findSpecificConnection(Object physicalConn) {
        final CoreConnection[] selectedConn = new CoreConnection[]{null};
        for (String poolServiceName : this.waitFreePools.keySet()) {
            this.forFirst(poolServiceName, Selectors.and(Selectors.not(this.connectionSource().availableConnectionsSelector()), this.connectionSource().physicalConnectionSelector(physicalConn)), new Applicator(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                public void apply(CoreConnection conn) {
                    selectedConn[0] = conn;
                }

                static {
                    try {
                        $$$methodRef$$$1 = 17.class.getDeclaredConstructor(Core.class, CoreConnection[].class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 17.class.getDeclaredMethod("apply", CoreConnection.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            });
        }
        return selectedConn[0];
    }

    final void closeAll() {
        this.keepOverMinimum.set(false);
        for (String poolServiceName : this.waitFreePools.keySet()) {
            this.split(poolServiceName, new Selector(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                public boolean selected(CoreConnection connection) {
                    connection.abort();
                    connection.close();
                    return true;
                }

                static {
                    try {
                        $$$methodRef$$$1 = 18.class.getDeclaredConstructor(Core.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 18.class.getDeclaredMethod("selected", CoreConnection.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            });
        }
    }

    void adjustLimits() {
        this.adjustMinLimit(10);
        this.adjustMaxLimit();
    }

    /*
     * WARNING - void declaration
     */
    void adjustMinLimit(int n2) {
        void attempts;
        boolean bl = (0x6000000000000L & TraceControllerImpl.feature) != 0L;
        Limits limits = this.limits();
        Policies policies = this.policies();
        if (this.keepOverMinimum.get()) {
            while (this.totalCount().get() + this.pendingBorrowedGrows.get() + this.pendingAvailableGrows.get() < limits.getMin()) {
                try {
                    if (bl) {
                        ClioSupport.ilogFine($$$loggerRef$$$41, Core.class, $$$methodRef$$$41, this, "growing...");
                    }
                    this.growAvailable(policies.getMostPopularCri(), attempts < 3);
                    if (!bl) continue;
                    ClioSupport.ilogFine($$$loggerRef$$$41, Core.class, $$$methodRef$$$41, this, "grew up 1 connection to reach the minimum");
                }
                catch (UniversalConnectionPoolException e2) {
                    if (!bl) break;
                    ClioSupport.ilogThrowing($$$loggerRef$$$41, Core.class, $$$methodRef$$$41, this, e2);
                    break;
                }
            }
        }
        if (this.totalCount().get() + this.pendingBorrowedGrows.get() + this.pendingAvailableGrows.get() < limits.getMin() && attempts > 0) {
            block8: {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e3) {
                    if (!bl) break block8;
                    ClioSupport.ilogThrowing($$$loggerRef$$$41, Core.class, $$$methodRef$$$41, this, e3);
                }
            }
            UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>((int)attempts){
                final /* synthetic */ int val$attempts;
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                {
                    this.val$attempts = n2;
                }

                @Override
                public void run() {
                    Core.this.adjustMinLimit(this.val$attempts - 1);
                }

                static {
                    try {
                        $$$methodRef$$$1 = 19.class.getDeclaredConstructor(Core.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 19.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            });
        }
    }

    void adjustMaxLimit() {
        boolean bl = (0x6000000000000L & TraceControllerImpl.feature) != 0L;
        final Limits limits = this.limits();
        for (String poolServiceName : this.waitFreePools.keySet()) {
            for (CoreConnection connection : this.split(poolServiceName, new Selector(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                public boolean selected(CoreConnection conn) {
                    if (!conn.available()) {
                        return false;
                    }
                    return Core.this.totalCount().get() + Core.this.pendingBorrowedGrows.get() + Core.this.pendingAvailableGrows.get() > limits.getMax();
                }

                static {
                    try {
                        $$$methodRef$$$1 = 20.class.getDeclaredConstructor(Core.class, Limits.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 20.class.getDeclaredMethod("selected", CoreConnection.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            })) {
                connection.close();
                if (!bl) continue;
                ClioSupport.ilogFine($$$loggerRef$$$42, Core.class, $$$methodRef$$$42, this, "closed one connection to stay under max limit");
            }
        }
    }

    private Counter totalCount() {
        return this.connectionSource().totalCount();
    }

    private int borrowedCount() {
        return this.connectionSource().borrowedCount().get();
    }

    int availableCount() {
        return this.totalCount().get() - this.borrowedCount();
    }

    public long repurposeCount() {
        return this.repurposeCount.get();
    }

    void start(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        ConnectionSource cs = this.connectionSource();
        cs.start(cri);
        final ConnectionRetrievalInfo defaultCri = cs.defaultCri();
        this.plugPolicies(new Policies(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            public ConnectionRetrievalInfo getMostPopularCri() {
                return defaultCri;
            }

            @Override
            public boolean isCriUnpopular(ConnectionRetrievalInfo cri) {
                return !defaultCri.equals(cri);
            }

            static {
                try {
                    $$$methodRef$$$2 = 21.class.getDeclaredConstructor(Core.class, ConnectionRetrievalInfo.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 21.class.getDeclaredMethod("isCriUnpopular", ConnectionRetrievalInfo.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 21.class.getDeclaredMethod("getMostPopularCri", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        });
    }

    void stop() {
        this.connectionSource().stop();
        this.waitFreePools.clear();
    }

    boolean available(ConnectionRetrievalInfo cri) {
        ConnectionSource cs = this.connectionSource();
        if (!cs.validateCri(cri)) {
            return false;
        }
        return cs.available(cri);
    }

    static {
        try {
            $$$methodRef$$$66 = Core.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$66 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$65 = Core.class.getDeclaredMethod("access$1500", Core.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$65 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$64 = Core.class.getDeclaredMethod("access$1400", Core.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$64 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$63 = Core.class.getDeclaredMethod("access$1300", Core.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$63 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$62 = Core.class.getDeclaredMethod("access$1200", Core.class, ConnectionRetrievalInfo.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$62 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$61 = Core.class.getDeclaredMethod("access$1100", Core.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$61 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$60 = Core.class.getDeclaredMethod("access$1000", Core.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$60 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$59 = Core.class.getDeclaredMethod("access$900", Core.class, String.class, Selector.class, Applicator.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$59 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$58 = Core.class.getDeclaredMethod("access$800", Core.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$57 = Core.class.getDeclaredMethod("access$700", Core.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$56 = Core.class.getDeclaredMethod("access$600", Core.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$55 = Core.class.getDeclaredMethod("access$500", Core.class, String.class, Selector.class, Applicator.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$54 = Core.class.getDeclaredMethod("access$400", Core.class, ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$53 = Core.class.getDeclaredMethod("access$300", Core.class, CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$52 = Core.class.getDeclaredMethod("access$200", Core.class, String.class, Selector.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$51 = Core.class.getDeclaredMethod("access$100", Core.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$50 = Core.class.getDeclaredMethod("access$000", Core.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$49 = Core.class.getDeclaredMethod("available", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$48 = Core.class.getDeclaredMethod("stop", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$47 = Core.class.getDeclaredMethod("start", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$46 = Core.class.getDeclaredMethod("repurposeCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$45 = Core.class.getDeclaredMethod("availableCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$44 = Core.class.getDeclaredMethod("borrowedCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$43 = Core.class.getDeclaredMethod("totalCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$42 = Core.class.getDeclaredMethod("adjustMaxLimit", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$41 = Core.class.getDeclaredMethod("adjustMinLimit", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$40 = Core.class.getDeclaredMethod("adjustLimits", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$39 = Core.class.getDeclaredMethod("closeAll", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$38 = Core.class.getDeclaredMethod("findSpecificConnection", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$37 = Core.class.getDeclaredMethod("retrieve", CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$36 = Core.class.getDeclaredMethod("harvest", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$35 = Core.class.getDeclaredMethod("returnTTLed", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$34 = Core.class.getDeclaredMethod("returnAbandoned", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$33 = Core.class.getDeclaredMethod("pendingAvailableGrows", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$32 = Core.class.getDeclaredMethod("kickAdjuster", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$31 = Core.class.getDeclaredMethod("replaceAvailable", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$30 = Core.class.getDeclaredMethod("replaceInvalidAvailable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$29 = Core.class.getDeclaredMethod("replaceAvailable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$28 = Core.class.getDeclaredMethod("replaceNonReusable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$27 = Core.class.getDeclaredMethod("closeAvailableInactive", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$26 = Core.class.getDeclaredMethod("initialize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$25 = Core.class.getDeclaredMethod("growAvailableAsynch", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$24 = Core.class.getDeclaredMethod("growAvailable", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$23 = Core.class.getDeclaredMethod("growAvailable", ConnectionRetrievalInfo.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$22 = Core.class.getDeclaredMethod("makeRoom", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$21 = Core.class.getDeclaredMethod("tryRepurpose", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$20 = Core.class.getDeclaredMethod("prepareRebalanceHandler", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$19 = Core.class.getDeclaredMethod("prepareFailoverHandler", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$18 = Core.class.getDeclaredMethod("growBorrowed", ConnectionRetrievalInfo.class, ConnectionAffinityCallback.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$17 = Core.class.getDeclaredMethod("reclaim", CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$16 = Core.class.getDeclaredMethod("updateRLBStats", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$15 = Core.class.getDeclaredMethod("borrow", ConnectionRetrievalInfo.class, ConnectionAffinityCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$14 = Core.class.getDeclaredMethod("policies", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$13 = Core.class.getDeclaredMethod("plugPolicies", Policies.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$12 = Core.class.getDeclaredMethod("limits", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$11 = Core.class.getDeclaredMethod("plugLimits", Limits.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$10 = Core.class.getDeclaredMethod("connectionSource", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$9 = Core.class.getDeclaredMethod("plugConnectionSource", ConnectionSource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$8 = Core.class.getDeclaredMethod("registerService", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$7 = Core.class.getDeclaredMethod("retrieveFirst", String.class, Selector.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$6 = Core.class.getDeclaredMethod("forFirst", String.class, Selector.class, Applicator.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$5 = Core.class.getDeclaredMethod("forFirst", String.class, Selector.class, Applicator.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$4 = Core.class.getDeclaredMethod("forSome", String.class, Selector.class, Applicator.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$3 = Core.class.getDeclaredMethod("split", String.class, Selector.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$2 = Core.class.getDeclaredMethod("forEach", String.class, Applicator.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$1 = Core.class.getDeclaredMethod("put", CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$0 = Core.class.getDeclaredMethod("waitFreePool", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        isAffinityStrict = Util.isAffinityStrict();
    }
}

