/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.io.InputStream;
import java.lang.reflect.Executable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ucp.common.ServiceMember;

@DefaultLogger(value="oracle.ucp.common")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT, Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public class Chunk {
    private final String name;
    private final AtomicInteger version = new AtomicInteger(0);
    private final Map<Integer, Set<ServiceMember>> instancesWithPriority = new ConcurrentHashMap<Integer, Set<ServiceMember>>();
    private final AtomicInteger minPriority = new AtomicInteger(-1);
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;

    Chunk(String name) {
        this.name = name;
    }

    Chunk(String name, int version) {
        this.name = name;
        this.version.set(version);
    }

    boolean hasInstance(ServiceMember instance) {
        return this.instancesWithPriority.entrySet().stream().anyMatch(e2 -> ((Set)e2.getValue()).contains(instance));
    }

    int instancePriority(ServiceMember instance) {
        if (instance == null) {
            return Integer.MAX_VALUE;
        }
        return this.instancesWithPriority.entrySet().stream().filter(e2 -> ((Set)e2.getValue()).contains(instance)).mapToInt(e2 -> (Integer)e2.getKey()).findFirst().orElse(Integer.MAX_VALUE);
    }

    void addInstanceWithPriority(ServiceMember instance, int priority) {
        this.instancesWithPriority.computeIfAbsent(new Integer(priority), k2 -> Collections.newSetFromMap(new ConcurrentHashMap())).add(instance);
        this.minPriority.set((Integer)this.instancesWithPriority.keySet().stream().min(Integer::compareTo).get());
    }

    void removeInstance(ServiceMember instance) {
        this.instancesWithPriority.entrySet().stream().forEach(e2 -> ((Set)e2.getValue()).remove(instance));
        this.instancesWithPriority.values().removeIf(v2 -> v2.size() == 0);
        this.minPriority.set(this.instancesWithPriority.keySet().stream().min(Integer::compareTo).orElse(0));
    }

    Set<ServiceMember> priorityInstances() {
        return this.instancesWithPriority.get(new Integer(this.minPriority.get()));
    }

    @DisableTrace
    public Set<ServiceMember> instances() {
        HashSet<ServiceMember> allInstances = new HashSet<ServiceMember>();
        this.instancesWithPriority.values().forEach(v2 -> allInstances.addAll((Collection<ServiceMember>)v2));
        return allInstances;
    }

    @DisableTrace
    String name() {
        return this.name + (this.version() == 0 ? "" : "-" + this.version.get());
    }

    @DisableTrace
    int version() {
        return this.version.get();
    }

    void setVersion(int version) {
        this.version.set(version);
    }

    @DisableTrace
    String absoluteName() {
        if (!this.name.contains("-")) {
            return this.name;
        }
        return this.name.substring(0, this.name.indexOf("-"));
    }

    @DisableTrace
    public String toString() {
        return this.name() + "\t\t [" + this.instancesWithPriority.entrySet().stream().filter(k2 -> k2 != null && k2.getKey() != null && k2.getValue() != null).map(k2 -> " Priority " + k2.getKey() + ": <" + ((Set)k2.getValue()).stream().map(sm -> sm.name()).collect(Collectors.joining(", ")) + ">").collect(Collectors.joining(", ")) + " ]";
    }

    @DisableTrace
    String toHTMLString() {
        return "<td>" + this.name() + "</td>" + "<td>" + this.instancesWithPriority.entrySet().stream().filter(k2 -> k2 != null && k2.getKey() != null && k2.getValue() != null).map(k2 -> " Priority " + k2.getKey() + ": <" + ((Set)k2.getValue()).stream().map(sm -> sm.name()).collect(Collectors.joining(", ")) + ">").collect(Collectors.joining(", ")) + "</td>";
    }

    public boolean hasPriorityInstance(ServiceMember instance) {
        if (instance == null) {
            return false;
        }
        if (this.priorityInstances() == null) {
            return false;
        }
        return this.priorityInstances().contains(instance);
    }

    static {
        try {
            $$$methodRef$$$21 = Chunk.class.getDeclaredConstructor(String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$20 = Chunk.class.getDeclaredConstructor(String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$19 = Chunk.class.getDeclaredMethod("lambda$hasInstance$0", ServiceMember.class, Map.Entry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$18 = Chunk.class.getDeclaredMethod("lambda$instancePriority$1", ServiceMember.class, Map.Entry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$17 = Chunk.class.getDeclaredMethod("lambda$instancePriority$2", Map.Entry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$16 = Chunk.class.getDeclaredMethod("lambda$addInstanceWithPriority$3", Integer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$15 = Chunk.class.getDeclaredMethod("lambda$removeInstance$4", ServiceMember.class, Map.Entry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$14 = Chunk.class.getDeclaredMethod("lambda$removeInstance$5", Set.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$13 = Chunk.class.getDeclaredMethod("lambda$instances$6", Set.class, Set.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$12 = Chunk.class.getDeclaredMethod("lambda$toString$7", Map.Entry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$11 = Chunk.class.getDeclaredMethod("lambda$null$8", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$10 = Chunk.class.getDeclaredMethod("lambda$toString$9", Map.Entry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$9 = Chunk.class.getDeclaredMethod("lambda$toHTMLString$10", Map.Entry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$8 = Chunk.class.getDeclaredMethod("lambda$null$11", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$7 = Chunk.class.getDeclaredMethod("lambda$toHTMLString$12", Map.Entry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$6 = Chunk.class.getDeclaredMethod("hasPriorityInstance", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$5 = Chunk.class.getDeclaredMethod("setVersion", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$4 = Chunk.class.getDeclaredMethod("priorityInstances", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$3 = Chunk.class.getDeclaredMethod("removeInstance", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$2 = Chunk.class.getDeclaredMethod("addInstanceWithPriority", ServiceMember.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$1 = Chunk.class.getDeclaredMethod("instancePriority", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$0 = Chunk.class.getDeclaredMethod("hasInstance", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
    }

    public static final class Metadata {
        String chunkName;
        InputStream shardKeyLow;
        InputStream shardKeyHigh;
        InputStream superKeyLow;
        InputStream superKeyHigh;
        int priority;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;

        public void setChunkName(String chunkName) {
            this.chunkName = chunkName;
        }

        public void setShardKeyLow(InputStream shardKeyLow) {
            this.shardKeyLow = shardKeyLow;
        }

        public void setShardKeyHigh(InputStream shardKeyHigh) {
            this.shardKeyHigh = shardKeyHigh;
        }

        public void setSuperKeyLow(InputStream superKeyLow) {
            this.superKeyLow = superKeyLow;
        }

        public void setSuperKeyHigh(InputStream superKeyHigh) {
            this.superKeyHigh = superKeyHigh;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        static {
            try {
                $$$methodRef$$$6 = Metadata.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$5 = Metadata.class.getDeclaredMethod("setPriority", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$4 = Metadata.class.getDeclaredMethod("setSuperKeyHigh", InputStream.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$3 = Metadata.class.getDeclaredMethod("setSuperKeyLow", InputStream.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$2 = Metadata.class.getDeclaredMethod("setShardKeyHigh", InputStream.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = Metadata.class.getDeclaredMethod("setShardKeyLow", InputStream.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = Metadata.class.getDeclaredMethod("setChunkName", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    }
}

