/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.admin;

import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.console.DMSConsole;
import oracle.dms.console.NounFactoryIntf;
import oracle.dms.instrument.NounIntf;
import oracle.dms.instrument.State;
import oracle.dms.instrument.StateIntf;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.ConnectionLabelingCallback;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolAdapter;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalConnectionPoolStatistics;
import oracle.ucp.admin.MetricsUpdateTimerTask;
import oracle.ucp.admin.UniversalConnectionPoolManager;
import oracle.ucp.common.UniversalConnectionPoolBase;
import oracle.ucp.jdbc.ConnectionInitializationCallback;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionPool;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionPoolStatistics;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.TaskManager;
import oracle.ucp.util.TimerHandle;
import oracle.ucp.util.TimerManager;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.UCPTaskManagerImpl;
import oracle.ucp.util.UCPTimerManagerImpl;
import oracle.ucp.util.UniqueIdentifier;
import oracle.ucp.util.logging.UCPLoggerFactory;

@DefaultLogger(value="oracle.ucp.admin")
@Supports(value={Feature.ADMIN})
public abstract class UniversalConnectionPoolManagerBase
implements UniversalConnectionPoolManager {
    private static final boolean DEFAULT_IS_JMX_ENABLED = true;
    private static final boolean DEFAULT_LOCAL_METRIC_CONSOLE = true;
    private static final int DEFAULT_METRIC_UPDATE_INTERVAL = 60;
    private boolean m_jmxFlag = true;
    private boolean m_localMetricConsole = true;
    private int m_metricInterval = 60;
    private static final String UCP_METRIC_NAME = "/UCP_METRIC";
    private static final String MGR_PREFIX;
    private DMSConsole m_metricConsole = null;
    private TimerHandle m_updateMetricTimer = null;
    private boolean m_metricsPostingThread = false;
    protected final Map<String, UniversalConnectionPool> m_connPool = Collections.synchronizedMap(new HashMap());
    protected final Map<String, String> m_mappedPoolNames = new HashMap<String, String>();
    private static final Map<UCPMetric, String> m_ucpMetrics;
    private final Hashtable<String, NounIntf> m_parentNouns = new Hashtable();
    private final ArrayList<String> m_metricPools = new ArrayList();
    static final String TOTAL_CONN_NAME = "TotalConnectionsCount";
    static final String TOTAL_CONN_UNITS = "ConnectionsCount";
    static final String TOTAL_CONN_DESC = "Total number of connections in the pool";
    static final String AVAILABLE_CONN_NAME = "AvailableConnectionsCount";
    static final String AVAILABLE_CONN_UNITS = "ConnectionsCount";
    static final String AVAILABLE_CONN_DESC = "Total number of available connections in the pool";
    static final String BORROWED_CONN_NAME = "BorrowedConnectionsCount";
    static final String BORROWED_CONN_UNITS = "ConnectionsCount";
    static final String BORROWED_CONN_DESC = "Total number of borrowed connections in the pool";
    static final String AVERAGE_BORROWED_CONN_NAME = "AverageBorrowedConnectionsCount";
    static final String AVERAGE_BORROWED_CONN_UNITS = "ConnectionsCount";
    static final String AVERAGE_BORROWED_CONN_DESC = "Average count for borrowed connections in the pool";
    static final String PEAK_CONN_NAME = "PeakConnectionsCount";
    static final String PEAK_CONN_UNITS = "ConnectionsCount";
    static final String PEAK_CONN_DESC = "Peak connections count in the pool";
    static final String REMAINING_CONN_NAME = "RemainingPoolCapacityCount";
    static final String REMAINING_CONN_UNITS = "ConnectionsCount";
    static final String REMAINING_CONN_DESC = "Remaining pool capacity count for the pool";
    static final String LABELED_CONN_NAME = "LabeledConnectionsCount";
    static final String LABELED_CONN_UNITS = "ConnectionsCount";
    static final String LABELED_CONN_DESC = "Total number of labeled connections in the pool";
    static final String CREATED_CONN_NAME = "ConnectionsCreatedCount";
    static final String CREATED_CONN_UNITS = "ConnectionsCount";
    static final String CREATED_CONN_DESC = "Total number of connections created in the pool";
    static final String CLOSED_CONN_NAME = "ConnectionsClosedCount";
    static final String CLOSED_CONN_UNITS = "ConnectionsCount";
    static final String CLOSED_CONN_DESC = "Total number of closed connections in the pool";
    static final String AVG_CONN_WAIT_NAME = "AverageConnectionWaitTime";
    static final String AVG_CONN_WAIT_UNITS = "Seconds";
    static final String AVG_CONN_WAIT_DESC = "Average connection wait time in the pool";
    static final String PEAK_CONN_WAIT_NAME = "PeakConnectionWaitTime";
    static final String PEAK_CONN_WAIT_UNITS = "Seconds";
    static final String PEAK_CONN_WAIT_DESC = "Peak Connection wait time in the pool";
    static final String ABANDONED_CONN_NAME = "AbandonedConnectionsCount";
    static final String ABANDONED_CONN_UNITS = "ConnectionsCount";
    static final String ABANDONED_CONN_DESC = "Total number of abandoned connections in the pool";
    static final String PENDING_REQUEST_NAME = "PendingRequestsCount";
    static final String PENDING_REQUEST_UNITS = "ConnectionsCount";
    static final String PENDING_REQUEST_DESC = "Total number of pending requests count in the pool";
    static final String CUMULATIVE_CONN_WAIT_NAME = "CumulativeConnectionWaitTime";
    static final String CUMULATIVE_CONN_WAIT_UNITS = "Seconds";
    static final String CUMULATIVE_CONN_WAIT_DESC = "Cumulative connection wait time for the pool";
    static final String CUMULATIVE_CONN_BORROWED_NAME = "CumulativeConnectionBorrowedCount";
    static final String CUMULATIVE_CONN_BORROWED_UNITS = "ConnectionsCount";
    static final String CUMULATIVE_CONN_BORROWED_DESC = "Cumulative connection borrowed count for the pool";
    static final String CUMULATIVE_CONN_USE_NAME = "CumulativeConnectionUseTime";
    static final String CUMULATIVE_CONN_USE_UNITS = "Seconds";
    static final String CUMULATIVE_CONN_USE_DESC = "Cumulative connection use time for the pool";
    static final String CUMULATIVE_CONN_RETURNED_NAME = "CumulativeConnectionReturnedCount";
    static final String CUMULATIVE_CONN_RETURNED_UNITS = "ConnectionsCount";
    static final String CUMULATIVE_CONN_RETURNED_DESC = "Cumulative connection returned count in the pool";
    static final String CUMULATIVE_SUCCESS_CONN_WAIT_NAME = "CumulativeSuccessfulConnectionWaitTime";
    static final String CUMULATIVE_SUCCESS_CONN_WAIT_UNITS = "Seconds";
    static final String CUMULATIVE_SUCCESS_CONN_WAIT_DESC = "Cumulative successful connection wait time for the pool";
    static final String CUMULATIVE_SUCCESS_CONN_WAIT_COUNT_NAME = "CumulativeSuccessfulConnectionWaitCount";
    static final String CUMULATIVE_SUCCESS_CONN_WAIT_COUNT_UNITS = "ConnectionsCount";
    static final String CUMULATIVE_SUCCESS_CONN_WAIT_COUNT_DESC = "Cumulative successful connection wait count for the pool";
    static final String CUMULATIVE_FAILED_CONN_WAIT_NAME = "CumulativeFailedConnectionWaitTime";
    static final String CUMULATIVE_FAILED_CONN_WAIT_UNITS = "Seconds";
    static final String CUMULATIVE_FAILED_CONN_WAIT_DESC = "Cumulative failed connection wait time for the pool";
    static final String CUMULATIVE_FAILED_CONN_WAIT_COUNT_NAME = "CumulativeFailedConnectionWaitCount";
    static final String CUMULATIVE_FAILED_CONN_WAIT_COUNT_UNITS = "ConnectionsCount";
    static final String CUMULATIVE_FAILED_CONN_WAIT_COUNT_DESC = "Cumulative failed connection wait count for the pool";
    static final String SUCCESSFUL_AFFINITYBASED_BORROW_COUNT_NAME = "SuccessfulAffinityBasedBorrowCount";
    static final String SUCCESSFUL_AFFINITYBASED_BORROW_COUNT_UNITS = "ConnectionsCount";
    static final String SUCCESSFUL_AFFINITYBASED_BORROW_COUNT_DESC = "Number of borrow requests succeeded with matching affinity contexts.";
    static final String FAILED_AFFINITYBASED_BORROW_COUNT_NAME = "FailedAffinityBasedBorrowCount";
    static final String FAILED_AFFINITYBASED_BORROW_COUNT_UNITS = "ConnectionsCount";
    static final String FAILED_AFFINITYBASED_BORROW_COUNT_DESC = "Number of borrow requests that returned connections not matching the affinity contexts.";
    static final String SUCCESSFUL_RCLBBASED_BORROW_COUNT_NAME = "SuccessfulRCLBBasedBorrowCount";
    static final String SUCCESSFUL_RCLBBASED_BORROW_COUNT_UNITS = "ConnectionsCount";
    static final String SUCCESSFUL_RCLBBASED_BORROW_COUNT_DESC = "Number of borrow requests succeeded using Runtime Connection Load-Balancing (RCLB) algorithms.";
    static final String FAILED_RCLBBASED_BORROW_COUNT_NAME = "FailedRCLBBasedBorrowCount";
    static final String FAILED_RCLBBASED_BORROW_COUNT_UNITS = "ConnectionsCount";
    static final String FAILED_RCLBBASED_BORROW_COUNT_DESC = "Number of borrow requests failed using Runtime Connection Load-Balancing (RCLB) algorithms.";
    private static TimerManager m_timerManager;
    private static TaskManager m_taskManager;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;

    @Override
    public void startConnectionPool(String poolName) throws UniversalConnectionPoolException {
        UniversalConnectionPool pool;
        String uniquePoolID = this.getManagerPoolID(poolName);
        UniversalConnectionPool universalConnectionPool = pool = uniquePoolID != null ? this.m_connPool.get(uniquePoolID) : null;
        if (pool != null) {
            pool.start();
        } else {
            UCPErrorHandler.throwUniversalConnectionPoolException(351);
        }
    }

    @Override
    public void stopConnectionPool(String poolName) throws UniversalConnectionPoolException {
        UniversalConnectionPool pool;
        String uniquePoolID = this.getManagerPoolID(poolName);
        UniversalConnectionPool universalConnectionPool = pool = uniquePoolID != null ? this.m_connPool.get(uniquePoolID) : null;
        if (pool != null) {
            pool.stop();
            if (this.m_metricPools.contains(uniquePoolID)) {
                this.stopMetricsCollection(poolName);
            }
        } else {
            UCPErrorHandler.throwUniversalConnectionPoolException(351);
        }
    }

    @Override
    public void refreshConnectionPool(String poolName) throws UniversalConnectionPoolException {
        UniversalConnectionPool pool;
        String uniquePoolID = this.getManagerPoolID(poolName);
        UniversalConnectionPool universalConnectionPool = pool = uniquePoolID != null ? this.m_connPool.get(uniquePoolID) : null;
        if (pool != null) {
            pool.refresh();
        } else {
            UCPErrorHandler.throwUniversalConnectionPoolException(351);
        }
    }

    @Override
    public void recycleConnectionPool(String poolName) throws UniversalConnectionPoolException {
        UniversalConnectionPool pool;
        String uniquePoolID = this.getManagerPoolID(poolName);
        UniversalConnectionPool universalConnectionPool = pool = uniquePoolID != null ? this.m_connPool.get(uniquePoolID) : null;
        if (pool != null) {
            pool.recycle();
        } else {
            UCPErrorHandler.throwUniversalConnectionPoolException(351);
        }
    }

    @Override
    public void purgeConnectionPool(String poolName) throws UniversalConnectionPoolException {
        UniversalConnectionPool pool;
        String uniquePoolID = this.getManagerPoolID(poolName);
        UniversalConnectionPool universalConnectionPool = pool = uniquePoolID != null ? this.m_connPool.get(uniquePoolID) : null;
        if (pool != null) {
            pool.purge();
        } else {
            UCPErrorHandler.throwUniversalConnectionPoolException(351);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void destroyConnectionPool(String string) throws UniversalConnectionPoolException {
        void poolName;
        block6: {
            boolean bl;
            boolean bl2 = bl = (0x4000000000000000L & TraceControllerImpl.feature) != 0L;
            if (poolName == null) {
                throw UCPErrorHandler.newUniversalConnectionPoolException(54);
            }
            try {
                this.stopConnectionPool((String)poolName);
            }
            catch (UniversalConnectionPoolException ucpe) {
                if (!bl) break block6;
                ClioSupport.ilogThrowing($$$loggerRef$$$5, UniversalConnectionPoolManagerBase.class, $$$methodRef$$$5, this, ucpe);
            }
        }
        this.m_connPool.remove(this.getManagerPoolID((String)poolName));
        Map<String, String> map = this.m_mappedPoolNames;
        synchronized (map) {
            this.m_mappedPoolNames.remove(poolName);
        }
    }

    @Override
    public void reconfigureConnectionPool(String poolName, Properties configuration) throws UniversalConnectionPoolException {
        String uniquePoolID = this.getManagerPoolID(poolName);
        try {
            this.applyConfiguration(uniquePoolID, configuration);
        }
        catch (Exception e2) {
            UCPErrorHandler.throwUniversalConnectionPoolException(388, e2);
        }
    }

    private void applyConfiguration(String uniquePoolID, Properties poolProperties) throws Exception {
        UniversalConnectionPoolBase pool;
        UniversalConnectionPoolBase universalConnectionPoolBase = pool = uniquePoolID != null ? (UniversalConnectionPoolBase)this.m_connPool.get(uniquePoolID) : null;
        if (pool != null) {
            String property = null;
            try {
                block77: for (Map.Entry<Object, Object> poolProperty : poolProperties.entrySet()) {
                    switch (property = (String)poolProperty.getKey()) {
                        case "user": 
                        case "password": 
                        case "url": 
                        case "connectionFactoryClassName": 
                        case "connectionFactoryProperties": 
                        case "connectionProperties": {
                            break;
                        }
                        case "initialPoolSize": {
                            pool.setInitialPoolSize(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        case "minPoolSize": {
                            pool.setMinPoolSize(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        case "maxPoolSize": {
                            pool.setMaxPoolSize(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        case "maxConnectionReuseCount": {
                            pool.setMaxConnectionReuseCount(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        case "maxConnectionReuseTime": {
                            pool.setMaxConnectionReuseTime(Long.parseLong((String)poolProperty.getValue()));
                            break;
                        }
                        case "fastConnectionFailoverEnabled": {
                            pool.setFailoverEnabled(Boolean.parseBoolean((String)poolProperty.getValue()));
                            break;
                        }
                        case "abandonedConnectionTimeout": {
                            pool.setAbandonedConnectionTimeout(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        case "connectionHarvestMaxCount": {
                            pool.setConnectionHarvestMaxCount(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        case "connectionHarvestTriggerCount": {
                            pool.setConnectionHarvestTriggerCount(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        case "inactiveConnectionTimeout": {
                            pool.setInactiveConnectionTimeout(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        case "connectionWaitTimeout": {
                            pool.setConnectionWaitTimeout(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        case "validateConnectionOnBorrow": {
                            pool.setValidateConnectionOnBorrow(Boolean.parseBoolean((String)poolProperty.getValue()));
                            break;
                        }
                        case "timeoutCheckInterval": {
                            pool.setTimeoutCheckInterval(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        case "propertyCycle": {
                            pool.setTimeoutCheckInterval(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        case "timeToLiveConnectionTimeout": {
                            pool.setTimeToLiveConnectionTimeout(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        case "highCostConnectionReuseThreshold": {
                            pool.setHighCostConnectionReuseThreshold(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        case "connectionLabelingHighCost": {
                            pool.setConnectionLabelingHighCost(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        case "onsConfiguration": {
                            pool.setONSConfiguration((String)poolProperty.getValue());
                            break;
                        }
                        case "maxIdleTime": {
                            pool.setInactiveConnectionTimeout(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        case "maxStatements": {
                            if (!(pool instanceof JDBCConnectionPool)) continue block77;
                            ((JDBCConnectionPool)pool).setMaxStatements(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        case "sqlForValidateConnection": {
                            if (!(pool instanceof JDBCConnectionPool)) continue block77;
                            ((JDBCConnectionPool)pool).setSQLForValidateConnection((String)poolProperty.getValue());
                            break;
                        }
                        case "connectionInitializationCallback": {
                            if (!(pool instanceof JDBCConnectionPool)) continue block77;
                            try {
                                ((JDBCConnectionPool)pool).unregisterConnectionInitializationCallback();
                                String initializationClassName = (String)poolProperty.getValue();
                                if (initializationClassName == null || "".equals(initializationClassName)) continue block77;
                                Class<?> initializationClass = Class.forName(initializationClassName);
                                ConnectionInitializationCallback initializationObject = (ConnectionInitializationCallback)initializationClass.newInstance();
                                ((JDBCConnectionPool)pool).registerConnectionInitializationCallback(initializationObject);
                                break;
                            }
                            catch (Exception e1) {
                                throw new IllegalArgumentException("Invalid property value " + property);
                            }
                        }
                        case "connectionLabelingCallback": {
                            try {
                                pool.removeConnectionLabelingCallback();
                                String labelingClassName = (String)poolProperty.getValue();
                                if (labelingClassName == null || "".equals(labelingClassName)) continue block77;
                                Class<?> labelingClass = Class.forName(labelingClassName);
                                ConnectionLabelingCallback labelingObject = (ConnectionLabelingCallback)labelingClass.newInstance();
                                pool.registerConnectionLabelingCallback(labelingObject);
                                break;
                            }
                            catch (Exception e1) {
                                throw new IllegalArgumentException("Invalid property value " + property);
                            }
                        }
                        case "connectionAffinityCallback": {
                            try {
                                pool.removeConnectionAffinityCallback();
                                String affinityClassName = (String)poolProperty.getValue();
                                if (affinityClassName == null || "".equals(affinityClassName)) continue block77;
                                Class<?> affinityClass = Class.forName(affinityClassName);
                                ConnectionAffinityCallback affinityObject = (ConnectionAffinityCallback)affinityClass.newInstance();
                                pool.registerConnectionAffinityCallback(affinityObject);
                                break;
                            }
                            catch (Exception e2) {
                                throw new IllegalArgumentException("Invalid property value " + property);
                            }
                        }
                        case "loginTimeout": {
                            pool.setLoginTimeout(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        case "secondsToTrustIdleConnection": {
                            break;
                        }
                        case "connectionRepurposeThreshold": {
                            pool.setConnectionRepurposeThreshold(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        case "maxConnectionsPerService": {
                            pool.setMaxConnectionsPerService(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        case "maxConnectionsPerShard": {
                            pool.setMaxConnectionsPerShard(Integer.parseInt((String)poolProperty.getValue()));
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid property name " + property);
                        }
                    }
                }
                if (poolProperties.containsKey("secondsToTrustIdleConnection")) {
                    pool.setSecondsToTrustIdleConnection(Integer.parseInt((String)poolProperties.get("secondsToTrustIdleConnection")));
                }
            }
            catch (ClassCastException e3) {
                throw new IllegalArgumentException("invalid type set");
            }
        }
    }

    @Override
    public void createConnectionPool(UniversalConnectionPoolAdapter ucpAdapter) throws UniversalConnectionPoolException {
        if (ucpAdapter == null) {
            UCPErrorHandler.throwUniversalConnectionPoolException(383);
        }
        try {
            UniversalConnectionPool pool = ucpAdapter.createUniversalConnectionPool();
            assert (pool != null);
            this.setConnectionPool(pool);
        }
        catch (Exception exc) {
            UCPErrorHandler.throwUniversalConnectionPoolException(385, exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setConnectionPool(UniversalConnectionPool connectionPool) throws UniversalConnectionPoolException {
        if (connectionPool != null) {
            String uniquePoolID;
            String poolName = connectionPool.getName();
            Map<String, String> map = this.m_mappedPoolNames;
            synchronized (map) {
                if (this.m_mappedPoolNames.containsKey(poolName)) {
                    UCPErrorHandler.throwUniversalConnectionPoolException(350);
                }
                uniquePoolID = new UniqueIdentifier(MGR_PREFIX).toString();
                this.m_mappedPoolNames.put(poolName, uniquePoolID);
            }
            this.m_connPool.put(uniquePoolID, connectionPool);
        } else {
            UCPErrorHandler.throwUniversalConnectionPoolException(54);
        }
    }

    @Override
    public UniversalConnectionPool getConnectionPool(String poolName) throws UniversalConnectionPoolException {
        UniversalConnectionPool pool;
        String uniquePoolID = this.getManagerPoolID(poolName);
        UniversalConnectionPool universalConnectionPool = pool = uniquePoolID != null ? this.m_connPool.get(uniquePoolID) : null;
        if (null == pool) {
            UCPErrorHandler.throwUniversalConnectionPoolException(351);
        }
        return pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getConnectionPoolNames() throws UniversalConnectionPoolException {
        String[] sArray;
        Map<String, String> map = this.m_mappedPoolNames;
        synchronized (map) {
            sArray = this.m_mappedPoolNames.keySet().toArray(new String[this.m_mappedPoolNames.size()]);
        }
        return sArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void setManagerPoolID(String string, String string2) throws UniversalConnectionPoolException {
        void newPoolName;
        String uniquePoolID;
        boolean bl = (0x4000000000000000L & TraceControllerImpl.feature) != 0L;
        Map<String, String> map = this.m_mappedPoolNames;
        synchronized (map) {
            void poolName;
            String string3 = uniquePoolID = poolName != null ? this.m_mappedPoolNames.get(poolName) : null;
            if (null == uniquePoolID) {
                UCPErrorHandler.throwUniversalConnectionPoolException(351);
            }
            this.m_mappedPoolNames.remove(poolName);
            this.m_mappedPoolNames.put((String)newPoolName, uniquePoolID);
        }
        if (bl) {
            ClioSupport.ilogFinest($$$loggerRef$$$12, UniversalConnectionPoolManagerBase.class, $$$methodRef$$$12, this, (String)newPoolName + " returns " + uniquePoolID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getManagerPoolID(String poolName) throws UniversalConnectionPoolException {
        String uniquePoolID;
        Map<String, String> map = this.m_mappedPoolNames;
        synchronized (map) {
            uniquePoolID = poolName != null ? this.m_mappedPoolNames.get(poolName) : null;
        }
        if (null == uniquePoolID) {
            UCPErrorHandler.throwUniversalConnectionPoolException(351);
        }
        return uniquePoolID;
    }

    private String[] getMetricPoolNames() throws UniversalConnectionPoolException {
        String[] sArray = this.m_metricPools.toArray(new String[this.m_metricPools.size()]);
        return sArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void startMetricsCollection(String string) throws UniversalConnectionPoolException {
        block5: {
            void poolName;
            boolean bl;
            boolean bl2 = bl = (0x4000000000000000L & TraceControllerImpl.feature) != 0L;
            if (poolName == null) {
                throw UCPErrorHandler.newUniversalConnectionPoolException(54);
            }
            if (this.isMetricConsoleAvailable()) {
                try {
                    UniversalConnectionPool pool = this.getConnectionPool((String)poolName);
                    this.createMetricSensors(pool);
                    if (!this.m_metricsPostingThread) {
                        this.initupdateMetricTimer();
                    }
                }
                catch (UniversalConnectionPoolException ce) {
                    if (!bl) break block5;
                    ClioSupport.ilogThrowing($$$loggerRef$$$15, UniversalConnectionPoolManagerBase.class, $$$methodRef$$$15, this, ce);
                }
            }
        }
    }

    private void createMetricSensors(UniversalConnectionPool pool) throws UniversalConnectionPoolException {
        if (null == pool) {
            UCPErrorHandler.throwUniversalConnectionPoolException(351);
        }
        NounIntf metricParentNoun = null;
        String poolName = pool.getName();
        String uniquePoolID = this.getManagerPoolID(poolName);
        metricParentNoun = !this.m_localMetricConsole ? (poolName != null ? this.m_parentNouns.get(poolName) : null) : this.m_metricConsole.getNounFactory().create("/UCP_METRIC/" + poolName);
        if (!this.m_metricPools.contains(uniquePoolID)) {
            this.m_metricPools.add(uniquePoolID);
        }
        UniversalConnectionPoolStatistics stats = pool.getStatistics();
        StateIntf totalConnectionsCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, TOTAL_CONN_NAME, (byte)3, "ConnectionsCount", TOTAL_CONN_DESC);
        totalConnectionsCount.deriveMetric(511);
        totalConnectionsCount.update(stats.getTotalConnectionsCount());
        StateIntf availableConnectionsCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, AVAILABLE_CONN_NAME, (byte)3, "ConnectionsCount", AVAILABLE_CONN_DESC);
        availableConnectionsCount.deriveMetric(511);
        totalConnectionsCount.update(stats.getAvailableConnectionsCount());
        StateIntf borrowedConnectionsCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, BORROWED_CONN_NAME, (byte)3, "ConnectionsCount", BORROWED_CONN_DESC);
        borrowedConnectionsCount.deriveMetric(8);
        borrowedConnectionsCount.update(stats.getBorrowedConnectionsCount());
        StateIntf averageBorrowedConnectionsCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, AVERAGE_BORROWED_CONN_NAME, (byte)3, "ConnectionsCount", AVERAGE_BORROWED_CONN_DESC);
        averageBorrowedConnectionsCount.update(stats.getAverageBorrowedConnectionsCount());
        StateIntf peakConnectionsCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, PEAK_CONN_NAME, (byte)3, "ConnectionsCount", PEAK_CONN_DESC);
        peakConnectionsCount.update(stats.getPeakConnectionsCount());
        StateIntf remainingPoolCapacityCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, REMAINING_CONN_NAME, (byte)3, "ConnectionsCount", REMAINING_CONN_DESC);
        remainingPoolCapacityCount.deriveMetric(511);
        remainingPoolCapacityCount.update(stats.getRemainingPoolCapacityCount());
        StateIntf labeledConnectionsCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, LABELED_CONN_NAME, (byte)3, "ConnectionsCount", LABELED_CONN_DESC);
        labeledConnectionsCount.deriveMetric(511);
        labeledConnectionsCount.update(stats.getLabeledConnectionsCount());
        StateIntf connectionsCreatedCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, CREATED_CONN_NAME, (byte)3, "ConnectionsCount", CREATED_CONN_DESC);
        connectionsCreatedCount.deriveMetric(511);
        connectionsCreatedCount.update(stats.getConnectionsCreatedCount());
        StateIntf connectionsClosedCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, CLOSED_CONN_NAME, (byte)3, "ConnectionsCount", CLOSED_CONN_DESC);
        connectionsClosedCount.deriveMetric(511);
        connectionsClosedCount.update(stats.getConnectionsClosedCount());
        StateIntf averageConnectionWaitTime = this.m_metricConsole.getStateFactory().create(metricParentNoun, AVG_CONN_WAIT_NAME, (byte)2, "Seconds", AVG_CONN_WAIT_DESC);
        averageConnectionWaitTime.update(stats.getAverageConnectionWaitTime());
        StateIntf peakConnectionWaitTime = this.m_metricConsole.getStateFactory().create(metricParentNoun, PEAK_CONN_WAIT_NAME, (byte)2, "Seconds", PEAK_CONN_WAIT_DESC);
        peakConnectionWaitTime.update(stats.getPeakConnectionWaitTime());
        StateIntf abandonedConnectionsCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, ABANDONED_CONN_NAME, (byte)3, "ConnectionsCount", ABANDONED_CONN_DESC);
        abandonedConnectionsCount.deriveMetric(511);
        abandonedConnectionsCount.update(stats.getAbandonedConnectionsCount());
        StateIntf pendingRequestsCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, PENDING_REQUEST_NAME, (byte)3, "ConnectionsCount", PENDING_REQUEST_DESC);
        pendingRequestsCount.deriveMetric(511);
        pendingRequestsCount.update(stats.getPendingRequestsCount());
        StateIntf cumulativeConnectionWaitTime = this.m_metricConsole.getStateFactory().create(metricParentNoun, CUMULATIVE_CONN_WAIT_NAME, (byte)2, "Seconds", CUMULATIVE_CONN_WAIT_DESC);
        cumulativeConnectionWaitTime.deriveMetric(511);
        cumulativeConnectionWaitTime.update(stats.getCumulativeConnectionWaitTime());
        StateIntf cumulativeConnectionBorrowedCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, CUMULATIVE_CONN_BORROWED_NAME, (byte)2, "ConnectionsCount", CUMULATIVE_CONN_BORROWED_DESC);
        cumulativeConnectionBorrowedCount.deriveMetric(511);
        cumulativeConnectionBorrowedCount.update(stats.getCumulativeConnectionBorrowedCount());
        StateIntf cumulativeConnectionUseTime = this.m_metricConsole.getStateFactory().create(metricParentNoun, CUMULATIVE_CONN_USE_NAME, (byte)2, "Seconds", CUMULATIVE_CONN_USE_DESC);
        cumulativeConnectionUseTime.deriveMetric(511);
        cumulativeConnectionUseTime.update(stats.getCumulativeConnectionUseTime());
        StateIntf cumulativeConnectionReturnedCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, CUMULATIVE_CONN_RETURNED_NAME, (byte)2, "ConnectionsCount", CUMULATIVE_CONN_RETURNED_DESC);
        cumulativeConnectionReturnedCount.deriveMetric(511);
        cumulativeConnectionReturnedCount.update(stats.getCumulativeConnectionReturnedCount());
        StateIntf cumulativeSuccessfulConnectionWaitTime = this.m_metricConsole.getStateFactory().create(metricParentNoun, CUMULATIVE_SUCCESS_CONN_WAIT_NAME, (byte)2, "Seconds", CUMULATIVE_SUCCESS_CONN_WAIT_DESC);
        cumulativeSuccessfulConnectionWaitTime.deriveMetric(511);
        cumulativeSuccessfulConnectionWaitTime.update(stats.getCumulativeSuccessfulConnectionWaitTime());
        StateIntf cumulativeSuccessfulConnectionWaitCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, CUMULATIVE_SUCCESS_CONN_WAIT_COUNT_NAME, (byte)2, "ConnectionsCount", CUMULATIVE_SUCCESS_CONN_WAIT_COUNT_DESC);
        cumulativeSuccessfulConnectionWaitCount.deriveMetric(511);
        cumulativeSuccessfulConnectionWaitCount.update(stats.getCumulativeSuccessfulConnectionWaitCount());
        StateIntf cumulativeFailedConnectionWaitTime = this.m_metricConsole.getStateFactory().create(metricParentNoun, CUMULATIVE_FAILED_CONN_WAIT_NAME, (byte)2, "Seconds", CUMULATIVE_FAILED_CONN_WAIT_DESC);
        cumulativeFailedConnectionWaitTime.deriveMetric(511);
        cumulativeFailedConnectionWaitTime.update(stats.getCumulativeFailedConnectionWaitTime());
        StateIntf cumulativeFailedConnectionWaitCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, CUMULATIVE_FAILED_CONN_WAIT_COUNT_NAME, (byte)2, "ConnectionsCount", CUMULATIVE_FAILED_CONN_WAIT_COUNT_DESC);
        cumulativeFailedConnectionWaitCount.deriveMetric(511);
        cumulativeFailedConnectionWaitCount.update(stats.getCumulativeFailedConnectionWaitCount());
        if (pool instanceof OracleJDBCConnectionPool) {
            OracleJDBCConnectionPoolStatistics oracleStats = (OracleJDBCConnectionPoolStatistics)stats;
            StateIntf successfulAffinityBasedBorrowCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, SUCCESSFUL_AFFINITYBASED_BORROW_COUNT_NAME, (byte)2, "ConnectionsCount", SUCCESSFUL_AFFINITYBASED_BORROW_COUNT_DESC);
            successfulAffinityBasedBorrowCount.deriveMetric(511);
            successfulAffinityBasedBorrowCount.update(oracleStats.getSuccessfulAffinityBasedBorrowCount());
            StateIntf failedAffinityBasedBorrowCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, FAILED_AFFINITYBASED_BORROW_COUNT_NAME, (byte)2, "ConnectionsCount", FAILED_AFFINITYBASED_BORROW_COUNT_DESC);
            failedAffinityBasedBorrowCount.deriveMetric(511);
            failedAffinityBasedBorrowCount.update(oracleStats.getFailedAffinityBasedBorrowCount());
            StateIntf successfulRCLBBasedBorrowCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, SUCCESSFUL_RCLBBASED_BORROW_COUNT_NAME, (byte)2, "ConnectionsCount", SUCCESSFUL_RCLBBASED_BORROW_COUNT_DESC);
            successfulRCLBBasedBorrowCount.deriveMetric(511);
            successfulRCLBBasedBorrowCount.update(oracleStats.getSuccessfulRCLBBasedBorrowCount());
            StateIntf failedRCLBBasedBorrowCount = this.m_metricConsole.getStateFactory().create(metricParentNoun, FAILED_RCLBBASED_BORROW_COUNT_NAME, (byte)2, "ConnectionsCount", FAILED_RCLBBASED_BORROW_COUNT_DESC);
            failedRCLBBasedBorrowCount.deriveMetric(511);
            failedRCLBBasedBorrowCount.update(oracleStats.getFailedRCLBBasedBorrowCount());
        }
    }

    void updateMetricSensors() throws UniversalConnectionPoolException {
        if (this.isMetricConsoleAvailable()) {
            try {
                String[] uniquePoolIDs = this.getMetricPoolNames();
                for (int i2 = 0; i2 < uniquePoolIDs.length; ++i2) {
                    UniversalConnectionPool connectionPool = uniquePoolIDs[i2] != null ? this.m_connPool.get(uniquePoolIDs[i2]) : null;
                    this.updateMetricSensors(connectionPool);
                }
            }
            catch (UniversalConnectionPoolException e2) {
                UCPErrorHandler.throwUniversalConnectionPoolException(377, e2);
            }
        }
    }

    private synchronized void updateMetricSensors(UniversalConnectionPool connectionPool) throws UniversalConnectionPoolException {
        NounFactoryIntf nfi;
        if (null == connectionPool) {
            UCPErrorHandler.throwUniversalConnectionPoolException(351);
        }
        String poolName = connectionPool.getName();
        NounIntf metricParentNoun = null;
        if (!this.m_localMetricConsole) {
            metricParentNoun = poolName != null ? this.m_parentNouns.get(poolName) : null;
        } else if (null != this.m_metricConsole && null != (nfi = this.m_metricConsole.getNounFactory())) {
            metricParentNoun = nfi.get("/UCP_METRIC/" + poolName);
        }
        if (null != metricParentNoun) {
            UniversalConnectionPoolStatistics stats = connectionPool.getStatistics();
            assert (stats != null);
            ((State)metricParentNoun.getSensor(TOTAL_CONN_NAME)).update(stats.getTotalConnectionsCount());
            ((State)metricParentNoun.getSensor(AVAILABLE_CONN_NAME)).update(stats.getAvailableConnectionsCount());
            ((State)metricParentNoun.getSensor(BORROWED_CONN_NAME)).update(stats.getBorrowedConnectionsCount());
            ((State)metricParentNoun.getSensor(AVERAGE_BORROWED_CONN_NAME)).update(stats.getAverageBorrowedConnectionsCount());
            ((State)metricParentNoun.getSensor(PEAK_CONN_NAME)).update(stats.getPeakConnectionsCount());
            ((State)metricParentNoun.getSensor(REMAINING_CONN_NAME)).update(stats.getRemainingPoolCapacityCount());
            ((State)metricParentNoun.getSensor(LABELED_CONN_NAME)).update(stats.getLabeledConnectionsCount());
            ((State)metricParentNoun.getSensor(CREATED_CONN_NAME)).update(stats.getConnectionsCreatedCount());
            ((State)metricParentNoun.getSensor(CLOSED_CONN_NAME)).update(stats.getConnectionsClosedCount());
            ((State)metricParentNoun.getSensor(AVG_CONN_WAIT_NAME)).update(stats.getAverageConnectionWaitTime());
            ((State)metricParentNoun.getSensor(PEAK_CONN_WAIT_NAME)).update(stats.getPeakConnectionWaitTime());
            ((State)metricParentNoun.getSensor(ABANDONED_CONN_NAME)).update(stats.getAbandonedConnectionsCount());
            ((State)metricParentNoun.getSensor(PENDING_REQUEST_NAME)).update(stats.getPendingRequestsCount());
            ((State)metricParentNoun.getSensor(CUMULATIVE_CONN_WAIT_NAME)).update(stats.getCumulativeConnectionWaitTime());
            ((State)metricParentNoun.getSensor(CUMULATIVE_CONN_BORROWED_NAME)).update(stats.getCumulativeConnectionBorrowedCount());
            ((State)metricParentNoun.getSensor(CUMULATIVE_CONN_USE_NAME)).update(stats.getCumulativeConnectionUseTime());
            ((State)metricParentNoun.getSensor(CUMULATIVE_CONN_RETURNED_NAME)).update(stats.getCumulativeConnectionReturnedCount());
            ((State)metricParentNoun.getSensor(CUMULATIVE_SUCCESS_CONN_WAIT_NAME)).update(stats.getCumulativeSuccessfulConnectionWaitTime());
            ((State)metricParentNoun.getSensor(CUMULATIVE_SUCCESS_CONN_WAIT_COUNT_NAME)).update(stats.getCumulativeSuccessfulConnectionWaitCount());
            ((State)metricParentNoun.getSensor(CUMULATIVE_FAILED_CONN_WAIT_NAME)).update(stats.getCumulativeFailedConnectionWaitTime());
            ((State)metricParentNoun.getSensor(CUMULATIVE_FAILED_CONN_WAIT_COUNT_NAME)).update(stats.getCumulativeFailedConnectionWaitCount());
            if (connectionPool instanceof OracleJDBCConnectionPool) {
                OracleJDBCConnectionPoolStatistics oracleStats = (OracleJDBCConnectionPoolStatistics)stats;
                ((State)metricParentNoun.getSensor(SUCCESSFUL_AFFINITYBASED_BORROW_COUNT_NAME)).update(oracleStats.getSuccessfulAffinityBasedBorrowCount());
                ((State)metricParentNoun.getSensor(FAILED_AFFINITYBASED_BORROW_COUNT_NAME)).update(oracleStats.getFailedAffinityBasedBorrowCount());
                ((State)metricParentNoun.getSensor(SUCCESSFUL_RCLBBASED_BORROW_COUNT_NAME)).update(oracleStats.getSuccessfulRCLBBasedBorrowCount());
                ((State)metricParentNoun.getSensor(FAILED_RCLBBASED_BORROW_COUNT_NAME)).update(oracleStats.getFailedRCLBBasedBorrowCount());
            }
        }
    }

    private boolean isMetricConsoleAvailable() {
        boolean metricConsoleExists;
        block10: {
            boolean bl = (0x4000000000000000L & TraceControllerImpl.feature) != 0L;
            metricConsoleExists = false;
            if (this.m_metricConsole != null) {
                metricConsoleExists = true;
            } else {
                try {
                    ClassLoader clsLoader = Thread.currentThread().getContextClassLoader();
                    Class.forName("oracle.dms.instrument.DMSConsole", true, clsLoader);
                    this.m_metricConsole = DMSConsole.getConsole();
                    this.m_metricConsole.init(UCP_METRIC_NAME);
                    metricConsoleExists = true;
                }
                catch (ClassNotFoundException cnf) {
                    if (bl) {
                        ClioSupport.ilogThrowing($$$loggerRef$$$19, UniversalConnectionPoolManagerBase.class, $$$methodRef$$$19, this, cnf);
                    }
                }
                catch (SecurityException e2) {
                    if (bl) {
                        ClioSupport.ilogThrowing($$$loggerRef$$$19, UniversalConnectionPoolManagerBase.class, $$$methodRef$$$19, this, e2);
                    }
                }
                catch (RuntimeException re) {
                    if (bl) {
                        ClioSupport.ilogThrowing($$$loggerRef$$$19, UniversalConnectionPoolManagerBase.class, $$$methodRef$$$19, this, re);
                    }
                }
                catch (Exception e3) {
                    if (!bl) break block10;
                    ClioSupport.ilogThrowing($$$loggerRef$$$19, UniversalConnectionPoolManagerBase.class, $$$methodRef$$$19, this, e3);
                }
            }
        }
        return metricConsoleExists;
    }

    @Override
    public synchronized void stopMetricsCollection(String poolName) throws UniversalConnectionPoolException {
        if (poolName == null) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(54);
        }
        if (this.isMetricConsoleAvailable()) {
            try {
                if (this.isMetricConsoleAvailable()) {
                    String uniquePoolID;
                    NounIntf metricParentNoun = null;
                    metricParentNoun = !this.m_localMetricConsole ? (poolName != null ? this.m_parentNouns.get(poolName) : null) : this.m_metricConsole.getNounFactory().get("/UCP_METRIC/" + poolName);
                    if (metricParentNoun != null) {
                        metricParentNoun.destroy();
                    }
                    if (this.m_metricPools.contains(uniquePoolID = this.getManagerPoolID(poolName))) {
                        this.m_metricPools.remove(uniquePoolID);
                    }
                    if (this.m_parentNouns.contains(poolName)) {
                        this.m_parentNouns.remove(poolName);
                    }
                    if (this.m_metricPools.size() == 0) {
                        this.disableupdateMetricTimer();
                        if (this.m_localMetricConsole) {
                            this.m_metricConsole.exit();
                        }
                        this.m_metricConsole = null;
                        this.m_localMetricConsole = true;
                    }
                }
            }
            catch (UniversalConnectionPoolException e2) {
                UCPErrorHandler.throwUniversalConnectionPoolException(375, e2);
            }
        }
    }

    @Override
    public synchronized void setMetricUpdateInterval(int metricInterval) throws UniversalConnectionPoolException {
        if (metricInterval < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        if (this.m_metricInterval != metricInterval) {
            this.disableupdateMetricTimer();
            this.m_metricInterval = metricInterval;
            if (this.m_metricConsole != null && this.m_metricInterval > 0) {
                this.initupdateMetricTimer();
            }
        }
    }

    @Override
    public int getMetricUpdateInterval() {
        return this.m_metricInterval;
    }

    @Override
    public synchronized void setJmxEnabled(boolean jmxFlag) throws UniversalConnectionPoolException {
        this.m_jmxFlag = jmxFlag;
    }

    @Override
    public boolean isJmxEnabled() {
        return this.m_jmxFlag;
    }

    private void initupdateMetricTimer() throws UniversalConnectionPoolException {
        if (this.m_metricInterval > 0) {
            try {
                this.m_updateMetricTimer = UniversalConnectionPoolManagerBase.getTimerManager().schedule(new MetricsUpdateTimerTask(), 0L, this.m_metricInterval * 1000);
                this.m_metricsPostingThread = true;
            }
            catch (Exception exc) {
                UCPErrorHandler.throwUniversalConnectionPoolException(376, exc);
            }
        } else {
            this.m_updateMetricTimer = null;
        }
    }

    private void disableupdateMetricTimer() throws UniversalConnectionPoolException {
        if (this.m_updateMetricTimer != null) {
            this.m_updateMetricTimer.cancel();
            this.m_metricsPostingThread = false;
            this.m_updateMetricTimer = null;
        }
    }

    @Override
    public void setLogLevel(Level newLogLevel) {
        UCPLoggerFactory.setLogLevel(newLogLevel);
    }

    @Override
    @DisableTrace
    public Level getLogLevel() {
        return UCPLoggerFactory.getLogLevel();
    }

    protected void setMetricConsole(DMSConsole metricConsole) {
        this.m_metricConsole = metricConsole;
        this.m_localMetricConsole = false;
    }

    protected void setMetricParentNoun(String poolName, NounIntf metricParentNoun) {
        this.m_parentNouns.put(poolName, metricParentNoun);
    }

    protected StateIntf getStateMetric(String poolName, UCPMetric ucpMetric) {
        NounIntf metricParentNoun;
        StateIntf stateMetric = null;
        NounIntf nounIntf = metricParentNoun = poolName != null ? this.m_parentNouns.get(poolName) : null;
        if (metricParentNoun != null) {
            stateMetric = (StateIntf)metricParentNoun.getSensor(m_ucpMetrics.get((Object)ucpMetric));
        }
        return stateMetric;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimerManager getTimerManager() {
        TimerManager timerManager = m_timerManager;
        synchronized (timerManager) {
            return m_timerManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setTimerManager(TimerManager timerManager) {
        TimerManager oldTm;
        TimerManager timerManager2 = oldTm = m_timerManager;
        synchronized (timerManager2) {
            TimerManager timerManager3 = timerManager;
            synchronized (timerManager3) {
                if (oldTm.isRunning()) {
                    return false;
                }
                m_timerManager = timerManager;
                return true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskManager getTaskManager() {
        TaskManager taskManager = m_taskManager;
        synchronized (taskManager) {
            return m_taskManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setTaskManager(TaskManager taskManager) {
        TaskManager oldTm;
        TaskManager taskManager2 = oldTm = m_taskManager;
        synchronized (taskManager2) {
            TaskManager taskManager3 = taskManager;
            synchronized (taskManager3) {
                if (oldTm.isRunning()) {
                    return false;
                }
                m_taskManager = taskManager;
                return true;
            }
        }
    }

    static {
        try {
            $$$methodRef$$$35 = UniversalConnectionPoolManagerBase.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$34 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("setTaskManager", TaskManager.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$33 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("getTaskManager", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$32 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("setTimerManager", TimerManager.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$31 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("getTimerManager", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$30 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("getStateMetric", String.class, UCPMetric.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$29 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("setMetricParentNoun", String.class, NounIntf.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$28 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("setMetricConsole", DMSConsole.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$27 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("setLogLevel", Level.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$26 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("disableupdateMetricTimer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$25 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("initupdateMetricTimer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$24 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("isJmxEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$23 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("setJmxEnabled", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$22 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("getMetricUpdateInterval", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$21 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("setMetricUpdateInterval", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$20 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("stopMetricsCollection", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$19 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("isMetricConsoleAvailable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$18 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("updateMetricSensors", UniversalConnectionPool.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$17 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("updateMetricSensors", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$16 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("createMetricSensors", UniversalConnectionPool.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$15 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("startMetricsCollection", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$14 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("getMetricPoolNames", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$13 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("getManagerPoolID", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$12 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("setManagerPoolID", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$11 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("getConnectionPoolNames", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$10 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("getConnectionPool", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$9 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("setConnectionPool", UniversalConnectionPool.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$8 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("createConnectionPool", UniversalConnectionPoolAdapter.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$7 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("applyConfiguration", String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$6 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("reconfigureConnectionPool", String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$5 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("destroyConnectionPool", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$4 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("purgeConnectionPool", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$3 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("recycleConnectionPool", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$2 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("refreshConnectionPool", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$1 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("stopConnectionPool", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$0 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("startConnectionPool", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        MGR_PREFIX = "UniversalConnectionPoolManager(" + UniversalConnectionPoolManagerBase.class.hashCode() + ")-";
        m_ucpMetrics = Collections.synchronizedMap(new HashMap());
        m_timerManager = new UCPTimerManagerImpl();
        m_taskManager = new UCPTaskManagerImpl();
        m_ucpMetrics.put(UCPMetric.TOTALCONNECTIONSCOUNT, TOTAL_CONN_NAME);
        m_ucpMetrics.put(UCPMetric.AVAILABLECONNECTIONSCOUNT, AVAILABLE_CONN_NAME);
        m_ucpMetrics.put(UCPMetric.BORROWEDCONNECTIONSCOUNT, BORROWED_CONN_NAME);
        m_ucpMetrics.put(UCPMetric.AVERAGEBORROWEDCONNECTIONSCOUNT, AVERAGE_BORROWED_CONN_NAME);
        m_ucpMetrics.put(UCPMetric.PEAKCONNECTIONSCOUNT, PEAK_CONN_NAME);
        m_ucpMetrics.put(UCPMetric.REMAININGPOOLCAPACITYCOUNT, REMAINING_CONN_NAME);
        m_ucpMetrics.put(UCPMetric.LABELEDCONNECTIONSCOUNT, LABELED_CONN_NAME);
        m_ucpMetrics.put(UCPMetric.CONNECTIONSCREATEDCOUNT, CREATED_CONN_NAME);
        m_ucpMetrics.put(UCPMetric.CONNECTIONSCLOSEDCOUNT, CLOSED_CONN_NAME);
        m_ucpMetrics.put(UCPMetric.AVERAGECONNECTIONWAITTIME, AVG_CONN_WAIT_NAME);
        m_ucpMetrics.put(UCPMetric.PEAKCONNECTIONWAITTIME, PEAK_CONN_WAIT_NAME);
        m_ucpMetrics.put(UCPMetric.ABANDONEDCONNECTIONSCOUNT, ABANDONED_CONN_NAME);
        m_ucpMetrics.put(UCPMetric.PENDINGREQUESTSCOUNT, PENDING_REQUEST_NAME);
        m_ucpMetrics.put(UCPMetric.CUMULATIVECONNECTIONWAITTIME, CUMULATIVE_CONN_WAIT_NAME);
        m_ucpMetrics.put(UCPMetric.CUMULATIVECONNECTIONBORROWEDCOUNT, CUMULATIVE_CONN_BORROWED_NAME);
        m_ucpMetrics.put(UCPMetric.CUMULATIVECONNECTIONUSETIME, CUMULATIVE_CONN_USE_NAME);
        m_ucpMetrics.put(UCPMetric.CUMULATIVECONNECTIONRETURNEDCOUNT, CUMULATIVE_CONN_RETURNED_NAME);
        m_ucpMetrics.put(UCPMetric.CUMULATIVESUCCESSFULCONNECTIONWAITTIME, CUMULATIVE_SUCCESS_CONN_WAIT_NAME);
        m_ucpMetrics.put(UCPMetric.CUMULATIVESUCCESSFULCONNECTIONWAITCOUNT, CUMULATIVE_SUCCESS_CONN_WAIT_COUNT_NAME);
        m_ucpMetrics.put(UCPMetric.CUMULATIVEFAILEDCONNECTIONWAITTIME, CUMULATIVE_FAILED_CONN_WAIT_NAME);
        m_ucpMetrics.put(UCPMetric.CUMULATIVEFAILEDCONNECTIONWAITCOUNT, CUMULATIVE_FAILED_CONN_WAIT_COUNT_NAME);
        m_ucpMetrics.put(UCPMetric.SUCCESSFULAFFINITYBASEDBORROWCOUNT, SUCCESSFUL_AFFINITYBASED_BORROW_COUNT_NAME);
        m_ucpMetrics.put(UCPMetric.FAILEDAFFINITYBASEDBORROWCOUNT, FAILED_AFFINITYBASED_BORROW_COUNT_NAME);
        m_ucpMetrics.put(UCPMetric.SUCCESSFULRCLBBASEDBORROWCOUNT, SUCCESSFUL_RCLBBASED_BORROW_COUNT_NAME);
        m_ucpMetrics.put(UCPMetric.FAILEDRCLBBASEDBORROWCOUNT, FAILED_RCLBBASED_BORROW_COUNT_NAME);
    }

    public static final class UCPMetric
    extends Enum<UCPMetric> {
        public static final /* enum */ UCPMetric TOTALCONNECTIONSCOUNT;
        public static final /* enum */ UCPMetric AVAILABLECONNECTIONSCOUNT;
        public static final /* enum */ UCPMetric BORROWEDCONNECTIONSCOUNT;
        public static final /* enum */ UCPMetric AVERAGEBORROWEDCONNECTIONSCOUNT;
        public static final /* enum */ UCPMetric PEAKCONNECTIONSCOUNT;
        public static final /* enum */ UCPMetric REMAININGPOOLCAPACITYCOUNT;
        public static final /* enum */ UCPMetric LABELEDCONNECTIONSCOUNT;
        public static final /* enum */ UCPMetric CONNECTIONSCREATEDCOUNT;
        public static final /* enum */ UCPMetric CONNECTIONSCLOSEDCOUNT;
        public static final /* enum */ UCPMetric AVERAGECONNECTIONWAITTIME;
        public static final /* enum */ UCPMetric PEAKCONNECTIONWAITTIME;
        public static final /* enum */ UCPMetric ABANDONEDCONNECTIONSCOUNT;
        public static final /* enum */ UCPMetric PENDINGREQUESTSCOUNT;
        public static final /* enum */ UCPMetric CUMULATIVECONNECTIONWAITTIME;
        public static final /* enum */ UCPMetric CUMULATIVECONNECTIONBORROWEDCOUNT;
        public static final /* enum */ UCPMetric CUMULATIVECONNECTIONUSETIME;
        public static final /* enum */ UCPMetric CUMULATIVECONNECTIONRETURNEDCOUNT;
        public static final /* enum */ UCPMetric CUMULATIVESUCCESSFULCONNECTIONWAITTIME;
        public static final /* enum */ UCPMetric CUMULATIVESUCCESSFULCONNECTIONWAITCOUNT;
        public static final /* enum */ UCPMetric CUMULATIVEFAILEDCONNECTIONWAITTIME;
        public static final /* enum */ UCPMetric CUMULATIVEFAILEDCONNECTIONWAITCOUNT;
        public static final /* enum */ UCPMetric SUCCESSFULAFFINITYBASEDBORROWCOUNT;
        public static final /* enum */ UCPMetric FAILEDAFFINITYBASEDBORROWCOUNT;
        public static final /* enum */ UCPMetric SUCCESSFULRCLBBASEDBORROWCOUNT;
        public static final /* enum */ UCPMetric FAILEDRCLBBASEDBORROWCOUNT;
        public static final /* enum */ UCPMetric FCFDOWNEVENTPROCESSINGINFO;
        private static final /* synthetic */ UCPMetric[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public static UCPMetric[] values() {
            return (UCPMetric[])$VALUES.clone();
        }

        public static UCPMetric valueOf(String name) {
            return Enum.valueOf(UCPMetric.class, name);
        }

        static {
            try {
                $$$methodRef$$$2 = UCPMetric.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = UCPMetric.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = UCPMetric.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            TOTALCONNECTIONSCOUNT = new UCPMetric();
            AVAILABLECONNECTIONSCOUNT = new UCPMetric();
            BORROWEDCONNECTIONSCOUNT = new UCPMetric();
            AVERAGEBORROWEDCONNECTIONSCOUNT = new UCPMetric();
            PEAKCONNECTIONSCOUNT = new UCPMetric();
            REMAININGPOOLCAPACITYCOUNT = new UCPMetric();
            LABELEDCONNECTIONSCOUNT = new UCPMetric();
            CONNECTIONSCREATEDCOUNT = new UCPMetric();
            CONNECTIONSCLOSEDCOUNT = new UCPMetric();
            AVERAGECONNECTIONWAITTIME = new UCPMetric();
            PEAKCONNECTIONWAITTIME = new UCPMetric();
            ABANDONEDCONNECTIONSCOUNT = new UCPMetric();
            PENDINGREQUESTSCOUNT = new UCPMetric();
            CUMULATIVECONNECTIONWAITTIME = new UCPMetric();
            CUMULATIVECONNECTIONBORROWEDCOUNT = new UCPMetric();
            CUMULATIVECONNECTIONUSETIME = new UCPMetric();
            CUMULATIVECONNECTIONRETURNEDCOUNT = new UCPMetric();
            CUMULATIVESUCCESSFULCONNECTIONWAITTIME = new UCPMetric();
            CUMULATIVESUCCESSFULCONNECTIONWAITCOUNT = new UCPMetric();
            CUMULATIVEFAILEDCONNECTIONWAITTIME = new UCPMetric();
            CUMULATIVEFAILEDCONNECTIONWAITCOUNT = new UCPMetric();
            SUCCESSFULAFFINITYBASEDBORROWCOUNT = new UCPMetric();
            FAILEDAFFINITYBASEDBORROWCOUNT = new UCPMetric();
            SUCCESSFULRCLBBASEDBORROWCOUNT = new UCPMetric();
            FAILEDRCLBBASEDBORROWCOUNT = new UCPMetric();
            FCFDOWNEVENTPROCESSINGINFO = new UCPMetric();
            $VALUES = new UCPMetric[]{TOTALCONNECTIONSCOUNT, AVAILABLECONNECTIONSCOUNT, BORROWEDCONNECTIONSCOUNT, AVERAGEBORROWEDCONNECTIONSCOUNT, PEAKCONNECTIONSCOUNT, REMAININGPOOLCAPACITYCOUNT, LABELEDCONNECTIONSCOUNT, CONNECTIONSCREATEDCOUNT, CONNECTIONSCLOSEDCOUNT, AVERAGECONNECTIONWAITTIME, PEAKCONNECTIONWAITTIME, ABANDONEDCONNECTIONSCOUNT, PENDINGREQUESTSCOUNT, CUMULATIVECONNECTIONWAITTIME, CUMULATIVECONNECTIONBORROWEDCOUNT, CUMULATIVECONNECTIONUSETIME, CUMULATIVECONNECTIONRETURNEDCOUNT, CUMULATIVESUCCESSFULCONNECTIONWAITTIME, CUMULATIVESUCCESSFULCONNECTIONWAITCOUNT, CUMULATIVEFAILEDCONNECTIONWAITTIME, CUMULATIVEFAILEDCONNECTIONWAITCOUNT, SUCCESSFULAFFINITYBASEDBORROWCOUNT, FAILEDAFFINITYBASEDBORROWCOUNT, SUCCESSFULRCLBBASEDBORROWCOUNT, FAILEDRCLBBASEDBORROWCOUNT, FCFDOWNEVENTPROCESSINGINFO};
        }
    }
}

