/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class GDKOracleMetaData {
    private static final String GDK_NAME = "Oracle Globalization Development Kit";
    private static final String GDK_VERSION = "12.2.0.1.0 - Production";
    private static long OracleVersionID = 100000000000L;
    private static final String GDK_DATA_PATH = "/oracle/i18n/data/";
    static final String README_NAME = "oracle/i18n/readme.txt";
    private static String[] M_PLUGINS = new String[]{"oracle.i18n.util.CharConvRepackage"};

    private GDKOracleMetaData() {
    }

    public static long getOracleVersionID() {
        return OracleVersionID;
    }

    public static String getName() {
        return GDK_NAME;
    }

    public static String getVersion() {
        return GDK_VERSION;
    }

    public static String getNameVersion() {
        return GDKOracleMetaData.getName() + " - " + GDKOracleMetaData.getVersion();
    }

    public static String getDataPath() {
        return GDK_DATA_PATH;
    }

    public static final void main(String[] stringArray) throws Exception {
        int n2;
        Class<GDKOracleMetaData> clazz = GDKOracleMetaData.class;
        InputStream inputStream = clazz.getResourceAsStream("/oracle/i18n/readme.txt");
        if (inputStream != null) {
            GDKOracleMetaData.printVersion();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "iso-8859-1");
            char[] cArray = new char[8192];
            int n3 = -1;
            while ((n3 = inputStreamReader.read(cArray, 0, cArray.length)) != -1) {
                String string = new String(cArray, 0, n3);
                System.out.print(string);
            }
            inputStream.close();
            return;
        }
        if (stringArray.length == 0) {
            GDKOracleMetaData.printUsage();
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            arrayList.add(stringArray[n2]);
        }
        if ("-version".equals(arrayList.get(0))) {
            GDKOracleMetaData.printVersion();
            return;
        }
        n2 = 0;
        for (int i2 = 0; i2 < M_PLUGINS.length; ++i2) {
            Object object = GDKOracleMetaData.callStaticMethod(M_PLUGINS[i2], "getCommand", null, null);
            if (object == null || !object.equals(arrayList.get(0))) continue;
            n2 = 1;
            arrayList.remove(0);
            GDKOracleMetaData.callStaticMethod(M_PLUGINS[i2], "main", new Class[]{List.class}, new Object[]{arrayList});
        }
        if (n2 == 0) {
            GDKOracleMetaData.printUsage();
        }
    }

    private static final void printVersion() {
        System.out.println(GDKOracleMetaData.getNameVersion());
    }

    private static final void printUsage() {
        GDKOracleMetaData.printBaseUsage();
        System.out.println("  -version : Displays the GDK version");
        for (int i2 = 0; i2 < M_PLUGINS.length; ++i2) {
            GDKOracleMetaData.callStaticMethod(M_PLUGINS[i2], "printUsage", null, null);
        }
    }

    static final void printBaseUsage() {
        System.out.println("Usage: java -jar orai18n.jar <option>");
        System.out.println("<option> :=");
    }

    private static Object callStaticMethod(String string, String string2, Class[] classArray, Object[] objectArray) {
        try {
            Class<?> clazz = Class.forName(string);
            return clazz.getMethod(string2, classArray).invoke((Object)classArray, objectArray);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

