/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text.converter;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import oracle.i18n.util.GDKOracleMetaData;

public class CharsetMeta
implements Serializable {
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();
    private static CharsetMeta m_instance = null;
    public static final String FILENAME = "charsetMeta";
    public static final String CUSTOM_CHARSET_METAFILE = "charsetMeta.properties";
    protected String[] m_aveCharsets;
    protected Map m_charSetIdMap;
    protected Map m_containsCharset;

    public static synchronized CharsetMeta getInstance() {
        if (m_instance == null) {
            m_instance = (CharsetMeta)CharsetMeta.readObj(GDKOracleMetaData.getDataPath() + FILENAME + ".glb");
        }
        return m_instance;
    }

    public String[] getAvailableCharacterSets() {
        return this.m_aveCharsets;
    }

    public String getCharSetId(String string) {
        return (String)this.m_charSetIdMap.get(string.toUpperCase(Locale.US));
    }

    public int[] getContainsCharset(int n2) {
        return (int[])this.m_containsCharset.get(new Integer(n2));
    }

    private static Object readObj(String string) {
        Class<CharsetMeta> clazz = CharsetMeta.class;
        URL uRL = clazz.getResource(string);
        if (uRL == null) {
            return null;
        }
        try {
            InputStream inputStream = uRL.openStream();
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            Object object = objectInputStream.readObject();
            objectInputStream.close();
            inputStream.close();
            CharsetMeta.readCustomCharsetMeta((CharsetMeta)object);
            return object;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getClass().getName() + ": " + exception.getMessage());
        }
    }

    private static void readCustomCharsetMeta(CharsetMeta charsetMeta) {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URL uRL = classLoader.getResource(CUSTOM_CHARSET_METAFILE);
            if (uRL == null) {
                return;
            }
            InputStream inputStream = uRL.openStream();
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            Properties properties = (Properties)objectInputStream.readObject();
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
                String string3 = stringTokenizer.nextToken();
                charsetMeta.m_charSetIdMap.put(string3, string);
                charsetMeta.m_aveCharsets = CharsetMeta.addToArray(charsetMeta.m_aveCharsets, string3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static String[] addToArray(String[] stringArray, String string) {
        Object[] objectArray = null;
        if (stringArray != null) {
            objectArray = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, objectArray, 0, stringArray.length);
            objectArray[stringArray.length] = string;
            Arrays.sort(objectArray);
        }
        return objectArray;
    }
}

