/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text.converter;

import java.io.CharConversionException;
import java.io.IOException;
import java.sql.SQLException;
import oracle.i18n.text.converter.CharacterConverterLC;
import oracle.i18n.text.converter.GDKMessage;
import oracle.i18n.util.GDKOracleMetaData;

public class CharacterConverterLCFixed
extends CharacterConverterLC {
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();
    static final int ORACHARBYTECNT = 4;
    public int m_4ByteOraCharReplacement = 0;

    public CharacterConverterLCFixed() {
        this.m_groupId = 3;
        this.averageCharsPerByte = 0.25f;
        this.maxCharsPerByte = 1.0f;
        this.maxBytesPerChar = 4.0f;
    }

    @Override
    int toOracleCharacter(char c2, char c3) throws SQLException {
        int n2 = -1;
        if (c3 != '\u0000') {
            int n3 = c2 >>> 8 & 0xFF;
            int n4 = c2 & 0xFF;
            int n5 = c3 >>> 8 & 0xFF;
            int n6 = c3 & 0xFF;
            if (this.m_oraCharLevel1[n3] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n3] + n4] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n3] + n4] + n5] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n3] + n4] + n5] + n6] != -1) {
                n2 = this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n3] + n4] + n5] + n6];
            }
        } else {
            int n7 = c2 >>> 8 & 0xFF;
            int n8 = c2 & 0xFF;
            if (this.m_oraCharLevel1[n7] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharLevel1[n7] + n8] != -1) {
                n2 = this.m_oraCharLevel2[this.m_oraCharLevel1[n7] + n8];
            }
        }
        if (n2 == -1) {
            throw new SQLException(GDKMessage.getORAMessage(17155), null, 17155);
        }
        return n2;
    }

    @Override
    int toOracleCharacterWithReplacement(char c2, char c3) {
        int n2 = -1;
        if (c3 != '\u0000') {
            int n3 = c2 >>> 8 & 0xFF;
            int n4 = c2 & 0xFF;
            int n5 = c3 >>> 8 & 0xFF;
            int n6 = c3 & 0xFF;
            if (this.m_oraCharLevel1[n3] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n3] + n4] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n3] + n4] + n5] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n3] + n4] + n5] + n6] != -1) {
                n2 = this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n3] + n4] + n5] + n6];
            }
        } else {
            int n7 = c2 >>> 8 & 0xFF;
            int n8 = c2 & 0xFF;
            if (this.m_oraCharLevel1[n7] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharLevel1[n7] + n8] != -1) {
                n2 = this.m_oraCharLevel2[this.m_oraCharLevel1[n7] + n8];
            }
        }
        if (n2 == -1) {
            return this.m_4ByteOraCharReplacement;
        }
        return n2;
    }

    @Override
    public String toUnicodeString(byte[] byArray, int n2, int n3) throws SQLException {
        char[] cArray = new char[n3 * 2];
        int n4 = 0;
        if (n3 >= 4) {
            int n5 = byArray[n2] << 8 & 0xFF00 | byArray[n2 + 1] & 0xFF;
            for (int i2 = 0; i2 < this.m_ucsCharLeadingCode.length; ++i2) {
                if (n5 != this.m_ucsCharLeadingCode[i2][0]) continue;
                char c2 = this.m_ucsCharLeadingCode[i2][1];
                int n6 = byArray[n2 + 2] << 8 & 0xFF00 | byArray[n2 + 3] & 0xFF;
                int n7 = (n6 >> 8 & 0xFF) + c2;
                int n8 = n6 & 0xFF;
                if (this.m_ucsCharLevel1[n7] == '\uffff' || this.m_ucsCharLevel2[this.m_ucsCharLevel1[n7] + n8] == -1) {
                    throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
                }
                int n9 = this.m_ucsCharLevel2[this.m_ucsCharLevel1[n7] + n8];
                if (((long)n9 & 0xFFFFFFFFL) > 65535L) {
                    cArray[n4++] = (char)(n9 >>> 16);
                    cArray[n4++] = (char)(n9 & 0xFFFF);
                } else {
                    cArray[n4++] = (char)n9;
                }
                n3 -= 4;
                n2 += 4;
                break;
            }
            throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
        }
        if (n3 != 0) {
            throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
        }
        return new String(cArray, 0, n4);
    }

    @Override
    public String toUnicodeStringWithReplacement(byte[] byArray, int n2, int n3) {
        char[] cArray = new char[n3 * 2];
        int n4 = 0;
        while (n3 >= 4) {
            int n5 = byArray[n2] << 8 & 0xFF00 | byArray[n2 + 1] & 0xFF;
            int n6 = this.m_ucsCharReplacement;
            for (int i2 = 0; i2 < this.m_ucsCharLeadingCode.length; ++i2) {
                if (n5 != this.m_ucsCharLeadingCode[i2][0]) continue;
                char c2 = this.m_ucsCharLeadingCode[i2][1];
                int n7 = byArray[n2 + 2] << 8 & 0xFF00 | byArray[n2 + 3] & 0xFF;
                int n8 = (n7 >> 8 & 0xFF) + c2;
                int n9 = n7 & 0xFF;
                if (this.m_ucsCharLevel1[n8] != '\uffff' && this.m_ucsCharLevel2[this.m_ucsCharLevel1[n8] + n9] != -1) {
                    n6 = this.m_ucsCharLevel2[this.m_ucsCharLevel1[n8] + n9];
                    break;
                }
                n6 = this.m_ucsCharReplacement;
                break;
            }
            if (((long)n6 & 0xFFFFFFFFL) > 65535L) {
                cArray[n4++] = (char)(n6 >>> 16);
                cArray[n4++] = (char)(n6 & 0xFFFF);
            } else {
                cArray[n4++] = (char)n6;
            }
            n3 -= 4;
            n2 += 4;
        }
        return new String(cArray, 0, n4);
    }

    public int ByteToCharConvert(byte[] byArray, int n2, int n3, char[] cArray, int n4, int n5) throws IOException, CharConversionException, IndexOutOfBoundsException {
        return 0;
    }

    public int CharToByteConvert(char[] cArray, int n2, int n3, byte[] byArray, int n4, int n5) throws IOException, CharConversionException, IndexOutOfBoundsException {
        return 0;
    }

    @Override
    public int toUnicodeCharsWithReplacement(byte[] byArray, int n2, char[] cArray, int n3, int n4) {
        return 0;
    }
}

