/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.sql.SQLException;
import oracle.i18n.text.OraCharset;
import oracle.i18n.text.UTFUtility;

class OraCharsetEncoder
extends CharsetEncoder {
    private int maxBPC;

    OraCharsetEncoder(OraCharset oraCharset, float f2, float f3, byte[] byArray) {
        super(oraCharset, f2, f3, byArray);
        this.maxBPC = (int)Math.ceil(f3);
    }

    OraCharsetEncoder(OraCharset oraCharset, float f2, float f3) {
        super(oraCharset, f2, f3);
        this.maxBPC = (int)Math.ceil(f3);
    }

    @Override
    public CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n2;
        int n3 = charBuffer.position();
        int n4 = charBuffer.remaining();
        if (n4 == 0) {
            return CoderResult.UNDERFLOW;
        }
        boolean bl = false;
        if (n4 * this.maxBPC > byteBuffer.remaining()) {
            bl = true;
            if (byteBuffer.remaining() / this.maxBPC < 1) {
                return CoderResult.OVERFLOW;
            }
            n2 = UTFUtility.isHiSurrogate(charBuffer.charAt(byteBuffer.remaining() / this.maxBPC - 1)) && UTFUtility.isLoSurrogate(charBuffer.charAt(byteBuffer.remaining() / this.maxBPC)) ? byteBuffer.remaining() / this.maxBPC - 1 : byteBuffer.remaining() / this.maxBPC;
        } else {
            n2 = n4;
        }
        n2 = n2 < n4 ? n2 : n4;
        char[] cArray = new char[n2];
        charBuffer.get(cArray);
        try {
            byte[] byArray;
            byte[] byArray2 = byArray = CodingErrorAction.REPLACE == this.unmappableCharacterAction() ? ((OraCharset)this.charset()).convertWithReplacement(new String(cArray, 0, cArray.length)) : ((OraCharset)this.charset()).convert(new String(cArray, 0, cArray.length));
            if (byArray.length > byteBuffer.remaining()) {
                bl = true;
                charBuffer.position(n3);
                char[] cArray2 = new char[n2 - 2];
                charBuffer.get(cArray2);
                byte[] byArray3 = byArray = CodingErrorAction.REPLACE == this.unmappableCharacterAction() ? ((OraCharset)this.charset()).convertWithReplacement(new String(cArray2, 0, cArray2.length)) : ((OraCharset)this.charset()).convert(new String(cArray2, 0, cArray2.length));
            }
            if (bl) {
                byteBuffer.put(byArray);
                return CoderResult.OVERFLOW;
            }
            byteBuffer.put(byArray);
            return CoderResult.UNDERFLOW;
        }
        catch (SQLException sQLException) {
            charBuffer.position(n3);
            return CoderResult.unmappableForLength(n4);
        }
    }
}

