/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import java.io.UTFDataFormatException;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import oracle.i18n.text.OraCharsetAL16UTF16;
import oracle.i18n.text.OraCharsetAL16UTF16LE;
import oracle.i18n.text.OraCharsetAL32UTF8;
import oracle.i18n.text.OraCharsetISO2022JP;
import oracle.i18n.text.OraCharsetUTF;
import oracle.i18n.text.OraCharsetUTFE;
import oracle.i18n.text.OraCharsetWithConverter;
import oracle.i18n.text.UTFUtility;
import oracle.i18n.text.converter.CharsetMeta;

public abstract class OraCharset
extends Charset {
    private static final int CONCAIN_CHARSET_TABLE = 2;
    private static final int AL16UTF16_CHARSET = 2000;
    private static final int AL16UTF16LE_CHARSET = 2002;
    private static final int UNICODE_1_CHARSET = 870;
    private static final int UNICODE_2_CHARSET = 871;
    private static final int UTFE_CHARSET = 872;
    private static final int AL32UTF8_CHARSET = 873;
    private static final int ISO2022JP_CHARSET = 9999;
    private static final int ISO2022_JP_OUTLOOK_CHARSET = 9994;
    private static final int ISO2022_JP_OUTLOOK_HWKANA_CHARSET = 9995;
    private static final byte[] REP_CHAR_UTF8 = new byte[]{-17, -65, -67};
    static final String ORACHARSET_PREFIX = "X-ORACLE-";
    private static HashMap OraCharsetCache = null;
    protected int oracleId;
    private static final String[] UNSUPPORTED_CHARSET = new String[]{"WE8DECTST", "ZHT32EUCTST", "WE16DECTST2", "WE16DECTST", "KO16TSTSET", "JA16TSTSET2", "JA16TSTSET", "US16TSTFIXED", "UTF16", "HZ-GB-2312", "ISO2022-KR", "ISO2022-CN"};

    OraCharset(String string, int n2) {
        super(string, null);
        this.oracleId = n2;
    }

    static OraCharset getInstance(String string) {
        String string2;
        int n2;
        if (!string.toUpperCase(Locale.US).startsWith(ORACHARSET_PREFIX)) {
            return null;
        }
        OraCharset oraCharset = null;
        String string3 = string.substring(ORACHARSET_PREFIX.length()).toUpperCase(Locale.US);
        for (int i2 = 0; i2 < UNSUPPORTED_CHARSET.length; ++i2) {
            if (!string3.equalsIgnoreCase(UNSUPPORTED_CHARSET[i2])) continue;
            return null;
        }
        if (OraCharsetCache != null) {
            oraCharset = (OraCharset)OraCharsetCache.get(string3);
            if (oraCharset != null) {
                return oraCharset;
            }
        } else {
            OraCharsetCache = new HashMap();
        }
        int n3 = n2 = (string2 = CharsetMeta.getInstance().getCharSetId(string3)) == null ? -1 : Integer.parseInt(string2);
        if (n2 == -1) {
            return null;
        }
        switch (n2) {
            case 2000: {
                oraCharset = new OraCharsetAL16UTF16(string, n2);
                break;
            }
            case 870: 
            case 871: {
                oraCharset = new OraCharsetUTF(string, n2);
                break;
            }
            case 873: {
                oraCharset = new OraCharsetAL32UTF8(string, n2);
                break;
            }
            case 872: {
                oraCharset = new OraCharsetUTFE(string, n2);
                break;
            }
            case 2002: {
                oraCharset = new OraCharsetAL16UTF16LE(string, n2);
                break;
            }
            case 9999: {
                oraCharset = new OraCharsetISO2022JP(string, n2);
                break;
            }
            default: {
                oraCharset = OraCharsetWithConverter.getInstance(string, n2);
            }
        }
        OraCharsetCache.put(string3, oraCharset);
        return oraCharset;
    }

    @Override
    public boolean contains(Charset charset) {
        String string = charset.name().toUpperCase(Locale.US);
        int n2 = 0;
        if (!string.startsWith(ORACHARSET_PREFIX)) {
            return false;
        }
        n2 = ((OraCharset)charset).oracleId;
        if (this.oracleId == n2) {
            return true;
        }
        CharsetMeta charsetMeta = CharsetMeta.getInstance();
        int[] nArray = charsetMeta.getContainsCharset(this.oracleId);
        if (nArray != null) {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (nArray[i2] != n2) continue;
                return true;
            }
        }
        return false;
    }

    abstract String toStringWithReplacement(byte[] var1, int var2, int var3);

    abstract String toString(byte[] var1, int var2, int var3) throws SQLException;

    abstract byte[] convertWithReplacement(String var1);

    abstract byte[] convert(String var1) throws SQLException;

    static int UTFToJavaChar(byte[] byArray, int n2, int n3, char[] cArray, CharacterConverterBehavior characterConverterBehavior) throws UTFDataFormatException {
        int n4 = n2;
        int n5 = n2 + n3;
        if (n5 > byArray.length) {
            n5 = byArray.length;
        }
        int n6 = 0;
        block5: while (n4 < n5) {
            byte by = byArray[n4++];
            int n7 = by & 0xF0;
            switch (n7 / 16) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    cArray[n6++] = (char)(by & 0xFFFFFFFF);
                    break;
                }
                case 12: 
                case 13: {
                    if (n4 >= n5) {
                        n4 = n5;
                        characterConverterBehavior.onFailConversion();
                        break;
                    }
                    char c2 = UTFUtility.conv2ByteUTFtoUTF16(by, byArray[n4++]);
                    cArray[n6++] = c2;
                    characterConverterBehavior.onFailConversion(c2);
                    break;
                }
                case 14: {
                    if (n4 + 1 >= n5) {
                        n4 = n5;
                        characterConverterBehavior.onFailConversion();
                        break;
                    }
                    char c2 = UTFUtility.conv3ByteUTFtoUTF16(by, byArray[n4++], byArray[n4++]);
                    if (by != REP_CHAR_UTF8[0] || byArray[n4 - 2] != REP_CHAR_UTF8[1] || byArray[n4 - 1] != REP_CHAR_UTF8[2]) {
                        characterConverterBehavior.onFailConversion(c2);
                    }
                    if (UTFUtility.isHiSurrogate(c2)) {
                        char c3;
                        if (n4 >= n5) continue block5;
                        by = byArray[n4];
                        if ((byte)(by & 0xF0) != -32) {
                            cArray[n6++] = 65533;
                            characterConverterBehavior.onFailConversion();
                            break;
                        }
                        if (++n4 + 1 >= n5) {
                            n4 = n5;
                            characterConverterBehavior.onFailConversion();
                            break;
                        }
                        if (UTFUtility.isLoSurrogate(c3 = UTFUtility.conv3ByteUTFtoUTF16(by, byArray[n4++], byArray[n4++]))) {
                            cArray[n6++] = c2;
                        } else {
                            cArray[n6++] = 65533;
                            characterConverterBehavior.onFailConversion();
                        }
                        cArray[n6++] = c3;
                        break;
                    }
                    cArray[n6++] = c2;
                    break;
                }
                default: {
                    cArray[n6++] = 65533;
                    characterConverterBehavior.onFailConversion();
                }
            }
        }
        return n6;
    }

    static int AL32UTF8ToJavaChar(byte[] byArray, int n2, int n3, char[] cArray, CharacterConverterBehavior characterConverterBehavior) throws UTFDataFormatException {
        int n4 = n2;
        int n5 = n2 + n3;
        if (n5 > byArray.length) {
            n5 = byArray.length;
        }
        int n6 = 0;
        block6: while (n4 < n5) {
            byte by = byArray[n4++];
            int n7 = by & 0xF0;
            switch (n7 / 16) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    cArray[n6++] = (char)(by & 0xFFFFFFFF);
                    break;
                }
                case 12: 
                case 13: {
                    if (n4 >= n5) {
                        n4 = n5;
                        characterConverterBehavior.onFailConversion();
                        break;
                    }
                    char c2 = UTFUtility.conv2ByteUTFtoUTF16(by, byArray[n4++]);
                    cArray[n6++] = c2;
                    characterConverterBehavior.onFailConversion(c2);
                    break;
                }
                case 14: {
                    if (n4 + 1 >= n5) {
                        n4 = n5;
                        characterConverterBehavior.onFailConversion();
                        break;
                    }
                    char c2 = UTFUtility.conv3ByteAL32UTF8toUTF16(by, byArray[n4++], byArray[n4++]);
                    cArray[n6++] = c2;
                    if (by == REP_CHAR_UTF8[0] && byArray[n4 - 2] == REP_CHAR_UTF8[1] && byArray[n4 - 1] == REP_CHAR_UTF8[2]) continue block6;
                    characterConverterBehavior.onFailConversion(c2);
                    break;
                }
                case 15: {
                    char c2;
                    if (n4 + 2 >= n5) {
                        n4 = n5;
                        characterConverterBehavior.onFailConversion();
                        break;
                    }
                    if ((c2 = UTFUtility.conv4ByteAL32UTF8toUTF16(by, byArray[n4++], byArray[n4++], byArray[n4++], cArray, n6)) == '\u0001') {
                        characterConverterBehavior.onFailConversion();
                        ++n6;
                        break;
                    }
                    n6 += 2;
                    break;
                }
                default: {
                    cArray[n6++] = 65533;
                    characterConverterBehavior.onFailConversion();
                }
            }
        }
        return n6;
    }

    static int AL16UTF16BytesToJavaChars(byte[] byArray, int n2, int n3, char[] cArray, CharacterConverterBehavior characterConverterBehavior) throws UTFDataFormatException {
        int n4 = n2 + n3;
        int n5 = 0;
        for (int i2 = n2; n5 < cArray.length && i2 < n4; i2 += 2) {
            int n6 = (byArray[i2] << 8) + (byArray[i2 + 1] & 0xFF);
            if (UTFUtility.isHiSurrogate((char)n6)) {
                if (n5 + 1 >= cArray.length || (i2 += 2) >= n4) continue;
                char c2 = (char)((byArray[i2] << 8) + (byArray[i2 + 1] & 0xFF));
                cArray[n5++] = UTFUtility.isLoSurrogate(c2) ? n6 : 65533;
                cArray[n5++] = c2;
                continue;
            }
            cArray[n5++] = n6;
        }
        return n5;
    }

    static int AL16UTF16LEBytesToJavaChars(byte[] byArray, int n2, int n3, char[] cArray, CharacterConverterBehavior characterConverterBehavior) throws UTFDataFormatException {
        int n4 = n2 + n3;
        int n5 = 0;
        for (int i2 = n2; n5 < cArray.length && i2 < n4; i2 += 2) {
            int n6 = (byArray[i2 + 1] << 8) + (byArray[i2] & 0xFF);
            if (UTFUtility.isHiSurrogate((char)n6)) {
                if (n5 + 1 >= cArray.length || (i2 += 2) >= n4) continue;
                char c2 = (char)((byArray[i2 + 1] << 8) + (byArray[i2] & 0xFF));
                cArray[n5++] = UTFUtility.isLoSurrogate(c2) ? n6 : 65533;
                cArray[n5++] = c2;
                continue;
            }
            cArray[n5++] = n6;
        }
        return n5;
    }

    static int javaCharsToAL16UTF16Bytes(char[] cArray, int n2, byte[] byArray) {
        int n3 = Math.min(n2, byArray.length >>> 1);
        int n4 = 0;
        int n5 = 0;
        while (n4 < n3) {
            byArray[n5] = (byte)(cArray[n4] >>> 8);
            byArray[n5 + 1] = (byte)(cArray[n4] & 0xFF);
            ++n4;
            n5 += 2;
        }
        return n5;
    }

    static int javaCharsToAL16UTF16LEBytes(char[] cArray, int n2, byte[] byArray) {
        int n3 = Math.min(n2, byArray.length >>> 1);
        int n4 = 0;
        int n5 = 0;
        while (n4 < n3) {
            byArray[n5] = (byte)(cArray[n4] & 0xFF);
            byArray[n5 + 1] = (byte)(cArray[n4] >>> 8);
            ++n4;
            n5 += 2;
        }
        return n5;
    }

    public static int UTFStringLength(byte[] byArray, int n2, int n3) {
        int n4 = 0;
        int n5 = n2;
        int n6 = n2 + n3;
        block6: while (n5 < n6) {
            switch ((byArray[n5] & 0xF0) >>> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n5;
                    ++n4;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if (n5 + 1 >= n6) {
                        n5 = n6;
                        continue block6;
                    }
                    ++n4;
                    n5 += 2;
                    continue block6;
                }
                case 14: {
                    if (n5 + 2 >= n6) {
                        n5 = n6;
                        continue block6;
                    }
                    ++n4;
                    n5 += 3;
                    continue block6;
                }
                case 15: {
                    if (n5 + 3 >= n6) {
                        n5 = n6;
                        continue block6;
                    }
                    n4 += 2;
                    n5 += 4;
                    continue block6;
                }
            }
            ++n5;
            ++n4;
        }
        return n4;
    }

    static int javaCharsToUTF(char[] cArray, int n2, int n3, byte[] byArray, int n4) {
        int n5 = n2;
        int n6 = n2 + n3;
        if (n5 < 0) {
            n5 = 0;
        }
        if (n6 > cArray.length) {
            n6 = cArray.length;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        int n7 = n4;
        for (int i2 = n5; i2 < n6; ++i2) {
            char c2 = cArray[i2];
            if (c2 >= '\u0000' && c2 <= '\u007f') {
                byArray[n7++] = (byte)c2;
                continue;
            }
            if (c2 > '\u07ff') {
                byArray[n7++] = (byte)(0xE0 | c2 >>> 12 & 0xF);
                byArray[n7++] = (byte)(0x80 | c2 >>> 6 & 0x3F);
                byArray[n7++] = (byte)(0x80 | c2 >>> 0 & 0x3F);
                continue;
            }
            byArray[n7++] = (byte)(0xC0 | c2 >>> 6 & 0x1F);
            byArray[n7++] = (byte)(0x80 | c2 >>> 0 & 0x3F);
        }
        return n7 - n4;
    }

    static int javaCharsToAL32UTF8(char[] cArray, int n2, int n3, byte[] byArray, int n4) {
        int n5 = n2;
        int n6 = n2 + n3;
        if (n5 < 0) {
            n5 = 0;
        }
        if (n6 > cArray.length) {
            n6 = cArray.length;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        int n7 = n4;
        for (int i2 = n5; i2 < n6; ++i2) {
            char c2 = cArray[i2];
            char c3 = '\u0000';
            if (c2 >= '\u0000' && c2 <= '\u007f') {
                byArray[n7++] = (byte)c2;
                continue;
            }
            if (UTFUtility.isHiSurrogate(c2)) {
                if (i2 + 1 < n6 && UTFUtility.isLoSurrogate(c3 = cArray[i2 + 1])) {
                    int n8 = (c2 >>> 6 & 0xF) + 1;
                    byArray[n7++] = (byte)(n8 >>> 2 | 0xF0);
                    byArray[n7++] = (byte)((n8 & 3) << 4 | c2 >>> 2 & 0xF | 0x80);
                    byArray[n7++] = (byte)((c2 & 3) << 4 | c3 >>> 6 & 0xF | 0x80);
                    byArray[n7++] = (byte)(c3 & 0x3F | 0x80);
                    ++i2;
                    continue;
                }
                byArray[n7++] = -17;
                byArray[n7++] = -65;
                byArray[n7++] = -67;
                continue;
            }
            if (c2 > '\u07ff') {
                byArray[n7++] = (byte)(0xE0 | c2 >>> 12 & 0xF);
                byArray[n7++] = (byte)(0x80 | c2 >>> 6 & 0x3F);
                byArray[n7++] = (byte)(0x80 | c2 >>> 0 & 0x3F);
                continue;
            }
            byArray[n7++] = (byte)(0xC0 | c2 >>> 6 & 0x1F);
            byArray[n7++] = (byte)(0x80 | c2 >>> 0 & 0x3F);
        }
        return n7 - n4;
    }

    public static int stringUTFLength(String string) {
        int n2 = 0;
        for (char c2 : string.toCharArray()) {
            if (c2 >= '\u0000' && c2 <= '\u007f') {
                ++n2;
                continue;
            }
            if (c2 > '\u07ff') {
                n2 += 3;
                continue;
            }
            n2 += 2;
        }
        return n2;
    }

    public static int string32UTF8Length(String string) {
        int n2 = 0;
        char[] cArray = string.toCharArray();
        int n3 = cArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = cArray[i2];
            if (c2 >= '\u0000' && c2 <= '\u007f') {
                ++n2;
                continue;
            }
            if (c2 > '\u07ff') {
                if (UTFUtility.isHiSurrogate(c2)) {
                    if (i2 + 1 >= n3) continue;
                    n2 += 4;
                    ++i2;
                    continue;
                }
                n2 += 3;
                continue;
            }
            n2 += 2;
        }
        return n2;
    }

    public static boolean isDefined(String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= '\udc00' && c2 <= '\udfff') {
                return false;
            }
            if (c2 >= '\ud800' && c2 <= '\udbff') {
                if (i2 + 1 >= n2) {
                    return false;
                }
                char c3 = string.charAt(i2 + 1);
                if (c3 < '\udc00' || c3 > '\udfff') {
                    return false;
                }
                ++i2;
                continue;
            }
            if (c2 != '\ufffe' && c2 != '\uffff') continue;
            return false;
        }
        return true;
    }

    static abstract class CharacterConverterBehavior {
        public static final char[] NULL_CHARS = new char[1];
        public static final char UTF16_REPLACEMENT_CHAR = '\ufffd';
        public static final CharacterConverterBehavior REPORT_ERROR = new CharacterConverterBehavior("Report Error"){

            @Override
            public void onFailConversion() throws UTFDataFormatException {
                throw new UTFDataFormatException();
            }

            @Override
            public void onFailConversion(char c2) throws UTFDataFormatException {
                if (c2 == '\ufffd') {
                    throw new UTFDataFormatException();
                }
            }
        };
        public static final CharacterConverterBehavior REPLACEMENT = new CharacterConverterBehavior("Replacement"){

            @Override
            public void onFailConversion() throws UTFDataFormatException {
            }

            @Override
            public void onFailConversion(char c2) throws UTFDataFormatException {
            }
        };
        private final String m_name;

        public CharacterConverterBehavior(String string) {
            this.m_name = string;
        }

        public abstract void onFailConversion(char var1) throws UTFDataFormatException;

        public abstract void onFailConversion() throws UTFDataFormatException;
    }
}

