/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.squareup.okhttp.internal.http.HttpDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class Headers {
    private final String[] namesAndValues;

    private Headers(Builder builder) {
        this.namesAndValues = builder.namesAndValues.toArray(new String[builder.namesAndValues.size()]);
    }

    private Headers(String[] namesAndValues) {
        this.namesAndValues = namesAndValues;
    }

    public String get(String name) {
        return Headers.get(this.namesAndValues, name);
    }

    public Date getDate(String name) {
        String value = this.get(name);
        return value != null ? HttpDate.parse(value) : null;
    }

    public int size() {
        return this.namesAndValues.length / 2;
    }

    public String name(int index) {
        int nameIndex = index * 2;
        if (nameIndex < 0 || nameIndex >= this.namesAndValues.length) {
            return null;
        }
        return this.namesAndValues[nameIndex];
    }

    public String value(int index) {
        int valueIndex = index * 2 + 1;
        if (valueIndex < 0 || valueIndex >= this.namesAndValues.length) {
            return null;
        }
        return this.namesAndValues[valueIndex];
    }

    public Set<String> names() {
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        int size = this.size();
        for (int i2 = 0; i2 < size; ++i2) {
            result.add(this.name(i2));
        }
        return Collections.unmodifiableSet(result);
    }

    public List<String> values(String name) {
        ArrayList<String> result = null;
        int size = this.size();
        for (int i2 = 0; i2 < size; ++i2) {
            if (!name.equalsIgnoreCase(this.name(i2))) continue;
            if (result == null) {
                result = new ArrayList<String>(2);
            }
            result.add(this.value(i2));
        }
        return result != null ? Collections.unmodifiableList(result) : Collections.emptyList();
    }

    public Builder newBuilder() {
        Builder result = new Builder();
        Collections.addAll(result.namesAndValues, this.namesAndValues);
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        int size = this.size();
        for (int i2 = 0; i2 < size; ++i2) {
            result.append(this.name(i2)).append(": ").append(this.value(i2)).append("\n");
        }
        return result.toString();
    }

    public Map<String, List<String>> toMultimap() {
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
        int size = this.size();
        for (int i2 = 0; i2 < size; ++i2) {
            String name = this.name(i2);
            ArrayList<String> values = (ArrayList<String>)result.get(name);
            if (values == null) {
                values = new ArrayList<String>(2);
                result.put(name, values);
            }
            values.add(this.value(i2));
        }
        return result;
    }

    private static String get(String[] namesAndValues, String name) {
        for (int i2 = namesAndValues.length - 2; i2 >= 0; i2 -= 2) {
            if (!name.equalsIgnoreCase(namesAndValues[i2])) continue;
            return namesAndValues[i2 + 1];
        }
        return null;
    }

    public static Headers of(String ... namesAndValues) {
        int i2;
        if (namesAndValues == null || namesAndValues.length % 2 != 0) {
            throw new IllegalArgumentException("Expected alternating header names and values");
        }
        namesAndValues = (String[])namesAndValues.clone();
        for (i2 = 0; i2 < namesAndValues.length; ++i2) {
            if (namesAndValues[i2] == null) {
                throw new IllegalArgumentException("Headers cannot be null");
            }
            namesAndValues[i2] = namesAndValues[i2].trim();
        }
        for (i2 = 0; i2 < namesAndValues.length; i2 += 2) {
            String name = namesAndValues[i2];
            String value = namesAndValues[i2 + 1];
            if (name.length() != 0 && name.indexOf(0) == -1 && value.indexOf(0) == -1) continue;
            throw new IllegalArgumentException("Unexpected header: " + name + ": " + value);
        }
        return new Headers(namesAndValues);
    }

    public static Headers of(Map<String, String> headers) {
        if (headers == null) {
            throw new IllegalArgumentException("Expected map with header names and values");
        }
        String[] namesAndValues = new String[headers.size() * 2];
        int i2 = 0;
        for (Map.Entry<String, String> header : headers.entrySet()) {
            if (header.getKey() == null || header.getValue() == null) {
                throw new IllegalArgumentException("Headers cannot be null");
            }
            String name = header.getKey().trim();
            String value = header.getValue().trim();
            if (name.length() == 0 || name.indexOf(0) != -1 || value.indexOf(0) != -1) {
                throw new IllegalArgumentException("Unexpected header: " + name + ": " + value);
            }
            namesAndValues[i2] = name;
            namesAndValues[i2 + 1] = value;
            i2 += 2;
        }
        return new Headers(namesAndValues);
    }

    public static final class Builder {
        private final List<String> namesAndValues = new ArrayList<String>(20);

        Builder addLenient(String line) {
            int index = line.indexOf(":", 1);
            if (index != -1) {
                return this.addLenient(line.substring(0, index), line.substring(index + 1));
            }
            if (line.startsWith(":")) {
                return this.addLenient("", line.substring(1));
            }
            return this.addLenient("", line);
        }

        public Builder add(String line) {
            int index = line.indexOf(":");
            if (index == -1) {
                throw new IllegalArgumentException("Unexpected header: " + line);
            }
            return this.add(line.substring(0, index).trim(), line.substring(index + 1));
        }

        public Builder add(String name, String value) {
            this.checkNameAndValue(name, value);
            return this.addLenient(name, value);
        }

        Builder addLenient(String name, String value) {
            this.namesAndValues.add(name);
            this.namesAndValues.add(value.trim());
            return this;
        }

        public Builder removeAll(String name) {
            for (int i2 = 0; i2 < this.namesAndValues.size(); i2 += 2) {
                if (!name.equalsIgnoreCase(this.namesAndValues.get(i2))) continue;
                this.namesAndValues.remove(i2);
                this.namesAndValues.remove(i2);
                i2 -= 2;
            }
            return this;
        }

        public Builder set(String name, String value) {
            this.checkNameAndValue(name, value);
            this.removeAll(name);
            this.addLenient(name, value);
            return this;
        }

        private void checkNameAndValue(String name, String value) {
            char c2;
            int i2;
            if (name == null) {
                throw new IllegalArgumentException("name == null");
            }
            if (name.isEmpty()) {
                throw new IllegalArgumentException("name is empty");
            }
            int length = name.length();
            for (i2 = 0; i2 < length; ++i2) {
                c2 = name.charAt(i2);
                if (c2 > '\u001f' && c2 < '\u007f') continue;
                throw new IllegalArgumentException(String.format("Unexpected char %#04x at %d in header name: %s", c2, i2, name));
            }
            if (value == null) {
                throw new IllegalArgumentException("value == null");
            }
            length = value.length();
            for (i2 = 0; i2 < length; ++i2) {
                c2 = value.charAt(i2);
                if (c2 > '\u001f' && c2 < '\u007f') continue;
                throw new IllegalArgumentException(String.format("Unexpected char %#04x at %d in header value: %s", c2, i2, value));
            }
        }

        public String get(String name) {
            for (int i2 = this.namesAndValues.size() - 2; i2 >= 0; i2 -= 2) {
                if (!name.equalsIgnoreCase(this.namesAndValues.get(i2))) continue;
                return this.namesAndValues.get(i2 + 1);
            }
            return null;
        }

        public Headers build() {
            return new Headers(this);
        }
    }
}

