/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj;

import com.mysql.cj.AbstractQuery;
import com.mysql.cj.AbstractQueryBindings;
import com.mysql.cj.BindValue;
import com.mysql.cj.Constants;
import com.mysql.cj.Messages;
import com.mysql.cj.NativeSession;
import com.mysql.cj.ParseInfo;
import com.mysql.cj.PreparedQuery;
import com.mysql.cj.QueryBindings;
import com.mysql.cj.conf.PropertyKey;
import com.mysql.cj.conf.RuntimeProperty;
import com.mysql.cj.exceptions.ExceptionFactory;
import com.mysql.cj.exceptions.WrongArgumentException;
import com.mysql.cj.protocol.Message;
import com.mysql.cj.protocol.a.NativeConstants;
import com.mysql.cj.protocol.a.NativePacketPayload;
import com.mysql.cj.protocol.a.ValueEncoder;
import com.mysql.cj.util.StringUtils;
import com.mysql.cj.util.Util;
import java.io.IOException;
import java.io.InputStream;

public abstract class AbstractPreparedQuery<T extends QueryBindings<?>>
extends AbstractQuery
implements PreparedQuery<T> {
    protected ParseInfo parseInfo;
    protected T queryBindings = null;
    protected String originalSql = null;
    protected int parameterCount;
    protected RuntimeProperty<Boolean> autoClosePStmtStreams = this.session.getPropertySet().getBooleanProperty(PropertyKey.autoClosePStmtStreams);
    protected int batchCommandIndex = -1;
    protected RuntimeProperty<Boolean> useStreamLengthsInPrepStmts = this.session.getPropertySet().getBooleanProperty(PropertyKey.useStreamLengthsInPrepStmts);
    private byte[] streamConvertBuf = null;
    private boolean usingAnsiMode = !this.session.getServerSession().useAnsiQuotedIdentifiers();

    public AbstractPreparedQuery(NativeSession sess) {
        super(sess);
    }

    @Override
    public void closeQuery() {
        this.streamConvertBuf = null;
        super.closeQuery();
    }

    @Override
    public ParseInfo getParseInfo() {
        return this.parseInfo;
    }

    @Override
    public void setParseInfo(ParseInfo parseInfo) {
        this.parseInfo = parseInfo;
    }

    @Override
    public String getOriginalSql() {
        return this.originalSql;
    }

    @Override
    public void setOriginalSql(String originalSql) {
        this.originalSql = originalSql;
    }

    @Override
    public int getParameterCount() {
        return this.parameterCount;
    }

    @Override
    public void setParameterCount(int parameterCount) {
        this.parameterCount = parameterCount;
    }

    @Override
    public T getQueryBindings() {
        return this.queryBindings;
    }

    @Override
    public void setQueryBindings(T queryBindings) {
        this.queryBindings = queryBindings;
    }

    @Override
    public int getBatchCommandIndex() {
        return this.batchCommandIndex;
    }

    @Override
    public void setBatchCommandIndex(int batchCommandIndex) {
        this.batchCommandIndex = batchCommandIndex;
    }

    @Override
    public int computeBatchSize(int numBatchedArgs) {
        long[] combinedValues = this.computeMaxParameterSetSizeAndBatchSize(numBatchedArgs);
        long maxSizeOfParameterSet = combinedValues[0];
        long sizeOfEntireBatch = combinedValues[1];
        if (sizeOfEntireBatch < (long)((Integer)this.maxAllowedPacket.getValue() - this.originalSql.length())) {
            return numBatchedArgs;
        }
        return (int)Math.max(1L, (long)((Integer)this.maxAllowedPacket.getValue() - this.originalSql.length()) / maxSizeOfParameterSet);
    }

    @Override
    public void checkNullOrEmptyQuery(String sql) {
        if (sql == null) {
            throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("PreparedQuery.0"), this.session.getExceptionInterceptor());
        }
        if (sql.length() == 0) {
            throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("PreparedQuery.1"), this.session.getExceptionInterceptor());
        }
    }

    @Override
    public String asSql() {
        return this.asSql(false);
    }

    @Override
    public String asSql(boolean quoteStreamsAndUnknowns) {
        StringBuilder buf = new StringBuilder();
        Object batchArg = null;
        if (this.batchCommandIndex != -1) {
            batchArg = this.batchedArgs.get(this.batchCommandIndex);
        }
        byte[][] staticSqlStrings = this.parseInfo.getStaticSql();
        for (int i2 = 0; i2 < this.parameterCount; ++i2) {
            boolean isStreamParam;
            buf.append(this.charEncoding != null ? StringUtils.toString(staticSqlStrings[i2], this.charEncoding) : StringUtils.toString(staticSqlStrings[i2]));
            byte[] val = null;
            if (batchArg != null && batchArg instanceof String) {
                buf.append((String)batchArg);
                continue;
            }
            byte[] byArray = this.batchCommandIndex == -1 ? (this.queryBindings == null ? null : this.queryBindings.getBindValues()[i2].getByteValue()) : (val = ((QueryBindings)batchArg).getBindValues()[i2].getByteValue());
            boolean bl = this.batchCommandIndex == -1 ? (this.queryBindings == null ? false : this.queryBindings.getBindValues()[i2].isStream()) : (isStreamParam = ((QueryBindings)batchArg).getBindValues()[i2].isStream());
            if (val == null && !isStreamParam) {
                buf.append(quoteStreamsAndUnknowns ? "'** NOT SPECIFIED **'" : "** NOT SPECIFIED **");
                continue;
            }
            if (isStreamParam) {
                buf.append(quoteStreamsAndUnknowns ? "'** STREAM DATA **'" : "** STREAM DATA **");
                continue;
            }
            buf.append(StringUtils.toString(val, this.charEncoding));
        }
        buf.append(this.charEncoding != null ? StringUtils.toString(staticSqlStrings[this.parameterCount], this.charEncoding) : StringUtils.toAsciiString(staticSqlStrings[this.parameterCount]));
        return buf.toString();
    }

    protected abstract long[] computeMaxParameterSetSizeAndBatchSize(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <M extends Message> M fillSendPacket() {
        AbstractPreparedQuery abstractPreparedQuery = this;
        synchronized (abstractPreparedQuery) {
            return this.fillSendPacket((QueryBindings<?>)this.queryBindings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <M extends Message> M fillSendPacket(QueryBindings<?> bindings) {
        AbstractPreparedQuery abstractPreparedQuery = this;
        synchronized (abstractPreparedQuery) {
            BindValue[] bindValues = bindings.getBindValues();
            NativePacketPayload sendPacket = this.session.getSharedSendPacket();
            sendPacket.writeInteger(NativeConstants.IntegerDataType.INT1, 3L);
            if (this.getSession().getServerSession().supportsQueryAttributes()) {
                if (this.queryAttributesBindings.getCount() > 0) {
                    sendPacket.writeInteger(NativeConstants.IntegerDataType.INT_LENENC, this.queryAttributesBindings.getCount());
                    sendPacket.writeInteger(NativeConstants.IntegerDataType.INT_LENENC, 1L);
                    byte[] nullBitsBuffer = new byte[(this.queryAttributesBindings.getCount() + 7) / 8];
                    for (int i2 = 0; i2 < this.queryAttributesBindings.getCount(); ++i2) {
                        if (!this.queryAttributesBindings.getAttributeValue(i2).isNull()) continue;
                        int n2 = i2 >>> 3;
                        nullBitsBuffer[n2] = (byte)(nullBitsBuffer[n2] | 1 << (i2 & 7));
                    }
                    sendPacket.writeBytes(NativeConstants.StringLengthDataType.STRING_VAR, nullBitsBuffer);
                    sendPacket.writeInteger(NativeConstants.IntegerDataType.INT1, 1L);
                    this.queryAttributesBindings.runThroughAll(a2 -> {
                        sendPacket.writeInteger(NativeConstants.IntegerDataType.INT2, a2.getType());
                        sendPacket.writeBytes(NativeConstants.StringSelfDataType.STRING_LENENC, a2.getName().getBytes());
                    });
                    ValueEncoder valueEncoder = new ValueEncoder(sendPacket, this.charEncoding, this.session.getServerSession().getDefaultTimeZone());
                    this.queryAttributesBindings.runThroughAll(a2 -> valueEncoder.encodeValue(a2.getValue(), a2.getType()));
                } else {
                    sendPacket.writeInteger(NativeConstants.IntegerDataType.INT_LENENC, 0L);
                    sendPacket.writeInteger(NativeConstants.IntegerDataType.INT_LENENC, 1L);
                }
            } else if (this.queryAttributesBindings.getCount() > 0) {
                this.session.getLog().logWarn(Messages.getString("QueryAttributes.SetButNotSupported"));
            }
            sendPacket.setTag("QUERY");
            boolean useStreamLengths = this.useStreamLengthsInPrepStmts.getValue();
            int ensurePacketSize = 0;
            String statementComment = this.session.getProtocol().getQueryComment();
            byte[] commentAsBytes = null;
            if (statementComment != null) {
                commentAsBytes = StringUtils.getBytes(statementComment, this.charEncoding);
                ensurePacketSize += commentAsBytes.length;
                ensurePacketSize += 6;
            }
            for (int i3 = 0; i3 < bindValues.length; ++i3) {
                if (!bindValues[i3].isStream() || !useStreamLengths) continue;
                ensurePacketSize = (int)((long)ensurePacketSize + bindValues[i3].getStreamLength());
            }
            if (ensurePacketSize != 0) {
                sendPacket.ensureCapacity(ensurePacketSize);
            }
            if (commentAsBytes != null) {
                sendPacket.writeBytes(NativeConstants.StringLengthDataType.STRING_FIXED, Constants.SLASH_STAR_SPACE_AS_BYTES);
                sendPacket.writeBytes(NativeConstants.StringLengthDataType.STRING_FIXED, commentAsBytes);
                sendPacket.writeBytes(NativeConstants.StringLengthDataType.STRING_FIXED, Constants.SPACE_STAR_SLASH_SPACE_AS_BYTES);
            }
            byte[][] staticSqlStrings = this.parseInfo.getStaticSql();
            for (int i4 = 0; i4 < bindValues.length; ++i4) {
                bindings.checkParameterSet(i4);
                sendPacket.writeBytes(NativeConstants.StringLengthDataType.STRING_FIXED, staticSqlStrings[i4]);
                if (bindValues[i4].isStream()) {
                    this.streamToBytes(sendPacket, bindValues[i4].getStreamValue(), true, bindValues[i4].getStreamLength(), useStreamLengths);
                    continue;
                }
                sendPacket.writeBytes(NativeConstants.StringLengthDataType.STRING_FIXED, bindValues[i4].getByteValue());
            }
            sendPacket.writeBytes(NativeConstants.StringLengthDataType.STRING_FIXED, staticSqlStrings[bindValues.length]);
            return (M)sendPacket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void streamToBytes(NativePacketPayload packet, InputStream in, boolean escape, long streamLength, boolean useLength) {
        try {
            if (this.streamConvertBuf == null) {
                this.streamConvertBuf = new byte[4096];
            }
            boolean hexEscape = this.session.getServerSession().isNoBackslashEscapesSet();
            if (streamLength == -1L) {
                useLength = false;
            }
            int bc = useLength ? Util.readBlock(in, this.streamConvertBuf, (int)streamLength, this.session.getExceptionInterceptor()) : Util.readBlock(in, this.streamConvertBuf, this.session.getExceptionInterceptor());
            int lengthLeftToRead = (int)streamLength - bc;
            packet.writeBytes(NativeConstants.StringLengthDataType.STRING_FIXED, StringUtils.getBytes(hexEscape ? "x" : "_binary"));
            if (escape) {
                packet.writeInteger(NativeConstants.IntegerDataType.INT1, 39L);
            }
            while (bc > 0) {
                if (hexEscape) {
                    ((AbstractQueryBindings)this.queryBindings).hexEscapeBlock(this.streamConvertBuf, packet, bc);
                } else if (escape) {
                    this.escapeblockFast(this.streamConvertBuf, packet, bc);
                } else {
                    packet.writeBytes(NativeConstants.StringLengthDataType.STRING_FIXED, this.streamConvertBuf, 0, bc);
                }
                if (useLength) {
                    bc = Util.readBlock(in, this.streamConvertBuf, lengthLeftToRead, this.session.getExceptionInterceptor());
                    if (bc <= 0) continue;
                    lengthLeftToRead -= bc;
                    continue;
                }
                bc = Util.readBlock(in, this.streamConvertBuf, this.session.getExceptionInterceptor());
            }
            if (escape) {
                packet.writeInteger(NativeConstants.IntegerDataType.INT1, 39L);
            }
        }
        finally {
            if (this.autoClosePStmtStreams.getValue().booleanValue()) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                in = null;
            }
        }
    }

    private final void escapeblockFast(byte[] buf, NativePacketPayload packet, int size) {
        int lastwritten = 0;
        for (int i2 = 0; i2 < size; ++i2) {
            byte b2 = buf[i2];
            if (b2 == 0) {
                if (i2 > lastwritten) {
                    packet.writeBytes(NativeConstants.StringLengthDataType.STRING_FIXED, buf, lastwritten, i2 - lastwritten);
                }
                packet.writeInteger(NativeConstants.IntegerDataType.INT1, 92L);
                packet.writeInteger(NativeConstants.IntegerDataType.INT1, 48L);
                lastwritten = i2 + 1;
                continue;
            }
            if (b2 != 92 && b2 != 39 && (this.usingAnsiMode || b2 != 34)) continue;
            if (i2 > lastwritten) {
                packet.writeBytes(NativeConstants.StringLengthDataType.STRING_FIXED, buf, lastwritten, i2 - lastwritten);
            }
            packet.writeInteger(NativeConstants.IntegerDataType.INT1, 92L);
            lastwritten = i2;
        }
        if (lastwritten < size) {
            packet.writeBytes(NativeConstants.StringLengthDataType.STRING_FIXED, buf, lastwritten, size - lastwritten);
        }
    }
}

