/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.configuration.configurators;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import org.codehaus.plexus.util.StringUtils;

public class PropertiesManager {
    private Properties properties = new Properties();
    private Set<String> modifiedProperties = new HashSet<String>();
    private boolean loadedFromInputStream = false;
    private Set<String> removedPropertyNames = new HashSet<String>();
    private boolean unmodifiedCommentingActivated = false;
    private String additionalPropertiesMessage = "The following properties were added.";

    public PropertiesManager() {
    }

    public PropertiesManager(InputStream sourcePropertiesInputStream) throws IOException {
        this.loadProperties(sourcePropertiesInputStream);
    }

    public PropertiesManager(Properties properties) {
        this.properties = properties;
    }

    private void loadProperties(InputStream sourcePropertiesInputStream) throws IOException {
        this.properties = new Properties();
        this.properties.load(sourcePropertiesInputStream);
        sourcePropertiesInputStream.close();
        this.loadedFromInputStream = true;
    }

    public String getProperty(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    public void setProperty(String propertyName, String propvalue) {
        String oldValue = (String)this.properties.setProperty(propertyName, propvalue);
        if (!StringUtils.equals((String)oldValue, (String)propvalue)) {
            this.modifiedProperties.add(propertyName);
        }
    }

    public void removeProperty(String propertyName) {
        this.properties.remove(propertyName);
        this.removedPropertyNames.add(propertyName);
    }

    public void storeProperties(InputStream sourcePropertiesInputStream, String destPropertiesFilePath) throws IOException {
        if (this.loadedFromInputStream && sourcePropertiesInputStream == null) {
            throw new UnsupportedOperationException("If loaded from an input stream, it must be provided when storing the file");
        }
        ArrayList<String> outputLineList = new ArrayList<String>();
        String currentLine = null;
        File propertiesFileObject = new File(destPropertiesFilePath);
        File propertiesFileFolder = propertiesFileObject.getParentFile();
        if (!propertiesFileFolder.exists()) {
            propertiesFileFolder.mkdirs();
            propertiesFileFolder = null;
        }
        if (this.loadedFromInputStream) {
            BufferedReader buffered = new BufferedReader(new InputStreamReader(sourcePropertiesInputStream));
            boolean position = false;
            HashSet<Object> remainingPropertyNames = new HashSet<Object>(this.properties.keySet());
            while ((currentLine = buffered.readLine()) != null) {
                try {
                    currentLine = currentLine.replaceAll("\\t", "    ");
                    int equalPosition = currentLine.indexOf("=");
                    if (!currentLine.trim().equals("") && !currentLine.trim().startsWith("#") && equalPosition >= 0) {
                        String string = currentLine.substring(0, equalPosition).trim();
                        if (remainingPropertyNames.contains(string)) {
                            String propValue = this.properties.getProperty(string);
                            remainingPropertyNames.remove(string);
                            StringBuffer thisLineBuffer = new StringBuffer();
                            if (!this.unmodifiedCommentingActivated || this.modifiedProperties.contains(string)) {
                                thisLineBuffer.append(currentLine.substring(0, equalPosition + 1));
                                thisLineBuffer.append(" ");
                                thisLineBuffer.append(this.escapeValue(propValue));
                            } else {
                                thisLineBuffer.append("#");
                                thisLineBuffer.append(currentLine.substring(0, equalPosition + 1));
                                thisLineBuffer.append(" ");
                                thisLineBuffer.append(this.escapeValue(propValue));
                            }
                            outputLineList.add(thisLineBuffer.toString());
                            continue;
                        }
                        if (!this.removedPropertyNames.contains(string)) continue;
                    }
                    outputLineList.add(currentLine.trim());
                }
                catch (IndexOutOfBoundsException ioobe) {
                }
                catch (PatternSyntaxException ex1) {
                    ex1.printStackTrace();
                }
                catch (IllegalArgumentException ex2) {
                    ex2.printStackTrace();
                }
            }
            if (remainingPropertyNames.size() > 0 && this.additionalPropertiesMessage != null) {
                outputLineList.add("# " + this.additionalPropertiesMessage);
            }
            for (String string : remainingPropertyNames) {
                StringBuffer specialLineBuffer = new StringBuffer();
                specialLineBuffer.append(string);
                for (int i = 0; i < 55 - string.length(); ++i) {
                    specialLineBuffer.append(" ");
                }
                specialLineBuffer.append("=   ");
                specialLineBuffer.append(this.escapeValue(this.properties.getProperty(string)));
                outputLineList.add(specialLineBuffer.toString());
            }
            buffered.close();
            this.writeTheFile(destPropertiesFilePath, outputLineList);
        } else {
            FileOutputStream outputStream = new FileOutputStream(destPropertiesFilePath);
            this.properties.store(outputStream, "This file has been written by Jahia.");
            outputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTheFile(String propertiesFilePath, List bufferList) {
        File thisFile = null;
        OutputStreamWriter fileWriter = null;
        StringBuffer outputBuffer = null;
        try {
            thisFile = new File(propertiesFilePath);
            fileWriter = new FileWriter(thisFile);
            outputBuffer = new StringBuffer();
            for (int i = 0; i < bufferList.size(); ++i) {
                outputBuffer.append((String)bufferList.get(i));
                outputBuffer.append("\n");
            }
            fileWriter.write(outputBuffer.toString());
        }
        catch (IOException ioe) {
        }
        finally {
            try {
                fileWriter.close();
            }
            catch (IOException ioe2) {}
            fileWriter = null;
            thisFile = null;
        }
    }

    public Properties getPropertiesObject() {
        return this.properties;
    }

    public boolean isUnmodifiedCommentingActivated() {
        return this.unmodifiedCommentingActivated;
    }

    public void setUnmodifiedCommentingActivated(boolean unmodifiedCommentingActivated) {
        this.unmodifiedCommentingActivated = unmodifiedCommentingActivated;
    }

    public String getAdditionalPropertiesMessage() {
        return this.additionalPropertiesMessage;
    }

    public void setAdditionalPropertiesMessage(String additionalPropertiesMessage) {
        this.additionalPropertiesMessage = additionalPropertiesMessage;
    }

    private String escapeValue(String theString) {
        if (theString == null || theString.length() == 0 || !theString.contains("\\")) {
            return theString;
        }
        return StringUtils.replace((String)theString, (String)"\\", (String)"\\\\");
    }
}

