/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.configuration.configurators;

import java.io.FileWriter;
import java.io.Writer;
import java.util.Map;
import org.jahia.configuration.configurators.AbstractXMLConfigurator;
import org.jahia.configuration.configurators.ConfigFile;
import org.jahia.configuration.configurators.JahiaConfigInterface;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class MailServerConfigurator
extends AbstractXMLConfigurator {
    private JahiaConfigInterface cfg;

    public MailServerConfigurator(Map dbProperties, JahiaConfigInterface jahiaConfigInterface) {
        super(dbProperties, jahiaConfigInterface);
        this.cfg = jahiaConfigInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateConfiguration(ConfigFile sourceConfigFile, String destFileName) throws Exception {
        if (sourceConfigFile == null) {
            return;
        }
        SAXBuilder saxBuilder = new SAXBuilder();
        saxBuilder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        Document jdomDocument = saxBuilder.build(sourceConfigFile.getInputStream());
        Element el = this.getElement(jdomDocument.getRootElement(), "/content/settings/mail-server");
        if (el != null && this.cfg.getMailServer() != null && this.cfg.getMailServer().length() > 0) {
            Namespace jahiaNamespace = el.getNamespace("j");
            el.setAttribute("activated", "true", jahiaNamespace);
            el.setAttribute("uri", this.cfg.getMailServer(), jahiaNamespace);
            if (this.cfg.getMailFrom() != null) {
                el.setAttribute("from", this.cfg.getMailFrom(), jahiaNamespace);
            }
            if (this.cfg.getMailAdministrator() != null) {
                el.setAttribute("to", this.cfg.getMailAdministrator(), jahiaNamespace);
            }
            if (this.cfg.getMailParanoia() != null) {
                el.setAttribute("notificationLevel", this.cfg.getMailParanoia(), jahiaNamespace);
            }
        }
        Format customFormat = Format.getPrettyFormat();
        customFormat.setLineSeparator(System.getProperty("line.separator"));
        XMLOutputter xmlOutputter = new XMLOutputter(customFormat);
        FileWriter out = new FileWriter(destFileName);
        try {
            xmlOutputter.output(jdomDocument, (Writer)out);
        }
        finally {
            out.close();
        }
    }
}

