/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.configuration.configurators;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.codehaus.plexus.util.PropertyUtils;
import org.codehaus.plexus.util.StringUtils;
import org.jahia.configuration.configurators.AbstractConfigurator;
import org.jahia.configuration.configurators.ConfigFile;
import org.jahia.configuration.configurators.JahiaConfigInterface;
import org.jahia.configuration.configurators.PropertiesManager;
import org.jahia.configuration.logging.AbstractLogger;

public class JahiaNodePropertiesConfigurator
extends AbstractConfigurator {
    protected AbstractLogger logger;
    private PropertiesManager properties;

    public JahiaNodePropertiesConfigurator(AbstractLogger logger, JahiaConfigInterface cfg) {
        super(cfg);
        this.logger = logger;
    }

    private String getServerId(String id) {
        if (id == null || id.length() == 0 || "<auto>".equalsIgnoreCase(id)) {
            id = "df-" + UUID.randomUUID();
        }
        return id;
    }

    private void setClusterProperties() {
        JahiaConfigInterface cfg = this.jahiaConfigInterface;
        this.properties.setProperty("cluster.activated", cfg.getCluster_activated());
        this.properties.setProperty("cluster.node.serverId", this.getServerId(cfg.getCluster_node_serverId()));
        if (this.properties.getProperty("cluster.tcp.bindAddress") != null && StringUtils.isNotBlank((String)cfg.getClusterTCPBindAddress())) {
            this.properties.setProperty("cluster.tcp.bindAddress", cfg.getClusterTCPBindAddress());
        }
        if (this.properties.getProperty("cluster.tcp.bindPort") != null && StringUtils.isNotBlank((String)cfg.getClusterTCPBindPort())) {
            this.properties.setProperty("cluster.tcp.bindPort", cfg.getClusterTCPBindPort());
        }
    }

    @Override
    public void updateConfiguration(ConfigFile sourceJahiaPath, String targetJahiaPath) throws IOException {
        this.properties = new PropertiesManager(sourceJahiaPath.getInputStream());
        this.properties.setUnmodifiedCommentingActivated(true);
        File targetJahiaFile = new File(targetJahiaPath);
        Properties existingProperties = new Properties();
        if (targetJahiaFile.exists()) {
            existingProperties.putAll((Map<?, ?>)PropertyUtils.loadProperties((File)targetJahiaFile));
            for (Object key : existingProperties.keySet()) {
                String propertyName = String.valueOf(key);
                this.properties.setProperty(propertyName, existingProperties.getProperty(propertyName));
            }
        }
        JahiaConfigInterface cfg = this.jahiaConfigInterface;
        this.properties.setProperty("processingServer", cfg.getProcessingServer());
        this.setClusterProperties();
        this.properties.storeProperties(sourceJahiaPath.getInputStream(), targetJahiaPath);
    }
}

