/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.cli.internal.core.internal.analysis.filter;

import org.jacoco.cli.internal.asm.tree.AbstractInsnNode;
import org.jacoco.cli.internal.asm.tree.MethodNode;
import org.jacoco.cli.internal.core.internal.analysis.filter.IFilter;
import org.jacoco.cli.internal.core.internal.analysis.filter.IFilterContext;
import org.jacoco.cli.internal.core.internal.analysis.filter.IFilterOutput;

public class KotlinGeneratedFilter
implements IFilter {
    static final String KOTLIN_METADATA_DESC = "Lkotlin/Metadata;";

    static boolean isKotlinClass(IFilterContext context) {
        return context.getClassAnnotations().contains(KOTLIN_METADATA_DESC);
    }

    public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
        if (context.getSourceFileName() == null) {
            return;
        }
        if (!KotlinGeneratedFilter.isKotlinClass(context)) {
            return;
        }
        if (this.hasLineNumber(methodNode)) {
            return;
        }
        output.ignore(methodNode.instructions.getFirst(), methodNode.instructions.getLast());
    }

    private boolean hasLineNumber(MethodNode methodNode) {
        for (AbstractInsnNode i = methodNode.instructions.getFirst(); i != null; i = i.getNext()) {
            if (15 != i.getType()) continue;
            return true;
        }
        return false;
    }
}

