/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.nodes.resolvers;

import java.util.Optional;
import org.instancio.internal.nodes.NodeKind;
import org.instancio.internal.nodes.NodeKindResolver;
import org.instancio.internal.util.StringUtils;

class NodeKindJdkResolver
implements NodeKindResolver {
    private static final String[] SYSTEM_PACKAGES = new String[]{"java.", "javax."};

    NodeKindJdkResolver() {
    }

    @Override
    public Optional<NodeKind> resolve(Class<?> targetClass) {
        if (targetClass.isPrimitive() || targetClass.isEnum()) {
            return Optional.of(NodeKind.JDK);
        }
        Package pkg = targetClass.getPackage();
        if (pkg == null) {
            return Optional.empty();
        }
        return StringUtils.startsWithAny(pkg.getName(), SYSTEM_PACKAGES) ? Optional.of(NodeKind.JDK) : Optional.empty();
    }
}

