/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.instantiation;

import org.instancio.internal.instantiation.InstantiationStrategy;
import org.instancio.internal.instantiation.ReflectionFactoryHelper;
import org.instancio.internal.util.ReflectionUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ReflectionFactoryInstantiationStrategy
implements InstantiationStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(ReflectionFactoryInstantiationStrategy.class);
    private final boolean isReflectionFactoryAvailable;

    private ReflectionFactoryInstantiationStrategy() {
        boolean bl = this.isReflectionFactoryAvailable = ReflectionUtils.loadClass("sun.reflect.ReflectionFactory") != null;
        if (!this.isReflectionFactoryAvailable) {
            LOG.debug("sun.reflect.ReflectionFactory is unavailable");
        }
    }

    static InstantiationStrategy getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public <T> T createInstance(Class<T> klass) {
        return this.isReflectionFactoryAvailable() ? (T)ReflectionFactoryHelper.createInstance(klass) : null;
    }

    @VisibleForTesting
    boolean isReflectionFactoryAvailable() {
        return this.isReflectionFactoryAvailable;
    }

    private static final class Holder {
        private static final InstantiationStrategy INSTANCE = new ReflectionFactoryInstantiationStrategy();

        private Holder() {
        }
    }
}

