/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.assigners;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.instancio.internal.assigners.MethodNameResolver;
import org.instancio.internal.assigners.SetterMethodNameNoPrefixResolver;
import org.instancio.internal.assigners.SetterMethodNameWithPrefixResolver;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.util.ExceptionUtils;
import org.instancio.internal.util.Fail;
import org.instancio.internal.util.Format;
import org.instancio.settings.Keys;
import org.instancio.settings.SetterStyle;
import org.instancio.settings.Settings;

final class DefaultSetterMethodResolver {
    private final MethodNameResolver setterNameResolver;

    DefaultSetterMethodResolver(Settings settings) {
        this.setterNameResolver = DefaultSetterMethodResolver.getMethodNameResolver(settings.get(Keys.SETTER_STYLE));
    }

    Method getSetter(InternalNode node) {
        String methodName = this.setterNameResolver.resolveFor(node.getField());
        Field field = node.getField();
        if (methodName != null) {
            try {
                Class<?> klass = field.getDeclaringClass();
                return klass.getDeclaredMethod(methodName, field.getType());
            }
            catch (NoSuchMethodException ex) {
                ExceptionUtils.logException("Resolved setter method '{}' for field '{}' does not exist", ex, methodName, Format.formatField(field));
            }
        }
        return null;
    }

    private static MethodNameResolver getMethodNameResolver(SetterStyle style) {
        switch (style) {
            case SET: {
                return new SetterMethodNameWithPrefixResolver("set");
            }
            case WITH: {
                return new SetterMethodNameWithPrefixResolver("with");
            }
            case PROPERTY: {
                return new SetterMethodNameNoPrefixResolver();
            }
        }
        throw Fail.withFataInternalError("Unhandled setter style: %s", new Object[]{style});
    }
}

