/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.annotation;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.instancio.internal.annotation.FieldAnnotationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AnnotationHandlerMap {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotationHandlerMap.class);
    private final Map<Class<?>, FieldAnnotationHandler> handlerMap = new HashMap();

    AnnotationHandlerMap() {
    }

    final <A extends Annotation> void put(Supplier<Class<A>> annotationTypeSupplier, FieldAnnotationHandler handler) {
        try {
            this.handlerMap.put(annotationTypeSupplier.get(), handler);
        }
        catch (NoClassDefFoundError error) {
            LOG.trace("Annotation not available on classpath: {}", (Object)error.toString());
        }
    }

    final FieldAnnotationHandler get(Annotation annotation) {
        return this.handlerMap.get(annotation.annotationType());
    }
}

