/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.instancio.internal.annotation.GetterMethodResolver;
import org.instancio.internal.annotation.GetterMethodResolverImpl;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.settings.BeanValidationTarget;
import org.instancio.settings.Keys;
import org.jetbrains.annotations.NotNull;

final class AnnotationExtractor {
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    private final BeanValidationTarget beanValidationTarget;
    private final GetterMethodResolver getterMethodResolver;

    AnnotationExtractor(ModelContext<?> context) {
        this.beanValidationTarget = context.getSettings().get(Keys.BEAN_VALIDATION_TARGET);
        this.getterMethodResolver = new GetterMethodResolverImpl();
    }

    @NotNull
    Annotation[] getAnnotations(InternalNode node) {
        Field field = node.getField();
        if (field == null) {
            return EMPTY_ANNOTATIONS;
        }
        if (this.beanValidationTarget == BeanValidationTarget.FIELD) {
            return field.getDeclaredAnnotations();
        }
        Method getter = this.getterMethodResolver.getGetter(node);
        return getter == null ? EMPTY_ANNOTATIONS : getter.getDeclaredAnnotations();
    }
}

