/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.junit4;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.infinispan.server.test.core.TestServer;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerRuleBuilder;
import org.infinispan.server.test.junit4.InfinispanXSiteServerRule;

public class InfinispanXSiteServerRuleBuilder {
    private final List<InfinispanServerRuleBuilder> sites = new ArrayList<InfinispanServerRuleBuilder>();

    public InfinispanXSiteServerRuleBuilder addSite(String siteName, InfinispanServerRuleBuilder siteBuilder) {
        siteBuilder.site(siteName);
        this.sites.add(siteBuilder);
        return this;
    }

    public InfinispanXSiteServerRule build() {
        HashSet uniqueSiteName = new HashSet();
        List<TestServer> sitesTestServers = this.sites.stream().map(InfinispanServerRuleBuilder::build).map(InfinispanServerRule::getTestServer).peek(testServer -> {
            if (!uniqueSiteName.add(testServer.getSiteName())) {
                throw new IllegalStateException("Site name already set: " + testServer.getSiteName());
            }
        }).collect(Collectors.toList());
        return new InfinispanXSiteServerRule(sitesTestServers);
    }
}

