/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.authentication.impl;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.authentication.Authenticator;
import org.infinispan.rest.authentication.SecurityDomain;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.util.concurrent.BlockingManager;

public class BasicAuthenticator
implements Authenticator {
    private final SecurityDomain domain;
    private final String authenticateHeader;
    private BlockingManager blockingManager;

    public BasicAuthenticator(SecurityDomain domain, String realm) {
        this.domain = domain;
        this.authenticateHeader = realm != null ? String.format("Basic realm=\"%s\"", realm) : "Basic";
    }

    @Override
    public CompletionStage<RestResponse> challenge(RestRequest request, ChannelHandlerContext ctx) {
        String type;
        String auth = request.getAuthorizationHeader();
        if (auth != null && auth.length() > 5 && "basic".equalsIgnoreCase(type = auth.substring(0, 5))) {
            String cookie = auth.substring(6);
            cookie = new String(Base64.getDecoder().decode(cookie.getBytes()));
            String[] split = cookie.split(":");
            return this.blockingManager.supplyBlocking(() -> {
                request.setSubject(this.domain.authenticate(split[0], split[1]));
                return new NettyRestResponse.Builder().build();
            }, (Object)"auth");
        }
        return CompletableFuture.completedFuture(new NettyRestResponse.Builder().status(HttpResponseStatus.UNAUTHORIZED).authenticate(this.authenticateHeader).build());
    }

    @Override
    public void init(RestServer restServer) {
        this.blockingManager = restServer.getBlockingManager();
    }
}

