/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.dataconversion;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.basic.BigDecimalConverter;
import com.thoughtworks.xstream.converters.basic.BigIntegerConverter;
import com.thoughtworks.xstream.converters.basic.BooleanConverter;
import com.thoughtworks.xstream.converters.basic.ByteConverter;
import com.thoughtworks.xstream.converters.basic.CharConverter;
import com.thoughtworks.xstream.converters.basic.DateConverter;
import com.thoughtworks.xstream.converters.basic.DoubleConverter;
import com.thoughtworks.xstream.converters.basic.FloatConverter;
import com.thoughtworks.xstream.converters.basic.IntConverter;
import com.thoughtworks.xstream.converters.basic.LongConverter;
import com.thoughtworks.xstream.converters.basic.NullConverter;
import com.thoughtworks.xstream.converters.basic.ShortConverter;
import com.thoughtworks.xstream.converters.basic.StringConverter;
import com.thoughtworks.xstream.converters.basic.URIConverter;
import com.thoughtworks.xstream.converters.basic.URLConverter;
import com.thoughtworks.xstream.converters.collections.ArrayConverter;
import com.thoughtworks.xstream.converters.collections.BitSetConverter;
import com.thoughtworks.xstream.converters.collections.CharArrayConverter;
import com.thoughtworks.xstream.converters.collections.CollectionConverter;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.converters.collections.SingletonCollectionConverter;
import com.thoughtworks.xstream.converters.collections.SingletonMapConverter;
import com.thoughtworks.xstream.converters.extended.EncodedByteArrayConverter;
import com.thoughtworks.xstream.converters.extended.FileConverter;
import com.thoughtworks.xstream.converters.extended.GregorianCalendarConverter;
import com.thoughtworks.xstream.converters.extended.JavaClassConverter;
import com.thoughtworks.xstream.converters.extended.JavaFieldConverter;
import com.thoughtworks.xstream.converters.extended.JavaMethodConverter;
import com.thoughtworks.xstream.converters.extended.LocaleConverter;
import com.thoughtworks.xstream.converters.reflection.ExternalizableConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.SerializableConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.security.ForbiddenClassException;
import com.thoughtworks.xstream.security.NoTypePermission;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Collections;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.configuration.ClassAllowList;
import org.infinispan.commons.configuration.io.ConfigurationReader;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.OneToManyTranscoder;
import org.infinispan.commons.dataconversion.StandardConversions;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.server.core.dataconversion.xml.MXParserDriver;
import org.infinispan.server.core.logging.Log;

public class XMLTranscoder
extends OneToManyTranscoder {
    private static final Log logger = (Log)LogFactory.getLog(XMLTranscoder.class, Log.class);

    public XMLTranscoder() {
        this(XMLTranscoder.class.getClassLoader(), new ClassAllowList(Collections.emptyList()));
    }

    public XMLTranscoder(ClassAllowList classAllowList) {
        this(XMLTranscoder.class.getClassLoader(), classAllowList);
    }

    public XMLTranscoder(ClassLoader classLoader, ClassAllowList allowList) {
        super(MediaType.APPLICATION_XML, new MediaType[]{MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_OCTET_STREAM, MediaType.TEXT_PLAIN, MediaType.APPLICATION_UNKNOWN});
        XStreamHolder.XStream.addPermission(NoTypePermission.NONE);
        XStreamHolder.XStream.addPermission(type -> allowList.isSafeClass(type.getName()));
        XStreamHolder.XStream.setClassLoader(classLoader);
    }

    public Object transcode(Object content, MediaType contentType, MediaType destinationType) {
        if (destinationType.match(MediaType.APPLICATION_XML)) {
            if (contentType.match(MediaType.APPLICATION_OBJECT)) {
                Object decoded = StandardConversions.decodeObjectContent((Object)content, (MediaType)contentType);
                String xmlString = XStreamHolder.XStream.toXML(decoded);
                return xmlString.getBytes(destinationType.getCharset());
            }
            if (contentType.match(MediaType.TEXT_PLAIN)) {
                String inputText = StandardConversions.convertTextToObject((Object)content, (MediaType)contentType);
                if (this.isWellFormed(inputText.getBytes())) {
                    return inputText.getBytes();
                }
                String xmlString = XStreamHolder.XStream.toXML((Object)inputText);
                return xmlString.getBytes(destinationType.getCharset());
            }
            if (contentType.match(MediaType.APPLICATION_OCTET_STREAM) || contentType.match(MediaType.APPLICATION_UNKNOWN)) {
                String inputText = StandardConversions.convertTextToObject((Object)content, (MediaType)contentType);
                if (this.isWellFormed(inputText.getBytes())) {
                    return inputText.getBytes();
                }
                String xmlString = XStreamHolder.XStream.toXML((Object)inputText);
                return xmlString.getBytes(destinationType.getCharset());
            }
        }
        if (destinationType.match(MediaType.APPLICATION_OCTET_STREAM) || destinationType.match(MediaType.APPLICATION_UNKNOWN)) {
            return StandardConversions.convertTextToOctetStream((Object)content, (MediaType)contentType);
        }
        if (destinationType.match(MediaType.TEXT_PLAIN)) {
            return StandardConversions.convertCharset((Object)content, (Charset)contentType.getCharset(), (Charset)destinationType.getCharset());
        }
        if (destinationType.match(MediaType.APPLICATION_OBJECT)) {
            try {
                Reader xmlReader = content instanceof byte[] ? new InputStreamReader(new ByteArrayInputStream((byte[])content)) : new StringReader(content.toString());
                return XStreamHolder.XStream.fromXML(xmlReader);
            }
            catch (ForbiddenClassException e) {
                throw logger.errorDeserializing(e.getMessage());
            }
            catch (XStreamException e) {
                throw new CacheException((Throwable)e);
            }
        }
        throw logger.unsupportedDataFormat(contentType);
    }

    private boolean isWellFormed(byte[] content) {
        boolean bl;
        block9: {
            ByteArrayInputStream is = new ByteArrayInputStream(content);
            ConfigurationReader reader = ConfigurationReader.from((InputStream)is).build();
            try {
                while (reader.hasNext()) {
                    reader.nextElement();
                }
                bl = true;
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return false;
                }
            }
            reader.close();
        }
        return bl;
    }

    private static class XStreamHolder {
        static final XStream XStream = new XStream((HierarchicalStreamDriver)new MXParserDriver()){

            protected void setupConverters() {
                this.registerConverter((Converter)new ReflectionConverter(this.getMapper(), this.getReflectionProvider()), -20);
                this.registerConverter((Converter)new SerializableConverter(this.getMapper(), this.getReflectionProvider(), this.getClassLoaderReference()), -10);
                this.registerConverter((Converter)new ExternalizableConverter(this.getMapper(), this.getClassLoaderReference()), -10);
                this.registerConverter((Converter)new NullConverter(), 10000);
                this.registerConverter((SingleValueConverter)new IntConverter(), 0);
                this.registerConverter((SingleValueConverter)new FloatConverter(), 0);
                this.registerConverter((SingleValueConverter)new DoubleConverter(), 0);
                this.registerConverter((SingleValueConverter)new LongConverter(), 0);
                this.registerConverter((SingleValueConverter)new ShortConverter(), 0);
                this.registerConverter((Converter)new CharConverter(), 0);
                this.registerConverter((SingleValueConverter)new BooleanConverter(), 0);
                this.registerConverter((SingleValueConverter)new ByteConverter(), 0);
                this.registerConverter((SingleValueConverter)new StringConverter(), 0);
                this.registerConverter((SingleValueConverter)new DateConverter(), 0);
                this.registerConverter((Converter)new BitSetConverter(), 0);
                this.registerConverter((SingleValueConverter)new URIConverter(), 0);
                this.registerConverter((SingleValueConverter)new URLConverter(), 0);
                this.registerConverter((SingleValueConverter)new BigIntegerConverter(), 0);
                this.registerConverter((SingleValueConverter)new BigDecimalConverter(), 0);
                this.registerConverter((Converter)new ArrayConverter(this.getMapper()), 0);
                this.registerConverter((Converter)new CharArrayConverter(), 0);
                this.registerConverter((Converter)new CollectionConverter(this.getMapper()), 0);
                this.registerConverter((Converter)new MapConverter(this.getMapper()), 0);
                this.registerConverter((Converter)new SingletonCollectionConverter(this.getMapper()), 0);
                this.registerConverter((Converter)new SingletonMapConverter(this.getMapper()), 0);
                this.registerConverter((Converter)new EncodedByteArrayConverter(), 0);
                this.registerConverter((SingleValueConverter)new FileConverter(), 0);
                this.registerConverter((SingleValueConverter)new JavaClassConverter(this.getClassLoaderReference()), 0);
                this.registerConverter((Converter)new JavaMethodConverter(this.getClassLoaderReference()), 0);
                this.registerConverter((Converter)new JavaFieldConverter(this.getClassLoaderReference()), 0);
                this.registerConverter((SingleValueConverter)new LocaleConverter(), 0);
                this.registerConverter((Converter)new GregorianCalendarConverter(), 0);
            }
        };

        private XStreamHolder() {
        }
    }
}

