/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.configuration;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.server.core.configuration.SniConfiguration;

public class EncryptionConfiguration
implements ConfigurationInfo {
    static final AttributeDefinition<String> SECURITY_REALM = AttributeDefinition.builder((String)"securityRealm", null, String.class).build();
    static final AttributeDefinition<Boolean> REQUIRE_CLIENT_AUTH = AttributeDefinition.builder((String)"requireSslClientAuth", (Object)false, Boolean.class).build();
    private static final ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition("encryption");
    private final List<ConfigurationInfo> subElements = new ArrayList<ConfigurationInfo>();
    private final AttributeSet attributes;
    private final List<SniConfiguration> sniConfigurations;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(EncryptionConfiguration.class, new AttributeDefinition[]{REQUIRE_CLIENT_AUTH, SECURITY_REALM});
    }

    EncryptionConfiguration(AttributeSet attributes, List<SniConfiguration> sniConfigurations) {
        this.attributes = attributes.checkProtection();
        this.sniConfigurations = sniConfigurations;
        this.subElements.addAll(sniConfigurations);
    }

    public List<ConfigurationInfo> subElements() {
        return this.subElements;
    }

    List<SniConfiguration> sniConfigurations() {
        return this.sniConfigurations;
    }

    public String realm() {
        return (String)this.attributes.attribute(SECURITY_REALM).get();
    }

    public boolean requireClientAuth() {
        return (Boolean)this.attributes.attribute(REQUIRE_CLIENT_AUTH).get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncryptionConfiguration that = (EncryptionConfiguration)o;
        if (!this.attributes.equals((Object)that.attributes)) {
            return false;
        }
        return this.sniConfigurations.equals(that.sniConfigurations);
    }

    public int hashCode() {
        int result = this.attributes.hashCode();
        result = 31 * result + this.sniConfigurations.hashCode();
        return result;
    }

    public String toString() {
        return "EncryptionConfiguration{attributes=" + this.attributes + ", sniConfigurations=" + this.sniConfigurations + '}';
    }
}

