/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core;

import org.infinispan.commons.configuration.ClassAllowList;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.encoding.impl.TwoStepTranscoder;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.InfinispanModule;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.marshall.protostream.impl.SerializationContextRegistry;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.server.core.PersistenceContextInitializerImpl;
import org.infinispan.server.core.dataconversion.JsonTranscoder;
import org.infinispan.server.core.dataconversion.XMLTranscoder;

@InfinispanModule(name="server-core", requiredModules={"core"}, optionalModules={"jboss-marshalling"})
public class LifecycleCallbacks
implements ModuleLifecycle {
    public void cacheManagerStarting(GlobalComponentRegistry gcr, GlobalConfiguration globalConfiguration) {
        SerializationContextRegistry ctxRegistry = (SerializationContextRegistry)gcr.getComponent(SerializationContextRegistry.class);
        ctxRegistry.addContextInitializer(SerializationContextRegistry.MarshallerType.PERSISTENCE, (SerializationContextInitializer)new PersistenceContextInitializerImpl());
        ClassAllowList classAllowList = ((EmbeddedCacheManager)gcr.getComponent(EmbeddedCacheManager.class)).getClassAllowList();
        ClassLoader classLoader = globalConfiguration.classLoader();
        EncoderRegistry encoderRegistry = (EncoderRegistry)gcr.getComponent(EncoderRegistry.class);
        JsonTranscoder jsonTranscoder = new JsonTranscoder(classLoader, classAllowList);
        encoderRegistry.registerTranscoder((Transcoder)jsonTranscoder);
        encoderRegistry.registerTranscoder((Transcoder)new XMLTranscoder(classLoader, classAllowList));
        if (encoderRegistry.isConversionSupported(MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_JBOSS_MARSHALLING)) {
            Transcoder jbossMarshallingTranscoder = encoderRegistry.getTranscoder(MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_JBOSS_MARSHALLING);
            encoderRegistry.registerTranscoder((Transcoder)new TwoStepTranscoder(jbossMarshallingTranscoder, (Transcoder)jsonTranscoder));
        }
    }
}

